/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.InstallationService.batchInstallationModel;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import sos.scheduler.InstallationService.batchInstallationModel.JSinstallation;
import sos.scheduler.InstallationService.batchInstallationModel.installations.Installation;
import sos.scheduler.InstallationService.batchInstallationModel.installations.Installations;

public class JSInstallations {
    private ArrayList<Installation> listOfInstallations;
    private File installationsDefinitionFile;
    private Iterator<Installation> jsInstallationsIterator;
    private Installations installations;

    public JSInstallations(File installationsDefinitionFile_) throws Exception {
        this.installationsDefinitionFile = installationsDefinitionFile_;
        this.readInstallationDefinitionFile();
    }

    public void reset() {
        this.jsInstallationsIterator = this.listOfInstallations.iterator();
    }

    public JSinstallation next() {
        Installation i = this.jsInstallationsIterator.next();
        JSinstallation j = new JSinstallation();
        j.globals = this.installations.getGlobals();
        j.setValues(i);
        return j;
    }

    public Installations getInstallations() {
        return this.installations;
    }

    public Installation nextInstallation() {
        return this.jsInstallationsIterator.next();
    }

    public boolean eof() {
        return !this.jsInstallationsIterator.hasNext();
    }

    public void readInstallationDefinitionFile() throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Installations.class});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        this.installations = (Installations)unmarshaller.unmarshal(this.installationsDefinitionFile);
        this.listOfInstallations = (ArrayList)this.installations.getInstallation();
        this.reset();
    }

    public void writeFile(File output) throws JAXBException, ParseException, FileNotFoundException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Installations.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.marshal((Object)this.installations, (OutputStream)new FileOutputStream(output));
    }
}

