/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.db;

import com.sos.JSHelper.Basics.JSJobUtilitiesClass;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.hibernate.exceptions.SOSHibernateConfigurationException;
import com.sos.keepass.SOSKeePassResolver;
import com.sos.scheduler.messages.JSMessages;
import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdbc.OracleDriver;
import org.hibernate.cfg.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.scheduler.db.DbmsOutput;
import sos.scheduler.db.JobSchedulerPLSQLJobOptions;

public class JobSchedulerPLSQLJob
extends JSJobUtilitiesClass<JobSchedulerPLSQLJobOptions> {
    protected static final String conSettingDBMS_OUTPUT = "dbmsOutput";
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSchedulerPLSQLJob.class);
    private static final String CLASSNAME = "JobSchedulerPLSQLJob";
    private CallableStatement cs = null;
    private Connection objConnection = null;
    private DbmsOutput dbmsOutput = null;
    private String strOutput = "";
    private String strSqlError = "";
    private Configuration configuration;

    public JobSchedulerPLSQLJob() {
        super((Object)new JobSchedulerPLSQLJobOptions());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JobSchedulerPLSQLJob execute() throws Exception {
        String conMethodName = "JobSchedulerPLSQLJob::Execute";
        JSMessages.JSJ_I_110.toLog(new Object[]{"JobSchedulerPLSQLJob::Execute"});
        this.objJSJobUtilities.setJSParam("sql_error", "");
        try {
            ((JobSchedulerPLSQLJobOptions)((Object)this.getOptions())).checkMandatory();
            if (((JobSchedulerPLSQLJobOptions)((Object)this.objOptions)).hibernate_configuration_file.isDirty()) {
                this.configuration = new Configuration();
                this.configure(((JobSchedulerPLSQLJobOptions)((Object)this.objOptions)).hibernate_configuration_file.getValue());
                String s = this.configuration.getProperty("hibernate.connection.url");
                if (s != null) {
                    ((JobSchedulerPLSQLJobOptions)((Object)this.objOptions)).db_url.setValue(s);
                }
                if ((s = this.configuration.getProperty("hibernate.connection.username")) != null) {
                    ((JobSchedulerPLSQLJobOptions)((Object)this.objOptions)).db_user.setValue(s);
                }
                if ((s = this.configuration.getProperty("hibernate.connection.password")) != null) {
                    ((JobSchedulerPLSQLJobOptions)((Object)this.objOptions)).db_password.setValue(s);
                }
            }
            DriverManager.registerDriver((Driver)new OracleDriver());
            SOSKeePassResolver r = new SOSKeePassResolver(((JobSchedulerPLSQLJobOptions)((Object)this.objOptions)).credential_store_file.getValue(), ((JobSchedulerPLSQLJobOptions)((Object)this.objOptions)).credential_store_key_file.getValue(), ((JobSchedulerPLSQLJobOptions)((Object)this.objOptions)).credential_store_password.getValue());
            r.setEntryPath(((JobSchedulerPLSQLJobOptions)((Object)this.objOptions)).credential_store_entry_path.getValue());
            String dbUrl = r.resolve(((JobSchedulerPLSQLJobOptions)((Object)this.objOptions)).db_url.getValue());
            String dbUser = r.resolve(((JobSchedulerPLSQLJobOptions)((Object)this.objOptions)).db_user.getValue());
            String dbPassword = r.resolve(((JobSchedulerPLSQLJobOptions)((Object)this.objOptions)).db_password.getValue());
            LOGGER.debug(((JobSchedulerPLSQLJobOptions)((Object)this.objOptions)).credential_store_file.getValue());
            LOGGER.debug(((JobSchedulerPLSQLJobOptions)((Object)this.objOptions)).credential_store_key_file.getValue());
            LOGGER.debug(((JobSchedulerPLSQLJobOptions)((Object)this.objOptions)).credential_store_entry_path.getValue());
            LOGGER.debug("dbUrl: " + dbUrl);
            LOGGER.debug("dbUser: " + dbUser);
            LOGGER.debug("dbPassword: ********");
            String s = dbUser.trim() + dbPassword.trim();
            if (s.isEmpty()) {
                LOGGER.debug("Empty password");
                this.objConnection = DriverManager.getConnection(dbUrl);
            } else {
                this.objConnection = DriverManager.getConnection(dbUrl, dbUser, dbPassword);
            }
            String[] plsql = ((JobSchedulerPLSQLJobOptions)((Object)this.objOptions)).command.unescapeXML().replace("\r\n", "\n");
            plsql = this.objJSJobUtilities.replaceSchedulerVars((String)plsql);
            LOGGER.debug(String.format("substituted Statement: %s will be executed.", new Object[]{plsql}));
            this.dbmsOutput = new DbmsOutput(this.objConnection);
            this.dbmsOutput.enable(1000000);
            this.cs = this.objConnection.prepareCall((String)plsql);
            this.cs.execute();
        }
        catch (SQLException e) {
            try {
                LOGGER.error(JSMessages.JSJ_F_107.get(new Object[]{"JobSchedulerPLSQLJob::Execute"}), (Throwable)e);
                String strT = String.format("SQL Exception raised. Msg='%1$s', Status='%2$s'", e.getMessage(), e.getSQLState());
                LOGGER.error(strT, (Throwable)e);
                this.strSqlError = strT;
                this.objJSJobUtilities.setJSParam("sql_error", strT);
                throw new JobSchedulerException(strT, (Throwable)e);
                catch (Exception e2) {
                    throw new JobSchedulerException(JSMessages.JSJ_F_107.get(new Object[]{"JobSchedulerPLSQLJob::Execute"}), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.objJSJobUtilities.setJSParam(conSettingDBMS_OUTPUT, "");
                this.objJSJobUtilities.setJSParam("std_out_output", "");
                if (this.dbmsOutput != null) {
                    this.strOutput = this.dbmsOutput.getOutput();
                    if (this.strOutput != null) {
                        ResultSetMetaData csmd;
                        this.objJSJobUtilities.setJSParam(conSettingDBMS_OUTPUT, this.strOutput);
                        this.objJSJobUtilities.setJSParam("std_out_output", this.strOutput);
                        int intRegExpFlags = 42;
                        String[] strA = this.strOutput.split("\n");
                        boolean flgAVariableFound = false;
                        String strRegExp = ((JobSchedulerPLSQLJobOptions)((Object)this.objOptions)).VariableParserRegExpr.getValue();
                        Pattern objRegExprPattern = Pattern.compile(strRegExp, intRegExpFlags);
                        for (String string : strA) {
                            Matcher objMatch = objRegExprPattern.matcher(string);
                            if (!objMatch.matches()) continue;
                            this.objJSJobUtilities.setJSParam(objMatch.group(1), objMatch.group(2).trim());
                            flgAVariableFound = true;
                        }
                        this.dbmsOutput.close();
                        if (!flgAVariableFound) {
                            LOGGER.info(String.format("no JS-variable definitions found using reg-exp '%1$s'.", strRegExp));
                        }
                        if ((csmd = this.cs.getMetaData()) != null) {
                            int nCols = csmd.getColumnCount();
                            for (int i = 1; i <= nCols; ++i) {
                                System.out.print(csmd.getColumnName(i));
                                int colSize = csmd.getColumnDisplaySize(i);
                                for (int k = 0; k < colSize - csmd.getColumnName(i).length(); ++k) {
                                    System.out.print(" ");
                                }
                            }
                            System.out.println("");
                        }
                    }
                    if (this.cs != null) {
                        this.cs.close();
                        this.cs = null;
                    }
                    if (this.objConnection != null) {
                        this.objConnection.close();
                        this.objConnection = null;
                    }
                }
                throw throwable;
            }
        }
        this.objJSJobUtilities.setJSParam(conSettingDBMS_OUTPUT, "");
        this.objJSJobUtilities.setJSParam("std_out_output", "");
        if (this.dbmsOutput != null) {
            this.strOutput = this.dbmsOutput.getOutput();
            if (this.strOutput != null) {
                ResultSetMetaData csmd;
                this.objJSJobUtilities.setJSParam(conSettingDBMS_OUTPUT, this.strOutput);
                this.objJSJobUtilities.setJSParam("std_out_output", this.strOutput);
                int intRegExpFlags = 42;
                String[] strA = this.strOutput.split("\n");
                boolean flgAVariableFound = false;
                String strRegExp = ((JobSchedulerPLSQLJobOptions)((Object)this.objOptions)).VariableParserRegExpr.getValue();
                Pattern objRegExprPattern = Pattern.compile(strRegExp, intRegExpFlags);
                for (String string : strA) {
                    Matcher objMatch = objRegExprPattern.matcher(string);
                    if (!objMatch.matches()) continue;
                    this.objJSJobUtilities.setJSParam(objMatch.group(1), objMatch.group(2).trim());
                    flgAVariableFound = true;
                }
                this.dbmsOutput.close();
                if (!flgAVariableFound) {
                    LOGGER.info(String.format("no JS-variable definitions found using reg-exp '%1$s'.", strRegExp));
                }
                if ((csmd = this.cs.getMetaData()) != null) {
                    int nCols = csmd.getColumnCount();
                    for (int i = 1; i <= nCols; ++i) {
                        System.out.print(csmd.getColumnName(i));
                        int colSize = csmd.getColumnDisplaySize(i);
                        for (int k = 0; k < colSize - csmd.getColumnName(i).length(); ++k) {
                            System.out.print(" ");
                        }
                    }
                    System.out.println("");
                }
            }
            if (this.cs != null) {
                this.cs.close();
                this.cs = null;
            }
            if (this.objConnection != null) {
                this.objConnection.close();
                this.objConnection = null;
            }
        }
        LOGGER.debug(JSMessages.JSJ_I_111.get(new Object[]{"JobSchedulerPLSQLJob::Execute"}));
        return this;
    }

    public String getSqlError() {
        return this.strSqlError;
    }

    public String getOutput() {
        return this.strOutput;
    }

    private void configure(String fileName) throws SOSHibernateConfigurationException {
        File hibernateConfigFile = new File(fileName);
        if (!hibernateConfigFile.exists()) {
            throw new SOSHibernateConfigurationException(String.format("hibernate config file not found: %s", hibernateConfigFile.toString()));
        }
        this.configuration.configure(hibernateConfigFile);
    }
}

