/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.db;

import com.sos.JSHelper.Basics.JSJobUtilitiesClass;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.io.Files.JSTextFile;
import com.sos.scheduler.messages.JSMessages;
import com.sos.vfs.common.SOSShell;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.scheduler.db.SOSSQLPlusJobOptions;

public class SOSSQLPlusJob
extends JSJobUtilitiesClass<SOSSQLPlusJobOptions> {
    private static final String CLASSNAME = "SOSSQLPlusJob";
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSSQLPlusJob.class);

    public SOSSQLPlusJob() {
        super((Object)new SOSSQLPlusJobOptions());
    }

    public SOSSQLPlusJob execute() throws Exception {
        String conMethodName = "SOSSQLPlusJob::Execute";
        JSMessages.JSJ_I_110.toLog(new Object[]{"SOSSQLPlusJob::Execute"});
        try {
            String strDBConn;
            ((SOSSQLPlusJobOptions)((Object)this.getOptions())).checkMandatory();
            LOGGER.debug(((SOSSQLPlusJobOptions)((Object)this.objOptions)).dirtyString());
            SOSShell objShell = new SOSShell();
            String strCommand = ((SOSSQLPlusJobOptions)((Object)this.objOptions)).shell_command.getOptionalQuotedValue();
            if (objShell.isWindows()) {
                strCommand = "echo 1 | " + strCommand;
            }
            String strCommandParams = "";
            if (((SOSSQLPlusJobOptions)((Object)this.objOptions)).CommandLineOptions.isNotEmpty()) {
                strCommand = strCommand + " " + ((SOSSQLPlusJobOptions)((Object)this.objOptions)).CommandLineOptions.getValue();
            }
            if (!(strDBConn = ((SOSSQLPlusJobOptions)((Object)this.objOptions)).getConnectionString()).isEmpty()) {
                strCommandParams = strCommandParams + " " + strDBConn;
            }
            File objTempFile = File.createTempFile("sos", ".sql");
            String strTempFileName = objTempFile.getAbsolutePath();
            ((SOSSQLPlusJobOptions)((Object)this.objOptions)).command_script_file.checkMandatory();
            if (((SOSSQLPlusJobOptions)((Object)this.objOptions)).command_script_file.isDirty()) {
                strCommandParams = strCommandParams + " @" + strTempFileName;
            }
            HashMap<String, String> objSettings = this.getSettings4StepName();
            JSTextFile objTF = new JSTextFile(strTempFileName);
            Iterator<Map.Entry<String, String>> iterator = objSettings.entrySet().iterator();
            while (iterator.hasNext()) {
                String[] element;
                String[] mapItem = element = iterator.next();
                String strMapKey = mapItem.getKey().toString();
                strMapKey = this.sqlPlusVariableName(strMapKey);
                if (mapItem.getValue() == null) continue;
                strMapKey = strMapKey.replace(".", "_");
                String strT = String.format("DEFINE %1$s = %2$s (char)", strMapKey, this.addQuotes(((String)mapItem.getValue()).toString()));
                if ("db_password".equals(strMapKey)) {
                    LOGGER.debug("DEFINE db_password = ******** (char)");
                } else {
                    LOGGER.debug(strT);
                }
                objTF.writeLine(strT);
            }
            if (((SOSSQLPlusJobOptions)((Object)this.objOptions)).include_files.isDirty()) {
                String[] strA;
                for (String strFileName2Include : strA = ((SOSSQLPlusJobOptions)((Object)this.objOptions)).include_files.getValue().split(";")) {
                    LOGGER.debug(String.format("Append file '%1$s' to script", strFileName2Include));
                    objTF.appendFile(strFileName2Include);
                }
            }
            String conNL = System.getProperty("line.separator");
            ((SOSSQLPlusJobOptions)((Object)this.objOptions)).Shell_command_Parameter.setValue(strCommandParams);
            String strFC = ((SOSSQLPlusJobOptions)((Object)this.objOptions)).command_script_file.getValue();
            strFC = this.objJSJobUtilities.replaceSchedulerVars(strFC);
            LOGGER.debug(((SOSSQLPlusJobOptions)((Object)this.objOptions)).command_script_file.getValue());
            strFC = strFC + "\nexit;\n";
            objTF.writeLine(strFC);
            int intCC = this.executeCommand((SOSSQLPlusJobOptions)((Object)this.objOptions), objShell);
            String strCC = String.valueOf(intCC);
            String f = "00000";
            strCC = f.substring(0, strCC.length() - 1) + strCC;
            String strSQLError = "";
            int intRegExpFlags = 42;
            String strStdOut = objShell.getStdOut();
            String[] strA = strStdOut.split(conNL);
            boolean flgAVariableFound = false;
            String strRegExp = ((SOSSQLPlusJobOptions)((Object)this.objOptions)).VariableParserRegExpr.getValue();
            Pattern objRegExprPattern = Pattern.compile(strRegExp, intRegExpFlags);
            for (String string : strA) {
                String[] objMatch = objRegExprPattern.matcher(string);
                if (!objMatch.matches()) continue;
                this.objJSJobUtilities.setJSParam(objMatch.group(1), objMatch.group(2).trim());
                flgAVariableFound = true;
            }
            if (!flgAVariableFound) {
                LOGGER.info(String.format("no JS-variable definitions found using reg-exp '%1$s'.", strRegExp));
            }
            boolean flgIgnoreSP2MsgNo = false;
            if (((SOSSQLPlusJobOptions)((Object)this.objOptions)).ignore_sp2_messages.contains("*all")) {
                flgIgnoreSP2MsgNo = true;
            }
            boolean flgIgnoreOraMsgNo = false;
            if (((SOSSQLPlusJobOptions)((Object)this.objOptions)).ignore_ora_messages.contains("*all")) {
                flgIgnoreOraMsgNo = true;
            }
            Pattern objErrorPattern = Pattern.compile("^\\s*SP2-(\\d\\d\\d\\d):\\s*(.*)$", intRegExpFlags);
            Pattern objORAPattern = Pattern.compile("^ORA-(\\d\\d\\d\\d\\d):\\s*(.*)$", intRegExpFlags);
            for (String strStdoutLine : strA) {
                strStdoutLine = strStdoutLine.trim();
                Matcher objMatch = objErrorPattern.matcher(strStdoutLine);
                Matcher objMatch2 = objORAPattern.matcher(strStdoutLine);
                if (objMatch.matches() || objMatch2.matches()) {
                    String strMsgNo;
                    boolean flgIsError = false;
                    if (objMatch.matches() && !flgIgnoreSP2MsgNo && !((SOSSQLPlusJobOptions)((Object)this.objOptions)).ignore_sp2_messages.contains(strMsgNo = objMatch.group(1).toString())) {
                        flgIsError = true;
                    }
                    if (objMatch2.matches() && !flgIgnoreOraMsgNo && !((SOSSQLPlusJobOptions)((Object)this.objOptions)).ignore_ora_messages.contains(strMsgNo = objMatch2.group(1).toString())) {
                        flgIsError = true;
                    }
                    if (flgIsError) {
                        strSQLError = strSQLError + strStdoutLine + conNL;
                        LOGGER.debug("error found: " + strStdoutLine);
                        this.objJSJobUtilities.setStateText(strStdoutLine);
                        continue;
                    }
                    LOGGER.info(String.format("Error '%1$s' ignored due to settings", strStdoutLine));
                    continue;
                }
                LOGGER.info(strStdoutLine);
                this.objJSJobUtilities.setStateText("");
            }
            String strStdErr = objShell.getStdErr();
            this.objJSJobUtilities.setJSParam("sql_error", strSQLError.trim());
            if (intCC == 0) {
                if (!strStdErr.trim().isEmpty()) {
                    intCC = 99;
                }
                if (!strSQLError.isEmpty()) {
                    intCC = 98;
                }
            }
            this.objJSJobUtilities.setJSParam("exit_Code", "" + intCC);
            if (intCC != 0 && !((SOSSQLPlusJobOptions)((Object)this.objOptions)).ignore_ora_messages.contains(strCC)) {
                throw new JobSchedulerException(String.format("Exit-Code set to '%1$s': %2$s", "" + intCC, strSQLError.trim()));
            }
        }
        catch (Exception e) {
            throw new JobSchedulerException(JSMessages.JSJ_F_107.get(new Object[]{"SOSSQLPlusJob::Execute"}) + ": " + e.getMessage(), (Throwable)e);
        }
        JSMessages.JSJ_I_111.toLog(new Object[]{"SOSSQLPlusJob::Execute"});
        return this;
    }

    public int executeCommand(SOSSQLPlusJobOptions options, SOSShell shell) throws Exception {
        return shell.executeCommand(this.createCommandUsingOptions(options, shell), false);
    }

    private String[] createCommands(SOSSQLPlusJobOptions options, SOSShell shell, String envComSpecName, String defaultComSpec, String startParam) {
        String[] command = new String[]{" ", " ", " "};
        String comSpec = "";
        int indx = 0;
        String startShellCommandParam = startParam;
        if (options.getStartShellCommand().isDirty()) {
            comSpec = options.getStartShellCommand().getValue();
            if (!"none".equalsIgnoreCase(comSpec)) {
                command[indx++] = comSpec;
                if (options.getStartShellCommandParameter().isDirty()) {
                    startShellCommandParam = options.getStartShellCommandParameter().getValue();
                    command[indx++] = startShellCommandParam;
                }
                command[indx++] = options.getShellCommand().getValue() + " " + options.getCommandLineOptions().getValue() + " " + options.getShellCommandParameter().getValue();
            } else {
                command[indx++] = options.getShellCommand().getValue();
                command[indx++] = options.getCommandLineOptions().getValue() + " " + options.getShellCommandParameter().getValue();
            }
        } else {
            comSpec = System.getenv(envComSpecName);
            if (comSpec == null) {
                comSpec = defaultComSpec;
            }
            command[indx++] = comSpec;
            command[indx++] = startShellCommandParam;
            command[indx++] = options.getShellCommand().getValue() + " " + options.getCommandLineOptions().getValue() + " " + options.getShellCommandParameter().getValue();
        }
        return command;
    }

    private String[] createCommandUsingOptions(SOSSQLPlusJobOptions options, SOSShell shell) {
        if (shell.isWindows()) {
            return this.createCommands(options, shell, "comspec", "cmd.exe", "/C");
        }
        return this.createCommands(options, shell, "SHELL", "/bin/sh", "-c");
    }

    private HashMap<String, String> getSettings4StepName() {
        HashMap<String, String> objS = new HashMap<String, String>();
        int intStartPos = ((SOSSQLPlusJobOptions)((Object)this.objOptions)).getCurrentNodeName().length() + 1;
        for (Map.Entry mapItem : ((SOSSQLPlusJobOptions)((Object)this.objOptions)).getSettings().entrySet()) {
            String strMapKey = (String)mapItem.getKey();
            String strValue = (String)mapItem.getValue();
            if (strMapKey.indexOf("/") != -1) {
                if (strMapKey.startsWith(((SOSSQLPlusJobOptions)((Object)this.objOptions)).getCurrentNodeName() + "/")) {
                    strMapKey = strMapKey.substring(intStartPos);
                } else {
                    strValue = null;
                }
            }
            if (strValue == null) continue;
            if ("db_password".equals(strMapKey)) {
                strValue = "********";
            }
            LOGGER.debug(strMapKey + " = " + strValue);
            objS.put(strMapKey, strValue);
        }
        return objS;
    }

    public String sqlPlusVariableName(String s) {
        if (s.length() > 30) {
            s = s.substring(0, 29) + "_";
        }
        return s;
    }
}

