/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.file;

import com.sos.JSHelper.Basics.JSJobUtilities;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.scheduler.messages.JSMessages;
import java.io.File;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.scheduler.file.JSExistsFile;
import sos.scheduler.file.JSExistsFileOptions;
import sos.scheduler.job.JobSchedulerJobAdapter;
import sos.spooler.Job_chain;
import sos.spooler.Order;
import sos.spooler.Variable_set;

public class JSExistsFileJSAdapterClass
extends JobSchedulerJobAdapter {
    private static final String SCHEDULER_FILE_PATH = "scheduler_file_path";
    private static final Logger LOGGER = LoggerFactory.getLogger(JSExistsFileJSAdapterClass.class);
    private JSExistsFileOptions objO = null;

    public void init() {
        this.doInitialize();
    }

    private void doInitialize() {
    }

    public boolean spooler_init() {
        return super.spooler_init();
    }

    public boolean spooler_process() throws Exception {
        try {
            super.spooler_process();
            return this.doProcessing();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new JobSchedulerException((Throwable)e);
        }
    }

    public void spooler_exit() {
        super.spooler_exit();
    }

    private boolean doProcessing() throws Exception {
        String filename;
        JSExistsFile objR = new JSExistsFile();
        this.objO = objR.getOptions();
        this.objO.setAllOptions(this.getSchedulerParameterAsProperties(this.getSpoolerProcess().getOrder()));
        if (!(this.objO.file_spec.isDirty() || this.objO.file.isDirty() || (filename = this.spooler_task.order().params().value(SCHEDULER_FILE_PATH)) == null || filename.isEmpty())) {
            File file = new File(filename);
            this.objO.file_spec.setValue("^" + file.getName().replaceAll(".", "\\.") + "$");
            this.objO.file.setValue(file.getParent());
        }
        objR.setJSJobUtilites((JSJobUtilities)this);
        boolean flgResult = objR.Execute();
        Vector<File> lstResultList = objR.getResultList();
        int intNoOfHitsInResultSet = lstResultList.size();
        String strOrderJobChainName = null;
        boolean flgCreateOrders4AllFiles = false;
        boolean count_files = this.objO.count_files.value();
        if (this.spooler_task.order() != null) {
            String strOnEmptyResultSet;
            Variable_set orderParams = this.spooler_task.order().params();
            if (orderParams != null) {
                if (count_files) {
                    orderParams.set_var(this.objO.count_files.getKey(), String.valueOf(intNoOfHitsInResultSet));
                }
                String strT = "";
                for (File objFile : lstResultList) {
                    strT = strT + objFile.getAbsolutePath() + ";";
                }
                orderParams.set_var(this.objO.scheduler_sosfileoperations_resultset.getKey(), strT);
                orderParams.set_var(this.objO.scheduler_sosfileoperations_resultsetsize.getKey(), String.valueOf(intNoOfHitsInResultSet));
            }
            if (this.isNotEmpty(strOnEmptyResultSet = this.objO.on_empty_result_set.getValue()) && intNoOfHitsInResultSet <= 0) {
                LOGGER.info(JSMessages.JSJ_I_0090.params(new Object[]{strOnEmptyResultSet}));
                this.spooler_task.order().set_state(strOnEmptyResultSet);
            }
        } else if (count_files) {
            LOGGER.warn(JSMessages.JSJ_E_0120.params(new Object[]{this.objO.count_files.getKey()}));
        }
        if (flgResult) {
            flgCreateOrders4AllFiles = this.objO.create_orders_for_all_files.value();
            boolean flgCreateOrder = this.objO.create_order.value();
            if (flgCreateOrder && intNoOfHitsInResultSet > 0) {
                strOrderJobChainName = this.objO.order_jobchain_name.getValue();
                if (this.isNull(strOrderJobChainName)) {
                    throw new JobSchedulerException(JSMessages.JSJ_E_0020.params(new Object[]{this.objO.order_jobchain_name.getKey()}));
                }
                if (!this.spooler.job_chain_exists(strOrderJobChainName)) {
                    throw new JobSchedulerException(JSMessages.JSJ_E_0041.params(new Object[]{strOrderJobChainName}));
                }
                for (File objFile : lstResultList) {
                    this.createOrder(objFile.getAbsolutePath(), strOrderJobChainName);
                    if (flgCreateOrders4AllFiles) continue;
                    break;
                }
            }
        }
        return this.setReturnResult(flgResult);
    }

    private void createOrder(String pstrOrder4FileName, String pstrOrderJobChainName) {
        String methodName = "JSExistsFileJSAdapterClass::createOrder";
        Order objOrder = this.spooler.create_order();
        Variable_set objOrderParams = this.spooler.create_variable_set();
        objOrderParams.set_value(this.objO.scheduler_file_path.getKey(), pstrOrder4FileName);
        objOrderParams.set_value(this.objO.scheduler_file_parent.getKey(), new File(pstrOrder4FileName).getParent());
        objOrderParams.set_value(this.objO.scheduler_file_name.getKey(), new File(pstrOrder4FileName).getName());
        String strNextState = this.objO.next_state.getValue();
        if (this.isNotEmpty(strNextState)) {
            objOrder.set_state(strNextState);
        }
        objOrder.set_params(objOrderParams);
        objOrder.set_id(pstrOrder4FileName);
        objOrder.set_title(JSMessages.JSJ_I_0017.params(new Object[]{"JSExistsFileJSAdapterClass::createOrder"}));
        Job_chain objJobchain = this.spooler.job_chain(pstrOrderJobChainName);
        objJobchain.add_order(objOrder);
        String strT = JSMessages.JSJ_I_0018.params(new Object[]{pstrOrder4FileName, pstrOrderJobChainName});
        if (this.isNotEmpty(strNextState)) {
            strT = strT + " " + JSMessages.JSJ_I_0019.params(new Object[]{strNextState});
        }
        LOGGER.info(strT);
    }

    public boolean setReturnResult(boolean pflgResult) {
        boolean rc1 = pflgResult;
        if (!rc1 && this.objO.gracious.isGraciousAll()) {
            return this.getSpoolerProcess().isOrderJob();
        }
        if (!rc1 && this.objO.gracious.isGraciousTrue()) {
            return false;
        }
        if (rc1) {
            return this.getSpoolerProcess().isOrderJob();
        }
        return false;
    }
}

