/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.file;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.SOSOptionFileAge;
import com.sos.JSHelper.Options.SOSOptionTime;
import com.sos.JSHelper.io.Files.JSTextFile;
import com.sos.JSHelper.io.SOSFileSystemOperations;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.scheduler.messages.JSMessages;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.scheduler.job.JobSchedulerJobAdapter;
import sos.spooler.Job_chain;
import sos.spooler.Order;
import sos.spooler.Variable_set;

@I18NResourceBundle(baseName="com_sos_scheduler_messages", defaultLocale="en")
public class JobSchedulerFileOperationBase
extends JobSchedulerJobAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSchedulerFileOperationBase.class);
    public static final String ORDER_PARAMETER_SCHEDULER_SOS_FILE_OPERATIONS_RESULT_SET = "scheduler_SOSFileOperations_ResultSet";
    public static final String ORDEDR_PARAMETER_SCHEDULER_SOS_FILE_OPERATIONS_RESULT_SET_SIZE = "scheduler_SOSFileOperations_ResultSetSize";
    public static final String ORDER_PARAMETER_SCHEDULER_SOS_FILE_OPERATIONS_FILE_COUNT = "scheduler_SOSFileOperations_file_count";
    public static final String PARAMTER_GRACIOUS = "gracious";
    protected static final String PROPERTY_JAVA_IO_TMPDIR = "java.io.tmpdir";
    protected static final String PARAMETER_CHECK_STEADY_STATE_OF_FILE = "check_steady_state_of_files";
    protected static final String PARAMETER_CHECK_STEADY_STATE_INTERVAL = "check_steady_state_interval";
    protected static final String PARAMETER_STEADY_STATE_COUNT = "steady_state_count";
    protected static final String PARAMETER_WARNING_FILE_LIMIT = "warning_file_limit";
    protected static final String PARAMETER_FILE_AGE = "file_age";
    protected static final String PARAMETER_FILE_SPEC = "file_spec";
    protected static final String PARAMETER_FILE_REGEX = "file_regex";
    protected static final String PARAMETER_FILE_SPECIFICATION = "file_specification";
    protected static final String PARAMETER_FILE_PATH = "file_path";
    protected static final String PARAMETERMAX_FILE_SIZE = "max_file_size";
    protected static final String PARAMETER_MIN_FILE_SIZE = "min_file_size";
    protected static final String PARAMETER_MAX_FILE_AGE = "max_file_age";
    protected static final String PARAMETER_MIN_FILE_AGE = "min_file_age";
    protected static final String PARAMETER_TARGET_FILE = "target_file";
    protected static final String PARAMETER_FILE = "file";
    protected static final String PARAMETER_SOURCE_FILE = "source_file";
    protected static final String PARAMETER_ON_EMPTY_RESULT_SET = "on_empty_result_set";
    protected static final String PARAMETER_SKIP_LAST_FILES = "skip_last_files";
    protected static final String PARAMETER_SKIP_FIRST_FILES = "skip_first_files";
    protected static final String PARAMETER_OVERWRITE = "overwrite";
    protected static final String PARAMETER_COUNT_FILES = "count_files";
    protected static final String ALL = "all";
    protected static final String TRUE = "true";
    protected static final String PARAMETER_REPLACEMENT = "replacement";
    protected static final String PARAMETER_REPLACING = "replacing";
    protected static final String PARAMETER_RAISE_ERROR_IF_RESULT_SET_IS = "Raise_Error_If_Result_Set_Is";
    protected static final String PARAMETER_EXPECTED_SIZE_OF_RESULT_SET = "Expected_Size_Of_Result_Set";
    protected static final String PARAMETER_RESULT_LIST_FILE = "Result_List_File";
    protected static final String PARAMETER_RECURSIVE = "recursive";
    protected static final String PARAMETER_CREATE_DIR = "create_dir";
    protected static final String PARAMETER_CREATE_FILE = "create_file";
    protected static final String PARAMETER_CREATE_FILES = "create_files";
    protected static final String PARAMETER_SORT_CRITERIA = "sort_criteria";
    protected static final String PARAMETER_SORT_ORDER = "sort_order";
    protected static final String PARAMETER_REMOVE_DIR = "remove_dir";
    protected static final String CLASS_NAME = "JobSchedulerFileOperationBase";
    protected static final String YES = "yes";
    private static final String ORDER_PARAMETER_SCHEDULER_FILE_PATH = "scheduler_file_path";
    private static final String ORDER_PARAMETER_SCHEDULER_FILE_PARENT = "scheduler_file_parent";
    private static final String ORDER_PARAMETER_SCHEDULER_FILE_NAME = "scheduler_file_name";
    private static final String PARAMETER_CREATE_ORDERS_FOR_ALL_FILES = "create_orders_for_all_files";
    private static final String PARAMETER_NEXT_STATE = "next_state";
    private static final String PARAMETER_ORDER_JOBCHAIN_NAME = "order_jobchain_name";
    private static final String PARAMETER_CREATE_ORDER = "create_order";
    private static final String PARAMETER_MERGE_ORDER_PARAMETER = "merge_order_parameter";
    protected final int isCaseInsensitive = 2;
    protected String filePath = System.getProperty("java.io.tmpdir");
    protected long lngFileAge = 86400000L;
    protected int warningFileLimit = 0;
    protected boolean flgOperationWasSuccessful = false;
    protected String name = null;
    protected String file = null;
    protected String fileSpec = ".*";
    protected String minFileAge = "0";
    protected String maxFileAge = "0";
    protected String minFileSize = "-1";
    protected String maxFileSize = "-1";
    protected int skipFirstFiles = 0;
    protected int skipLastFiles = 0;
    protected String strGracious = "false";
    protected String onEmptyResultSet = null;
    protected String resultList2File = null;
    protected int expectedSizeOfResultSet = 0;
    protected String raiseErrorIfResultSetIs = null;
    protected List<File> lstResultList = new Vector<File>();
    protected boolean flgCreateOrder = false;
    protected boolean flgMergeOrderParameter = false;
    protected boolean flgCreateOrders4AllFiles = false;
    protected String orderJobChainName = null;
    protected String nextState = null;
    protected boolean flgCheckSteadyStateOfFiles = false;
    protected long steadyCount = 30L;
    protected long checkSteadyStateInterval = 1000L;
    protected boolean flgUseNIOLock = false;
    protected SOSFileSystemOperations sosFileOperations = null;
    private final String fileSpecDefault = ".*";
    private final String fileSizeDefault = "-1";
    private final String JSJ_F_0110 = "JSJ_F_0110";
    private SOSOptionFileAge sosOptionFileAge = null;
    private SOSOptionTime sosOptionTime = null;
    public int noOfHitsInResultSet = 0;
    HashMap<String, String> params = null;
    String source = null;
    String target = null;
    int flags = 0;
    String replacing = null;
    String replacement = null;
    boolean countFiles = false;
    protected String sortCriteria;
    protected String sortOrder;

    private void resetVariables() {
        this.flgOperationWasSuccessful = false;
        this.name = null;
        this.file = null;
        this.fileSpec = ".*";
        this.minFileAge = "0";
        this.maxFileAge = "0";
        this.minFileSize = "-1";
        this.maxFileSize = "-1";
        this.skipFirstFiles = 0;
        this.skipLastFiles = 0;
        this.strGracious = "false";
        this.source = null;
        this.target = null;
        this.flags = 0;
        this.replacing = null;
        this.replacement = "";
        this.countFiles = false;
        this.noOfHitsInResultSet = 0;
        this.onEmptyResultSet = null;
        this.resultList2File = null;
        this.expectedSizeOfResultSet = 0;
        this.raiseErrorIfResultSetIs = null;
        this.lstResultList = null;
        this.flgCreateOrder = false;
        this.flgMergeOrderParameter = false;
        this.flgCreateOrders4AllFiles = false;
        this.orderJobChainName = null;
        this.sortOrder = null;
        this.sortCriteria = null;
        this.nextState = null;
        this.sosOptionFileAge = new SOSOptionFileAge(null, PARAMETER_FILE_AGE, PARAMETER_FILE_AGE, "0", "0", false);
        this.sosOptionTime = new SOSOptionTime(null, PARAMETER_CHECK_STEADY_STATE_INTERVAL, PARAMETER_CHECK_STEADY_STATE_INTERVAL, "1", "1", false);
        this.flgCheckSteadyStateOfFiles = false;
        this.steadyCount = 30L;
        this.checkSteadyStateInterval = 1000L;
    }

    protected boolean getParamBoolean(String pstrParamName, boolean pflgDefaultValue) {
        String strReturnValue = this.getParamValue(pstrParamName);
        boolean flgReturnValue = pflgDefaultValue;
        if (this.isNotNull(strReturnValue)) {
            try {
                flgReturnValue = this.toBoolean(strReturnValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return flgReturnValue;
    }

    protected long getParamLong(String pstrParamName, long plngDefaultValue) {
        long lngReturnValue = this.getParamInteger(pstrParamName);
        if (lngReturnValue == 0L) {
            lngReturnValue = plngDefaultValue;
        }
        return lngReturnValue;
    }

    protected int getParamInteger(String pstrParamName, int pintDefaultValue) {
        int intReturnValue = this.getParamInteger(pstrParamName);
        if (intReturnValue == 0) {
            intReturnValue = pintDefaultValue;
        }
        return intReturnValue;
    }

    protected int getParamInteger(String pstrParamName) {
        String strT = this.getParamValue(pstrParamName);
        int intRetVal = 0;
        try {
            if (this.isNotEmpty(strT)) {
                intRetVal = Integer.parseInt(strT);
            }
        }
        catch (Exception ex) {
            throw new JobSchedulerException(JSMessages.JSJ_E_0130.get(new Object[]{pstrParamName, ex.getMessage()}), (Throwable)ex);
        }
        return intRetVal;
    }

    protected String getParamValue(String[] pstrKeys, String pstrDefaultValue) {
        String strT = pstrDefaultValue;
        for (String strKey : pstrKeys) {
            String strK = this.getParamValue(strKey);
            if (!this.isNotEmpty(strK)) continue;
            strT = strK;
            break;
        }
        return strT;
    }

    protected String getParamValue(String pstrParamName, String pstrDefaultValue) {
        String strT = this.getParamValue(pstrParamName);
        if (this.isNull(strT)) {
            strT = pstrDefaultValue;
        }
        return strT;
    }

    protected String getParamValue(String pstrParamName) {
        this.name = pstrParamName;
        String strT = this.params.get(pstrParamName);
        if (this.isNull(strT) && this.isNull(strT = this.params.get(pstrParamName.toLowerCase()))) {
            strT = this.params.get(pstrParamName.replaceAll("_", "").toLowerCase());
        }
        if (this.isNotNull(strT) && !(strT = strT.trim()).isEmpty()) {
            if (pstrParamName.contains("password")) {
                LOGGER.info(JSMessages.JSJ_I_0040.params(new Object[]{pstrParamName, "*****"}));
            } else {
                LOGGER.info(JSMessages.JSJ_I_0040.params(new Object[]{pstrParamName, strT}));
            }
        }
        return strT;
    }

    public boolean initialize() {
        try {
            super.spooler_process();
            this.params = null;
            this.params = this.getSchedulerParameterAsProperties(this.getSpoolerProcess().getOrder());
            this.getParametersFromHashMap();
        }
        catch (Exception e) {
            LOGGER.error("Error during initializing", (Throwable)e);
            throw new JobSchedulerException(JSMessages.JSJ_E_0042.get(e), (Throwable)e);
        }
        return true;
    }

    protected void getParametersFromHashMap() throws Exception {
        this.resetVariables();
        this.flgCreateOrders4AllFiles = this.getParamBoolean(PARAMETER_CREATE_ORDERS_FOR_ALL_FILES, false);
        this.flgCreateOrder = this.getParamBoolean(PARAMETER_CREATE_ORDER, false) | this.flgCreateOrders4AllFiles;
        this.flgMergeOrderParameter = this.getParamBoolean(PARAMETER_MERGE_ORDER_PARAMETER, false);
        if (this.flgCreateOrder) {
            this.orderJobChainName = this.getParamValue(PARAMETER_ORDER_JOBCHAIN_NAME);
            if (this.isNull(this.orderJobChainName)) {
                throw new JobSchedulerException(JSMessages.JSJ_E_0020.params(new Object[]{PARAMETER_ORDER_JOBCHAIN_NAME}));
            }
            if (!this.spooler.job_chain_exists(this.orderJobChainName)) {
                throw new JobSchedulerException(JSMessages.JSJ_E_0041.params(new Object[]{this.orderJobChainName}));
            }
            this.nextState = this.getParamValue(PARAMETER_NEXT_STATE);
        } else {
            this.orderJobChainName = null;
            this.nextState = null;
            this.flgCreateOrders4AllFiles = false;
            this.flgMergeOrderParameter = false;
        }
        this.lngFileAge = this.calculateFileAge(this.getParamValue(PARAMETER_FILE_AGE, "0"));
        this.warningFileLimit = this.getParamInteger(PARAMETER_WARNING_FILE_LIMIT, 0);
        this.expectedSizeOfResultSet = this.getParamInteger(PARAMETER_EXPECTED_SIZE_OF_RESULT_SET, 0);
        this.raiseErrorIfResultSetIs = this.getParamValue(PARAMETER_RAISE_ERROR_IF_RESULT_SET_IS, "");
        this.resultList2File = this.getParamValue(PARAMETER_RESULT_LIST_FILE, "");
        this.onEmptyResultSet = this.getParamValue(PARAMETER_ON_EMPTY_RESULT_SET, "");
        this.file = this.filePath = this.getParamValue(new String[]{PARAMETER_SOURCE_FILE, PARAMETER_FILE, PARAMETER_FILE_PATH}, "");
        this.source = this.filePath;
        String spec = this.getParamValue(PARAMETER_FILE_SPEC);
        this.fileSpec = this.getParamValue(new String[]{PARAMETER_FILE_SPEC, PARAMETER_FILE_SPECIFICATION}, ".*");
        if (!this.isNotEmpty(spec) && !this.isNotEmpty(this.source)) {
            this.file = this.filePath = this.getParamValue(new String[]{ORDER_PARAMETER_SCHEDULER_FILE_PATH}, "");
            this.source = this.filePath;
        }
        this.target = this.getParamValue(PARAMETER_TARGET_FILE, null);
        this.minFileAge = this.getParamValue(PARAMETER_MIN_FILE_AGE, "0");
        this.sosOptionFileAge.setValue(this.minFileAge);
        this.minFileAge = String.valueOf(this.sosOptionFileAge.getAgeAsSeconds());
        this.maxFileAge = this.getParamValue(PARAMETER_MAX_FILE_AGE, "0");
        this.sosOptionFileAge.setValue(this.maxFileAge);
        this.maxFileAge = String.valueOf(this.sosOptionFileAge.getAgeAsSeconds());
        this.minFileSize = this.getParamValue(PARAMETER_MIN_FILE_SIZE, "-1");
        this.maxFileSize = this.getParamValue(PARAMETERMAX_FILE_SIZE, "-1");
        this.flgUseNIOLock = this.getParamBoolean("use_nio_lock", false);
        this.strGracious = this.getParamValue(PARAMTER_GRACIOUS, "false");
        this.skipFirstFiles = this.getParamInteger(PARAMETER_SKIP_FIRST_FILES, 0);
        this.skipLastFiles = this.getParamInteger(PARAMETER_SKIP_LAST_FILES, 0);
        this.sortCriteria = this.getParamValue(PARAMETER_SORT_CRITERIA, "name");
        this.sortOrder = this.getParamValue(PARAMETER_SORT_ORDER, "asc");
        this.flags = 0;
        String strCreateWhat = this.getParamValue(new String[]{PARAMETER_CREATE_DIR, PARAMETER_CREATE_FILE, PARAMETER_CREATE_FILES}, "false");
        if (this.toBoolean(strCreateWhat)) {
            this.flags |= 1;
        }
        if (this.getParamBoolean(PARAMTER_GRACIOUS, false)) {
            this.flags |= 2;
        }
        if (!this.getParamBoolean(PARAMETER_OVERWRITE, true)) {
            this.flags |= 4;
        }
        if (this.getParamBoolean(PARAMETER_RECURSIVE, false)) {
            this.flags |= 8;
        }
        if (this.getParamBoolean(PARAMETER_REMOVE_DIR, false)) {
            this.flags |= 0x10;
        }
        this.countFiles = this.getParamBoolean(PARAMETER_COUNT_FILES, false);
        if (this.countFiles && this.spooler_task.order() == null) {
            JSMessages.JSJ_E_0120.toLog(new Object[]{PARAMETER_COUNT_FILES});
        }
        this.replacing = this.getParamValue(PARAMETER_REPLACING, "");
        this.replacement = this.getParamValue(PARAMETER_REPLACEMENT, "");
        String strM = JSMessages.JSJ_E_0110.get(new Object[]{PARAMETER_REPLACEMENT, PARAMETER_REPLACING});
        if (this.isNotNull(this.replacing) && this.isNull(this.replacement)) {
            this.replacement = "";
        } else if (this.isNull(this.replacing) && this.isNotNull(this.replacement)) {
            throw new JobSchedulerException(strM);
        }
        this.flgCheckSteadyStateOfFiles = this.getParamBoolean(PARAMETER_CHECK_STEADY_STATE_OF_FILE, false);
        this.steadyCount = this.getParamLong(PARAMETER_STEADY_STATE_COUNT, 30L);
        this.sosOptionTime.setValue(this.getParamValue(PARAMETER_CHECK_STEADY_STATE_INTERVAL, "1"));
        this.checkSteadyStateInterval = this.sosOptionTime.getTimeAsSeconds() * 1000;
    }

    public void spooler_exit() {
        try {
            super.spooler_exit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isGraciousAll() {
        return this.strGracious != null && this.strGracious.equalsIgnoreCase(ALL);
    }

    public boolean isGraciousTrue() {
        boolean flgResult = false;
        try {
            if (this.isNotEmpty(this.strGracious)) {
                flgResult = this.toBoolean(this.strGracious);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return flgResult;
    }

    public void saveResultList() {
        List lstR;
        if (this.isNull(this.lstResultList)) {
            this.lstResultList = new Vector<File>();
        }
        if (this.isNotNull(lstR = this.sosFileOperations.lstResultList) && !lstR.isEmpty()) {
            this.lstResultList.addAll(lstR);
        }
    }

    public boolean createResultListParam(boolean pflgOperationWasSuccessful) {
        boolean flgR;
        String strFirstFile = "";
        String strResultSetFileList = "";
        if (this.isNull(this.lstResultList)) {
            this.saveResultList();
        }
        this.noOfHitsInResultSet = 0;
        if (this.isNotNull(this.lstResultList) && !this.lstResultList.isEmpty()) {
            this.noOfHitsInResultSet = this.lstResultList.size();
            strFirstFile = this.lstResultList.get(0).getAbsolutePath();
            for (File objFile : this.lstResultList) {
                strResultSetFileList = strResultSetFileList + objFile.getAbsolutePath() + ";";
            }
        }
        if (this.spooler_task.order() != null) {
            Order order = this.spooler_task.order();
            Variable_set orderParams = order.params();
            if (orderParams != null) {
                if (this.countFiles) {
                    orderParams.set_var(ORDER_PARAMETER_SCHEDULER_SOS_FILE_OPERATIONS_FILE_COUNT, String.valueOf(this.noOfHitsInResultSet));
                }
                orderParams.set_var(ORDER_PARAMETER_SCHEDULER_SOS_FILE_OPERATIONS_RESULT_SET, strResultSetFileList);
                orderParams.set_var(ORDEDR_PARAMETER_SCHEDULER_SOS_FILE_OPERATIONS_RESULT_SET_SIZE, String.valueOf(this.noOfHitsInResultSet));
            }
            if (this.isNotEmpty(this.onEmptyResultSet) && this.noOfHitsInResultSet <= 0) {
                JSMessages.JSJ_I_0090.toLog(new Object[]{this.onEmptyResultSet});
                order.set_state(this.onEmptyResultSet);
            }
        }
        if (this.isNotEmpty(this.resultList2File) && this.isNotEmpty(strResultSetFileList)) {
            LOGGER.debug("..try to write file:" + this.resultList2File);
            JSTextFile objResultListFile = new JSTextFile(this.resultList2File);
            try {
                if (!objResultListFile.canWrite()) {
                    throw new JobSchedulerException(JSMessages.JSJ_F_0090.get(new Object[]{PARAMETER_RESULT_LIST_FILE, this.resultList2File}));
                }
                objResultListFile.write(strResultSetFileList);
                objResultListFile.close();
                LOGGER.debug("..file close");
            }
            catch (Exception e) {
                JSMessages.JSJ_F_0080.toLog(new Object[]{this.resultList2File, PARAMETER_RESULT_LIST_FILE});
                throw new JobSchedulerException((Throwable)e);
            }
        }
        if (this.isNotEmpty(this.raiseErrorIfResultSetIs) && (flgR = this.compareIntValues(this.raiseErrorIfResultSetIs, this.noOfHitsInResultSet, this.expectedSizeOfResultSet))) {
            LOGGER.info(JSMessages.JSJ_E_0040.params(new Object[]{this.noOfHitsInResultSet, this.raiseErrorIfResultSetIs, this.expectedSizeOfResultSet}));
            return false;
        }
        if (this.noOfHitsInResultSet > 0 && this.flgCreateOrder && pflgOperationWasSuccessful) {
            if (this.flgCreateOrders4AllFiles) {
                for (File objFile : this.lstResultList) {
                    this.createOrder(objFile.getAbsolutePath(), this.orderJobChainName);
                }
            } else {
                this.createOrder(strFirstFile, this.orderJobChainName);
            }
        }
        return pflgOperationWasSuccessful;
    }

    public boolean toBoolean(String value) throws Exception {
        Hashtable<String, String> boolValues = new Hashtable<String, String>();
        boolValues.put(TRUE, TRUE);
        boolValues.put("false", "false");
        boolValues.put("j", TRUE);
        boolValues.put("ja", TRUE);
        boolValues.put("y", TRUE);
        boolValues.put(YES, TRUE);
        boolValues.put("n", "false");
        boolValues.put("nein", "false");
        boolValues.put("no", "false");
        boolValues.put("on", TRUE);
        boolValues.put("off", "false");
        boolValues.put("1", TRUE);
        boolValues.put("0", "false");
        boolValues.put(ALL, TRUE);
        boolValues.put("none", "false");
        try {
            if (value == null) {
                throw new JobSchedulerException("null");
            }
            String v = value.toLowerCase();
            String bool = (String)boolValues.get(v);
            if (bool == null) {
                throw new JobSchedulerException("\"" + value + "\"");
            }
            return TRUE.equals(bool);
        }
        catch (Exception e) {
            throw new JobSchedulerException("cannot evaluate to boolean: " + e.getMessage());
        }
    }

    public boolean compareIntValues(String pstrComparator, int pintValue1, int pintValue2) {
        HashMap<String, Integer> objRelOp = new HashMap<String, Integer>();
        objRelOp.put("eq", 1);
        objRelOp.put("equal", 1);
        objRelOp.put("==", 1);
        objRelOp.put("=", 1);
        objRelOp.put("ne", 2);
        objRelOp.put("not equal", 2);
        objRelOp.put("!=", 2);
        objRelOp.put("<>", 2);
        objRelOp.put("lt", 3);
        objRelOp.put("less than", 3);
        objRelOp.put("<", 3);
        objRelOp.put("le", 4);
        objRelOp.put("less or equal", 4);
        objRelOp.put("<=", 4);
        objRelOp.put("ge", 5);
        objRelOp.put(JSMessages.JSJ_T_0010.get(), 5);
        objRelOp.put(">=", 5);
        objRelOp.put("gt", 6);
        objRelOp.put("greater than", 6);
        objRelOp.put(">", 6);
        boolean flgR = false;
        String strT1 = pstrComparator;
        Integer iOp = (Integer)objRelOp.get(strT1.toLowerCase());
        if (this.isNotNull(iOp)) {
            switch (iOp) {
                case 1: {
                    flgR = pintValue1 == pintValue2;
                    break;
                }
                case 2: {
                    flgR = pintValue1 != pintValue2;
                    break;
                }
                case 3: {
                    flgR = pintValue1 < pintValue2;
                    break;
                }
                case 4: {
                    flgR = pintValue1 <= pintValue2;
                    break;
                }
                case 5: {
                    flgR = pintValue1 >= pintValue2;
                    break;
                }
                case 6: {
                    flgR = pintValue1 > pintValue2;
                    break;
                }
            }
        } else {
            throw new JobSchedulerException(JSMessages.JSJ_E_0017.get(new Object[]{pstrComparator}));
        }
        return flgR;
    }

    private void createOrder(String pstrOrder4FileName, String pstrOrderJobChainName) {
        String methodName = "JobSchedulerFileOperationBase::createOrder";
        Order objOrder = this.spooler.create_order();
        Variable_set objOrderParams = this.spooler.create_variable_set();
        if (this.flgMergeOrderParameter && this.spooler_task.job().order_queue() != null) {
            objOrderParams.merge(this.spooler_task.order().params());
        }
        objOrderParams.set_value(ORDER_PARAMETER_SCHEDULER_FILE_PATH, pstrOrder4FileName);
        objOrderParams.set_value(ORDER_PARAMETER_SCHEDULER_FILE_PARENT, new File(pstrOrder4FileName).getParent());
        objOrderParams.set_value(ORDER_PARAMETER_SCHEDULER_FILE_NAME, new File(pstrOrder4FileName).getName());
        if (this.isNotEmpty(this.nextState)) {
            objOrder.set_state(this.nextState);
        }
        objOrder.set_params(objOrderParams);
        objOrder.set_id(pstrOrder4FileName);
        objOrder.set_title(JSMessages.JSJ_I_0017.get(new Object[]{"JobSchedulerFileOperationBase::createOrder"}));
        Job_chain objJobchain = this.spooler.job_chain(pstrOrderJobChainName);
        objJobchain.add_order(objOrder);
        String strT = JSMessages.JSJ_I_0018.get(new Object[]{pstrOrder4FileName, pstrOrderJobChainName});
        if (this.isNotEmpty(this.nextState)) {
            strT = strT + " " + JSMessages.JSJ_I_0019.get(new Object[]{this.nextState});
        }
        LOGGER.info(strT);
    }

    public String replaceVars4(String pstrReplaceIn) {
        String strParamNameEnclosedInPercentSigns = "^.*%([^%]+)%.*$";
        if (this.isNotNull(pstrReplaceIn)) {
            while (pstrReplaceIn.matches(strParamNameEnclosedInPercentSigns)) {
                String p = pstrReplaceIn.replaceFirst(strParamNameEnclosedInPercentSigns, "$1");
                String strPP = "%" + p + "%";
                String s = this.params.get(p);
                if (this.isNotNull(s)) {
                    s = s.replace('\\', '/');
                    pstrReplaceIn = pstrReplaceIn.replaceAll(strPP, s);
                    JSMessages.JSJ_D_0044.toLog(new Object[]{this.name, strPP, s});
                    continue;
                }
                pstrReplaceIn = pstrReplaceIn.replaceAll(strPP, "?" + p + "?");
                JSMessages.JSJ_W_0043.toLog(new Object[]{p});
            }
        }
        return pstrReplaceIn;
    }

    public void setParams(HashMap<String, String> pobjparams) {
        this.params = pobjparams;
    }

    public boolean setReturnResult(Order order, boolean pflgResult) {
        boolean rc1 = pflgResult;
        rc1 = this.createResultListParam(pflgResult);
        if (!rc1 && this.isGraciousAll()) {
            return this.signalSuccess(order);
        }
        if (!rc1 && this.isGraciousTrue()) {
            return false;
        }
        if (rc1) {
            return this.signalSuccess(order);
        }
        return false;
    }

    public void checkMandatoryFile() {
        if (this.isNull(this.file)) {
            throw new JobSchedulerException(JSMessages.JSJ_E_0020.params(new Object[]{PARAMETER_FILE}));
        }
    }

    public void checkMandatorySource() {
        if (this.isNull(this.source)) {
            throw new JobSchedulerException(JSMessages.JSJ_E_0020.params(new Object[]{PARAMETER_SOURCE_FILE}));
        }
    }

    public void checkMandatoryTarget() {
        if (this.isNull(this.target)) {
            throw new JobSchedulerException(JSMessages.JSJ_E_0020.params(new Object[]{PARAMETER_TARGET_FILE}));
        }
    }

    public long calculateFileAge(String hoursMinSec) {
        long age = 0L;
        if (this.isNotEmpty(hoursMinSec)) {
            if (hoursMinSec.indexOf(":") > -1) {
                String[] timeArray = hoursMinSec.split(":");
                long hours = Long.parseLong(timeArray[0]);
                long minutes = Long.parseLong(timeArray[1]);
                long seconds = 0L;
                if (timeArray.length > 2) {
                    seconds = Long.parseLong(timeArray[2]);
                }
                age = hours * 3600000L + minutes * 60000L + seconds * 1000L;
            } else {
                age = Long.parseLong(hoursMinSec);
            }
        }
        return age;
    }

    public Variable_set getParams() {
        String methodName = "JSFileOperationBase::getParams";
        throw new JobSchedulerException(this.getMessages().getMsg("JSJ_F_0110", new Object[]{"JSFileOperationBase::getParams"}));
    }

    public void setParams(Variable_set params1) {
        String methodName = "JSFileOperationBase::setParams";
        throw new JobSchedulerException(this.getMessages().getMsg("JSJ_F_0110", new Object[]{"JSFileOperationBase::setParams"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkSteadyStateOfFiles() {
        if (this.isNull(this.lstResultList)) {
            this.saveResultList();
        }
        boolean flgAllFilesAreSteady = this.flgOperationWasSuccessful;
        if (this.flgOperationWasSuccessful && this.flgCheckSteadyStateOfFiles && !this.lstResultList.isEmpty()) {
            LOGGER.debug("checking file(s) for steady state");
            Vector<FileDescriptor> lstFD = new Vector<FileDescriptor>();
            for (File file : this.lstResultList) {
                FileDescriptor objFD = new FileDescriptor();
                objFD.lastFileLength = file.length();
                objFD.lastModificationDate = file.lastModified();
                objFD.FileName = file.getAbsolutePath();
                LOGGER.debug("filedescriptor is : " + objFD.lastModificationDate + ", " + objFD.lastFileLength);
                lstFD.add(objFD);
            }
            try {
                Thread.sleep(this.checkSteadyStateInterval);
            }
            catch (InterruptedException e1) {
                LOGGER.error(e1.getMessage(), (Throwable)e1);
            }
            int i = 0;
            while ((long)i < this.steadyCount) {
                flgAllFilesAreSteady = true;
                for (FileDescriptor objFD : lstFD) {
                    File objActFile = new File(objFD.FileName);
                    LOGGER.debug("result is : " + objActFile.lastModified() + ", " + objFD.lastModificationDate + ", " + objActFile.length() + ", " + objFD.lastFileLength);
                    if (this.flgUseNIOLock) {
                        try {
                            RandomAccessFile objRAFile = new RandomAccessFile(objActFile, "rw");
                            FileChannel channel = objRAFile.getChannel();
                            FileLock lock = channel.lock();
                            try {
                                lock = channel.tryLock();
                                LOGGER.debug(String.format("lock for file '%1$s' ok", objActFile.getAbsolutePath()));
                            }
                            catch (OverlappingFileLockException e) {
                                try {
                                    flgAllFilesAreSteady = false;
                                    LOGGER.info(String.format("File '%1$s' is open by someone else", objActFile.getAbsolutePath()));
                                }
                                catch (Throwable throwable) {
                                    lock.release();
                                    LOGGER.debug(String.format("release lock for '%1$s'", objActFile.getAbsolutePath()));
                                    if (objRAFile != null) {
                                        channel.close();
                                        objRAFile.close();
                                        objRAFile = null;
                                    }
                                    throw throwable;
                                }
                                lock.release();
                                LOGGER.debug(String.format("release lock for '%1$s'", objActFile.getAbsolutePath()));
                                if (objRAFile == null) break;
                                channel.close();
                                objRAFile.close();
                                objRAFile = null;
                                break;
                            }
                            lock.release();
                            LOGGER.debug(String.format("release lock for '%1$s'", objActFile.getAbsolutePath()));
                            if (objRAFile == null) break;
                            channel.close();
                            objRAFile.close();
                            objRAFile = null;
                            break;
                        }
                        catch (FileNotFoundException e) {
                            LOGGER.error(e.getMessage(), (Throwable)e);
                        }
                        catch (IOException e) {
                            LOGGER.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    if (objActFile.lastModified() != objFD.lastModificationDate || objActFile.length() != objFD.lastFileLength) {
                        flgAllFilesAreSteady = false;
                        objFD.lastModificationDate = objActFile.lastModified();
                        objFD.lastFileLength = objActFile.length();
                        objFD.flgIsSteady = false;
                        LOGGER.info(String.format("File '%1$s' changed during checking steady state", objActFile.getAbsolutePath()));
                        break;
                    }
                    objFD.flgIsSteady = true;
                }
                if (flgAllFilesAreSteady) break;
                try {
                    Thread.sleep(this.checkSteadyStateInterval);
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.error(interruptedException.getMessage(), (Throwable)interruptedException);
                }
                ++i;
            }
            if (!flgAllFilesAreSteady) {
                LOGGER.error("not all files are steady");
                for (FileDescriptor fileDescriptor : lstFD) {
                    if (fileDescriptor.flgIsSteady) continue;
                    LOGGER.info(String.format("File '%1$s' is not steady", fileDescriptor.FileName));
                }
                throw new JobSchedulerException("not all files are steady");
            }
        }
        return flgAllFilesAreSteady;
    }

    class FileDescriptor {
        public long lastModificationDate = 0L;
        public long lastFileLength = 0L;
        public String FileName = "";
        public boolean flgIsSteady = false;

        FileDescriptor() {
        }
    }
}

