/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.job;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.io.SOSFileSystemOperationsImpl;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.scheduler.messages.JSMessages;
import java.io.File;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.scheduler.file.JobSchedulerFileOperationBase;
import sos.util.SOSFile;

@I18NResourceBundle(baseName="com_sos_scheduler_messages", defaultLocale="en")
public class JobSchedulerCleanupFiles
extends JobSchedulerFileOperationBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSchedulerCleanupFiles.class);
    private static final String conClassName = "JobSchedulerCleanupFiles";

    public boolean spooler_process() {
        this.initialize();
        this.sosFileOperations = new SOSFileSystemOperationsImpl();
        try {
            String[] fileSpecs;
            if (this.isEmpty(this.filePath)) {
                this.filePath = "java.io.tmpdir";
            }
            String[] filePaths = this.filePath.split(";");
            String tmpFileSpec = this.getParamValue(new String[]{"file_spec", "file_specification"}, "");
            if (this.isEmpty(tmpFileSpec)) {
                this.fileSpec = "^(sos.*)";
            }
            if (this.lngFileAge <= 0L) {
                this.lngFileAge = this.calculateFileAge(this.getParamValue("file_age", "24:00"));
            }
            boolean flgPathAndSpecHasSameNumberOfItems = filePaths.length == (fileSpecs = this.fileSpec.split(";")).length;
            this.fileSpec = fileSpecs[0];
            for (int i = 0; i < filePaths.length; ++i) {
                int counter = 0;
                this.filePath = filePaths[i];
                if (this.filePath.trim().equalsIgnoreCase("java.io.tmpdir")) {
                    this.filePath = System.getProperty("java.io.tmpdir");
                }
                if (flgPathAndSpecHasSameNumberOfItems) {
                    this.fileSpec = fileSpecs[i];
                }
                LOGGER.debug(JSMessages.JFO_I_0019.params(new Object[]{this.filePath}));
                Vector filelist = SOSFile.getFolderlist((String)this.filePath, (String)this.fileSpec, (int)0);
                if (filelist.isEmpty()) {
                    LOGGER.info(JSMessages.JFO_I_0020.params(new Object[]{this.fileSpec}));
                }
                if (this.warningFileLimit > 0 && filelist.size() >= this.warningFileLimit) {
                    LOGGER.error(JSMessages.JFO_E_0016.params(new Object[]{filelist.size(), this.filePath, this.warningFileLimit, "warning_file_limit"}));
                }
                for (File tempFile : filelist) {
                    long interval = System.currentTimeMillis() - tempFile.lastModified();
                    if (interval <= this.lngFileAge) continue;
                    counter += SOSFile.deleteFile((File)tempFile);
                    LOGGER.info(JSMessages.JFO_I_0014.params(new Object[]{tempFile.getAbsolutePath()}));
                }
                if (counter <= 0) continue;
                String strT = this.filePath;
                LOGGER.info(JSMessages.JFO_I_0015.params(new Object[]{counter, strT}));
            }
            return this.signalSuccess(this.spooler_task.order());
        }
        catch (Exception e) {
            throw new JobSchedulerException(JSMessages.JSJ_F_0010.params(new Object[]{conClassName, e.getMessage()}), (Throwable)e);
        }
    }
}

