/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.job;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.hibernate.classes.SOSHibernateFactory;
import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.jitl.eventing.db.SchedulerEventDBLayer;
import com.sos.jitl.reporting.db.DBLayer;
import org.apache.xpath.XPathAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sos.scheduler.job.JobSchedulerJobAdapter;
import sos.spooler.Variable_set;

public class JobSchedulerExistsEventJob
extends JobSchedulerJobAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSchedulerExistsEventJob.class);
    private String scheduler_event_service_id = "";
    private String configurationFile = "";
    private boolean filterSchedulerId = true;

    public boolean spooler_process() throws Exception {
        super.spooler_process();
        boolean rc = true;
        try {
            Variable_set params = this.spooler.create_variable_set();
            if (this.spooler_task.params() != null) {
                params.merge(this.spooler_task.params());
            }
            if (this.spooler_job.order_queue() != null && this.spooler_task.order().params() != null) {
                params.merge(this.spooler_task.order().params());
            }
            String eventSpec = "";
            if (params.var("scheduler_event_spec") == null || params.var("scheduler_event_spec").isEmpty()) {
                throw new JobSchedulerException("parameter scheduler_event_spec is missing");
            }
            eventSpec = params.var("scheduler_event_spec");
            this.scheduler_event_service_id = params.var("scheduler_event_service_id") != null && !params.var("scheduler_event_service_id").isEmpty() ? params.var("scheduler_event_service_id") : this.spooler.id();
            if (params.var("filter_scheduler_id") != null && !params.var("filter_scheduler_id").isEmpty()) {
                this.filterSchedulerId = "true".equalsIgnoreCase(params.var("filter_scheduler_id"));
            }
            LOGGER.debug(".. job parameter [scheduler_event_service_id]: " + this.scheduler_event_service_id);
            LOGGER.debug(".. job parameter [scheduler_event_spec]: " + eventSpec);
            LOGGER.debug("Checking events for: " + eventSpec);
            this.configurationFile = this.getHibernateConfigurationReporting().toFile().getAbsolutePath();
            Document eventDocument = this.readEventsFromDB();
            NodeList nodes = XPathAPI.selectNodeList((Node)eventDocument, (String)eventSpec);
            if (nodes == null || nodes.getLength() == 0) {
                LOGGER.info("No matching events were found.");
                rc = false;
            } else {
                LOGGER.info("Matching events were found.");
                rc = true;
            }
        }
        catch (Exception e) {
            throw new JobSchedulerException("Error checking events: " + e, (Throwable)e);
        }
        return rc;
    }

    private SOSHibernateSession getSession(String confFile) throws Exception {
        SOSHibernateFactory sosHibernateFactory = new SOSHibernateFactory(confFile);
        sosHibernateFactory.addClassMapping(DBLayer.getReportingClassMapping());
        sosHibernateFactory.build();
        return sosHibernateFactory.openStatelessSession();
    }

    public Document readEventsFromDB() throws Exception {
        SchedulerEventDBLayer schedulerEventDBLayer = new SchedulerEventDBLayer(this.getSession(this.configurationFile));
        if (this.filterSchedulerId) {
            return schedulerEventDBLayer.getEventsAsXml(this.scheduler_event_service_id);
        }
        return schedulerEventDBLayer.getEventsAsXml("");
    }

    public void setConfigurationFile(String configurationFile) {
        this.configurationFile = configurationFile;
    }
}

