/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.job;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import sos.scheduler.command.SOSSchedulerCommand;
import sos.scheduler.job.JobSchedulerJobAdapter;
import sos.spooler.Variable_set;
import sos.xml.SOSXMLXPath;

public class JobSchedulerRemoteCommandJob
extends JobSchedulerJobAdapter {
    String host = "";
    int port = 0;
    int timeout = 0;
    String protocol = "";
    String command = "";
    String jobName = "";
    String orderId = "";
    String at = "";
    String webService = "";
    String after = "";
    boolean replace = true;
    String jobChain = "";
    String priority = "";
    String state = "";
    String title = "";
    String runTime = "";

    public void initParameters() {
        this.setHost("localhost");
        this.setPort(40444);
        this.setProtocol("http");
        this.setTimeout(60);
        this.setJobName("");
        this.setOrderId("");
        this.setCommand("");
        this.setAt("");
        this.setWebService("");
        this.setAfter("");
        this.setReplace(true);
        this.setJobChain("");
        this.setPriority("");
        this.setState("");
        this.setTitle("");
        this.setRunTime("");
    }

    public void getTaskParameters(boolean logValue) {
        try {
            if (this.spooler_task.params().var("scheduler_remote_host") != null && !this.spooler_task.params().var("scheduler_remote_host").isEmpty()) {
                this.setHost(this.spooler_task.params().var("scheduler_remote_host"));
                if (logValue) {
                    this.spooler_log.info(".. job parameter [scheduler_remote_host]: " + this.getHost());
                }
            }
            if (this.spooler_task.params().var("scheduler_remote_port") != null && !this.spooler_task.params().var("scheduler_remote_port").isEmpty()) {
                try {
                    this.setPort(Integer.parseInt(this.spooler_task.params().var("scheduler_remote_port")));
                    if (logValue) {
                        this.spooler_log.info(".. job parameter [scheduler_remote_port]: " + this.getPort());
                    }
                }
                catch (Exception e) {
                    throw new JobSchedulerException("illegal value specified for parameter [scheduler_remote_port], numeric value expected, found: " + this.spooler_task.params().var("scheduler_remote_port"), (Throwable)e);
                }
            }
            if (this.spooler_task.params().var("scheduler_remote_protocol") != null && !this.spooler_task.params().var("scheduler_remote_protocol").isEmpty()) {
                if (!"http".equalsIgnoreCase(this.spooler_task.params().var("scheduler_remote_protocol")) && !"https".equalsIgnoreCase(this.spooler_task.params().var("scheduler_remote_protocol"))) {
                    throw new JobSchedulerException("illegal value specified for parameter [scheduler_remote_protocol], \"http\" or \"https\" expected, found: " + this.spooler_task.params().var("scheduler_remote_protocol"));
                }
                this.setProtocol(this.spooler_task.params().var("scheduler_remote_protocol"));
                if (logValue) {
                    this.spooler_log.info(".. job parameter [scheduler_remote_protocol]: " + this.getProtocol());
                }
            }
            if (this.spooler_task.params().var("scheduler_remote_timeout") != null && !this.spooler_task.params().var("scheduler_remote_timeout").isEmpty()) {
                try {
                    this.setTimeout(Integer.parseInt(this.spooler_task.params().var("scheduler_remote_timeout")));
                    if (logValue) {
                        this.spooler_log.info(".. job parameter [scheduler_remote_timeout]: " + this.getTimeout());
                    }
                }
                catch (Exception e) {
                    throw new JobSchedulerException("illegal value specified for parameter [scheduler_remote_timeout], numeric value expected, found: " + this.spooler_task.params().var("scheduler_remote_timeout"), (Throwable)e);
                }
            }
            if (this.spooler_task.params().var("scheduler_remote_job") != null && !this.spooler_task.params().var("scheduler_remote_job").isEmpty()) {
                this.setJobName(this.spooler_task.params().var("scheduler_remote_job"));
                if (logValue) {
                    this.spooler_log.info(".. job parameter [scheduler_remote_job]: " + this.getJobName());
                }
            }
            if (this.spooler_task.params().var("scheduler_remote_order") != null && !this.spooler_task.params().var("scheduler_remote_order").isEmpty()) {
                this.setOrderId(this.spooler_task.params().var("scheduler_remote_order"));
                if (logValue) {
                    this.spooler_log.info(".. job parameter [scheduler_remote_order]: " + this.getOrderId());
                }
            }
            if (this.spooler_task.params().var("scheduler_remote_command") != null && !this.spooler_task.params().var("scheduler_remote_command").isEmpty()) {
                this.setCommand(this.spooler_task.params().var("scheduler_remote_command"));
                if (logValue) {
                    this.spooler_log.info(".. job parameter [scheduler_remote_command]: " + this.getCommand());
                }
            }
            if (this.spooler_task.params().var("scheduler_remote_start_at") != null && !this.spooler_task.params().var("scheduler_remote_start_at").isEmpty()) {
                this.setAt(this.spooler_task.params().var("scheduler_remote_start_at"));
                if (logValue) {
                    this.spooler_log.info(".. job parameter [scheduler_remote_start_at]: " + this.getAt());
                }
            }
            if (this.spooler_task.params().var("scheduler_remote_web_service") != null && !this.spooler_task.params().var("scheduler_remote_web_service").isEmpty()) {
                this.setWebService(this.spooler_task.params().var("scheduler_remote_web_service"));
                if (logValue) {
                    this.spooler_log.info(".. job parameter [scheduler_remote_web_service]: " + this.getWebService());
                }
            }
            if (this.spooler_task.params().var("scheduler_remote_job_start_after") != null && !this.spooler_task.params().var("scheduler_remote_job_start_after").isEmpty()) {
                this.setAfter(this.spooler_task.params().var("scheduler_remote_job_start_after"));
                if (logValue) {
                    this.spooler_log.info(".. job parameter [scheduler_remote_job_start_after]: " + this.getAfter());
                }
            }
            if (this.spooler_task.params().var("scheduler_remote_order_replace") != null && !this.spooler_task.params().var("scheduler_remote_order_replace").isEmpty()) {
                if ("yes".equalsIgnoreCase(this.spooler_task.params().var("scheduler_remote_order_replace")) || "true".equalsIgnoreCase(this.spooler_task.params().var("scheduler_remote_order_replace")) || "1".equals(this.spooler_task.params().var("scheduler_remote_order_replace"))) {
                    this.setReplace(true);
                } else {
                    this.setReplace(false);
                }
                if (logValue) {
                    this.spooler_log.info(".. job parameter [scheduler_remote_order_replace]: " + this.isReplace());
                }
            }
            if (this.spooler_task.params().var("scheduler_remote_order_job_chain") != null && !this.spooler_task.params().var("scheduler_remote_order_job_chain").isEmpty()) {
                this.setJobChain(this.spooler_task.params().var("scheduler_remote_order_job_chain"));
                if (logValue) {
                    this.spooler_log.info(".. job parameter [scheduler_remote_order_job_chain]: " + this.getJobChain());
                }
            }
            if (this.spooler_task.params().var("scheduler_remote_order_priority") != null && !this.spooler_task.params().var("scheduler_remote_order_priority").isEmpty()) {
                this.setPriority(this.spooler_task.params().var("scheduler_remote_order_priority"));
                if (logValue) {
                    this.spooler_log.info(".. job parameter [scheduler_remote_order_priority]: " + this.getPriority());
                }
            }
            if (this.spooler_task.params().var("scheduler_remote_order_state") != null && !this.spooler_task.params().var("scheduler_remote_order_state").isEmpty()) {
                this.setState(this.spooler_task.params().var("scheduler_remote_order_state"));
                if (logValue) {
                    this.spooler_log.info(".. job parameter [scheduler_remote_order_state]: " + this.getState());
                }
            }
            if (this.spooler_task.params().var("scheduler_remote_order_title") != null && !this.spooler_task.params().var("scheduler_remote_order_title").isEmpty()) {
                this.setTitle(this.spooler_task.params().var("scheduler_remote_order_title"));
                if (logValue) {
                    this.spooler_log.info(".. job parameter [scheduler_remote_order_title]: " + this.getTitle());
                }
            }
            if (this.spooler_task.params().var("scheduler_remote_order_run_time") != null && !this.spooler_task.params().var("scheduler_remote_order_run_time").isEmpty()) {
                this.setRunTime(this.spooler_task.params().var("scheduler_remote_order_run_time"));
                if (logValue) {
                    this.spooler_log.info(".. job parameter [scheduler_remote_order_run_time]: " + this.getRunTime());
                }
            }
        }
        catch (Exception e) {
            throw new JobSchedulerException("error occurred processing task parameters: " + e.getMessage(), (Throwable)e);
        }
    }

    public void getOrderParameters(Variable_set params, boolean logValue) {
        try {
            if (params.var("scheduler_remote_host") != null && !params.var("scheduler_remote_host").isEmpty()) {
                this.setHost(params.var("scheduler_remote_host"));
                if (logValue) {
                    this.spooler_log.info(".. order parameter [scheduler_remote_host]: " + this.getHost());
                }
            }
            if (params.var("scheduler_remote_port") != null && !params.var("scheduler_remote_port").isEmpty()) {
                try {
                    this.setPort(Integer.parseInt(params.var("scheduler_remote_port")));
                    if (logValue) {
                        this.spooler_log.info(".. order parameter [scheduler_remote_port]: " + this.getPort());
                    }
                }
                catch (Exception e) {
                    throw new JobSchedulerException("illegal value specified for parameter [scheduler_remote_port], numeric value expected, found: " + params.var("scheduler_remote_port"), (Throwable)e);
                }
            }
            if (params.var("scheduler_remote_protocol") != null && !params.var("scheduler_remote_protocol").isEmpty()) {
                if (!"http".equalsIgnoreCase(params.var("scheduler_remote_protocol")) && !"https".equalsIgnoreCase(params.var("scheduler_remote_protocol"))) {
                    throw new JobSchedulerException("illegal value specified for parameter [scheduler_remote_protocol], \"http\" or \"https\" expected, found: " + this.spooler_task.params().var("scheduler_remote_protocol"));
                }
                this.setProtocol(params.var("scheduler_remote_protocol"));
                if (logValue) {
                    this.spooler_log.info(".. order parameter [scheduler_remote_protocol]: " + this.getProtocol());
                }
            }
            if (params.var("scheduler_remote_timeout") != null && !params.var("scheduler_remote_timeout").isEmpty()) {
                try {
                    this.setTimeout(Integer.parseInt(params.var("scheduler_remote_timeout")));
                    if (logValue) {
                        this.spooler_log.info(".. order parameter [scheduler_remote_timeout]: " + this.getTimeout());
                    }
                }
                catch (Exception e) {
                    throw new JobSchedulerException("illegal value specified for parameter [scheduler_remote_timeout], numeric value expected, found: " + params.var("scheduler_remote_timeout"), (Throwable)e);
                }
            }
            if (params.var("scheduler_remote_job") != null && !params.var("scheduler_remote_job").isEmpty()) {
                this.setJobName(params.var("scheduler_remote_job"));
                if (logValue) {
                    this.spooler_log.info(".. order parameter [scheduler_remote_job]: " + this.getJobName());
                }
            }
            if (params.var("scheduler_remote_order") != null && !params.var("scheduler_remote_order").isEmpty()) {
                this.setOrderId(params.var("scheduler_remote_order"));
                if (logValue) {
                    this.spooler_log.info(".. order parameter [scheduler_remote_order]: " + this.getOrderId());
                }
            }
            if (params.var("scheduler_remote_command") != null && !params.var("scheduler_remote_command").isEmpty()) {
                this.setCommand(params.var("scheduler_remote_command"));
                if (logValue) {
                    this.spooler_log.info(".. order parameter [scheduler_remote_command]: " + this.getCommand());
                }
            }
            if (params.var("scheduler_remote_start_at") != null && !params.var("scheduler_remote_start_at").isEmpty()) {
                this.setAt(params.var("scheduler_remote_start_at"));
                if (logValue) {
                    this.spooler_log.info(".. order parameter [scheduler_remote_start_at]: " + this.getAt());
                }
            }
            if (params.var("scheduler_remote_web_service") != null && !params.var("scheduler_remote_web_service").isEmpty()) {
                this.setWebService(params.var("scheduler_remote_web_service"));
                if (logValue) {
                    this.spooler_log.info(".. order parameter [scheduler_remote_web_service]: " + this.getWebService());
                }
            }
            if (params.var("scheduler_remote_job_start_after") != null && !params.var("scheduler_remote_job_start_after").isEmpty()) {
                this.setAfter(params.var("scheduler_remote_job_start_after"));
                if (logValue) {
                    this.spooler_log.info(".. order parameter [scheduler_remote_job_start_after]: " + this.getAfter());
                }
            }
            if (params.var("scheduler_remote_order_replace") != null && !params.var("scheduler_remote_order_replace").isEmpty()) {
                if ("yes".equalsIgnoreCase(params.var("scheduler_remote_order_replace")) || "true".equalsIgnoreCase(params.var("scheduler_remote_order_replace")) || "1".equals(params.var("scheduler_remote_order_replace"))) {
                    this.setReplace(true);
                } else {
                    this.setReplace(false);
                }
                if (logValue) {
                    this.spooler_log.info(".. order parameter [scheduler_remote_order_replace]: " + this.isReplace());
                }
            }
            if (params.var("scheduler_remote_order_job_chain") != null && !params.var("scheduler_remote_order_job_chain").isEmpty()) {
                this.setJobChain(params.var("scheduler_remote_order_job_chain"));
                if (logValue) {
                    this.spooler_log.info(".. order parameter [scheduler_remote_order_job_chain]: " + this.getJobChain());
                }
            }
            if (params.var("scheduler_remote_order_priority") != null && !params.var("scheduler_remote_order_priority").isEmpty()) {
                this.setPriority(params.var("scheduler_remote_order_priority"));
                if (logValue) {
                    this.spooler_log.info(".. order parameter [scheduler_remote_order_priority]: " + this.getPriority());
                }
            }
            if (params.var("scheduler_remote_order_state") != null && !params.var("scheduler_remote_order_state").isEmpty()) {
                this.setState(params.var("scheduler_remote_order_state"));
                if (logValue) {
                    this.spooler_log.info(".. order parameter [scheduler_remote_order_state]: " + this.getState());
                }
            }
            if (params.var("scheduler_remote_order_title") != null && !params.var("scheduler_remote_order_title").isEmpty()) {
                this.setTitle(params.var("scheduler_remote_order_title"));
                if (logValue) {
                    this.spooler_log.info(".. order parameter [scheduler_remote_order_title]: " + this.getTitle());
                }
            }
            if (params.var("scheduler_remote_order_run_time") != null && !params.var("scheduler_remote_order_run_time").isEmpty()) {
                this.setRunTime(params.var("scheduler_remote_order_run_time"));
                if (logValue) {
                    this.spooler_log.info(".. order parameter [scheduler_remote_order_run_time]: " + this.getRunTime());
                }
            }
        }
        catch (Exception e) {
            throw new JobSchedulerException("error occurred processing order parameters: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean spooler_init() {
        try {
            this.initParameters();
            this.getTaskParameters(true);
            if (this.spooler_job.order_queue() == null) {
                if (this.spooler_task.params().var("scheduler_remote_host") == null || this.spooler_task.params().var("scheduler_remote_host").isEmpty()) {
                    throw new JobSchedulerException("no host name parameter [scheduler_remote_host] was specified for remote job scheduler");
                }
                if (!(this.spooler_task.params().var("scheduler_remote_job") != null && !this.spooler_task.params().var("scheduler_remote_job").isEmpty() || this.spooler_task.params().var("scheduler_remote_order_job_chain") != null && !this.spooler_task.params().var("scheduler_remote_order_job_chain").isEmpty() || this.spooler_task.params().var("scheduler_remote_command") != null && !this.spooler_task.params().var("scheduler_remote_command").isEmpty())) {
                    throw new JobSchedulerException("one of the parameters [scheduler_remote_job, scheduler_remote_order_job_chain, scheduler_remote_command] must be specified");
                }
            }
            return true;
        }
        catch (Exception e) {
            this.spooler_log.error("error occurred initializing job: " + e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean spooler_process() {
        String request = "";
        String response = "";
        Variable_set parameters = null;
        SOSSchedulerCommand remoteCommand = null;
        try {
            parameters = this.spooler_task.params();
            if (this.spooler_job.order_queue() != null) {
                parameters.merge(this.spooler_task.order().params());
                this.initParameters();
                this.getTaskParameters(false);
                this.getOrderParameters(this.spooler_task.order().params(), true);
            }
            int oneOfUs = 0;
            oneOfUs += this.getJobName() == null || this.getJobName().isEmpty() ? 0 : 1;
            oneOfUs += this.getJobChain() == null || this.getJobChain().isEmpty() ? 0 : 1;
            if ((oneOfUs += this.getCommand() == null || this.getCommand().isEmpty() ? 0 : 1) == 0) {
                throw new JobSchedulerException("one of the parameters [scheduler_remote_job, scheduler_remote_order_job_chain, scheduler_remote_command] must be specified");
            }
            if (oneOfUs > 1) {
                throw new JobSchedulerException("one of the parameters [scheduler_remote_job, scheduler_remote_order_job_chain, scheduler_remote_command] must be specified, " + oneOfUs + " were given");
            }
            if (this.getJobChain() != null && !this.getJobChain().isEmpty()) {
                request = "<add_order";
                request = request + " replace=\"" + (this.isReplace() ? "yes" : "no") + "\"";
                if (this.getOrderId() != null && !this.getOrderId().isEmpty()) {
                    request = request + " id=\"" + this.getOrderId() + "\"";
                }
                if (this.getAt() != null && !this.getAt().isEmpty()) {
                    request = request + " at=\"" + this.getAt() + "\"";
                }
                if (this.getJobChain() != null && !this.getJobChain().isEmpty()) {
                    request = request + " job_chain=\"" + this.getJobChain() + "\"";
                }
                if (this.getPriority() != null && !this.getPriority().isEmpty()) {
                    request = request + " priority=\"" + this.getPriority() + "\"";
                }
                if (this.getState() != null && !this.getState().isEmpty()) {
                    request = request + " state=\"" + this.getState() + "\"";
                }
                if (this.getTitle() != null && !this.getTitle().isEmpty()) {
                    request = request + " title=\"" + this.getTitle() + "\"";
                }
                if (this.getWebService() != null && !this.getWebService().isEmpty()) {
                    request = request + " web_service=\"" + this.getWebService() + "\"";
                }
                request = request + ">";
                request = request + this.writeParamsXML(parameters);
                if (this.getRunTime() != null && !this.getRunTime().isEmpty()) {
                    request = request + this.getRunTime();
                }
                request = request + "</add_order>";
            } else if (this.getJobName() != null && !this.getJobName().isEmpty()) {
                request = "<start_job job=\"" + this.getJobName() + "\"";
                if (this.getAfter() != null && !this.getAfter().isEmpty()) {
                    request = request + " after=\"" + this.getAfter() + "\"";
                }
                if (this.getAt() != null && !this.getAt().isEmpty()) {
                    request = request + " at=\"" + this.getAt() + "\"";
                }
                if (this.getWebService() != null && !this.getWebService().isEmpty()) {
                    request = request + " web_service=\"" + this.getWebService() + "\"";
                }
                request = request + ">";
                request = request + this.writeParamsXML(parameters);
                request = request + "</start_job>";
            } else {
                request = this.getCommand();
            }
            remoteCommand = new SOSSchedulerCommand(this.getHost(), this.getPort(), this.getProtocol());
            remoteCommand.setTimeout(this.timeout);
            remoteCommand.connect();
            this.spooler_log.info("sending request to remote Job Scheduler [" + this.getHost() + ":" + this.getPort() + "]: " + request);
            remoteCommand.sendRequest(request);
            response = remoteCommand.getResponse();
            SOSXMLXPath xpath = new SOSXMLXPath(new StringBuffer(response));
            String errCode = xpath.selectSingleNodeValue("//ERROR/@code");
            String errMessage = xpath.selectSingleNodeValue("//ERROR/@text");
            this.spooler_log.info("remote job scheduler response: " + response);
            if (errCode != null && !errCode.isEmpty() || errMessage != null && !errMessage.isEmpty()) {
                throw new JobSchedulerException(String.format("remote JobScheduler response reports error message: %1$s [%2$s]", errMessage, errCode));
            }
            boolean bl = this.spooler_job.order_queue() != null;
            return bl;
        }
        catch (Exception e) {
            this.spooler_log.error("error occurred for remote execution: " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (remoteCommand != null) {
                try {
                    remoteCommand.disconnect();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String writeParamsXML(Variable_set parameters) {
        String paramsXml = "<params>";
        String[] params = parameters.names().split(";");
        for (int i = 0; i < params.length; ++i) {
            if (params[i].startsWith("scheduler_remote_")) continue;
            paramsXml = paramsXml + "<param name=\"" + params[i] + "\" value=\"" + parameters.var(params[i]).replaceAll("&", "&amp;") + "\"/>";
        }
        paramsXml = paramsXml + "</params>";
        return paramsXml;
    }

    public String getAfter() {
        return this.after;
    }

    public void setAfter(String after) {
        this.after = after;
    }

    public String getAt() {
        return this.at;
    }

    public void setAt(String at) {
        this.at = at;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getJobChain() {
        return this.jobChain;
    }

    public void setJobChain(String jobChain) {
        this.jobChain = jobChain;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        if (protocol == null || protocol.isEmpty()) {
            throw new JobSchedulerException("no value was given for protocol [http, https]");
        }
        if (!"http".equalsIgnoreCase(protocol) && !"https".equalsIgnoreCase(protocol)) {
            throw new JobSchedulerException("illegal value specified for protocol [http, https], found: " + protocol);
        }
        this.protocol = protocol.toLowerCase();
    }

    public String getRunTime() {
        return this.runTime;
    }

    public void setRunTime(String runTime) {
        this.runTime = runTime;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getWebService() {
        return this.webService;
    }

    public void setWebService(String webService) {
        this.webService = webService;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public void setReplace(boolean replace) {
        this.replace = replace;
    }
}

