/*
 * Decompiled with CFR 0.152.
 */
package js7.agent.scheduler.order;

import cats.Applicative;
import cats.Foldable;
import cats.Traverse;
import cats.UnorderedFoldable;
import cats.UnorderedFoldable$;
import cats.UnorderedTraverse;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Outcome;
import cats.instances.package;
import cats.kernel.CommutativeMonoid;
import cats.kernel.Monoid;
import cats.kernel.Semigroup$;
import cats.syntax.ParallelUnorderedSequenceOps$;
import cats.syntax.package;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.Logger;
import fs2.Chunk;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.concurrent.Signal;
import fs2.concurrent.SignallingRef$;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import js7.agent.data.AgentState;
import js7.agent.data.orderwatch.FileWatchState;
import js7.agent.data.orderwatch.FileWatchState$;
import js7.agent.scheduler.order.FileWatchManager$;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.fs2utils.StreamExtensions$;
import js7.base.io.file.watch.DirectoryEvent;
import js7.base.io.file.watch.DirectoryEvent$FileAdded$;
import js7.base.io.file.watch.DirectoryEvent$FileDeleted$;
import js7.base.io.file.watch.DirectoryEventDelayer$;
import js7.base.io.file.watch.DirectoryState;
import js7.base.io.file.watch.DirectoryWatch$;
import js7.base.io.file.watch.DirectoryWatchSettings;
import js7.base.io.file.watch.DirectoryWatchSettings$;
import js7.base.log.Logger$syntax$;
import js7.base.monixutils.AsyncMap;
import js7.base.monixutils.AsyncMap$;
import js7.base.problem.Checked$;
import js7.base.problem.Problem;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$DurationRichInt$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.utils.CatsUtils$syntax$;
import js7.base.utils.Delayer;
import js7.base.utils.Delayer$extensions$;
import js7.base.utils.LockKeeper;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichEither$;
import js7.base.utils.ScalaUtils$syntax$RichEitherF$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import js7.base.utils.ScalaUtils$syntax$RichView$;
import js7.base.utils.SimplePattern;
import js7.data.agent.AgentPath;
import js7.data.agent.AgentPath$;
import js7.data.event.KeyedEvent;
import js7.data.event.KeyedEvent$NoKey$;
import js7.data.event.Stamped;
import js7.data.item.BasicItemEvent$ItemAttachedToMe$;
import js7.data.item.BasicItemEvent$ItemDetached$;
import js7.data.item.InventoryItemState;
import js7.data.item.ItemRevision;
import js7.data.orderwatch.ExternalOrderName;
import js7.data.orderwatch.ExternalOrderName$;
import js7.data.orderwatch.FileWatch;
import js7.data.orderwatch.FileWatch$;
import js7.data.orderwatch.OrderWatchEvent;
import js7.data.orderwatch.OrderWatchEvent$ExternalOrderAppeared$;
import js7.data.orderwatch.OrderWatchEvent$ExternalOrderVanished$;
import js7.data.orderwatch.OrderWatchPath;
import js7.data.value.StringValue$;
import js7.data.value.Value;
import js7.data.value.expression.Expression;
import js7.data.value.expression.scopes.EnvScope$;
import js7.data.value.package$NamedValues$;
import js7.data.workflow.WorkflowPath;
import js7.journal.state.Journal;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.View;
import scala.collection.View$;
import scala.collection.generic.DefaultSerializable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Right$;
import sourcecode.Enclosing$;

public final class FileWatchManager {
    private final AgentPath ownAgentPath;
    private final Journal<AgentState> journal;
    private final DirectoryWatchSettings settings;
    private final LockKeeper<OrderWatchPath> lockKeeper;
    private final AsyncMap<OrderWatchPath, IO<BoxedUnit>> idToStopper;

    public FileWatchManager(AgentPath ownAgentPath, Journal<AgentState> journal, Config config) {
        this.ownAgentPath = ownAgentPath;
        this.journal = journal;
        Either either = ScalaUtils$syntax$.MODULE$.RichEither(DirectoryWatchSettings$.MODULE$.fromConfig(config));
        this.settings = (DirectoryWatchSettings)ScalaUtils$syntax$RichEither$.MODULE$.orThrow$extension(either);
        this.lockKeeper = new LockKeeper();
        this.idToStopper = AsyncMap$.MODULE$.apply(Predef$.MODULE$.Map().empty(), Tag$.MODULE$.apply(OrderWatchPath.class, LightTypeTag$.MODULE$.parse(-1256054345, "\u0004\u0000\u0001\"js7.data.orderwatch.OrderWatchPath\u0001\u0001", "\u0000\u0007\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.UnsignedItemKey\u0001\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u001cjs7.data.item.SimpleItemPath\u0001\u0001\u0003\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001\u0090\u0007\u0001\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.UnsignedItemPath\u0001\u0001\u0002\u0004\u0000\u0001\u0090\u0007\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0004\u0000\u0001\"js7.data.orderwatch.OrderWatchPath\u0001\u0001\u000b\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0004\u0000\u0001\u0090\u0007\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0004\u0000\u0001$js7.data.item.UnsignedSimpleItemPath\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u00012js7.data.item.InventoryItemPath$.AttachableToAgent\u0001\u0002\u0003\u0000\u0000\u0090\u0007\u0001\u0001\u0004\u0000\u0001\u0090\f\u0001\u0001\u0006\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0004\u0000\u0001\u0090\u0007\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u000b\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0000\u0001\u0090\f\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\r\u0001\u0002\u0003\u0000\u0000\u0090\u0007\u0001\u0001", 30)), Tag$.MODULE$.apply(IO.class, LightTypeTag$.MODULE$.parse(-489763023, "\u0001\u0001\u0001\u000ecats.effect.IO\u0001\u0000\u0004\u0000\u0001\nscala.Unit\u0001\u0001\u0002\u0001", "\u0000\u0002\u0004\u0000\u0001\nscala.Unit\u0001\u0001\u0001\u0004\u0000\u0001\fscala.AnyVal\u0001\u0001\u0001\u0001\u0001\u000ecats.effect.IO\u0001\u0000\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0002\u0001\u0002\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0001\u0001\u0001\u0016cats.effect.IOPlatform\u0001\u0000\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0002\u0001\u0002\u0000\u0001\u0090\u0004\u0001\u0001\u0002\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001", 30)));
    }

    public IO<BoxedUnit> stop() {
        return this.idToStopper.removeAll(Enclosing$.MODULE$.apply("js7.agent.scheduler.order.FileWatchManager#stop")).flatMap((Function1 & Serializable)_$1 -> {
            Vector vector = (Vector)package.parallel$.MODULE$.catsSyntaxParallelUnorderedSequence((Object)_$1.values().toVector());
            return (IO)ParallelUnorderedSequenceOps$.MODULE$.parUnorderedSequence$extension((Object)vector, IO$.MODULE$.parallelForIO(), IO$.MODULE$.commutativeApplicativeForIOPar(), (UnorderedTraverse)package.vector$.MODULE$.catsStdInstancesForVector());
        }).map((Function1)(JProcedure1 & Serializable)_$2 -> package.foldable$.MODULE$.toUnorderedFoldableOps(_$2, (UnorderedFoldable)package.vector$.MODULE$.catsStdInstancesForVector()).unorderedFold((CommutativeMonoid)Semigroup$.MODULE$.catsKernelInstancesForUnit()));
    }

    public IO<Either<Problem, BoxedUnit>> start() {
        return this.journal.state().map((Function1 & Serializable)_$3 -> _$3.keyTo((InventoryItemState.Companion)FileWatchState$.MODULE$).values()).flatMap((Function1 & Serializable)_$4 -> ((IO)package.traverse$.MODULE$.toTraverseOps((Object)_$4.toVector(), (Traverse)package.vector$.MODULE$.catsStdInstancesForVector()).traverse((Function1 & Serializable)fileWatchState -> this.startWatching((FileWatchState)fileWatchState), (Applicative)IO$.MODULE$.asyncForIO())).map((Function1 & Serializable)_$5 -> (Either)package.foldable$.MODULE$.toFoldableOps(_$5, (Foldable)package.vector$.MODULE$.catsStdInstancesForVector()).combineAll(Semigroup$.MODULE$.catsKernelMonoidForEither((Monoid)Semigroup$.MODULE$.catsKernelInstancesForUnit()))));
    }

    public IO<Either<Problem, BoxedUnit>> update(FileWatch fileWatch) {
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.lockKeeper.lock(fileWatch.path(), this.journal.persist((Function1 & Serializable)agentState -> {
            Nil$ nil$;
            Right$ right$ = package$.MODULE$.Right();
            Option option = agentState.keyTo((InventoryItemState.Companion)FileWatchState$.MODULE$).get((Object)fileWatch.path());
            if (option instanceof Some) {
                FileWatchState watchState = (FileWatchState)((Some)option).value();
                FileWatch fileWatch = watchState.fileWatch();
                FileWatch fileWatch2 = fileWatch;
                if (!(fileWatch != null ? !((Object)fileWatch).equals(fileWatch2) : fileWatch2 != null)) {
                    nil$ = package$.MODULE$.Nil();
                } else {
                    FileWatch fileWatch3 = FileWatchManager.reduce$1(fileWatch);
                    FileWatch fileWatch4 = FileWatchManager.reduce$1(watchState.fileWatch());
                    View<KeyedEvent<OrderWatchEvent.ExternalOrderVanished>> vanished = !(fileWatch3 != null ? !((Object)fileWatch3).equals(fileWatch4) : fileWatch4 != null) ? View$.MODULE$.empty() : watchState.allFilesVanished();
                    View RichView_this = ScalaUtils$syntax$.MODULE$.RichView(vanished);
                    KeyedEvent$NoKey$ keyedEvent$NoKey$ = KeyedEvent$NoKey$.MODULE$;
                    KeyedEvent b$proxy1 = BasicItemEvent$ItemAttachedToMe$.MODULE$.apply(fileWatch).toKeyedEvent(keyedEvent$NoKey$);
                    nil$ = ScalaUtils$syntax$RichView$.MODULE$.appended$extension(RichView_this, b$proxy1).toVector();
                }
            } else if (None$.MODULE$.equals(option)) {
                KeyedEvent$NoKey$ keyedEvent$NoKey$ = KeyedEvent$NoKey$.MODULE$;
                KeyedEvent keyedEvent = BasicItemEvent$ItemAttachedToMe$.MODULE$.apply(fileWatch).toKeyedEvent(keyedEvent$NoKey$);
                nil$ = package$.MODULE$.Nil().$colon$colon((Object)keyedEvent);
            } else {
                throw new MatchError((Object)option);
            }
            return right$.apply((Object)nil$);
        }), Enclosing$.MODULE$.apply("js7.agent.scheduler.order.FileWatchManager#update")));
        return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)x$1 -> {
            Seq seq = (Seq)x$1._1();
            AgentState agentState = (AgentState)x$1._2();
            return this.startWatching((FileWatchState)agentState.keyTo((InventoryItemState.Companion)FileWatchState$.MODULE$).apply((Object)fileWatch.path()));
        }, IO$.MODULE$.asyncForIO());
    }

    public IO<Either<Problem, BoxedUnit>> remove(OrderWatchPath fileWatchPath) {
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.journal.persist((Function1 & Serializable)agentState -> {
            Nil$ nil$;
            Right$ right$ = package$.MODULE$.Right();
            Option option = agentState.keyTo((InventoryItemState.Companion)FileWatchState$.MODULE$).get((Object)fileWatchPath);
            if (None$.MODULE$.equals(option)) {
                nil$ = package$.MODULE$.Nil();
            } else if (option instanceof Some) {
                FileWatchState fileWatchState = (FileWatchState)((Some)option).value();
                KeyedEvent$NoKey$ keyedEvent$NoKey$ = KeyedEvent$NoKey$.MODULE$;
                nil$ = (DefaultSerializable)fileWatchState.allFilesVanished().toVector().$colon$plus((Object)BasicItemEvent$ItemDetached$.MODULE$.apply(fileWatchPath, this.ownAgentPath).toKeyedEvent(keyedEvent$NoKey$));
            } else {
                throw new MatchError((Object)option);
            }
            return right$.apply((Object)nil$);
        }));
        return this.lockKeeper.lock(fileWatchPath, (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)x$1 -> {
            Seq seq = (Seq)x$1._1();
            AgentState agentState = (AgentState)x$1._2();
            return this.stopWatching(fileWatchPath).as(Checked$.MODULE$.unit());
        }, IO$.MODULE$.asyncForIO()), Enclosing$.MODULE$.apply("js7.agent.scheduler.order.FileWatchManager#remove"));
    }

    private IO<Either<Problem, BoxedUnit>> startWatching(FileWatchState fileWatchState) {
        OrderWatchPath id = fileWatchState.fileWatch().path();
        return Logger$syntax$.MODULE$.debugIO(FileWatchManager$.js7$agent$scheduler$order$FileWatchManager$$$logger, "startWatching", (Function0<Object>)((Function0 & Serializable)() -> FileWatchManager.startWatching$$anonfun$1(id)), ((IO)SignallingRef$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false), (GenConcurrent)IO$.MODULE$.asyncForIO())).flatMap((Function1 & Serializable)stop -> {
            IO iO = (IO)package.traverse$.MODULE$.toTraverseOps(this.watch(fileWatchState, (Signal<IO, Object>)stop), UnorderedFoldable$.MODULE$.catsTraverseForEither()).traverse((Function1 & Serializable)stream -> this.idToStopper.update(fileWatchState.id(), (Function1<Option<IO<BoxedUnit>>, IO<IO<BoxedUnit>>>)(Function1 & Serializable)previous -> ((IO)previous.getOrElse(FileWatchManager::$anonfun$1$$anonfun$1$$anonfun$1)).$times$greater(stream.handleError((Function1)(JProcedure1 & Serializable)throwable -> {
                Logger LoggerImpl_this = FileWatchManager$.js7$agent$scheduler$order$FileWatchManager$$$logger;
                if (LoggerImpl_this.underlying().isErrorEnabled()) {
                    Throwable throwable2 = ScalaUtils$syntax$.MODULE$.RichThrowable(throwable);
                    LoggerImpl_this.underlying().error(ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable2));
                    return;
                }
            }).start().map((Function1 & Serializable)fiber -> {
                IO iO = (IO)CatsEffectExtensions$.MODULE$.joinStd(fiber, IO$.MODULE$.asyncForIO());
                return Logger$syntax$.MODULE$.debugIO(FileWatchManager$.js7$agent$scheduler$order$FileWatchManager$$$logger, "Stop watching", (Function0<Object>)((Function0 & Serializable)() -> FileWatchManager.$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$1(id)), ((IO)stop.set((Object)BoxesRunTime.boxToBoolean((boolean)true))).$times$greater(CatsUtils$syntax$.MODULE$.logWhenItTakesLonger(iO, (Function0<String>)((Function0 & Serializable)() -> FileWatchManager.$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$2(id)), CatsUtils$syntax$.MODULE$.logWhenItTakesLonger$default$3(iO))));
            })), Enclosing$.MODULE$.apply("js7.agent.scheduler.order.FileWatchManager#startWatching")).void(), (Applicative)IO$.MODULE$.asyncForIO());
            return CatsUtils$syntax$.MODULE$.logWhenItTakesLonger(iO, (Function0<String>)((Function0 & Serializable)() -> FileWatchManager.startWatching$$anonfun$2$$anonfun$1(id)), CatsUtils$syntax$.MODULE$.logWhenItTakesLonger$default$3(iO));
        }));
    }

    private IO<BoxedUnit> stopWatching(OrderWatchPath id) {
        return Logger$syntax$.MODULE$.debugIO(FileWatchManager$.js7$agent$scheduler$order$FileWatchManager$$$logger, "stopWatching", (Function0<Object>)((Function0 & Serializable)() -> FileWatchManager.stopWatching$$anonfun$1(id)), this.idToStopper.remove(id, Enclosing$.MODULE$.apply("js7.agent.scheduler.order.FileWatchManager#stopWatching")).flatMap((Function1 & Serializable)_$8 -> (IO)_$8.getOrElse(FileWatchManager::stopWatching$$anonfun$2$$anonfun$1)));
    }

    private Either<Problem, IO<BoxedUnit>> watch(FileWatchState fileWatchState, Signal<IO, Object> stop) {
        return fileWatchState.fileWatch().directoryExpr().evalAsString(EnvScope$.MODULE$).flatMap((Function1 & Serializable)string -> Checked$.MODULE$.catchNonFatal(() -> FileWatchManager.watch$$anonfun$1$$anonfun$1(string))).map((Function1 & Serializable)directory -> {
            ObjectRef directoryState = ObjectRef.create((Object)fileWatchState.directoryState());
            return Delayer$extensions$.MODULE$.onFailureRestartWithDelayer((IO)StreamExtensions$.MODULE$.onStart(DirectoryWatch$.MODULE$.stream((Path)directory, (DirectoryState)directoryState.elem, this.settings, (Function1<Path, Object>)(Function1 & Serializable)relativePath -> fileWatchState.fileWatch().matchesFilename(relativePath.toString())), IO$.MODULE$.apply((Function0 & Serializable)() -> {
                FileWatchManager.watch$$anonfun$2$$anonfun$2(fileWatchState, directory);
                return BoxedUnit.UNIT;
            })).interruptWhen(stop, (GenConcurrent)IO$.MODULE$.asyncForIO()).through(DirectoryEventDelayer$.MODULE$.apply((Path)directory, fileWatchState.fileWatch().delay(), this.settings.logDelayConf())).chunks().evalMap((Function1 & Serializable)chunk -> this.lockKeeper.lock(fileWatchState.fileWatch().path(), this.emitOrderWatchEvents(fileWatchState.fileWatch(), (Path)directory, (Chunk<DirectoryEvent>)chunk), Enclosing$.MODULE$.apply("js7.agent.scheduler.order.FileWatchManager#watch"))).foreach((Function1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Left) {
                    Problem problem = (Problem)((Left)either).value();
                    return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                        FileWatchManager.watch$$anonfun$2$$anonfun$4$$anonfun$1(problem);
                        return BoxedUnit.UNIT;
                    });
                }
                if (either instanceof Right) {
                    AgentState agentState = (AgentState)((Tuple2)((Right)either).value())._2();
                    return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                        FileWatchManager.watch$$anonfun$2$$anonfun$4$$anonfun$2(directoryState, agentState, fileWatchState);
                        return BoxedUnit.UNIT;
                    });
                }
                throw new MatchError((Object)either);
            }).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).drain(), this.settings.delayConf(), (Function2<Delayer<IO>, Throwable, IO<BoxedUnit>>)(Function2 & Serializable)(delayer, throwable) -> delayer.peekNextDelay().map((Function1)(JProcedure1 & Serializable)delay -> {
                Logger LoggerImpl_this = FileWatchManager$.js7$agent$scheduler$order$FileWatchManager$$$logger;
                if (LoggerImpl_this.underlying().isErrorEnabled()) {
                    Object[] objectArray = new Object[2];
                    objectArray[0] = ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration((FiniteDuration)delay));
                    Throwable throwable = ScalaUtils$syntax$.MODULE$.RichThrowable(throwable);
                    objectArray[1] = ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable);
                    LoggerImpl_this.underlying().error("Delay {} after error: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), Object.class));
                }
                Throwable throwable = ScalaUtils$syntax$.MODULE$.RichThrowable(throwable);
                ScalaUtils$syntax$RichThrowable$.MODULE$.ifStackTrace$extension(throwable).foreach((Function1)(JProcedure1 & Serializable)t -> {
                    Logger LoggerImpl_this = FileWatchManager$.js7$agent$scheduler$order$FileWatchManager$$$logger;
                    if (LoggerImpl_this.underlying().isDebugEnabled()) {
                        LoggerImpl_this.underlying().debug(t.toString(), t);
                        return;
                    }
                });
            }), Enclosing$.MODULE$.apply("js7.agent.scheduler.order.FileWatchManager#watch")).guaranteeCase((Function1 & Serializable)exitCase -> IO$.MODULE$.apply((Function0 & Serializable)() -> {
                FileWatchManager.watch$$anonfun$2$$anonfun$6$$anonfun$1(fileWatchState, exitCase, directory);
                return BoxedUnit.UNIT;
            }));
        });
    }

    private IO<Either<Problem, Tuple2<Seq<Stamped<KeyedEvent<OrderWatchEvent>>>, AgentState>>> emitOrderWatchEvents(FileWatch fileWatch, Path directory, Chunk<DirectoryEvent> dirEventSeqs) {
        return this.journal.state().flatMap((Function1 & Serializable)agentState2 -> {
            if (!agentState2.keyTo((InventoryItemState.Companion)FileWatchState$.MODULE$).contains((Object)fileWatch.path())) {
                Nil$ nil$ = (Nil$)Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.Nil());
                return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)nil$, agentState2));
            }
            return this.journal.persist((Function1 & Serializable)agentState -> package$.MODULE$.Right().apply(((StrictOptimizedIterableOps)Option$.MODULE$.option2Iterable(agentState.keyTo((InventoryItemState.Companion)FileWatchState$.MODULE$).get((Object)fileWatch.path())).toVector().flatMap((Function1 & Serializable)fileWatchState -> (IterableOnce)dirEventSeqs.asSeq().flatMap((Function1 & Serializable)dirEvent -> {
                block2: {
                    DirectoryEvent.FileDeleted fileDeleted;
                    Path path;
                    Path path2;
                    DirectoryEvent.FileAdded fileAdded;
                    Path path3;
                    Path path4;
                    DirectoryEvent directoryEvent = dirEvent;
                    if (directoryEvent instanceof DirectoryEvent.FileAdded && !fileWatchState.containsPath(path4 = (path3 = (fileAdded = DirectoryEvent$FileAdded$.MODULE$.unapply((DirectoryEvent.FileAdded)directoryEvent))._1()))) {
                        return Some$.MODULE$.apply((Object)OrderWatchEvent$ExternalOrderAppeared$.MODULE$.apply((ExternalOrderName)ExternalOrderName$.MODULE$.apply(path4.toString()), this.toOrderArguments(directory, path4), OrderWatchEvent$ExternalOrderAppeared$.MODULE$.$lessinit$greater$default$3()));
                    }
                    if (directoryEvent instanceof DirectoryEvent.FileDeleted && fileWatchState.containsPath(path2 = (path = (fileDeleted = DirectoryEvent$FileDeleted$.MODULE$.unapply((DirectoryEvent.FileDeleted)directoryEvent))._1()))) {
                        return Some$.MODULE$.apply((Object)OrderWatchEvent$ExternalOrderVanished$.MODULE$.apply((ExternalOrderName)ExternalOrderName$.MODULE$.apply(path2.toString())));
                    }
                    DirectoryEvent event = directoryEvent;
                    Logger LoggerImpl_this = FileWatchManager$.js7$agent$scheduler$order$FileWatchManager$$$logger;
                    if (!LoggerImpl_this.underlying().isDebugEnabled()) break block2;
                    LoggerImpl_this.underlying().debug("Ignore {}", (Object)event);
                }
                return None$.MODULE$;
            }))).map((Function1 & Serializable)_$9 -> _$9.toKeyedEvent(fileWatch.path()))));
        });
    }

    private Map<String, Value> toOrderArguments(Path directory, Path path) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)FileWatch$.MODULE$.FileArgumentName());
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)StringValue$.MODULE$.apply(directory.resolve(path).toString()));
        return package$NamedValues$.MODULE$.apply((Seq<Tuple2<String, Value>>)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    private static final FileWatch reduce$1(FileWatch fw) {
        AgentPath agentPath = AgentPath$.MODULE$.empty();
        None$ none$ = None$.MODULE$;
        FiniteDuration finiteDuration = ScalaTime$DurationRichInt$.MODULE$.s$extension(ScalaTime$.MODULE$.DurationRichInt(0));
        None$ none$2 = None$.MODULE$;
        OrderWatchPath orderWatchPath = fw.copy$default$1();
        WorkflowPath workflowPath = fw.copy$default$2();
        Expression expression = fw.copy$default$4();
        Option<Expression> option = fw.copy$default$6();
        Option<Expression> option2 = fw.copy$default$7();
        return fw.copy(orderWatchPath, workflowPath, agentPath, expression, (Option<SimplePattern>)none$, option, option2, finiteDuration, (Option<ItemRevision>)none$2);
    }

    private static final Object startWatching$$anonfun$1(OrderWatchPath id$1) {
        return id$1;
    }

    private static final IO $anonfun$1$$anonfun$1$$anonfun$1() {
        return IO$.MODULE$.unit();
    }

    private static final Object $anonfun$1$$anonfun$1$$anonfun$3$$anonfun$1(OrderWatchPath id$6) {
        return id$6;
    }

    private static final String $anonfun$1$$anonfun$1$$anonfun$3$$anonfun$2(OrderWatchPath id$7) {
        return id$7 + ": stopping previous watcher";
    }

    private static final String startWatching$$anonfun$2$$anonfun$1(OrderWatchPath id$8) {
        return "startWatching " + id$8;
    }

    private static final Object stopWatching$$anonfun$1(OrderWatchPath id$9) {
        return id$9;
    }

    private static final IO stopWatching$$anonfun$2$$anonfun$1() {
        return IO$.MODULE$.unit();
    }

    private static final Path watch$$anonfun$1$$anonfun$1(String string$1) {
        return Paths.get(string$1, new String[0]);
    }

    private static final void watch$$anonfun$2$$anonfun$2(FileWatchState fileWatchState$5, Path directory$1) {
        Logger LoggerImpl_this = FileWatchManager$.js7$agent$scheduler$order$FileWatchManager$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("{} watching started - {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{fileWatchState$5.fileWatch().path(), directory$1}), Object.class));
            return;
        }
    }

    private static final void watch$$anonfun$2$$anonfun$4$$anonfun$1(Problem problem$1) {
        Logger LoggerImpl_this = FileWatchManager$.js7$agent$scheduler$order$FileWatchManager$$$logger;
        if (LoggerImpl_this.underlying().isErrorEnabled()) {
            LoggerImpl_this.underlying().error(problem$1.toString());
            return;
        }
    }

    private static final void watch$$anonfun$2$$anonfun$4$$anonfun$2(ObjectRef directoryState$2, AgentState agentState$1, FileWatchState fileWatchState$8) {
        directoryState$2.elem = ((FileWatchState)agentState$1.keyTo((InventoryItemState.Companion)FileWatchState$.MODULE$).apply((Object)fileWatchState$8.fileWatch().path())).directoryState();
    }

    private static final void watch$$anonfun$2$$anonfun$6$$anonfun$1(FileWatchState fileWatchState$10, Outcome exitCase$1, Path directory$4) {
        Logger LoggerImpl_this = FileWatchManager$.js7$agent$scheduler$order$FileWatchManager$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("{} watching {} - {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{fileWatchState$10.fileWatch().path(), exitCase$1, directory$4}), Object.class));
            return;
        }
    }
}

