/*
 * Decompiled with CFR 0.152.
 */
package js7.agent.scheduler.order;

import java.io.Serializable;
import java.util.NoSuchElementException;
import js7.base.crypt.Signed;
import js7.base.crypt.Signed$;
import js7.base.crypt.SignedString;
import js7.base.utils.Assertions$;
import js7.base.utils.Collections$implicits$;
import js7.base.utils.Collections$implicits$InsertableMutableMap$;
import js7.data.agent.AgentPath;
import js7.data.event.KeyedEvent;
import js7.data.item.BasicItemEvent;
import js7.data.item.BasicItemEvent$ItemAttachedToMe$;
import js7.data.item.BasicItemEvent$SignedItemAttachedToMe$;
import js7.data.item.InventoryItem;
import js7.data.item.SignableItem;
import js7.data.item.VersionedItemId;
import js7.data.order.Order;
import js7.data.workflow.Workflow;
import js7.data.workflow.WorkflowPath;
import js7.data.workflow.position.WorkflowPosition;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import sourcecode.FileName$;
import sourcecode.FullName$;
import sourcecode.Line$;
import sourcecode.Text;
import sourcecode.Text$;

public final class WorkflowRegister {
    private final AgentPath agentPath;
    private final Map<VersionedItemId<WorkflowPath>, Workflow> _idToWorkflow;

    public WorkflowRegister(AgentPath agentPath) {
        this.agentPath = agentPath;
        this._idToWorkflow = ((Map)Map$.MODULE$.empty()).withDefault((Function1 & Serializable)workflowPath -> {
            throw new NoSuchElementException("No such " + workflowPath);
        });
    }

    public PartialFunction<VersionedItemId<WorkflowPath>, Workflow> idToWorkflow() {
        return this._idToWorkflow;
    }

    public void recover(Workflow workflow) {
        Map map = Collections$implicits$.MODULE$.InsertableMutableMap(this._idToWorkflow);
        Collections$implicits$InsertableMutableMap$.MODULE$.insert$extension(map, workflow.id(), workflow);
    }

    public void recover(Signed<Workflow> signed) {
        Workflow workflow = signed.value();
        Map map = Collections$implicits$.MODULE$.InsertableMutableMap(this._idToWorkflow);
        Collections$implicits$InsertableMutableMap$.MODULE$.insert$extension(map, workflow.id(), workflow.reduceForAgent(this.agentPath));
    }

    public void handleEvent(KeyedEvent<BasicItemEvent> keyedEvent, Workflow reducedWorkflow) {
        BasicItemEvent.ItemAttachedToMe itemAttachedToMe;
        InventoryItem inventoryItem;
        BasicItemEvent basicItemEvent = keyedEvent.event();
        if (basicItemEvent instanceof BasicItemEvent.SignedItemAttachedToMe) {
            BasicItemEvent.SignedItemAttachedToMe signedItemAttachedToMe = BasicItemEvent$SignedItemAttachedToMe$.MODULE$.unapply((BasicItemEvent.SignedItemAttachedToMe)basicItemEvent);
            Signed<SignableItem> signed = signedItemAttachedToMe._1();
            Signed<SignableItem> signed2 = Signed$.MODULE$.unapply(signed);
            SignableItem signableItem = signed2._1();
            SignedString signedString = signed2._2();
            if (signableItem instanceof Workflow) {
                this._idToWorkflow.update(reducedWorkflow.id(), (Object)reducedWorkflow.reduceForAgent(this.agentPath));
                return;
            }
        }
        if (basicItemEvent instanceof BasicItemEvent.ItemAttachedToMe && (inventoryItem = (itemAttachedToMe = BasicItemEvent$ItemAttachedToMe$.MODULE$.unapply((BasicItemEvent.ItemAttachedToMe)basicItemEvent))._1()) instanceof Workflow) {
            Workflow workflow = (Workflow)inventoryItem;
            this._idToWorkflow.update(workflow.id(), (Object)reducedWorkflow);
            return;
        }
        throw package$.MODULE$.error("WorkflowRegister: Unexpected event: " + keyedEvent);
    }

    public <S extends Order.State> Order<S> reuseMemory(Order<S> order) {
        VersionedItemId<WorkflowPath> reusedId = ((Workflow)this._idToWorkflow.apply(order.workflowId())).id();
        WorkflowPosition wp = order.position().$div$colon(reusedId);
        if (order.workflowPosition() == wp) {
            return order;
        }
        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)WorkflowRegister.v$proxy1$1(order, wp)), "order.workflowPosition == wp"), FullName$.MODULE$.apply("js7.agent.scheduler.order.WorkflowRegister.reuseMemory"), FileName$.MODULE$.apply("WorkflowRegister.scala"), Line$.MODULE$.apply(54));
        return order.copy(order.copy$default$1(), wp, order.copy$default$3(), order.copy$default$4(), order.copy$default$5(), order.copy$default$6(), order.copy$default$7(), order.copy$default$8(), order.copy$default$9(), order.copy$default$10(), order.copy$default$11(), order.copy$default$12(), order.copy$default$13(), order.copy$default$14(), order.copy$default$15(), order.copy$default$16(), order.copy$default$17(), order.copy$default$18());
    }

    public Option<Workflow> get(VersionedItemId<WorkflowPath> id) {
        return this._idToWorkflow.get(id);
    }

    public Workflow apply(VersionedItemId<WorkflowPath> id) {
        return (Workflow)this._idToWorkflow.apply(id);
    }

    public Vector<Workflow> workflows() {
        return this._idToWorkflow.values().toVector();
    }

    public int size() {
        return this._idToWorkflow.size();
    }

    private static final boolean v$proxy1$1(Order order$1, WorkflowPosition wp$1) {
        WorkflowPosition workflowPosition = order$1.workflowPosition();
        WorkflowPosition workflowPosition2 = wp$1;
        return !(workflowPosition != null ? !((Object)workflowPosition).equals(workflowPosition2) : workflowPosition2 != null);
    }
}

