/*
 * Decompiled with CFR 0.152.
 */
package js7.base.crypt.x509;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import js7.base.crypt.DocumentSigner;
import js7.base.crypt.SignerId;
import js7.base.crypt.SignerId$;
import js7.base.crypt.x509.Openssl$;
import js7.base.crypt.x509.Openssl$CertWithPrivateKey$;
import js7.base.crypt.x509.Openssl$Root$;
import js7.base.crypt.x509.Openssl$Root$Signer$;
import js7.base.crypt.x509.OpensslSignature;
import js7.base.crypt.x509.OpensslSignature$;
import js7.base.crypt.x509.X509Cert$;
import js7.base.data.ByteArray;
import js7.base.data.ByteArray$;
import js7.base.io.file.FileUtils$;
import js7.base.io.file.FileUtils$syntax$;
import js7.base.io.file.FileUtils$syntax$RichPath$;
import js7.base.io.process.Processes$;
import js7.base.problem.Problem;
import js7.base.system.OperatingSystem$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;
import scala.util.Either;
import scala.util.matching.Regex;

public final class Openssl {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(Openssl.class.getDeclaredField("caConstraintFile$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Openssl.class.getDeclaredField("systemOpensslCnf$lzy1"));
    public final Path js7$base$crypt$x509$Openssl$$dir;
    private volatile Object systemOpensslCnf$lzy1;
    private volatile Object caConstraintFile$lzy1;
    public final Openssl$Root$ Root$lzy1;
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(Openssl$.class.getDeclaredField("openssl$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Openssl$.class.getDeclaredField("homebrewOpenssl$lzy1"));

    public static void assertPemFile(String string, Path path) {
        Openssl$.MODULE$.assertPemFile(string, path);
    }

    public static String openssl() {
        return Openssl$.MODULE$.openssl();
    }

    public static String quote(Path path) {
        return Openssl$.MODULE$.quote(path);
    }

    public Openssl(Path dir) {
        this.js7$base$crypt$x509$Openssl$$dir = dir;
        this.Root$lzy1 = new Openssl$Root$();
    }

    private String systemOpensslCnf() {
        Object object = this.systemOpensslCnf$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.systemOpensslCnf$lzyINIT1();
    }

    private Object systemOpensslCnf$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.systemOpensslCnf$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        Regex OpensslDir = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("OPENSSLDIR: \"(.*)\""));
                        Object object3 = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(Processes$.MODULE$.runProcess(Openssl$.MODULE$.openssl() + " version -a")), '\n'));
                        String opensslCnf = (String)ArrayOps$.MODULE$.collectFirst$extension(object3, (PartialFunction)new Serializable(OpensslDir){
                            private final Regex OpensslDir$1;
                            {
                                this.OpensslDir$1 = OpensslDir$2;
                            }

                            public final boolean isDefinedAt(String x2) {
                                List list;
                                String string = x2;
                                Option option = this.OpensslDir$1.unapplySeq((CharSequence)string);
                                if (!option.isEmpty() && (list = (List)option.get()).lengthCompare(1) == 0) {
                                    String string2;
                                    String dir = string2 = (String)list.apply(0);
                                    return true;
                                }
                                return false;
                            }

                            public final Object applyOrElse(String x2, Function1 function1) {
                                List list;
                                Option option;
                                String string = x2;
                                if (string != null && !(option = this.OpensslDir$1.unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(1) == 0) {
                                    String string2;
                                    String dir = string2 = (String)list.apply(0);
                                    return dir;
                                }
                                return function1.apply((Object)x2);
                            }
                        }).map((Function1 & Serializable)dir -> {
                            LazyRef lazyRef = new LazyRef();
                            LazyRef lazyRef2 = new LazyRef();
                            if (OperatingSystem$.MODULE$.isWindows() && dir.startsWith("/etc") && Files.exists(Openssl.cygwinOpensslCnf$1(lazyRef, dir), new LinkOption[0])) {
                                return FileUtils$syntax$RichPath$.MODULE$.contentString$extension(FileUtils$syntax$.MODULE$.RichPath(Openssl.cygwinOpensslCnf$1(lazyRef, dir)));
                            }
                            if (OperatingSystem$.MODULE$.isWindows()) {
                                String string = dir;
                                String string2 = "/usr/ssl";
                                if (!(string != null ? !string.equals(string2) : string2 != null) && Files.exists(Openssl.winGitOpensslCnf$1(lazyRef2), new LinkOption[0])) {
                                    return FileUtils$syntax$RichPath$.MODULE$.contentString$extension(FileUtils$syntax$.MODULE$.RichPath(Openssl.winGitOpensslCnf$1(lazyRef2)));
                                }
                            }
                            return FileUtils$syntax$RichPath$.MODULE$.contentString$extension(FileUtils$syntax$.MODULE$.RichPath(FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(Paths.get(dir, new String[0])), "openssl.cnf")));
                        }).getOrElse(Openssl::$anonfun$2);
                        Logger LoggerImpl_this = Openssl$.js7$base$crypt$x509$Openssl$$$logger;
                        if (LoggerImpl_this.underlying().isDebugEnabled()) {
                            LoggerImpl_this.underlying().debug("Using system openssl.cnf {}", (Object)opensslCnf);
                        }
                        object2 = (string = opensslCnf) == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.systemOpensslCnf$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.systemOpensslCnf$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Path caConstraintFile() {
        Object object = this.caConstraintFile$lzy1;
        if (object instanceof Path) {
            return (Path)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Path)this.caConstraintFile$lzyINIT1();
    }

    private Object caConstraintFile$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.caConstraintFile$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Path path = null;
                    try {
                        Path f = FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(this.js7$base$crypt$x509$Openssl$$dir), "openssl-ca.cnf");
                        FileUtils$syntax$RichPath$.MODULE$.$colon$eq$extension(FileUtils$syntax$.MODULE$.RichPath(f), this.systemOpensslCnf() + StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |[SAN]\n        |basicConstraints = critical, CA:TRUE\n        |")));
                        path = f;
                        object2 = path == null ? LazyVals.NullValue$.MODULE$ : path;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.caConstraintFile$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.caConstraintFile$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return path;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final Openssl$Root$ Root() {
        return this.Root$lzy1;
    }

    public Either<Problem, CertWithPrivateKey> generateCertWithPrivateKey(String name, String distinguishedName) {
        Path privateFile = FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(this.js7$base$crypt$x509$Openssl$$dir), name + ".private-key.pem");
        Path certFile = FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(this.js7$base$crypt$x509$Openssl$$dir), name + ".certificate.pem");
        this.js7$base$crypt$x509$Openssl$$opensslReq(distinguishedName, privateFile, certFile, false);
        Path p12File = FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(this.js7$base$crypt$x509$Openssl$$dir), name + ".certificate.p12");
        Processes$.MODULE$.runProcess("openssl pkcs12 -export" + (" -inkey " + privateFile) + (" -in " + certFile) + (" -out " + p12File) + (" -passout 'pass:" + Openssl$.js7$base$crypt$x509$Openssl$$$p12Password + "'"));
        return X509Cert$.MODULE$.PrivateKeyPem().fromPem(FileUtils$syntax$RichPath$.MODULE$.contentString$extension(FileUtils$syntax$.MODULE$.RichPath(privateFile))).map((Function1 & Serializable)privateKey -> Openssl$CertWithPrivateKey$.MODULE$.apply((ByteArray)privateKey, FileUtils$syntax$RichPath$.MODULE$.byteArray$extension(FileUtils$syntax$.MODULE$.RichPath(certFile)), p12File));
    }

    public String js7$base$crypt$x509$Openssl$$opensslReq(String distinguishedName, Path privateFile, Path certFile, boolean ca) {
        return Processes$.MODULE$.runProcess(Openssl$.MODULE$.openssl() + " req -x509 -newkey rsa:1024 -sha512 -days 2 -nodes " + ("-subj '" + distinguishedName + "' ") + ("-keyout " + Openssl$.MODULE$.quote(privateFile) + " ") + ("-out " + Openssl$.MODULE$.quote(certFile) + " ") + ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(ca), (Function0<String>)((Function0 & Serializable)this::opensslReq$$anonfun$1)));
    }

    private static final Path cygwinOpensslCnf$lzyINIT1$1(LazyRef cygwinOpensslCnf$lzy1$1, String dir$1) {
        Path path;
        LazyRef lazyRef = cygwinOpensslCnf$lzy1$1;
        synchronized (lazyRef) {
            path = (Path)(cygwinOpensslCnf$lzy1$1.initialized() ? cygwinOpensslCnf$lzy1$1.value() : cygwinOpensslCnf$lzy1$1.initialize((Object)FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(Paths.get("c:\\cygwin64", new String[0])), dir$1)), "openssl.cnf")));
        }
        return path;
    }

    private static final Path cygwinOpensslCnf$1(LazyRef cygwinOpensslCnf$lzy1$2, String dir$2) {
        return (Path)(cygwinOpensslCnf$lzy1$2.initialized() ? cygwinOpensslCnf$lzy1$2.value() : Openssl.cygwinOpensslCnf$lzyINIT1$1(cygwinOpensslCnf$lzy1$2, dir$2));
    }

    private static final Path winGitOpensslCnf$lzyINIT1$1(LazyRef winGitOpensslCnf$lzy1$1) {
        Path path;
        LazyRef lazyRef = winGitOpensslCnf$lzy1$1;
        synchronized (lazyRef) {
            path = (Path)(winGitOpensslCnf$lzy1$1.initialized() ? winGitOpensslCnf$lzy1$1.value() : winGitOpensslCnf$lzy1$1.initialize((Object)FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(Paths.get("C:\\Program files\\Git\\usr\\ssl", new String[0])), "openssl.cnf")));
        }
        return path;
    }

    private static final Path winGitOpensslCnf$1(LazyRef winGitOpensslCnf$lzy1$2) {
        return (Path)(winGitOpensslCnf$lzy1$2.initialized() ? winGitOpensslCnf$lzy1$2.value() : Openssl.winGitOpensslCnf$lzyINIT1$1(winGitOpensslCnf$lzy1$2));
    }

    private static final String $anonfun$2() {
        throw package$.MODULE$.error("Missing OPENSSLDIR in output of: " + Openssl$.MODULE$.openssl() + " version -a");
    }

    private final String opensslReq$$anonfun$1() {
        return "-extensions 'SAN' -config " + Openssl$.MODULE$.quote(this.caConstraintFile());
    }

    public static final class CertWithPrivateKey
    implements Product,
    Serializable {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(CertWithPrivateKey.class.getDeclaredField("certificatePem$lzy1"));
        private final ByteArray privateKey;
        private final ByteArray certificate;
        private final Path p12File;
        private volatile Object certificatePem$lzy1;

        public static CertWithPrivateKey apply(ByteArray byteArray, ByteArray byteArray2, Path path) {
            return Openssl$CertWithPrivateKey$.MODULE$.apply(byteArray, byteArray2, path);
        }

        public static CertWithPrivateKey fromProduct(Product product) {
            return Openssl$CertWithPrivateKey$.MODULE$.fromProduct(product);
        }

        public static CertWithPrivateKey unapply(CertWithPrivateKey certWithPrivateKey) {
            return Openssl$CertWithPrivateKey$.MODULE$.unapply(certWithPrivateKey);
        }

        public CertWithPrivateKey(ByteArray privateKey, ByteArray certificate, Path p12File) {
            this.privateKey = privateKey;
            this.certificate = certificate;
            this.p12File = p12File;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CertWithPrivateKey)) return false;
            CertWithPrivateKey certWithPrivateKey = (CertWithPrivateKey)object;
            ByteArray byteArray = this.privateKey();
            ByteArray byteArray2 = certWithPrivateKey.privateKey();
            if (byteArray == null) {
                if (byteArray2 != null) {
                    return false;
                }
            } else if (!((Object)byteArray).equals(byteArray2)) return false;
            ByteArray byteArray3 = this.certificate();
            ByteArray byteArray4 = certWithPrivateKey.certificate();
            if (byteArray3 == null) {
                if (byteArray4 != null) {
                    return false;
                }
            } else if (!((Object)byteArray3).equals(byteArray4)) return false;
            Path path = this.p12File();
            Path path2 = certWithPrivateKey.p12File();
            if (path == null) {
                if (path2 == null) return true;
                return false;
            } else {
                if (!((Object)path).equals(path2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CertWithPrivateKey;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "CertWithPrivateKey";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "privateKey";
                }
                case 1: {
                    return "certificate";
                }
                case 2: {
                    return "p12File";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ByteArray privateKey() {
            return this.privateKey;
        }

        public ByteArray certificate() {
            return this.certificate;
        }

        public Path p12File() {
            return this.p12File;
        }

        public String certificatePem() {
            Object object = this.certificatePem$lzy1;
            if (object instanceof String) {
                return (String)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (String)this.certificatePem$lzyINIT1();
        }

        private Object certificatePem$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.certificatePem$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        String string = null;
                        try {
                            string = X509Cert$.MODULE$.CertificatePem().toPem(this.certificate());
                            object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.certificatePem$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return string;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public CertWithPrivateKey copy(ByteArray privateKey, ByteArray certificate, Path p12File) {
            return new CertWithPrivateKey(privateKey, certificate, p12File);
        }

        public ByteArray copy$default$1() {
            return this.privateKey();
        }

        public ByteArray copy$default$2() {
            return this.certificate();
        }

        public Path copy$default$3() {
            return this.p12File();
        }

        public ByteArray _1() {
            return this.privateKey();
        }

        public ByteArray _2() {
            return this.certificate();
        }

        public Path _3() {
            return this.p12File();
        }
    }

    public final class Root {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Root.class.getDeclaredField("Signer$lzy1"));
        private final Path privateKeyFile;
        private final Path certificateFile;
        private volatile Object Signer$lzy1;

        public Root(String name, boolean suppressCAContraint) {
            if (Openssl.this == null) {
                throw new NullPointerException();
            }
            this.privateKeyFile = FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(Openssl.this.js7$base$crypt$x509$Openssl$$dir), name + ".private-key");
            this.certificateFile = FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(Openssl.this.js7$base$crypt$x509$Openssl$$dir), name + ".crt");
            Openssl.this.js7$base$crypt$x509$Openssl$$opensslReq("/CN=" + name, this.privateKeyFile(), this.certificateFile(), !suppressCAContraint);
        }

        public Path privateKeyFile() {
            return this.privateKeyFile;
        }

        public Path certificateFile() {
            return this.certificateFile;
        }

        public Path js7$base$crypt$x509$Openssl$Root$$newCertificate(Path csrFile, String name) {
            Path certFile = FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(Openssl.this.js7$base$crypt$x509$Openssl$$dir), name + ".crt");
            Processes$.MODULE$.runProcess(Openssl$.MODULE$.openssl() + " x509 -req" + (" -in " + Openssl$.MODULE$.quote(csrFile)) + (" -CA " + Openssl$.MODULE$.quote(this.certificateFile())) + (" -CAkey " + Openssl$.MODULE$.quote(this.privateKeyFile())) + " -CAcreateserial" + (" -days 2 -sha512 -out " + Openssl$.MODULE$.quote(certFile)));
            Openssl$.MODULE$.assertPemFile("CERTIFICATE", certFile);
            return certFile;
        }

        public final Openssl$Root$Signer$ Signer() {
            Object object = this.Signer$lzy1;
            if (object instanceof Openssl$Root$Signer$) {
                return (Openssl$Root$Signer$)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (Openssl$Root$Signer$)this.Signer$lzyINIT1();
        }

        private Object Signer$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.Signer$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Openssl$Root$Signer$ openssl$Root$Signer$ = null;
                        try {
                            openssl$Root$Signer$ = new Openssl$Root$Signer$();
                            object2 = openssl$Root$Signer$ == null ? LazyVals.NullValue$.MODULE$ : openssl$Root$Signer$;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.Signer$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return openssl$Root$Signer$;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public final /* synthetic */ Openssl js7$base$crypt$x509$Openssl$Root$$$outer() {
            return Openssl.this;
        }

        public final class Signer
        implements DocumentSigner {
            private final Openssl$Root$Signer$ companion;
            private final SignerId signerId;
            private final Path privateKeyFile;
            private final Path certificateFile;

            public Signer(String name) {
                if (Root.this == null) {
                    throw new NullPointerException();
                }
                this.companion = Root.this.Signer();
                this.signerId = (SignerId)SignerId$.MODULE$.apply("CN=" + name);
                this.privateKeyFile = FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(Root.this.js7$base$crypt$x509$Openssl$Root$$$outer().js7$base$crypt$x509$Openssl$$dir), name + ".private-key");
                Processes$.MODULE$.runProcess(Openssl$.MODULE$.openssl() + " genrsa -out " + Openssl$.MODULE$.quote(this.privateKeyFile) + " 1024");
                Path certificateRequestFile = FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(Root.this.js7$base$crypt$x509$Openssl$Root$$$outer().js7$base$crypt$x509$Openssl$$dir), name + ".csr");
                Processes$.MODULE$.runProcess(Openssl$.MODULE$.openssl() + " req -new" + (" -subj '/" + this.signerId().string() + "'") + (" -key " + Openssl$.MODULE$.quote(this.privateKeyFile)) + (" -out " + Openssl$.MODULE$.quote(certificateRequestFile)));
                Path certFile = Root.this.js7$base$crypt$x509$Openssl$Root$$newCertificate(certificateRequestFile, name);
                Files.delete(certificateRequestFile);
                this.certificateFile = certFile;
            }

            @Override
            public Openssl$Root$Signer$ companion() {
                return this.companion;
            }

            public SignerId signerId() {
                return this.signerId;
            }

            public Path certificateFile() {
                return this.certificateFile;
            }

            public String certificateString() {
                return FileUtils$syntax$RichPath$.MODULE$.contentString$extension(FileUtils$syntax$.MODULE$.RichPath(this.certificateFile()));
            }

            @Override
            public OpensslSignature sign(ByteArray document) {
                return (OpensslSignature)FileUtils$.MODULE$.withTemporaryFile("openssl-", ".tmp", (Seq<FileAttribute<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FileAttribute[0]), (Function1 & Serializable)file -> {
                    FileUtils$syntax$RichPath$.MODULE$.$colon$eq$extension(FileUtils$syntax$.MODULE$.RichPath((Path)file), document, ByteArray$.MODULE$.implicitByteSequence());
                    Path signatureFile = this.signFile((Path)file);
                    String signature = FileUtils$syntax$RichPath$.MODULE$.contentString$extension(FileUtils$syntax$.MODULE$.RichPath(signatureFile));
                    Files.delete(signatureFile);
                    return OpensslSignature$.MODULE$.apply(signature);
                });
            }

            public Path signFile(Path documentFile) {
                Path signatureFile = Paths.get(documentFile + ".signature", new String[0]);
                Processes$.MODULE$.runProcess(Openssl$.MODULE$.openssl() + " dgst -sha512 -sign " + Openssl$.MODULE$.quote(this.privateKeyFile) + (" -out " + Openssl$.MODULE$.quote(signatureFile) + " " + Openssl$.MODULE$.quote(documentFile)));
                Path base64SignatureFile = Paths.get(signatureFile + ".base64", new String[0]);
                Processes$.MODULE$.runProcess(Openssl$.MODULE$.openssl() + " base64 -in " + Openssl$.MODULE$.quote(signatureFile) + " -out " + Openssl$.MODULE$.quote(base64SignatureFile));
                Files.delete(signatureFile);
                return base64SignatureFile;
            }

            public final /* synthetic */ Root js7$base$crypt$x509$Openssl$Root$Signer$$$outer() {
                return Root.this;
            }
        }
    }
}

