/*
 * Decompiled with CFR 0.152.
 */
package js7.base.crypt.x509;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import js7.base.auth.Pem;
import js7.base.auth.Pem$;
import js7.base.crypt.x509.X509Cert;
import js7.base.crypt.x509.X509CertInterface;
import js7.base.data.ByteArray;
import js7.base.log.Logger$;
import js7.base.problem.Checked$;
import js7.base.problem.Problem;
import js7.base.time.Timestamp;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.deriving.Mirror;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;

public final class X509Cert$
implements Mirror.Product,
Serializable {
    private static final Logger logger;
    public static final String js7$base$crypt$x509$X509Cert$$$MayActAsCA;
    private static final Pem CertificatePem;
    private static final Pem PrivateKeyPem;
    private static final Vector<String> keyUsages;
    public static final Map<String, String> js7$base$crypt$x509$X509Cert$$$oidToString;
    private static final Map<Object, String> subjectAlternativeKeys;
    public static final X509Cert$ MODULE$;

    private X509Cert$() {
    }

    static {
        MODULE$ = new X509Cert$();
        logger = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(X509Cert$.class));
        js7$base$crypt$x509$X509Cert$$$MayActAsCA = "2.5.29.19";
        CertificatePem = Pem$.MODULE$.apply("CERTIFICATE");
        PrivateKeyPem = Pem$.MODULE$.apply("PRIVATE KEY");
        keyUsages = (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"digitalSignature", "nonRepudiation", "keyEncipherment", "dataEncipherment", "keyAgreement", "keyCertSign", "crlSign", "encipherOnly", "decipherOnly"}));
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"1.3.6.1.5.5.7.3.1");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"serverAuth");
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"1.3.6.1.5.5.7.3.2");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)"clientAuth");
        js7$base$crypt$x509$X509Cert$$$oidToString = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Object[] objectArray2 = new Tuple2[9];
        Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0));
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, (Object)"other");
        Integer n2 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1));
        objectArray2[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n2, (Object)"rfc822");
        Integer n3 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2));
        objectArray2[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n3, (Object)"DNS");
        Integer n4 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3));
        objectArray2[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n4, (Object)"x400Address");
        Integer n5 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4));
        objectArray2[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n5, (Object)"directory");
        Integer n6 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5));
        objectArray2[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n6, (Object)"ediParty");
        Integer n7 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6));
        objectArray2[6] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n7, (Object)"uniformResourceIdentifier");
        Integer n8 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7));
        objectArray2[7] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n8, (Object)"IP");
        Integer n9 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8));
        objectArray2[8] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n9, (Object)"registeredID");
        subjectAlternativeKeys = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(X509Cert$.class);
    }

    public X509Cert apply(X509Certificate x509Certificate) {
        return new X509Cert(x509Certificate);
    }

    public X509Cert unapply(X509Cert x$1) {
        return x$1;
    }

    public Pem CertificatePem() {
        return CertificatePem;
    }

    public Pem PrivateKeyPem() {
        return PrivateKeyPem;
    }

    public Either<Problem, X509Cert> fromPem(String pem) {
        return this.CertificatePem().fromPem(pem).flatMap((Function1 & Serializable)byteArray -> MODULE$.fromByteArray((ByteArray)byteArray));
    }

    public Either<Problem, X509Cert> fromByteArray(ByteArray byteArray) {
        return Checked$.MODULE$.catchNonFatal(() -> X509Cert$.fromByteArray$$anonfun$1(byteArray));
    }

    public <A extends X509CertInterface> Seq<A> removeDuplicates(Seq<A> certs, Timestamp timestamp) {
        return (Seq)certs.groupBy((Function1 & Serializable)_$2 -> _$2.signersDistinguishedName()).values().toVector().flatMap((Function1 & Serializable)_$3 -> MODULE$.selectBestCert((Seq)_$3, timestamp));
    }

    private <A extends X509CertInterface> Option<A> selectBestCert(Seq<A> certs, Timestamp timestamp) {
        if (IterableOps.SizeCompareOps$.MODULE$.$less$eq$extension(certs.sizeIs(), 1)) {
            return certs.headOption();
        }
        Seq notExpiredCerts = (Seq)certs.flatMap((Function1 & Serializable)cert -> {
            if (cert.notAfter().$less(timestamp)) {
                Logger LoggerImpl_this = logger;
                if (LoggerImpl_this.underlying().isErrorEnabled()) {
                    LoggerImpl_this.underlying().error("Ignoring {} because it expired at {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{cert, cert.notAfter()}), Object.class));
                }
                return None$.MODULE$;
            }
            return Some$.MODULE$.apply(cert);
        });
        if (IterableOps.SizeCompareOps$.MODULE$.$less$eq$extension(notExpiredCerts.sizeIs(), 1)) {
            return notExpiredCerts.headOption();
        }
        Option latestStillValid = ((IterableOps)((SeqOps)notExpiredCerts.filter((Function1 & Serializable)_$4 -> _$4.notBefore().$less$eq(timestamp))).sortBy((Function1 & Serializable)_$5 -> _$5.notAfter(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).lastOption();
        Option result = latestStillValid.orElse(() -> X509Cert$.$anonfun$4(notExpiredCerts));
        result.foreach((Function1)(JProcedure1 & Serializable)selected -> ((IterableOnceOps)notExpiredCerts.filter((Function1 & Serializable)x$0 -> selected != x$0)).foreach((Function1)(JProcedure1 & Serializable)cert -> {
            Logger LoggerImpl_this = logger;
            if (LoggerImpl_this.underlying().isErrorEnabled()) {
                LoggerImpl_this.underlying().error("Ignoring duplicate {}", cert);
                return;
            }
        }));
        return result;
    }

    public String js7$base$crypt$x509$X509Cert$$$keyUsageToString(boolean[] keyUsage) {
        return ((IterableOnceOps)keyUsages.indices().flatMap((Function1 & Serializable)i -> this.keyUsageToString$$anonfun$1(keyUsage, BoxesRunTime.unboxToInt((Object)i)))).mkString(",");
    }

    public String js7$base$crypt$x509$X509Cert$$$subjectAlternativeNamesToString(Collection<List<?>> collection) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(collection).asScala().map((Function1 & Serializable)_$7 -> {
            Object[] objectArray = (Object[])CollectionConverters$.MODULE$.ListHasAsScala(_$7).asScala().toArray(ClassTag$.MODULE$.Any());
            Object object = Array$.MODULE$.unapplySeq((Object)objectArray);
            if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 2) == 0) {
                String value;
                String string;
                Object object2 = Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0);
                Object object3 = Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1);
                Object i = object2;
                Object value2 = object3;
                Object object4 = i;
                if (object4 instanceof Integer) {
                    Integer i2 = (Integer)object4;
                    string = (String)subjectAlternativeKeys.getOrElse((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(i2)), () -> X509Cert$.subjectAlternativeNamesToString$$anonfun$1$$anonfun$1(i2));
                } else {
                    Object i3 = object4;
                    string = i3.toString();
                }
                Object object5 = value2;
                return string + "=" + (object5 instanceof String ? (value = (String)object5) : "...");
            }
            throw new MatchError((Object)objectArray);
        })).mkString(",");
    }

    public X509Cert fromProduct(Product x$0) {
        return new X509Cert((X509Certificate)x$0.productElement(0));
    }

    private static final X509Cert fromByteArray$$anonfun$1(ByteArray byteArray$1) {
        X509Certificate certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(byteArray$1.toInputStream());
        certificate.checkValidity();
        return MODULE$.apply(certificate);
    }

    private static final Option $anonfun$4(Seq notExpiredCerts$1) {
        return ((IterableOps)notExpiredCerts$1.sortBy((Function1 & Serializable)_$6 -> _$6.notBefore(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).headOption();
    }

    private final String a$proxy1$1(int i$1) {
        return (String)keyUsages.apply(i$1);
    }

    private final String keyUsageToString$$anonfun$1$$anonfun$1(int i$3) {
        return this.a$proxy1$1(i$3);
    }

    private final /* synthetic */ IterableOnce keyUsageToString$$anonfun$1(boolean[] keyUsage$1, int i) {
        boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(keyUsage$1[i]);
        return ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, () -> this.keyUsageToString$$anonfun$1$$anonfun$1(i));
    }

    private static final String subjectAlternativeNamesToString$$anonfun$1$$anonfun$1(Integer i$2) {
        return i$2.toString();
    }
}

