/*
 * Decompiled with CFR 0.152.
 */
package js7.base.data;

import cats.effect.kernel.Resource;
import cats.kernel.Monoid;
import cats.kernel.Semigroup;
import fs2.Chunk;
import fs2.Stream;
import io.circe.Decoder;
import io.circe.Json;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Base64;
import js7.base.circeutils.CirceUtils$;
import js7.base.circeutils.CirceUtils$RichCirceEither$;
import js7.base.data.ByteArray$;
import js7.base.data.ByteSequence;
import js7.base.problem.Problem;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ClassTag;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.util.Either;

public final class ByteArray {
    private final byte[] unsafeArray;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ByteArray$.class.getDeclaredField("classTag$lzy1"));

    public static byte at(ByteArray byteArray, int n) {
        return ByteArray$.MODULE$.at(byteArray, n);
    }

    public static Stream byteStream(Object object, int n) {
        return ByteArray$.MODULE$.byteStream(object, n);
    }

    public static Stream chunkStream(Object object, int n) {
        return ByteArray$.MODULE$.chunkStream(object, n);
    }

    public static ClassTag classTag() {
        return ByteArray$.MODULE$.classTag();
    }

    public static Class<ByteArray> clazz() {
        return ByteArray$.MODULE$.clazz();
    }

    public static ByteArray combine(ByteArray byteArray, ByteArray byteArray2) {
        return ByteArray$.MODULE$.combine(byteArray, byteArray2);
    }

    public static ByteArray combineAll(IterableOnce<ByteArray> iterableOnce) {
        return ByteArray$.MODULE$.combineAll((IterableOnce)iterableOnce);
    }

    public static /* synthetic */ Object combineAll(IterableOnce iterableOnce) {
        return ByteArray$.MODULE$.combineAll(iterableOnce);
    }

    public static Option<ByteArray> combineAllOption(IterableOnce<ByteArray> iterableOnce) {
        return ByteArray$.MODULE$.combineAllOption(iterableOnce);
    }

    public static <ByteSeq> ByteArray combineByteSequences(IterableOnce<ByteSeq> iterableOnce, ByteSequence<ByteSeq> byteSequence) {
        return ByteArray$.MODULE$.combineByteSequences(iterableOnce, byteSequence);
    }

    public static Object combineN(Object object, int n) {
        return ByteArray$.MODULE$.combineN(object, n);
    }

    public static Object concat(Object object, Object object2) {
        return ByteArray$.MODULE$.concat(object, object2);
    }

    public static Object drop(Object object, int n) {
        return ByteArray$.MODULE$.drop(object, n);
    }

    public static ByteArray empty() {
        return ByteArray$.MODULE$.empty();
    }

    public static boolean endsWith(Object object, Object object2) {
        return ByteArray$.MODULE$.endsWith(object, object2);
    }

    public static boolean eqv(ByteArray byteArray, ByteArray byteArray2) {
        return ByteArray$.MODULE$.eqv(byteArray, byteArray2);
    }

    public static ByteArray fromArray(byte[] byArray) {
        return ByteArray$.MODULE$.fromArray(byArray);
    }

    public static Object fromArray(byte[] byArray, int n, int n2) {
        return ByteArray$.MODULE$.fromArray(byArray, n, n2);
    }

    public static ByteArray fromByteArray(ByteArray byteArray) {
        return ByteArray$.MODULE$.fromByteArray(byteArray);
    }

    public static Object fromFileUnlimited(Path path) {
        return ByteArray$.MODULE$.fromFileUnlimited(path);
    }

    public static Either<ByteArray, ByteArray> fromInputStreamLimited(InputStream inputStream, int n) {
        return ByteArray$.MODULE$.fromInputStreamLimited(inputStream, n);
    }

    public static Object fromInputStreamUnlimited(InputStream inputStream) {
        return ByteArray$.MODULE$.fromInputStreamUnlimited(inputStream);
    }

    public static Either<Problem, ByteArray> fromMimeBase64(String string) {
        return ByteArray$.MODULE$.fromMimeBase64(string);
    }

    public static Object fromSeq(Seq seq) {
        return ByteArray$.MODULE$.fromSeq(seq);
    }

    public static Object fromString(String string) {
        return ByteArray$.MODULE$.fromString(string);
    }

    public static Option headOption(Object object) {
        return ByteArray$.MODULE$.headOption(object);
    }

    public static ByteSequence<ByteArray> implicitByteSequence() {
        return ByteArray$.MODULE$.implicitByteSequence();
    }

    public static int indexOf(Object object, byte by) {
        return ByteArray$.MODULE$.indexOf(object, by);
    }

    public static int indexOf(Object object, byte by, int n) {
        return ByteArray$.MODULE$.indexOf(object, by, n);
    }

    public static int indexOf(Object object, byte by, int n, int n2) {
        return ByteArray$.MODULE$.indexOf(object, by, n, n2);
    }

    public static int inputStreamBufferSize() {
        return ByteArray$.MODULE$.inputStreamBufferSize();
    }

    public static int intLength(Object object) {
        return ByteArray$.MODULE$.intLength(object);
    }

    public static Semigroup intercalate(Object object) {
        return ByteArray$.MODULE$.intercalate(object);
    }

    public static Option lastOption(Object object) {
        return ByteArray$.MODULE$.lastOption(object);
    }

    public static int lengthIs(Object object) {
        return ByteArray$.MODULE$.lengthIs(object);
    }

    public static boolean neqv(Object object, Object object2) {
        return ByteArray$.MODULE$.neqv(object, object2);
    }

    public static boolean nonEmpty(Object object) {
        return ByteArray$.MODULE$.nonEmpty(object);
    }

    public static Object one(byte by) {
        return ByteArray$.MODULE$.one(by);
    }

    public static Object random(int n) {
        return ByteArray$.MODULE$.random(n);
    }

    public static Object readByteBuffer(ByteBuffer byteBuffer) {
        return ByteArray$.MODULE$.readByteBuffer(byteBuffer);
    }

    public static Monoid<ByteArray> reverse() {
        return ByteArray$.MODULE$.reverse();
    }

    public static /* synthetic */ Semigroup<ByteArray> reverse() {
        return ByteArray$.MODULE$.reverse();
    }

    public static String show(Object object) {
        return ByteArray$.MODULE$.show(object);
    }

    public static String show(Object object, int n) {
        return ByteArray$.MODULE$.show(object, n);
    }

    public static boolean startsWith(Object object, Object object2) {
        return ByteArray$.MODULE$.startsWith(object, object2);
    }

    public static Object take(Object object, int n) {
        return ByteArray$.MODULE$.take(object, n);
    }

    public static ByteArray toByteArray(ByteArray byteArray) {
        return ByteArray$.MODULE$.toByteArray(byteArray);
    }

    public static /* synthetic */ ByteArray toByteArray(Object object) {
        return ByteArray$.MODULE$.toByteArray(object);
    }

    public static ByteBuffer toByteBuffer(Object object) {
        return ByteArray$.MODULE$.toByteBuffer(object);
    }

    public static Object toByteSequence(Object object, ByteSequence byteSequence) {
        return ByteArray$.MODULE$.toByteSequence(object, byteSequence);
    }

    public static Chunk toChunk(Object object) {
        return ByteArray$.MODULE$.toChunk(object);
    }

    public static String toHex(Object object) {
        return ByteArray$.MODULE$.toHex(object);
    }

    public static String toHexRaw(Object object) {
        return ByteArray$.MODULE$.toHexRaw(object);
    }

    public static String toHexRaw(Object object, int n, boolean bl) {
        return ByteArray$.MODULE$.toHexRaw(object, n, bl);
    }

    public static Resource toInputStreamResource(Object object) {
        return ByteArray$.MODULE$.toInputStreamResource(object);
    }

    public static String toStringAndHexRaw(Object object, int n, boolean bl) {
        return ByteArray$.MODULE$.toStringAndHexRaw(object, n, bl);
    }

    public static String typeName() {
        return ByteArray$.MODULE$.typeName();
    }

    public static ByteArray unsafeWrap(byte[] byArray) {
        return ByteArray$.MODULE$.unsafeWrap(byArray);
    }

    public static Object unsafeWrapChunk(Chunk chunk) {
        return ByteArray$.MODULE$.unsafeWrapChunk(chunk);
    }

    public static Option<byte[]> unsafeWrappedArray(ByteArray byteArray) {
        return ByteArray$.MODULE$.unsafeWrappedArray(byteArray);
    }

    public static /* synthetic */ Option unsafeWrappedArray(Object object) {
        return ByteArray$.MODULE$.unsafeWrappedArray(object);
    }

    public static String utf8StringTruncateAt(Object object, int n) {
        return ByteArray$.MODULE$.utf8StringTruncateAt(object, n);
    }

    public static Object wrapChunk(Chunk chunk) {
        return ByteArray$.MODULE$.wrapChunk(chunk);
    }

    public static int toHexRaw$default$2() {
        return ByteArray$.MODULE$.toHexRaw$default$2();
    }

    public static int toStringAndHexRaw$default$2() {
        return ByteArray$.MODULE$.toStringAndHexRaw$default$2();
    }

    public static boolean toHexRaw$default$3() {
        return ByteArray$.MODULE$.toHexRaw$default$3();
    }

    public static boolean toStringAndHexRaw$default$3() {
        return ByteArray$.MODULE$.toStringAndHexRaw$default$3();
    }

    public ByteArray(byte[] unsafeArray) {
        this.unsafeArray = unsafeArray;
    }

    public byte[] unsafeArray() {
        return this.unsafeArray;
    }

    public int length() {
        return this.unsafeArray().length;
    }

    public byte apply(int i) {
        return this.unsafeArray()[i];
    }

    public boolean isEmpty() {
        Object object = Predef$.MODULE$.byteArrayOps(this.unsafeArray());
        return ArrayOps$.MODULE$.isEmpty$extension(object);
    }

    public int copyToArray(byte[] array) {
        return this.copyToArray(array, 0, Integer.MAX_VALUE);
    }

    public int copyToArray(byte[] array, int start, int len) {
        int n = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(len), this.unsafeArray().length)), array.length - start);
        System.arraycopy(this.unsafeArray(), 0, array, start, n);
        return n;
    }

    public ByteArray slice(int from, int until) {
        if (from >= until) {
            return ByteArray$.MODULE$.empty();
        }
        if (from <= 0 && until >= this.unsafeArray().length) {
            return this;
        }
        return new ByteArray(Arrays.copyOfRange(this.unsafeArray(), RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(from), 0), RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(until), this.length())));
    }

    public ByteArray $plus$plus(ByteArray o) {
        if (o.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return o;
        }
        byte[] a = new byte[this.length() + o.length()];
        System.arraycopy(this.unsafeArray(), 0, a, 0, this.unsafeArray().length);
        System.arraycopy(o.unsafeArray(), 0, a, this.unsafeArray().length, o.length());
        return ByteArray$.MODULE$.unsafeWrap(a);
    }

    public Iterator<Object> iterator() {
        Object object = Predef$.MODULE$.byteArrayOps(this.unsafeArray());
        return ArrayOps$.MODULE$.iterator$extension(object);
    }

    public InputStream toInputStream() {
        return new ByteArrayInputStream(this.unsafeArray());
    }

    public byte[] toArray() {
        return Arrays.copyOf(this.unsafeArray(), this.unsafeArray().length);
    }

    public String utf8String() {
        return new String(this.unsafeArray(), StandardCharsets.UTF_8);
    }

    public String toMimeBase64() {
        return Base64.getMimeEncoder().encodeToString(this.unsafeArray());
    }

    public Either<Problem, Json> parseJson() {
        Either either = CirceUtils$.MODULE$.RichCirceEither(CirceUtils$.MODULE$.parseJsonByteArray(this.unsafeArray()));
        return CirceUtils$RichCirceEither$.MODULE$.toChecked$extension(either);
    }

    public <A> Either<Problem, A> parseJsonAs(Decoder<A> evidence$1) {
        Either either = CirceUtils$.MODULE$.RichCirceEither(CirceUtils$.MODULE$.parseJsonByteArray(this.unsafeArray()).flatMap((Function1 & Serializable)_$1 -> _$1.as(evidence$1)));
        return CirceUtils$RichCirceEither$.MODULE$.toChecked$extension(either);
    }

    public void writeToStream(OutputStream out) {
        out.write(this.unsafeArray());
    }

    public boolean equals(Object other) {
        Object object = other;
        if (object instanceof ByteArray) {
            ByteArray other2 = (ByteArray)object;
            return Arrays.equals(this.unsafeArray(), other2.unsafeArray());
        }
        return false;
    }

    public int hashCode() {
        return this.unsafeArray().hashCode();
    }

    public String toString() {
        return ByteArray$.MODULE$.show(this);
    }
}

