/*
 * Decompiled with CFR 0.152.
 */
package js7.base.metering;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.GenTemporal;
import cats.effect.kernel.Resource;
import com.typesafe.config.Config;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream$;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import js7.base.metering.CallMeter$;
import js7.base.metering.CallMeter$Conf$;
import js7.base.metering.CallMeterMacros$;
import js7.base.service.Service;
import js7.base.service.StoppableByRequest;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$DurationRichLong$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import sourcecode.Enclosing;

public final class CallMeter {
    private final String name;
    private int _count;
    private long _nanos;
    private long _sinceNano;
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(CallMeter$.class.getDeclaredField("given_Ordering_CallMeter$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(CallMeter$.class.getDeclaredField("logger$lzy1"));

    public static CallMeter apply(Enclosing enclosing) {
        return CallMeter$.MODULE$.apply(enclosing);
    }

    public static CallMeter apply(String string) {
        return CallMeter$.MODULE$.apply(string);
    }

    public static Ordering<CallMeter> given_Ordering_CallMeter() {
        return CallMeter$.MODULE$.given_Ordering_CallMeter();
    }

    public static void logAndResetAll() {
        CallMeter$.MODULE$.logAndResetAll();
    }

    public static Resource<IO, LoggingService> loggingService(Conf conf) {
        return CallMeter$.MODULE$.loggingService(conf);
    }

    public static Resource<IO, LoggingService> loggingService(Config config) {
        return CallMeter$.MODULE$.loggingService(config);
    }

    public CallMeter(String name) {
        this.name = name;
        this._count = 0;
        this._nanos = 0L;
        this._sinceNano = System.nanoTime();
        CallMeter$.MODULE$.js7$base$metering$CallMeter$$$register(this);
    }

    public String name() {
        return this.name;
    }

    public <A> A call(Function0<A> body) {
        Object object;
        long t = System.nanoTime();
        try {
            object = body.apply();
        }
        finally {
            this.addNanos(System.nanoTime() - t);
        }
        return (A)object;
    }

    public <A> IO<A> io(IO<A> io) {
        return IO$.MODULE$.defer(() -> this.io$$anonfun$1(io));
    }

    public void addNanos(long nanos) {
        CallMeter callMeter = this;
        synchronized (callMeter) {
            ++this._count;
            this._nanos += nanos;
        }
    }

    public int count() {
        return this._count;
    }

    public FiniteDuration duration() {
        return ScalaTime$DurationRichLong$.MODULE$.ns$extension(ScalaTime$.MODULE$.DurationRichLong(this._nanos));
    }

    public double quote() {
        return (double)this._nanos / (double)(System.nanoTime() - this._sinceNano);
    }

    public String js7$base$metering$CallMeter$$asStringAndReset() {
        Tuple3 tuple3;
        CallMeter callMeter = this;
        synchronized (callMeter) {
            Tuple3 r = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)this._sinceNano), (Object)BoxesRunTime.boxToInteger((int)this._count), (Object)BoxesRunTime.boxToLong((long)this._nanos));
            this.reset();
            tuple3 = r;
        }
        Tuple3 tuple32 = tuple3;
        long sinceNano = BoxesRunTime.unboxToLong((Object)tuple32._1());
        int n = BoxesRunTime.unboxToInt((Object)tuple32._2());
        long nanos = BoxesRunTime.unboxToLong((Object)tuple32._3());
        Tuple3 tuple33 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)sinceNano), (Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToLong((long)nanos));
        long sinceNano2 = BoxesRunTime.unboxToLong((Object)tuple33._1());
        int n2 = BoxesRunTime.unboxToInt((Object)tuple33._2());
        long nanos2 = BoxesRunTime.unboxToLong((Object)tuple33._3());
        return this.mkString(sinceNano2, n2, nanos2);
    }

    public String asString() {
        Tuple3 tuple3;
        CallMeter callMeter = this;
        synchronized (callMeter) {
            tuple3 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)this._sinceNano), (Object)BoxesRunTime.boxToInteger((int)this._count), (Object)BoxesRunTime.boxToLong((long)this._nanos));
        }
        Tuple3 tuple32 = tuple3;
        long sinceNano = BoxesRunTime.unboxToLong((Object)tuple32._1());
        int n = BoxesRunTime.unboxToInt((Object)tuple32._2());
        long nanos = BoxesRunTime.unboxToLong((Object)tuple32._3());
        Tuple3 tuple33 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)sinceNano), (Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToLong((long)nanos));
        long sinceNano2 = BoxesRunTime.unboxToLong((Object)tuple33._1());
        int n2 = BoxesRunTime.unboxToInt((Object)tuple33._2());
        long nanos2 = BoxesRunTime.unboxToLong((Object)tuple33._3());
        return this.mkString(sinceNano2, n2, nanos2);
    }

    private String mkString(long sinceNano, int n, long nanos) {
        FiniteDuration duration = ScalaTime$DurationRichLong$.MODULE$.ns$extension(ScalaTime$.MODULE$.DurationRichLong(nanos));
        FiniteDuration period = ScalaTime$DurationRichLong$.MODULE$.ns$extension(ScalaTime$.MODULE$.DurationRichLong(System.nanoTime() - sinceNano));
        double pct = package.IntMult$.MODULE$.$times$extension(package$.MODULE$.IntMult(100), duration).$div((Duration)period);
        return StringOps$.MODULE$.format$extension("%9d\u00d7%8s %8s/%-8s %6.1f%% %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n), ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(n > 0), (Function0<String>)((Function0 & Serializable)() -> CallMeter.mkString$$anonfun$1(duration, n))), ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(duration)), ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(period)), BoxesRunTime.boxToDouble((double)pct), this.name()}));
    }

    private void reset() {
        CallMeter callMeter = this;
        synchronized (callMeter) {
            this._count = 0;
            this._nanos = 0L;
            this._sinceNano = System.nanoTime();
        }
    }

    public String toString() {
        return "CallMeter(" + this.asString() + ")";
    }

    public CallMeterMacros$ inline$CallMeterMacros() {
        return CallMeterMacros$.MODULE$;
    }

    private final void io$$anonfun$1$$anonfun$1(long t$1) {
        this.addNanos(System.nanoTime() - t$1);
    }

    private final IO io$$anonfun$1(IO io$1) {
        long t = System.nanoTime();
        return io$1.guarantee(IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.io$$anonfun$1$$anonfun$1(t);
            return BoxedUnit.UNIT;
        }));
    }

    private static final String mkString$$anonfun$1(FiniteDuration duration$1, int n$1) {
        return " " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(duration$1.$div(Int$.MODULE$.int2long(n$1))));
    }

    public static final class Conf
    implements Product,
    Serializable {
        private final FiniteDuration shortPeriod;
        private final double shortMinimumQuote;
        private final FiniteDuration longPeriod;

        public static Conf apply(FiniteDuration finiteDuration, double d, FiniteDuration finiteDuration2) {
            return CallMeter$Conf$.MODULE$.apply(finiteDuration, d, finiteDuration2);
        }

        public static Conf forTesting() {
            return CallMeter$Conf$.MODULE$.forTesting();
        }

        public static Conf fromConfig(Config config) {
            return CallMeter$Conf$.MODULE$.fromConfig(config);
        }

        public static Conf fromProduct(Product product) {
            return CallMeter$Conf$.MODULE$.fromProduct(product);
        }

        public static Conf unapply(Conf conf) {
            return CallMeter$Conf$.MODULE$.unapply(conf);
        }

        public Conf(FiniteDuration shortPeriod, double shortMinimumQuote, FiniteDuration longPeriod) {
            this.shortPeriod = shortPeriod;
            this.shortMinimumQuote = shortMinimumQuote;
            this.longPeriod = longPeriod;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.shortPeriod()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.shortMinimumQuote()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.longPeriod()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Conf)) return false;
            Conf conf = (Conf)object;
            if (this.shortMinimumQuote() != conf.shortMinimumQuote()) return false;
            FiniteDuration finiteDuration = this.shortPeriod();
            FiniteDuration finiteDuration2 = conf.shortPeriod();
            if (finiteDuration == null) {
                if (finiteDuration2 != null) {
                    return false;
                }
            } else if (!finiteDuration.equals(finiteDuration2)) return false;
            FiniteDuration finiteDuration3 = this.longPeriod();
            FiniteDuration finiteDuration4 = conf.longPeriod();
            if (finiteDuration3 == null) {
                if (finiteDuration4 == null) return true;
                return false;
            } else {
                if (!finiteDuration3.equals(finiteDuration4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Conf;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Conf";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToDouble((double)this._2());
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "shortPeriod";
                }
                case 1: {
                    return "shortMinimumQuote";
                }
                case 2: {
                    return "longPeriod";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public FiniteDuration shortPeriod() {
            return this.shortPeriod;
        }

        public double shortMinimumQuote() {
            return this.shortMinimumQuote;
        }

        public FiniteDuration longPeriod() {
            return this.longPeriod;
        }

        public Conf copy(FiniteDuration shortPeriod, double shortMinimumQuote, FiniteDuration longPeriod) {
            return new Conf(shortPeriod, shortMinimumQuote, longPeriod);
        }

        public FiniteDuration copy$default$1() {
            return this.shortPeriod();
        }

        public double copy$default$2() {
            return this.shortMinimumQuote();
        }

        public FiniteDuration copy$default$3() {
            return this.longPeriod();
        }

        public FiniteDuration _1() {
            return this.shortPeriod();
        }

        public double _2() {
            return this.shortMinimumQuote();
        }

        public FiniteDuration _3() {
            return this.longPeriod();
        }
    }

    public static final class LoggingService
    implements Service,
    StoppableByRequest,
    Service.StoppableByRequest {
        private AtomicBoolean js7$base$service$Service$$started;
        private Deferred js7$base$service$Service$$stopped;
        private boolean stoppableByCancel;
        private Deferred js7$base$service$StoppableByRequest$$fiber;
        private Deferred js7$base$service$StoppableByRequest$$stopRequested;
        private volatile boolean js7$base$service$StoppableByRequest$$_isStopping;
        private IO js7$base$service$StoppableByRequest$$memoizedStop;
        private final Conf conf;

        public LoggingService(Conf conf) {
            this.conf = conf;
            Service.$init$(this);
            StoppableByRequest.$init$(this);
            Statics.releaseFence();
        }

        @Override
        public AtomicBoolean js7$base$service$Service$$started() {
            return this.js7$base$service$Service$$started;
        }

        public Deferred js7$base$service$Service$$stopped() {
            return this.js7$base$service$Service$$stopped;
        }

        @Override
        public void js7$base$service$Service$_setter_$js7$base$service$Service$$started_$eq(AtomicBoolean x$0) {
            this.js7$base$service$Service$$started = x$0;
        }

        @Override
        public void js7$base$service$Service$_setter_$js7$base$service$Service$$stopped_$eq(Deferred x$0) {
            this.js7$base$service$Service$$stopped = x$0;
        }

        @Override
        public boolean stoppableByCancel() {
            return this.stoppableByCancel;
        }

        public final Deferred js7$base$service$StoppableByRequest$$fiber() {
            return this.js7$base$service$StoppableByRequest$$fiber;
        }

        public Deferred js7$base$service$StoppableByRequest$$stopRequested() {
            return this.js7$base$service$StoppableByRequest$$stopRequested;
        }

        @Override
        public boolean js7$base$service$StoppableByRequest$$_isStopping() {
            return this.js7$base$service$StoppableByRequest$$_isStopping;
        }

        public IO js7$base$service$StoppableByRequest$$memoizedStop() {
            return this.js7$base$service$StoppableByRequest$$memoizedStop;
        }

        @Override
        public void js7$base$service$StoppableByRequest$$_isStopping_$eq(boolean x$1) {
            this.js7$base$service$StoppableByRequest$$_isStopping = x$1;
        }

        @Override
        public void js7$base$service$StoppableByRequest$_setter_$stoppableByCancel_$eq(boolean x$0) {
            this.stoppableByCancel = x$0;
        }

        @Override
        public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$fiber_$eq(Deferred x$0) {
            this.js7$base$service$StoppableByRequest$$fiber = x$0;
        }

        @Override
        public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$stopRequested_$eq(Deferred x$0) {
            this.js7$base$service$StoppableByRequest$$stopRequested = x$0;
        }

        @Override
        public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$memoizedStop_$eq(IO x$0) {
            this.js7$base$service$StoppableByRequest$$memoizedStop = x$0;
        }

        @Override
        public IO<Service.Started> start() {
            int shortPerLong = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper((int)this.conf.longPeriod().$div((Duration)this.conf.shortPeriod())), 1);
            return this.startService(((IO)Stream$.MODULE$.fixedRate(this.conf.shortPeriod(), (GenTemporal)IO$.MODULE$.asyncForIO()).zipWithIndex().evalTap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = (BoxedUnit)x$1._1();
                long l = BoxesRunTime.unboxToLong((Object)x$1._2());
                return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                    this.start$$anonfun$1$$anonfun$1(l, shortPerLong);
                    return BoxedUnit.UNIT;
                });
            }).interruptWhen((Object)this.untilStopRequested().attempt()).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).drain()).guarantee(IO$.MODULE$.apply(CallMeter$::js7$base$metering$CallMeter$LoggingService$$_$start$$anonfun$adapted$1)));
        }

        public String toString() {
            return "CallMeter.LoggingService";
        }

        private final void start$$anonfun$1$$anonfun$1(long i$1, int shortPerLong$1) {
            if ((i$1 + 1L) % (long)shortPerLong$1 == 0L) {
                CallMeter$.MODULE$.logAndResetAll();
                return;
            }
            CallMeter$.MODULE$.js7$base$metering$CallMeter$$$logAndResetAbove(this.conf.shortMinimumQuote());
        }
    }
}

