/*
 * Decompiled with CFR 0.152.
 */
package js7.base.session;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Outcome;
import cats.effect.kernel.Resource;
import cats.effect.package$;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import js7.base.auth.UserAndPassword;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.generic.Completed$package$Completed$;
import js7.base.log.BlockingSymbol;
import js7.base.log.LogLevel;
import js7.base.log.Logger$syntax$;
import js7.base.log.Slf4jUtils$syntax$;
import js7.base.log.Slf4jUtils$syntax$LevelLogger$;
import js7.base.monixlike.MonixLikeExtensions$;
import js7.base.problem.Problem;
import js7.base.problem.Problems$InvalidSessionTokenProblem$;
import js7.base.session.SessionApi$;
import js7.base.utils.AsyncLock;
import js7.base.utils.AsyncLock$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import js7.base.web.HttpClient;
import js7.base.web.HttpClient$;
import js7.base.web.HttpClient$HttpException$HasProblem$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Left;
import sourcecode.Enclosing$;

public interface SessionApi {
    public static Iterator<FiniteDuration> defaultLoginDelays() {
        return SessionApi$.MODULE$.defaultLoginDelays();
    }

    public static <A extends SessionApi> Resource<IO, A> resource(IO<A> iO) {
        return SessionApi$.MODULE$.resource(iO);
    }

    public static void $init$(SessionApi $this) {
        $this.js7$base$session$SessionApi$_setter_$js7$base$session$SessionApi$$tryLogoutLock_$eq(AsyncLock$.MODULE$.apply("SessionApi.tryLogout", AsyncLock$.MODULE$.apply$default$2(), AsyncLock$.MODULE$.apply$default$3(), AsyncLock$.MODULE$.apply$default$4()));
    }

    public AsyncLock js7$base$session$SessionApi$$tryLogoutLock();

    public void js7$base$session$SessionApi$_setter_$js7$base$session$SessionApi$$tryLogoutLock_$eq(AsyncLock var1);

    public IO<Completed$package$Completed$> login_(Option<UserAndPassword> var1, boolean var2);

    public static boolean login_$default$2$(SessionApi $this) {
        return $this.login_$default$2();
    }

    default public boolean login_$default$2() {
        return false;
    }

    public IO<Completed$package$Completed$> logout();

    public void clearSession();

    public static IO retryIfSessionLost$(SessionApi $this, IO body) {
        return $this.retryIfSessionLost(body);
    }

    default public <A> IO<A> retryIfSessionLost(IO<A> body) {
        return body;
    }

    public static IO retryUntilReachable$(SessionApi $this, Function1 onError, Function0 body) {
        return $this.retryUntilReachable((Function1<Throwable, IO<Object>>)onError, body);
    }

    default public <A> IO<A> retryUntilReachable(Function1<Throwable, IO<Object>> onError, Function0<IO<A>> body) {
        return (IO)body.apply();
    }

    public static Function1 retryUntilReachable$default$1$(SessionApi $this) {
        return $this.retryUntilReachable$default$1();
    }

    default public <A> Function1<Throwable, IO<Object>> retryUntilReachable$default$1() {
        return (Function1 & Serializable)throwable -> this.onErrorTryAgain((Throwable)throwable);
    }

    public static IO tryLogout$(SessionApi $this) {
        return $this.tryLogout();
    }

    default public IO<Completed$package$Completed$> tryLogout() {
        return Logger$syntax$.MODULE$.traceIO(SessionApi$.js7$base$session$SessionApi$$$logger, this.toString() + ": tryLogout", Logger$syntax$.MODULE$.traceIO$default$3(SessionApi$.js7$base$session$SessionApi$$$logger), this.js7$base$session$SessionApi$$tryLogoutLock().lock(this.logout().timeout((Duration)SessionApi$.js7$base$session$SessionApi$$$tryLogoutTimeout).handleError((Function1 & Serializable)t -> {
            Logger LoggerImpl_this = SessionApi$.js7$base$session$SessionApi$$$logger;
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                Object[] objectArray = new Object[2];
                objectArray[0] = this.toString();
                Throwable throwable = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                objectArray[1] = ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable);
                LoggerImpl_this.underlying().debug("{}: logout failed: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), Object.class));
            }
            this.clearSession();
            return Completed$package$Completed$.MODULE$;
        }), Enclosing$.MODULE$.apply("js7.base.session.SessionApi#tryLogout")));
    }

    public static IO onErrorTryAgain$(SessionApi $this, Throwable throwable) {
        return $this.onErrorTryAgain(throwable);
    }

    default public IO<Object> onErrorTryAgain(Throwable throwable) {
        return SessionApi$.MODULE$.onErrorTryAgain(this.toString(), throwable);
    }

    public static interface Dummy
    extends HasUserAndPassword {
        public static Option userAndPassword$(Dummy $this) {
            return $this.userAndPassword();
        }

        @Override
        default public Option<UserAndPassword> userAndPassword() {
            return None$.MODULE$;
        }

        public static boolean hasSession$(Dummy $this) {
            return $this.hasSession();
        }

        @Override
        default public boolean hasSession() {
            return true;
        }

        public static IO login_$(Dummy $this, Option userAndPassword, boolean onlyIfNotLoggedIn) {
            return $this.login_((Option<UserAndPassword>)userAndPassword, onlyIfNotLoggedIn);
        }

        @Override
        default public IO<Completed$package$Completed$> login_(Option<UserAndPassword> userAndPassword, boolean onlyIfNotLoggedIn) {
            return CatsEffectExtensions$.MODULE$.inline$completedIO();
        }

        public static IO logout$(Dummy $this) {
            return $this.logout();
        }

        @Override
        default public IO<Completed$package$Completed$> logout() {
            return CatsEffectExtensions$.MODULE$.inline$completedIO();
        }

        public static void clearSession$(Dummy $this) {
            $this.clearSession();
        }

        @Override
        default public void clearSession() {
        }
    }

    public static interface HasUserAndPassword
    extends LoginUntilReachable {
        public static void $init$(HasUserAndPassword $this) {
            $this.js7$base$session$SessionApi$HasUserAndPassword$_setter_$loginDelays_$eq((Function0 & Serializable)() -> SessionApi$.MODULE$.defaultLoginDelays());
        }

        public Option<UserAndPassword> userAndPassword();

        public Function0<Iterator<FiniteDuration>> loginDelays();

        public void js7$base$session$SessionApi$HasUserAndPassword$_setter_$loginDelays_$eq(Function0 var1);

        public static IO retryIfSessionLost$(HasUserAndPassword $this, IO body) {
            return $this.retryIfSessionLost(body);
        }

        @Override
        default public <A> IO<A> retryIfSessionLost(IO<A> body) {
            return this.login(true).$times$greater(body.recoverWith((PartialFunction)new Serializable(body, this){
                private final IO body$1;
                private final /* synthetic */ HasUserAndPassword $outer;
                {
                    this.body$1 = body$5;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Throwable x2) {
                    Problem problem;
                    Problem problem2;
                    Option<Problem> option;
                    Throwable throwable = x2;
                    return throwable instanceof HttpClient.HttpException && !(option = HttpClient$HttpException$HasProblem$.MODULE$.unapply((HttpClient.HttpException)throwable)).isEmpty() && (problem2 = (problem = (Problem)option.get())).is(Problems$InvalidSessionTokenProblem$.MODULE$);
                }

                public final Object applyOrElse(Throwable x2, Function1 function1) {
                    Problem problem;
                    Problem problem2;
                    Option<Problem> option;
                    Throwable throwable = x2;
                    if (throwable instanceof HttpClient.HttpException && !(option = HttpClient$HttpException$HasProblem$.MODULE$.unapply((HttpClient.HttpException)throwable)).isEmpty() && (problem2 = (problem = (Problem)option.get())).is(Problems$InvalidSessionTokenProblem$.MODULE$)) {
                        return this.$outer.js7$base$session$SessionApi$HasUserAndPassword$$renewSession(problem2).$times$greater(this.body$1);
                    }
                    return function1.apply((Object)x2);
                }
            }).flatMap((Function1 & Serializable)x$1 -> {
                Problem problem;
                Object object;
                Object object2 = x$1;
                if (object2 instanceof Left && (object = ((Left)object2).value()) instanceof Problem && (problem = (Problem)object).is(Problems$InvalidSessionTokenProblem$.MODULE$)) {
                    return this.js7$base$session$SessionApi$HasUserAndPassword$$renewSession(problem).$times$greater(body);
                }
                Object o = object2;
                return IO$.MODULE$.pure(o);
            }));
        }

        public static IO js7$base$session$SessionApi$HasUserAndPassword$$renewSession$(HasUserAndPassword $this, Problem problem) {
            return $this.js7$base$session$SessionApi$HasUserAndPassword$$renewSession(problem);
        }

        default public IO<Completed$package$Completed$> js7$base$session$SessionApi$HasUserAndPassword$$renewSession(Problem problem) {
            return IO$.MODULE$.defer(this::renewSession$$anonfun$1);
        }

        public static IO retryUntilReachable$(HasUserAndPassword $this, Function1 onError, Function0 body) {
            return $this.retryUntilReachable((Function1<Throwable, IO<Object>>)onError, body);
        }

        @Override
        default public <A> IO<A> retryUntilReachable(Function1<Throwable, IO<Object>> onError, Function0<IO<A>> body) {
            return IO$.MODULE$.defer(() -> this.retryUntilReachable$$anonfun$1(onError, body));
        }

        public static Function1 retryUntilReachable$default$1$(HasUserAndPassword $this) {
            return $this.retryUntilReachable$default$1();
        }

        @Override
        default public <A> Function1<Throwable, IO<Object>> retryUntilReachable$default$1() {
            return (Function1 & Serializable)throwable -> this.onErrorTryAgain((Throwable)throwable);
        }

        public static IO login$(HasUserAndPassword $this, boolean onlyIfNotLoggedIn) {
            return $this.login(onlyIfNotLoggedIn);
        }

        default public IO<Completed$package$Completed$> login(boolean onlyIfNotLoggedIn) {
            return this.login_(this.userAndPassword(), onlyIfNotLoggedIn);
        }

        public static boolean login$default$1$(HasUserAndPassword $this) {
            return $this.login$default$1();
        }

        default public boolean login$default$1() {
            return false;
        }

        public static IO loginUntilReachable$(HasUserAndPassword $this, Iterator delays, Function1 onError, boolean onlyIfNotLoggedIn) {
            return $this.loginUntilReachable((Iterator<FiniteDuration>)delays, (Function1<Throwable, IO<Object>>)onError, onlyIfNotLoggedIn);
        }

        default public IO<Completed$package$Completed$> loginUntilReachable(Iterator<FiniteDuration> delays, Function1<Throwable, IO<Object>> onError, boolean onlyIfNotLoggedIn) {
            return this.loginUntilReachable_(this.userAndPassword(), delays, onError, onlyIfNotLoggedIn);
        }

        public static Iterator loginUntilReachable$default$1$(HasUserAndPassword $this) {
            return $this.loginUntilReachable$default$1();
        }

        default public Iterator<FiniteDuration> loginUntilReachable$default$1() {
            return SessionApi$.MODULE$.defaultLoginDelays();
        }

        public static Function1 loginUntilReachable$default$2$(HasUserAndPassword $this) {
            return $this.loginUntilReachable$default$2();
        }

        default public Function1<Throwable, IO<Object>> loginUntilReachable$default$2() {
            return (Function1 & Serializable)throwable -> this.onErrorTryAgain((Throwable)throwable);
        }

        public static boolean loginUntilReachable$default$3$(HasUserAndPassword $this) {
            return $this.loginUntilReachable$default$3();
        }

        default public boolean loginUntilReachable$default$3() {
            return false;
        }

        private IO renewSession$$anonfun$1() {
            this.clearSession();
            return this.login(this.login$default$1());
        }

        private /* synthetic */ IO retryUntilReachable$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(BlockingSymbol sym$9, HttpClient.HttpException e$1, Iterator delays$6, Function1 onError$6, boolean bl) {
            if (bl) {
                sym$9.onWarn();
                SessionApi$.MODULE$.js7$base$session$SessionApi$$$warn(sym$9 + " " + this.toString(), e$1);
                return this.loginUntilReachable((Iterator<FiniteDuration>)delays$6, (Function1<Throwable, IO<Object>>)onError$6, true);
            }
            return IO$.MODULE$.raiseError((Throwable)e$1);
        }

        private void retryUntilReachable$$anonfun$1$$anonfun$2$$anonfun$1(BlockingSymbol sym$11) {
            if (sym$11.used()) {
                Logger LoggerImpl_this = SessionApi$.js7$base$session$SessionApi$$$logger;
                if (LoggerImpl_this.underlying().isInfoEnabled()) {
                    LoggerImpl_this.underlying().info("\ud83d\udfe2 {} reached", (Object)this);
                    return;
                }
                return;
            }
        }

        private void retryUntilReachable$$anonfun$1$$anonfun$2$$anonfun$2(BlockingSymbol sym$12) {
            if (sym$12.used()) {
                Logger LoggerImpl_this = SessionApi$.js7$base$session$SessionApi$$$logger;
                if (LoggerImpl_this.underlying().isInfoEnabled()) {
                    LoggerImpl_this.underlying().info("\u25fc\ufe0f  {} Canceled", (Object)this);
                    return;
                }
                return;
            }
        }

        private IO retryUntilReachable$$anonfun$1(Function1 onError$3, Function0 body$3) {
            Iterator delays = (Iterator)this.loginDelays().apply();
            BlockingSymbol sym = new BlockingSymbol();
            return this.loginUntilReachable((Iterator<FiniteDuration>)delays, (Function1<Throwable, IO<Object>>)onError$3, true).flatMap((Function1 & Serializable)_$4 -> (IO)MonixLikeExtensions$.MODULE$.onErrorRestartLoop(body$3.apply(), BoxedUnit.UNIT, (Function3 & Serializable)(throwable, _$5, retry) -> {
                IO<Completed$package$Completed$> iO;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof HttpClient.HttpException) {
                    Problem problem;
                    Problem problem2;
                    HttpClient.HttpException httpException = (HttpClient.HttpException)throwable2;
                    Option<Problem> option = HttpClient$HttpException$HasProblem$.MODULE$.unapply(httpException);
                    if (!option.isEmpty() && (problem2 = (problem = (Problem)option.get())).is(Problems$InvalidSessionTokenProblem$.MODULE$) && delays.hasNext()) {
                        Logger LoggerImpl_this = SessionApi$.js7$base$session$SessionApi$$$logger;
                        if (LoggerImpl_this.underlying().isDebugEnabled()) {
                            LoggerImpl_this.underlying().debug("\u27f2 {}: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.toString(), problem2}), Object.class));
                        }
                        iO = this.loginUntilReachable((Iterator<FiniteDuration>)delays, (Function1<Throwable, IO<Object>>)onError$3, this.loginUntilReachable$default$3());
                        return iO.$times$greater(IO$.MODULE$.sleep((FiniteDuration)delays.next())).$times$greater((IO)retry.apply((Object)BoxedUnit.UNIT));
                    }
                    HttpClient.HttpException e = httpException;
                    if (this.isTemporaryUnreachable(e) && delays.hasNext()) {
                        iO = ((IO)onError$3.apply((Object)e)).flatMap((Function1 & Serializable)object -> this.retryUntilReachable$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(sym, e, delays, onError$3, BoxesRunTime.unboxToBoolean((Object)object)));
                        return iO.$times$greater(IO$.MODULE$.sleep((FiniteDuration)delays.next())).$times$greater((IO)retry.apply((Object)BoxedUnit.UNIT));
                    }
                }
                iO = IO$.MODULE$.raiseError(throwable);
                return iO.$times$greater(IO$.MODULE$.sleep((FiniteDuration)delays.next())).$times$greater((IO)retry.apply((Object)BoxedUnit.UNIT));
            }, IO$.MODULE$.asyncForIO())).guaranteeCase((Function1 & Serializable)x$1 -> {
                Outcome outcome = x$1;
                if (outcome instanceof Outcome.Succeeded) {
                    package$.MODULE$.Outcome();
                    Outcome.Succeeded succeeded = Outcome.Succeeded$.MODULE$.unapply((Outcome.Succeeded)outcome);
                    IO iO = (IO)succeeded._1();
                    return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                        this.retryUntilReachable$$anonfun$1$$anonfun$2$$anonfun$1(sym);
                        return BoxedUnit.UNIT;
                    });
                }
                if (outcome instanceof Outcome.Canceled) {
                    package$.MODULE$.Outcome();
                    if (Outcome.Canceled$.MODULE$.unapply((Outcome.Canceled)outcome)) {
                        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                            this.retryUntilReachable$$anonfun$1$$anonfun$2$$anonfun$2(sym);
                            return BoxedUnit.UNIT;
                        });
                    }
                }
                return IO$.MODULE$.unit();
            });
        }
    }

    public static interface LoginUntilReachable
    extends SessionApi {
        public static boolean isTemporaryUnreachable$(LoginUntilReachable $this, Throwable throwable) {
            return $this.isTemporaryUnreachable(throwable);
        }

        default public boolean isTemporaryUnreachable(Throwable throwable) {
            return HttpClient$.MODULE$.isTemporaryUnreachable(throwable);
        }

        public boolean hasSession();

        public static IO loginUntilReachable_$(LoginUntilReachable $this, Option userAndPassword, Iterator delays, Function1 onError, boolean onlyIfNotLoggedIn) {
            return $this.loginUntilReachable_((Option<UserAndPassword>)userAndPassword, (Iterator<FiniteDuration>)delays, (Function1<Throwable, IO<Object>>)onError, onlyIfNotLoggedIn);
        }

        default public IO<Completed$package$Completed$> loginUntilReachable_(Option<UserAndPassword> userAndPassword, Iterator<FiniteDuration> delays, Function1<Throwable, IO<Object>> onError, boolean onlyIfNotLoggedIn) {
            return IO$.MODULE$.defer(() -> this.loginUntilReachable_$$anonfun$1(onlyIfNotLoggedIn, userAndPassword, onError, delays));
        }

        public static Iterator loginUntilReachable_$default$2$(LoginUntilReachable $this) {
            return $this.loginUntilReachable_$default$2();
        }

        default public Iterator<FiniteDuration> loginUntilReachable_$default$2() {
            return SessionApi$.MODULE$.defaultLoginDelays();
        }

        public static Function1 loginUntilReachable_$default$3$(LoginUntilReachable $this) {
            return $this.loginUntilReachable_$default$3();
        }

        default public Function1<Throwable, IO<Object>> loginUntilReachable_$default$3() {
            return (Function1 & Serializable)throwable -> this.onErrorTryAgain((Throwable)throwable);
        }

        public static boolean loginUntilReachable_$default$4$(LoginUntilReachable $this) {
            return $this.loginUntilReachable_$default$4();
        }

        default public boolean loginUntilReachable_$default$4() {
            return false;
        }

        private /* synthetic */ IO loginUntilReachable_$$anonfun$1$$anonfun$1$$anonfun$1(Iterator delays$3, boolean isTemporary$1, BlockingSymbol sym$2, Throwable throwable$1, Function1 retry$1, boolean bl) {
            if (bl && delays$3.hasNext() && isTemporary$1) {
                String prefix = ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(isTemporary$1), (Function0<String>)((Function0 & Serializable)() -> SessionApi$.js7$base$session$SessionApi$LoginUntilReachable$$_$_$$anonfun$1(sym$2)));
                SessionApi$.MODULE$.js7$base$session$SessionApi$$$warn(prefix + this, throwable$1);
                return ((IO)retry$1.apply((Object)BoxedUnit.UNIT)).delayBy((Duration)delays$3.next());
            }
            return IO$.MODULE$.raiseError(throwable$1);
        }

        private String message$proxy4$1() {
            return "\ud83d\udfe2 " + this + " logged-in";
        }

        private String loginUntilReachable_$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1() {
            return this.message$proxy4$1();
        }

        private void loginUntilReachable_$$anonfun$1$$anonfun$2$$anonfun$1(BlockingSymbol sym$5) {
            LogLevel level$proxy1 = sym$5.relievedLogLevel();
            Slf4jUtils$syntax$LevelLogger$.MODULE$.log$extension(Slf4jUtils$syntax$.MODULE$.LevelLogger(SessionApi$.js7$base$session$SessionApi$$$logger.underlying()), level$proxy1, (Function0<String>)((Function0 & Serializable)this::loginUntilReachable_$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1));
        }

        private String message$proxy5$1() {
            return "\u25fc\ufe0f  " + this + " Canceled";
        }

        private String loginUntilReachable_$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1() {
            return this.message$proxy5$1();
        }

        private void loginUntilReachable_$$anonfun$1$$anonfun$2$$anonfun$2(BlockingSymbol sym$6) {
            LogLevel level$proxy2 = sym$6.relievedLogLevel();
            Slf4jUtils$syntax$LevelLogger$.MODULE$.log$extension(Slf4jUtils$syntax$.MODULE$.LevelLogger(SessionApi$.js7$base$session$SessionApi$$$logger.underlying()), level$proxy2, (Function0<String>)((Function0 & Serializable)this::loginUntilReachable_$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1));
        }

        private IO loginUntilReachable_$$anonfun$1(boolean onlyIfNotLoggedIn$1, Option userAndPassword$1, Function1 onError$1, Iterator delays$1) {
            if (onlyIfNotLoggedIn$1 && this.hasSession()) {
                return CatsEffectExtensions$.MODULE$.inline$completedIO();
            }
            BlockingSymbol sym = new BlockingSymbol();
            return ((IO)MonixLikeExtensions$.MODULE$.onErrorRestartLoop(this.login_((Option<UserAndPassword>)userAndPassword$1, this.login_$default$2()), BoxedUnit.UNIT, (Function3 & Serializable)(throwable, _$3, retry) -> {
                boolean isTemporary = this.isTemporaryUnreachable((Throwable)throwable);
                return ((IO)onError$1.apply(throwable)).flatMap((Function1 & Serializable)object -> this.loginUntilReachable_$$anonfun$1$$anonfun$1$$anonfun$1(delays$1, isTemporary, sym, (Throwable)throwable, (Function1)retry, BoxesRunTime.unboxToBoolean((Object)object)));
            }, IO$.MODULE$.asyncForIO())).guaranteeCase((Function1 & Serializable)x$1 -> {
                Outcome outcome = x$1;
                if (outcome instanceof Outcome.Succeeded) {
                    package$.MODULE$.Outcome();
                    Outcome.Succeeded succeeded = Outcome.Succeeded$.MODULE$.unapply((Outcome.Succeeded)outcome);
                    IO iO = (IO)succeeded._1();
                    return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                        this.loginUntilReachable_$$anonfun$1$$anonfun$2$$anonfun$1(sym);
                        return BoxedUnit.UNIT;
                    });
                }
                if (outcome instanceof Outcome.Canceled) {
                    package$.MODULE$.Outcome();
                    if (Outcome.Canceled$.MODULE$.unapply((Outcome.Canceled)outcome)) {
                        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                            this.loginUntilReachable_$$anonfun$1$$anonfun$2$$anonfun$2(sym);
                            return BoxedUnit.UNIT;
                        });
                    }
                }
                return IO$.MODULE$.unit();
            });
        }
    }
}

