/*
 * Decompiled with CFR 0.152.
 */
package js7.base.time;

import cats.Show;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.Encoder;
import io.circe.Json$;
import java.io.Serializable;
import js7.base.number.Numbers$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.time.Timestamp$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordered;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;
import scala.util.Either;

public interface Timestamp
extends Ordered<Timestamp> {
    public static Timestamp Epoch() {
        return Timestamp$.MODULE$.Epoch();
    }

    public static FiniteDuration Epsilon() {
        return Timestamp$.MODULE$.Epsilon();
    }

    public static Timestamp MaxValue() {
        return Timestamp$.MODULE$.MaxValue();
    }

    public static Encoder<Timestamp> StringTimestampJsonEncoder() {
        return Timestamp$.MODULE$.StringTimestampJsonEncoder();
    }

    public static Show<Timestamp> TimestampShow() {
        return Timestamp$.MODULE$.TimestampShow();
    }

    public static Timestamp apply(String string) {
        return Timestamp$.MODULE$.apply(string);
    }

    public static Either<Problem, Timestamp> checked(String string) {
        return Timestamp$.MODULE$.checked(string);
    }

    public static long currentTimeMillis() {
        return Timestamp$.MODULE$.currentTimeMillis();
    }

    public static Companion implementation() {
        return Timestamp$.MODULE$.implementation();
    }

    public static Decoder<Timestamp> jsonDecoder() {
        return Timestamp$.MODULE$.jsonDecoder();
    }

    public static Encoder<Timestamp> jsonEncoder() {
        return Timestamp$.MODULE$.jsonEncoder();
    }

    public static Timestamp now() {
        return Timestamp$.MODULE$.now();
    }

    public static Timestamp ofEpochMilli(long l) {
        return Timestamp$.MODULE$.ofEpochMilli(l);
    }

    public static Timestamp ofEpochSecond(long l) {
        return Timestamp$.MODULE$.ofEpochSecond(l);
    }

    public static Timestamp parse(String string) {
        return Timestamp$.MODULE$.parse(string);
    }

    public Companion companion();

    public long toEpochMilli();

    public static long toEpochSecond$(Timestamp $this) {
        return $this.toEpochSecond();
    }

    default public long toEpochSecond() {
        return this.toEpochMilli() / 1000L;
    }

    public String toIsoString();

    public static String toTimeString$(Timestamp $this) {
        return $this.toTimeString();
    }

    default public String toTimeString() {
        return StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(this.toIsoString().substring(11)), "Z");
    }

    public static boolean isFiniteDurationCompatible$(Timestamp $this) {
        return $this.isFiniteDurationCompatible();
    }

    default public boolean isFiniteDurationCompatible() {
        return this.toEpochMilli() >= 0L && this.toEpochSecond() < 9223372036854L;
    }

    public static Either checkFiniteDurationCompatible$(Timestamp $this) {
        return $this.checkFiniteDurationCompatible();
    }

    default public Either<Problem, Timestamp> checkFiniteDurationCompatible() {
        if (!this.isFiniteDurationCompatible()) {
            return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)this::checkFiniteDurationCompatible$$anonfun$1), Problem$.MODULE$.apply$default$2()));
        }
        return package$.MODULE$.Right().apply((Object)this);
    }

    public Either<Problem, String> format(String var1, Option<String> var2);

    public static Option format$default$2$(Timestamp $this) {
        return $this.format$default$2();
    }

    default public Option<String> format$default$2() {
        return None$.MODULE$;
    }

    public static int compare$(Timestamp $this, Timestamp o) {
        return $this.compare(o);
    }

    default public int compare(Timestamp o) {
        return new RichLong(Predef$.MODULE$.longWrapper(this.toEpochMilli())).compare((Object)BoxesRunTime.boxToLong((long)o.toEpochMilli()));
    }

    public static Timestamp $plus$(Timestamp $this, FiniteDuration o) {
        return $this.$plus(o);
    }

    default public Timestamp $plus(FiniteDuration o) {
        return this.copy(Numbers$.MODULE$.addSaturating(this.toEpochMilli(), o.toMillis()));
    }

    public static Timestamp $minus$(Timestamp $this, FiniteDuration o) {
        return $this.$minus(o);
    }

    default public Timestamp $minus(FiniteDuration o) {
        return this.copy(Numbers$.MODULE$.subtractSaturating(this.toEpochMilli(), o.toMillis()));
    }

    public static FiniteDuration $minus$(Timestamp $this, Timestamp o) {
        return $this.$minus(o);
    }

    default public FiniteDuration $minus(Timestamp o) {
        return new FiniteDuration(Numbers$.MODULE$.subtractSaturating(this.toEpochMilli(), o.toEpochMilli()), scala.concurrent.duration.package$.MODULE$.MILLISECONDS());
    }

    public static Timestamp min$(Timestamp $this, Timestamp o) {
        return $this.min(o);
    }

    default public Timestamp min(Timestamp o) {
        if (this.$less(o)) {
            return this;
        }
        return o;
    }

    public static Timestamp max$(Timestamp $this, Timestamp o) {
        return $this.max(o);
    }

    default public Timestamp max(Timestamp o) {
        if (this.$greater(o)) {
            return this;
        }
        return o;
    }

    public static Timestamp roundToNextSecond$(Timestamp $this) {
        return $this.roundToNextSecond();
    }

    default public Timestamp roundToNextSecond() {
        return this.copy((this.toEpochMilli() + 999L) / 1000L * 1000L);
    }

    public static Timestamp secondsOnly$(Timestamp $this) {
        return $this.secondsOnly();
    }

    default public Timestamp secondsOnly() {
        return this.copy(this.toEpochMilli() / 1000L * 1000L);
    }

    public static Timestamp roundTo$(Timestamp $this, FiniteDuration duration) {
        return $this.roundTo(duration);
    }

    default public Timestamp roundTo(FiniteDuration duration) {
        return this.$plus(duration.$div(2L)).roundDownTo(duration);
    }

    public static Timestamp roundDownTo$(Timestamp $this, FiniteDuration duration) {
        return $this.roundDownTo(duration);
    }

    default public Timestamp roundDownTo(FiniteDuration duration) {
        long durationMillis = duration.toMillis();
        return this.companion().ofEpochMilli(this.toEpochMilli() / durationMillis * durationMillis);
    }

    public Timestamp copy(long var1);

    public static String show$(Timestamp $this) {
        return $this.show();
    }

    default public String show() {
        return this.toString();
    }

    public static String pretty$(Timestamp $this) {
        return $this.pretty();
    }

    default public String pretty() {
        return this.toString().replace('T', ' ');
    }

    public static String toString$(Timestamp $this) {
        return $this.toString();
    }

    default public String toString() {
        if (this.toEpochMilli() == 0L) {
            return "Epoch";
        }
        return this.toIsoString();
    }

    private String checkFiniteDurationCompatible$$anonfun$1() {
        return this.toString() + " is out of range";
    }

    public static interface Companion {
        public static void $init$(Companion $this) {
            $this.js7$base$time$Timestamp$Companion$_setter_$StringTimestampJsonEncoder_$eq((Encoder & Serializable)o -> Json$.MODULE$.fromString(o.toIsoString()));
            $this.js7$base$time$Timestamp$Companion$_setter_$NumericTimestampJsonEncoder_$eq((Encoder & Serializable)o -> Json$.MODULE$.fromLong(o.toEpochMilli()));
            $this.js7$base$time$Timestamp$Companion$_setter_$jsonEncoder_$eq($this.NumericTimestampJsonEncoder());
            $this.js7$base$time$Timestamp$Companion$_setter_$jsonDecoder_$eq((Decoder & Serializable)cursor -> {
                if (cursor.value().isString()) {
                    return cursor.as(Decoder$.MODULE$.decodeString()).map((Function1 & Serializable)string -> this.parse((String)string));
                }
                return cursor.as(Decoder$.MODULE$.decodeLong()).map((Function1 & Serializable)o -> this.$init$$$anonfun$4$$anonfun$2(BoxesRunTime.unboxToLong((Object)o)));
            });
        }

        public Encoder<Timestamp> StringTimestampJsonEncoder();

        public void js7$base$time$Timestamp$Companion$_setter_$StringTimestampJsonEncoder_$eq(Encoder var1);

        public Encoder<Timestamp> NumericTimestampJsonEncoder();

        public void js7$base$time$Timestamp$Companion$_setter_$NumericTimestampJsonEncoder_$eq(Encoder var1);

        public Encoder<Timestamp> jsonEncoder();

        public void js7$base$time$Timestamp$Companion$_setter_$jsonEncoder_$eq(Encoder var1);

        public Decoder<Timestamp> jsonDecoder();

        public void js7$base$time$Timestamp$Companion$_setter_$jsonDecoder_$eq(Decoder var1);

        public Timestamp ofEpochMilli(long var1);

        public static Timestamp ofEpochSecond$(Companion $this, long o) {
            return $this.ofEpochSecond(o);
        }

        default public Timestamp ofEpochSecond(long o) {
            return this.ofEpochMilli(o * 1000L);
        }

        public Timestamp parse(String var1);

        private /* synthetic */ Timestamp $init$$$anonfun$4$$anonfun$2(long o) {
            return this.ofEpochMilli(o);
        }
    }
}

