/*
 * Decompiled with CFR 0.152.
 */
package js7.common.auth;

import com.typesafe.scalalogging.Logger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import js7.base.utils.ScalaUtils$;
import js7.common.auth.Hasher$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.runtime.LazyVals$;

public final class Hasher
implements Function1<String, String> {
    private final String algorithm;
    private final MessageDigest prototype;
    private boolean isCloneable;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Hasher$.class.getDeclaredField("sha512$lzy1"));

    public static Hasher sha512() {
        return Hasher$.MODULE$.sha512();
    }

    public Hasher(String algorithm) {
        this.algorithm = algorithm;
        this.prototype = MessageDigest.getInstance(algorithm);
        this.isCloneable = true;
    }

    public String apply(String string) {
        return ScalaUtils$.MODULE$.bytesToHex((Seq<Object>)Predef$.MODULE$.wrapByteArray(this.cloneMessageDigest().digest(string.getBytes(StandardCharsets.UTF_8))));
    }

    private MessageDigest cloneMessageDigest() {
        if (this.isCloneable) {
            MessageDigest messageDigest;
            try {
                messageDigest = (MessageDigest)this.prototype.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                this.isCloneable = false;
                Logger LoggerImpl_this = Hasher$.js7$common$auth$Hasher$$$logger;
                if (LoggerImpl_this.underlying().isDebugEnabled()) {
                    LoggerImpl_this.underlying().debug("{} MessageDigest is not cloneable", (Object)this.algorithm);
                }
                messageDigest = this.newMessageDigest();
            }
            return messageDigest;
        }
        return this.newMessageDigest();
    }

    private MessageDigest newMessageDigest() {
        return MessageDigest.getInstance(this.algorithm);
    }

    public String toString() {
        return this.algorithm;
    }
}

