/*
 * Decompiled with CFR 0.152.
 */
package js7.common.configuration;

import cats.syntax.package;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import js7.base.configutils.Configs$;
import js7.base.configutils.Configs$RichConfig$;
import js7.base.io.file.FileUtils$syntax$;
import js7.base.io.file.FileUtils$syntax$RichPath$;
import js7.base.io.https.HttpsConfig;
import js7.base.io.https.HttpsConfig$;
import js7.base.io.https.KeyStoreRef;
import js7.base.io.https.KeyStoreRef$;
import js7.base.io.https.TrustStoreRef;
import js7.base.io.https.TrustStoreRef$;
import js7.base.problem.Checked$;
import js7.base.problem.Checked$Ops$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.common.commandline.CommandLineArguments;
import js7.common.configuration.BasicConfiguration;
import js7.common.configuration.CommonConfiguration$;
import js7.common.configuration.CommonConfiguration$Common$;
import js7.common.pekkohttp.web.data.WebServerBinding;
import js7.common.pekkohttp.web.data.WebServerBinding$Http$;
import js7.common.pekkohttp.web.data.WebServerBinding$Https$;
import js7.common.pekkohttp.web.data.WebServerPort;
import js7.common.pekkohttp.web.data.WebServerPort$Http$;
import js7.common.pekkohttp.web.data.WebServerPort$Https$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Product;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;

public interface CommonConfiguration
extends WebServerBinding.HasLocalUris,
BasicConfiguration {
    public static void $init$(CommonConfiguration $this) {
    }

    @Override
    public Config config();

    public Path configDirectory();

    @Override
    public Seq<WebServerPort> webServerPorts();

    public static HttpsConfig httpsConfig$(CommonConfiguration $this) {
        return $this.httpsConfig();
    }

    default public HttpsConfig httpsConfig() {
        Either either = Checked$.MODULE$.Ops(this.config().hasPath("js7.web.https.client-keystore") ? KeyStoreRef$.MODULE$.fromSubconfig(this.config().getConfig("js7.web.https.client-keystore"), this.configDirectory().resolve("private/https-client-keystore.p12")) : this.js7$common$configuration$CommonConfiguration$$keyStoreRef());
        return HttpsConfig$.MODULE$.apply(Checked$Ops$.MODULE$.onProblem$extension(either, (Function1<Problem, BoxedUnit>)(JProcedure1 & Serializable)p -> {
            Logger LoggerImpl_this = CommonConfiguration$.js7$common$configuration$CommonConfiguration$$$logger;
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("No keystore: {}", p);
                return;
            }
        }), this.trustStoreRefs());
    }

    public static Seq trustStoreRefs$(CommonConfiguration $this) {
        return $this.trustStoreRefs();
    }

    default public Seq<TrustStoreRef> trustStoreRefs() {
        return TrustStoreRef$.MODULE$.fromConfig(this.config());
    }

    public static Either js7$common$configuration$CommonConfiguration$$keyStoreRef$(CommonConfiguration $this) {
        return $this.js7$common$configuration$CommonConfiguration$$keyStoreRef();
    }

    default public Either<Problem, KeyStoreRef> js7$common$configuration$CommonConfiguration$$keyStoreRef() {
        return Configs$RichConfig$.MODULE$.checkedPath$extension(Configs$.MODULE$.RichConfig(this.config()), "js7.web.https.keystore", (Function1 & Serializable)path -> KeyStoreRef$.MODULE$.fromSubconfig(this.config().getConfig(path), this.configDirectory().resolve("private/https-keystore.p12")));
    }

    public static Seq http$(CommonConfiguration $this) {
        return $this.http();
    }

    default public Seq<WebServerBinding.Http> http() {
        return (Seq)this.webServerBindings().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(WebServerBinding x2) {
                WebServerBinding webServerBinding = x2;
                if (webServerBinding instanceof WebServerBinding.Http) {
                    WebServerBinding.Http o = (WebServerBinding.Http)webServerBinding;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(WebServerBinding x2, Function1 function1) {
                WebServerBinding webServerBinding = x2;
                if (webServerBinding instanceof WebServerBinding.Http) {
                    WebServerBinding.Http o = (WebServerBinding.Http)webServerBinding;
                    return o;
                }
                return function1.apply((Object)x2);
            }
        });
    }

    public static Seq https$(CommonConfiguration $this) {
        return $this.https();
    }

    default public Seq<WebServerBinding.Https> https() {
        return (Seq)this.webServerBindings().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(WebServerBinding x2) {
                WebServerBinding webServerBinding = x2;
                if (webServerBinding instanceof WebServerBinding.Https) {
                    WebServerBinding.Https o = (WebServerBinding.Https)webServerBinding;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(WebServerBinding x2, Function1 function1) {
                WebServerBinding webServerBinding = x2;
                if (webServerBinding instanceof WebServerBinding.Https) {
                    WebServerBinding.Https o = (WebServerBinding.Https)webServerBinding;
                    return o;
                }
                return function1.apply((Object)x2);
            }
        });
    }

    public static Seq webServerBindings$(CommonConfiguration $this) {
        return $this.webServerBindings();
    }

    default public Seq<WebServerBinding> webServerBindings() {
        return (Seq)this.webServerPorts().map((Function1 & Serializable)x$1 -> {
            Product product;
            WebServerPort webServerPort = x$1;
            if (webServerPort instanceof WebServerPort.Http) {
                InetSocketAddress inetSocketAddress;
                WebServerPort.Http http = WebServerPort$Http$.MODULE$.unapply((WebServerPort.Http)webServerPort);
                InetSocketAddress port = inetSocketAddress = http._1();
                product = WebServerBinding$Http$.MODULE$.apply(port);
            } else if (webServerPort instanceof WebServerPort.Https) {
                InetSocketAddress inetSocketAddress;
                WebServerPort.Https https = WebServerPort$Https$.MODULE$.unapply((WebServerPort.Https)webServerPort);
                InetSocketAddress port = inetSocketAddress = https._1();
                Either either = Checked$.MODULE$.Ops(this.js7$common$configuration$CommonConfiguration$$keyStoreRef());
                Either either2 = Checked$.MODULE$.Ops(Checked$Ops$.MODULE$.mapProblem$extension(either, (Function1<Problem, Problem>)(Function1 & Serializable)_$1 -> (Problem)package.semigroup$.MODULE$.catsSyntaxSemigroup((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)CommonConfiguration::webServerBindings$$anonfun$1$$anonfun$1$$anonfun$1), Problem$.MODULE$.apply$default$2()), Problem$.MODULE$.problemSemigroup()).$bar$plus$bar(_$1)));
                product = WebServerBinding$Https$.MODULE$.apply(port, (KeyStoreRef)Checked$Ops$.MODULE$.orThrow$extension(either2), this.trustStoreRefs());
            } else {
                throw new MatchError((Object)webServerPort);
            }
            return product;
        });
    }

    private static String webServerBindings$$anonfun$1$$anonfun$1$$anonfun$1() {
        return "HTTPS requires a key store:";
    }

    public static final class Common
    implements Product,
    Serializable {
        private final Path configDirectory;
        private final Path dataDirectory;
        private final Seq<WebServerPort> webServerPorts;
        private final Path workDirectory;
        private final Path logDirectory;

        public static Common apply(Path path, Path path2, Seq<WebServerPort> seq) {
            return CommonConfiguration$Common$.MODULE$.apply(path, path2, seq);
        }

        public static Common fromCommandLineArguments(CommandLineArguments commandLineArguments) {
            return CommonConfiguration$Common$.MODULE$.fromCommandLineArguments(commandLineArguments);
        }

        public static Common fromProduct(Product product) {
            return CommonConfiguration$Common$.MODULE$.fromProduct(product);
        }

        public static Common unapply(Common common) {
            return CommonConfiguration$Common$.MODULE$.unapply(common);
        }

        public Common(Path configDirectory, Path dataDirectory, Seq<WebServerPort> webServerPorts) {
            this.configDirectory = configDirectory;
            this.dataDirectory = dataDirectory;
            this.webServerPorts = webServerPorts;
            this.workDirectory = FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(dataDirectory), "work");
            this.logDirectory = FileUtils$syntax$RichPath$.MODULE$.$div$extension(FileUtils$syntax$.MODULE$.RichPath(dataDirectory), "logs");
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Common)) return false;
            Common common = (Common)object;
            Path path = this.configDirectory();
            Path path2 = common.configDirectory();
            if (path == null) {
                if (path2 != null) {
                    return false;
                }
            } else if (!((Object)path).equals(path2)) return false;
            Path path3 = this.dataDirectory();
            Path path4 = common.dataDirectory();
            if (path3 == null) {
                if (path4 != null) {
                    return false;
                }
            } else if (!((Object)path3).equals(path4)) return false;
            Seq<WebServerPort> seq = this.webServerPorts();
            Seq<WebServerPort> seq2 = common.webServerPorts();
            if (seq == null) {
                if (seq2 == null) return true;
                return false;
            } else {
                if (!seq.equals(seq2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Common;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Common";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "configDirectory";
                }
                case 1: {
                    return "dataDirectory";
                }
                case 2: {
                    return "webServerPorts";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Path configDirectory() {
            return this.configDirectory;
        }

        public Path dataDirectory() {
            return this.dataDirectory;
        }

        public Seq<WebServerPort> webServerPorts() {
            return this.webServerPorts;
        }

        public Path workDirectory() {
            return this.workDirectory;
        }

        public Path logDirectory() {
            return this.logDirectory;
        }

        public Common copy(Path configDirectory, Path dataDirectory, Seq<WebServerPort> webServerPorts) {
            return new Common(configDirectory, dataDirectory, webServerPorts);
        }

        public Path copy$default$1() {
            return this.configDirectory();
        }

        public Path copy$default$2() {
            return this.dataDirectory();
        }

        public Seq<WebServerPort> copy$default$3() {
            return this.webServerPorts();
        }

        public Path _1() {
            return this.configDirectory();
        }

        public Path _2() {
            return this.dataDirectory();
        }

        public Seq<WebServerPort> _3() {
            return this.webServerPorts();
        }
    }
}

