/*
 * Decompiled with CFR 0.152.
 */
package js7.data.session;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Outcome;
import cats.effect.kernel.Resource;
import cats.effect.package$;
import cats.syntax.package;
import com.typesafe.scalalogging.Logger;
import fs2.Stream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import js7.base.auth.SessionToken;
import js7.base.auth.UserAndPassword;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.fs2utils.StreamExtensions$;
import js7.base.generic.Completed$package$Completed$;
import js7.base.problem.Checked$;
import js7.base.problem.Checked$Ops$;
import js7.base.session.HasSessionToken;
import js7.base.session.SessionApi;
import js7.base.session.SessionCommand;
import js7.base.session.SessionCommand$;
import js7.base.session.SessionCommand$Login$;
import js7.base.session.SessionCommand$Logout$;
import js7.base.session.SessionCommand$Response$;
import js7.base.time.Stopwatch$;
import js7.base.utils.AsyncLock;
import js7.base.utils.AsyncLock$;
import js7.base.utils.Atomic$package$Atomic$extensions$;
import js7.base.utils.CatsUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichAny$;
import js7.base.version.Version;
import js7.base.web.HttpClient;
import js7.base.web.Uri;
import js7.data.event.SnapshotableState;
import js7.data.session.HttpSessionApi$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import sourcecode.Enclosing$;

public interface HttpSessionApi
extends SessionApi,
HasSessionToken {
    public static void logNonMatchingVersion(Version version, Function0<String> function0, Version version2) {
        HttpSessionApi$.MODULE$.logNonMatchingVersion(version, function0, version2);
    }

    public static Version logNonMatchingVersion$default$3() {
        return HttpSessionApi$.MODULE$.logNonMatchingVersion$default$3();
    }

    public static void $init$(HttpSessionApi $this) {
        $this.js7$data$session$HttpSessionApi$_setter_$js7$data$session$HttpSessionApi$$lock_$eq(AsyncLock$.MODULE$.apply("HttpSessionApi", AsyncLock$.MODULE$.apply$default$2(), AsyncLock$.MODULE$.apply$default$3(), AsyncLock$.MODULE$.apply$default$4()));
        Option initial$proxy1 = package.option$.MODULE$.none();
        $this.js7$data$session$HttpSessionApi$_setter_$js7$data$session$HttpSessionApi$$sessionTokenRef_$eq(new AtomicReference<Option>(initial$proxy1));
    }

    public HttpClient httpClient();

    public Uri sessionUri();

    public AsyncLock js7$data$session$HttpSessionApi$$lock();

    public void js7$data$session$HttpSessionApi$_setter_$js7$data$session$HttpSessionApi$$lock_$eq(AsyncLock var1);

    public AtomicReference<Option<SessionToken>> js7$data$session$HttpSessionApi$$sessionTokenRef();

    public void js7$data$session$HttpSessionApi$_setter_$js7$data$session$HttpSessionApi$$sessionTokenRef_$eq(AtomicReference var1);

    public static void logOpenSession$(HttpSessionApi $this) {
        $this.logOpenSession();
    }

    default public void logOpenSession() {
        this.js7$data$session$HttpSessionApi$$sessionTokenRef().get().foreach((Function1)(JProcedure1 & Serializable)token -> {
            Logger LoggerImpl_this = HttpSessionApi$.js7$data$session$HttpSessionApi$$$logger;
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("close(), but {} not logged-out: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{token, this.toString()}), Object.class));
                return;
            }
        });
    }

    public static IO login_$(HttpSessionApi $this, Option userAndPassword, boolean onlyIfNotLoggedIn) {
        return $this.login_((Option<UserAndPassword>)userAndPassword, onlyIfNotLoggedIn);
    }

    @Override
    default public IO<Completed$package$Completed$> login_(Option<UserAndPassword> userAndPassword, boolean onlyIfNotLoggedIn) {
        return IO$.MODULE$.defer(() -> this.login_$$anonfun$1(onlyIfNotLoggedIn, userAndPassword));
    }

    public static boolean login_$default$2$(HttpSessionApi $this) {
        return $this.login_$default$2();
    }

    @Override
    default public boolean login_$default$2() {
        return false;
    }

    public static IO logout$(HttpSessionApi $this) {
        return $this.logout();
    }

    @Override
    default public IO<Completed$package$Completed$> logout() {
        return IO$.MODULE$.defer(this::logout$$anonfun$1);
    }

    private IO<Object> executeSessionCommand(SessionCommand command, boolean suppressSessionToken) {
        LazyRef lazyRef = new LazyRef();
        return this.httpClient().post(this.sessionUri(), command, SessionCommand$.MODULE$.jsonCodec(), SessionCommand$Response$.MODULE$.jsonCodec(), (IO<Option<SessionToken>>)this.given_IO_Option$1(lazyRef, suppressSessionToken)).map((Function1 & Serializable)_$3 -> _$3);
    }

    private boolean executeSessionCommand$default$2() {
        return false;
    }

    public static void clearSession$(HttpSessionApi $this) {
        $this.clearSession();
    }

    @Override
    default public void clearSession() {
        Atomic$package$Atomic$extensions$.MODULE$.$colon$eq(this.js7$data$session$HttpSessionApi$$sessionTokenRef(), None$.MODULE$);
    }

    public static void setSessionToken$(HttpSessionApi $this, SessionToken sessionToken) {
        $this.setSessionToken(sessionToken);
    }

    default public void setSessionToken(SessionToken sessionToken) {
        Atomic$package$Atomic$extensions$.MODULE$.$colon$eq(this.js7$data$session$HttpSessionApi$$sessionTokenRef(), Some$.MODULE$.apply((Object)sessionToken));
    }

    public static Option sessionToken$(HttpSessionApi $this) {
        return $this.sessionToken();
    }

    @Override
    default public Option<SessionToken> sessionToken() {
        return this.js7$data$session$HttpSessionApi$$sessionTokenRef().get();
    }

    public static IO snapshotAs$(HttpSessionApi $this, Uri uri, SnapshotableState.Companion S) {
        return $this.snapshotAs(uri, S);
    }

    default public <S extends SnapshotableState<S>> IO<S> snapshotAs(Uri uri, SnapshotableState.Companion<S> S) {
        return IO$.MODULE$.defer(() -> this.snapshotAs$$anonfun$1(uri, S));
    }

    private static boolean login_$$anonfun$1$$anonfun$1$$anonfun$1() {
        return HttpSessionApi$.js7$data$session$HttpSessionApi$$$isPasswordLoggable;
    }

    private static Object login_$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2(HttpClient.HttpException t$2) {
        return t$2;
    }

    private static void login_$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(Option userAndPassword$5, HttpClient.HttpException t$1) {
        Logger LoggerImpl_this = HttpSessionApi$.js7$data$session$HttpSessionApi$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("\u26d4\ufe0f Login {} => {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{userAndPassword$5.map((Function1 & Serializable)o -> o.userId() + " \u00bb" + o.password().string() + "\u00ab"), t$1.problem().getOrElse(() -> HttpSessionApi.login_$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2(t$1))}), Object.class));
            return;
        }
    }

    private String login_$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$1() {
        return this.sessionUri().stripPath().toString();
    }

    private IO login_$$anonfun$1$$anonfun$1(boolean onlyIfNotLoggedIn$2, Option userAndPassword$2) {
        if (onlyIfNotLoggedIn$2 && this.hasSession()) {
            return CatsEffectExtensions$.MODULE$.inline$completedIO();
        }
        SessionCommand.Login cmd = SessionCommand$Login$.MODULE$.apply((Option<UserAndPassword>)userAndPassword$2, (Option<Version>)Some$.MODULE$.apply((Object)js7.base.package$.MODULE$.Js7Version()));
        Logger LoggerImpl_this = HttpSessionApi$.js7$data$session$HttpSessionApi$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("{}: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.toString(), cmd}), Object.class));
        }
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichAny(this.executeSessionCommand(cmd, this.executeSessionCommand$default$2()));
        return ((IO)ScalaUtils$syntax$RichAny$.MODULE$.pipeIf$extension(iO, (Function0<Object>)((Function0 & Serializable)HttpSessionApi::login_$$anonfun$1$$anonfun$1$$anonfun$1), (Function1 & Serializable)_$1 -> _$1.guaranteeCase((Function1 & Serializable)x$1 -> {
            Outcome outcome = x$1;
            if (outcome instanceof Outcome.Errored) {
                HttpClient.HttpException t;
                package$.MODULE$.Outcome();
                Outcome.Errored errored = Outcome.Errored$.MODULE$.unapply((Outcome.Errored)outcome);
                Throwable throwable = (Throwable)errored._1();
                if (throwable instanceof HttpClient.HttpException && (t = (HttpClient.HttpException)throwable).statusInt() == 401) {
                    return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                        HttpSessionApi.login_$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(userAndPassword$2, t);
                        return BoxedUnit.UNIT;
                    });
                }
            }
            return IO$.MODULE$.unit();
        }))).map((Function1 & Serializable)response -> {
            HttpSessionApi$.MODULE$.logNonMatchingVersion(response.js7Version(), (Function0<String>)((Function0 & Serializable)this::login_$$anonfun$1$$anonfun$1$$anonfun$3$$anonfun$1), HttpSessionApi$.MODULE$.logNonMatchingVersion$default$3());
            this.setSessionToken(response.sessionToken());
            return Completed$package$Completed$.MODULE$;
        });
    }

    private IO login_$$anonfun$1(boolean onlyIfNotLoggedIn$1, Option userAndPassword$1) {
        if (onlyIfNotLoggedIn$1 && this.hasSession()) {
            return CatsEffectExtensions$.MODULE$.inline$completedIO();
        }
        return this.js7$data$session$HttpSessionApi$$lock().lock(IO$.MODULE$.defer(() -> this.login_$$anonfun$1$$anonfun$1(onlyIfNotLoggedIn$1, userAndPassword$1)), Enclosing$.MODULE$.apply("js7.data.session.HttpSessionApi#login_"));
    }

    private void $anonfun$1(Some sometoken$1) {
        this.js7$data$session$HttpSessionApi$$sessionTokenRef().compareAndSet((Option<SessionToken>)sometoken$1, (Option<SessionToken>)None$.MODULE$);
    }

    private String logout$$anonfun$1$$anonfun$1$$anonfun$1() {
        return "logout " + this.httpClient();
    }

    private IO logout$$anonfun$1$$anonfun$1() {
        Option<SessionToken> option = this.js7$data$session$HttpSessionApi$$sessionTokenRef().get();
        if (None$.MODULE$.equals(option)) {
            return CatsEffectExtensions$.MODULE$.inline$completedIO();
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            SessionToken sessionToken = (SessionToken)some.value();
            Some sometoken = some;
            SessionCommand.Logout cmd = SessionCommand$Logout$.MODULE$.apply(sessionToken);
            Logger LoggerImpl_this = HttpSessionApi$.js7$data$session$HttpSessionApi$$$logger;
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("{}: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.toString(), cmd}), Object.class));
            }
            IO iO = this.executeSessionCommand(cmd, true).guarantee(IO$.MODULE$.apply((Function0 & Serializable)() -> {
                this.$anonfun$1(sometoken);
                return BoxedUnit.UNIT;
            })).map((Function1 & Serializable)_$2 -> Completed$package$Completed$.MODULE$);
            return CatsUtils$syntax$.MODULE$.logWhenItTakesLonger(iO, (Function0<String>)((Function0 & Serializable)this::logout$$anonfun$1$$anonfun$1$$anonfun$1), CatsUtils$syntax$.MODULE$.logWhenItTakesLonger$default$3(iO));
        }
        throw new MatchError(option);
    }

    private IO logout$$anonfun$1() {
        if (this.js7$data$session$HttpSessionApi$$sessionTokenRef().get().isEmpty()) {
            return CatsEffectExtensions$.MODULE$.inline$completedIO();
        }
        return this.js7$data$session$HttpSessionApi$$lock().lock(IO$.MODULE$.defer(this::logout$$anonfun$1$$anonfun$1), Enclosing$.MODULE$.apply("js7.data.session.HttpSessionApi#logout"));
    }

    private Option given_IO_Option$lzyINIT1$1$$anonfun$1() {
        return this.sessionToken();
    }

    private IO given_IO_Option$lzyINIT1$1(LazyRef given_IO_Option$lzy1$1, boolean suppressSessionToken$1) {
        IO iO;
        LazyRef lazyRef = given_IO_Option$lzy1$1;
        synchronized (lazyRef) {
            iO = (IO)(given_IO_Option$lzy1$1.initialized() ? given_IO_Option$lzy1$1.value() : given_IO_Option$lzy1$1.initialize((Object)(suppressSessionToken$1 ? IO$.MODULE$.pure((Object)None$.MODULE$) : IO$.MODULE$.apply(this::given_IO_Option$lzyINIT1$1$$anonfun$1))));
        }
        return iO;
    }

    private IO given_IO_Option$1(LazyRef given_IO_Option$lzy1$2, boolean suppressSessionToken$2) {
        return (IO)(given_IO_Option$lzy1$2.initialized() ? given_IO_Option$lzy1$2.value() : this.given_IO_Option$lzyINIT1$1(given_IO_Option$lzy1$2, suppressSessionToken$2));
    }

    private static void $anonfun$4$$anonfun$1(SnapshotableState.Companion S$4, Resource.ExitCase exitCase$1, FiniteDuration d$1, long n$1) {
        Logger LoggerImpl_this = HttpSessionApi$.js7$data$session$HttpSessionApi$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("{} snapshot receive {} - {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{S$4, exitCase$1, Stopwatch$.MODULE$.bytesPerSecondString(d$1, n$1)}), Object.class));
            return;
        }
    }

    private static void snapshotAs$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(SnapshotableState.Companion S$7, Resource.ExitCase exitCase$2, FiniteDuration d$2, long n$2) {
        Logger LoggerImpl_this = HttpSessionApi$.js7$data$session$HttpSessionApi$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("{} snapshot receive {} - {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{S$7, exitCase$2, Stopwatch$.MODULE$.itemsPerSecondString(d$2, n$2, "objects")}), Object.class));
            return;
        }
    }

    private IO snapshotAs$$anonfun$1(Uri uri$1, SnapshotableState.Companion S$1) {
        Deadline startedAt = Deadline$.MODULE$.now();
        HttpClient httpClient = this.httpClient();
        return httpClient.getRawLinesStream(uri$1, httpClient.getRawLinesStream$default$2(), httpClient.getRawLinesStream$default$3(), this.implicitSessionToken()).map((Function1 & Serializable)_$4 -> {
            Stream stream = StreamExtensions$.MODULE$.logTiming(_$4, (Function1 & Serializable)_$5 -> Int$.MODULE$.int2long(_$5.length()), (Function3<FiniteDuration, Object, Resource.ExitCase, Object>)(Function3 & Serializable)(d, n, exitCase) -> IO$.MODULE$.apply((Function0 & Serializable)() -> {
                HttpSessionApi.$anonfun$4$$anonfun$1(S$3, exitCase, d, n);
                return BoxedUnit.UNIT;
            }), startedAt, IO$.MODULE$.asyncForIO());
            Stream stream2 = StreamExtensions$.MODULE$.mapParallelBatch(stream, StreamExtensions$.MODULE$.mapParallelBatch$default$2(stream), StreamExtensions$.MODULE$.mapParallelBatch$default$3(stream), StreamExtensions$.MODULE$.mapParallelBatch$default$4(stream), (Function1 & Serializable)_$6 -> {
                Either either = Checked$.MODULE$.Ops(_$6.parseJsonAs(S$1.snapshotObjectJsonCodec()));
                return Checked$Ops$.MODULE$.orThrow$extension(either);
            });
            return StreamExtensions$.MODULE$.logTiming(stream2, StreamExtensions$.MODULE$.logTiming$default$2(stream2), (Function3<FiniteDuration, Object, Resource.ExitCase, Object>)(Function3 & Serializable)(d, n, exitCase) -> IO$.MODULE$.apply((Function0 & Serializable)() -> {
                HttpSessionApi.snapshotAs$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(S$6, exitCase, d, n);
                return BoxedUnit.UNIT;
            }), startedAt, IO$.MODULE$.asyncForIO());
        }).flatMap((Function1 & Serializable)snapshotObjects -> S$1.fromStream((Stream<IO, Object>)snapshotObjects));
    }
}

