/*
 * Decompiled with CFR 0.152.
 */
package js7.journal.watch;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Arrays;
import js7.base.utils.ByteUnits$;
import js7.common.jsonseq.PositionAnd;
import js7.common.jsonseq.PositionAnd$;
import js7.common.scalautil.Synchronizer;
import js7.data.event.EventId$;
import js7.journal.watch.JournalIndex$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class JournalIndex {
    private final PositionAnd<Object> torn;
    private long[] positions;
    private long[] eventIds;
    private int length;
    private long _highestEventId;
    private boolean freezed;
    private int spread;
    private int addedCount;
    private final Synchronizer buildSynchronizer;

    public JournalIndex(PositionAnd<Object> torn, int size) {
        this.torn = torn;
        this.positions = new long[(size + 1) / 2 * 2];
        this.eventIds = new long[this.positions.length];
        this.length = 0;
        this._highestEventId = EventId$.MODULE$.BeforeFirst() - 1L;
        this.freezed = false;
        this.spread = 1;
        this.addedCount = 0;
        Object object = Predef$.MODULE$.longArrayOps(this.positions);
        Predef$.MODULE$.require(ArrayOps$.MODULE$.nonEmpty$extension(object));
        this.addAfter(BoxesRunTime.unboxToLong((Object)torn.value()), torn.position(), this.addAfter$default$3());
        Logger LoggerImpl_this = JournalIndex$.js7$journal$watch$JournalIndex$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("Building JournalIndex({})", (Object)EventId$.MODULE$.toString(BoxesRunTime.unboxToLong((Object)torn.value())));
        }
        this.buildSynchronizer = new Synchronizer("building JournalIndex");
    }

    public void addAfter(long eventId, long position, int n) {
        if (!this.tryAddAfter(eventId, position, n)) {
            if (eventId == this._highestEventId) {
                throw new IllegalArgumentException("JournalIndex: Duplicate EventId added: " + EventId$.MODULE$.toString(eventId));
            }
            throw new IllegalArgumentException("JournalIndex: EventIds are in wrong order: " + EventId$.MODULE$.toString(eventId) + " \u2265 " + EventId$.MODULE$.toString(this._highestEventId));
        }
    }

    public int addAfter$default$3() {
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tryAddAfter(long eventId, long position, int n) {
        Predef$.MODULE$.require(n > 0, JournalIndex::tryAddAfter$$anonfun$1);
        if (eventId <= this._highestEventId) return false;
        JournalIndex journalIndex = this;
        synchronized (journalIndex) {
            if (eventId <= this._highestEventId) return false;
            if (this.freezed) {
                throw new IllegalStateException("JournalIndex: tryAddAfter(" + eventId + ") after freeze " + this._highestEventId + " ?");
            }
            this._highestEventId = eventId;
            int a = this.addedCount;
            this.addedCount += n;
            if (this.addedCount / this.spread > a / this.spread) {
                if (this.length == this.positions.length) {
                    this.compress(2);
                }
                this.positions[this.length] = position;
                this.eventIds[this.length] = eventId;
                ++this.length;
            }
            if (!true) return false;
            return true;
        }
    }

    public int tryAddAfter$default$3() {
        return 1;
    }

    public void freeze(int toFactor) {
        if (!this.freezed) {
            JournalIndex journalIndex = this;
            synchronized (journalIndex) {
                if (!this.freezed) {
                    int a = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(toFactor / this.spread), this.length / JournalIndex$.js7$journal$watch$JournalIndex$$$MinimumLength);
                    if (a > 1) {
                        this.compress(a);
                    }
                    if (this.length < this.positions.length) {
                        this.positions = JournalIndex$.MODULE$.js7$journal$watch$JournalIndex$$$shrinkArray(this.positions, this.length);
                        this.eventIds = JournalIndex$.MODULE$.js7$journal$watch$JournalIndex$$$shrinkArray(this.eventIds, this.length);
                    }
                    this.freezed = true;
                    Logger LoggerImpl_this = JournalIndex$.js7$journal$watch$JournalIndex$$$logger;
                    if (LoggerImpl_this.underlying().isDebugEnabled()) {
                        LoggerImpl_this.underlying().debug("Freezed {}, memory={}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.toString(), ByteUnits$.MODULE$.toKBGB(Int$.MODULE$.int2long(this.positions.length * 2 * 8))}), Object.class));
                    }
                    v0 = BoxedUnit.UNIT;
                } else {
                    v0 = BoxedUnit.UNIT;
                }
            }
            return;
        }
    }

    public long highestEventId() {
        return this._highestEventId;
    }

    private void compress(int factor) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), this.length / factor).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            this.positions[i] = this.positions[factor * i];
            this.eventIds[i] = this.eventIds[factor * i];
        });
        this.length = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.length / factor), 1);
        this.spread = factor * this.spread;
        Logger LoggerImpl_this = JournalIndex$.js7$journal$watch$JournalIndex$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("Compressed {}", (Object)this.toString());
            return;
        }
    }

    public <A> A synchronizeBuilding(Function0<A> body) {
        return this.buildSynchronizer.synchronize(body);
    }

    public long positionAfter(long after) {
        return this.positionAndEventIdAfter(after).position();
    }

    public PositionAnd<Object> positionAndEventIdAfter(long after) {
        PositionAnd<Object> positionAnd;
        JournalIndex journalIndex = this;
        synchronized (journalIndex) {
            int n;
            if (this.length == 0) {
                throw new IllegalStateException("JournalIndex.positionAfter but length=0");
            }
            int n2 = Arrays.binarySearch(this.eventIds, 0, this.length, after);
            int i = n2;
            if (i >= 0) {
                n = i;
            } else {
                int i2 = n2;
                Object object = Predef$.MODULE$.longArrayOps(this.eventIds);
                if (after < BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.head$extension(object))) {
                    Object object2 = Predef$.MODULE$.longArrayOps(this.eventIds);
                    throw new IllegalArgumentException("JournalIndex.positionAfter(" + after + ") but oldest EventId is " + BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.head$extension(object2)));
                }
                n = -i2 - 2;
            }
            int index = n;
            positionAnd = PositionAnd$.MODULE$.apply(this.positions[index], BoxesRunTime.boxToLong((long)this.eventIds[index]));
        }
        return positionAnd;
    }

    public Seq<PositionAnd<Object>> positionAndEventIds() {
        IndexedSeq indexedSeq;
        JournalIndex journalIndex = this;
        synchronized (journalIndex) {
            indexedSeq = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.length).map((Function1 & Serializable)i -> this.positionAndEventIds$$anonfun$1(BoxesRunTime.unboxToInt((Object)i)));
        }
        return indexedSeq;
    }

    public String toString() {
        long l;
        JournalIndex journalIndex = this;
        synchronized (journalIndex) {
            l = this.length == 0 ? 0L : this.positions[this.length - 1] - this.torn.position();
        }
        long addedFileSize = l;
        return "JournalIndex(" + EventId$.MODULE$.toString(BoxesRunTime.unboxToLong((Object)this.torn.value())) + ".." + EventId$.MODULE$.toString(this._highestEventId) + (" eventIds=" + this.addedCount + " " + ByteUnits$.MODULE$.toKBGB(addedFileSize)) + (" entries=" + this.length + "/" + this.eventIds.length + " spread=" + this.spread + " \u2300" + ByteUnits$.MODULE$.toKBGB(addedFileSize / (long)this.length)) + ")";
    }

    public int spreadForTest() {
        return this.spread;
    }

    public int lengthForTest() {
        return this.length;
    }

    private static final Object tryAddAfter$$anonfun$1() {
        return "JournalIndex.tryAddAfter";
    }

    private final /* synthetic */ PositionAnd positionAndEventIds$$anonfun$1(int i) {
        return PositionAnd$.MODULE$.apply(this.positions[i], BoxesRunTime.boxToLong((long)this.eventIds[i]));
    }
}

