/*
 * Decompiled with CFR 0.152.
 */
package js7.launcher;

import cats.Applicative;
import cats.ApplicativeError;
import cats.Functor;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Resource;
import cats.effect.package$;
import com.typesafe.scalalogging.Logger;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.concurrent.Channel;
import fs2.text$;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.fs2utils.StreamExtensions$;
import js7.base.io.ReaderStreams$;
import js7.base.io.process.Stderr$;
import js7.base.io.process.Stdout$;
import js7.base.io.process.StdoutOrStderr;
import js7.base.utils.CatsUtils$syntax$;
import js7.base.utils.CatsUtils$syntax$RichResource$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichAny$;
import js7.launcher.StdObservers$;
import js7.launcher.StdWriter;
import js7.launcher.utils.LastLineKeeper;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class StdObservers {
    private final Function1<StdoutOrStderr, Function1<Stream<IO, String>, Stream<IO, Nothing$>>> outErrToSink;
    private final Channel<IO, String> outChannel;
    private final Channel<IO, String> errChannel;
    private final int byteBufferSize;
    private final int chunkSize;
    private final FiniteDuration delay;
    private final String name;
    private final Option<LastLineKeeper> lastLineKeeper;
    private final StdWriter out;
    private final StdWriter err;
    private final IO<BoxedUnit> closeChannels;

    public static Resource<IO, StdObservers> resource(Function1<StdoutOrStderr, Function1<Stream<IO, String>, Stream<IO, Nothing$>>> function1, int n, int n2, FiniteDuration finiteDuration, int n3, Option<Object> option, String string) {
        return StdObservers$.MODULE$.resource(function1, n, n2, finiteDuration, n3, option, string);
    }

    public static int resource$default$5() {
        return StdObservers$.MODULE$.resource$default$5();
    }

    public static Option<Object> resource$default$6() {
        return StdObservers$.MODULE$.resource$default$6();
    }

    public StdObservers(Function1<StdoutOrStderr, Function1<Stream<IO, String>, Stream<IO, Nothing$>>> outErrToSink, Channel<IO, String> outChannel, Channel<IO, String> errChannel, int byteBufferSize, int chunkSize, FiniteDuration delay, Option<Object> useErrorLineLengthMax, String name) {
        this.outErrToSink = outErrToSink;
        this.outChannel = outChannel;
        this.errChannel = errChannel;
        this.byteBufferSize = byteBufferSize;
        this.chunkSize = chunkSize;
        this.delay = delay;
        this.name = name;
        this.lastLineKeeper = useErrorLineLengthMax.map((Function1 & Serializable)_$1 -> StdObservers.$init$$$anonfun$1(BoxesRunTime.unboxToInt((Object)_$1)));
        this.out = new StdWriter(outChannel);
        this.err = new StdWriter(errChannel);
        this.closeChannels = IO$.MODULE$.both((IO)outChannel.close(), (IO)errChannel.close()).void();
    }

    public StdWriter out() {
        return this.out;
    }

    public StdWriter err() {
        return this.err;
    }

    public Option<String> errorLine() {
        return this.lastLineKeeper.flatMap((Function1 & Serializable)_$2 -> _$2.lastLine());
    }

    public StdWriter writer(StdoutOrStderr outerr) {
        StdoutOrStderr stdoutOrStderr = outerr;
        if (Stdout$.MODULE$.equals(stdoutOrStderr)) {
            return this.out();
        }
        if (Stderr$.MODULE$.equals(stdoutOrStderr)) {
            return this.err();
        }
        throw new MatchError((Object)stdoutOrStderr);
    }

    private Channel<IO, String> channel(StdoutOrStderr outerr) {
        StdoutOrStderr stdoutOrStderr = outerr;
        if (Stdout$.MODULE$.equals(stdoutOrStderr)) {
            return this.outChannel;
        }
        if (Stderr$.MODULE$.equals(stdoutOrStderr)) {
            return this.errChannel;
        }
        throw new MatchError((Object)stdoutOrStderr);
    }

    public IO<BoxedUnit> closeChannels() {
        return this.closeChannels;
    }

    public Resource<IO, BoxedUnit> js7$launcher$StdObservers$$pumpChannelsToSinkResource() {
        Resource resource = CatsUtils$syntax$.MODULE$.RichResource(package$.MODULE$.Resource().make((Object)this.pumpChannelsToSink().start(), (Function1 & Serializable)fiber -> this.closeChannels().$times$greater((IO)CatsEffectExtensions$.MODULE$.joinStd(fiber, IO$.MODULE$.asyncForIO())), (Functor)IO$.MODULE$.asyncForIO()));
        return CatsUtils$syntax$RichResource$.MODULE$.void$extension(resource);
    }

    private IO<BoxedUnit> pumpChannelsToSink() {
        return IO$.MODULE$.both(this.pumpChannelToSink(Stdout$.MODULE$), this.pumpChannelToSink(Stderr$.MODULE$)).void();
    }

    private IO<BoxedUnit> pumpChannelToSink(StdoutOrStderr outErr) {
        return this.pumpToSink(outErr, (Stream<IO, String>)this.channel(outErr).stream());
    }

    public IO<BoxedUnit> pumpInputStreamToSink(StdoutOrStderr outErr, InputStream in, Charset encoding) {
        return this.pumpToSink(outErr, this.inputStreamAsStream(outErr, in, encoding));
    }

    private Stream<IO, String> inputStreamAsStream(StdoutOrStderr outErr, InputStream in, Charset encoding) {
        return ReaderStreams$.MODULE$.inputStreamToByteStream(in, this.byteBufferSize).onFinalizeCase((Function1 & Serializable)x$1 -> {
            Resource.ExitCase exitCase = x$1;
            package$.MODULE$.Resource();
            if (Resource.ExitCase$.Canceled$.MODULE$.equals(exitCase)) {
                Resource.ExitCase exitCase2 = exitCase;
                IO iO = IO$.MODULE$.blocking((Function0 & Serializable)() -> {
                    StdObservers.$anonfun$1();
                    return BoxedUnit.UNIT;
                });
                return CatsEffectExtensions$.MODULE$.startAndForget(CatsUtils$syntax$.MODULE$.logWhenItTakesLonger(iO, (Function0<String>)((Function0 & Serializable)() -> this.inputStreamAsStream$$anonfun$1$$anonfun$1(outErr, exitCase2)), CatsUtils$syntax$.MODULE$.logWhenItTakesLonger$default$3(iO))).$times$greater(IO$.MODULE$.whenA(false, () -> this.inputStreamAsStream$$anonfun$1$$anonfun$2(outErr, exitCase2, in)));
            }
            IO iO = IO$.MODULE$.blocking((Function0 & Serializable)() -> {
                StdObservers.$anonfun$3(in);
                return BoxedUnit.UNIT;
            });
            return CatsUtils$syntax$.MODULE$.logWhenItTakesLonger(iO, (Function0<String>)((Function0 & Serializable)() -> StdObservers.inputStreamAsStream$$anonfun$1$$anonfun$3(outErr)), CatsUtils$syntax$.MODULE$.logWhenItTakesLonger$default$3(iO));
        }, (Applicative)IO$.MODULE$.asyncForIO()).through(text$.MODULE$.decodeWithCharset(encoding, RaiseThrowable$.MODULE$.fromApplicativeError((ApplicativeError)IO$.MODULE$.asyncForIO())));
    }

    private IO<BoxedUnit> pumpToSink(StdoutOrStderr outErr, Stream<IO, String> stream) {
        Stream stream2 = (Stream)ScalaUtils$syntax$.MODULE$.RichAny(stream);
        Chunk$ chunk$ = Chunk$.MODULE$;
        return (IO)((Stream)((Function1)this.outErrToSink.apply((Object)outErr)).apply((Object)StreamExtensions$.MODULE$.chunkWithin(((Stream)ScalaUtils$syntax$RichAny$.MODULE$.pipeIf$extension(stream2, (Function0<Object>)((Function0 & Serializable)() -> StdObservers.pumpToSink$$anonfun$1(outErr)), (Function1 & Serializable)_$3 -> _$3.through((Function1)this.lastLineKeeper.getOrElse(StdObservers::pumpToSink$$anonfun$2$$anonfun$1)))).map((Function1 & Serializable)string -> StreamExtensions$.MODULE$.fromString(chunk$, (String)string)).unchunks((.less.colon.less)$less$colon$less$.MODULE$.refl()), this.chunkSize, this.delay, IO$.MODULE$.asyncForIO()).map((Function1 & Serializable)_$4 -> StreamExtensions$.MODULE$.convertToString((Chunk<Object>)_$4)))).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).drain();
    }

    private static final /* synthetic */ LastLineKeeper $init$$$anonfun$1(int _$1) {
        return new LastLineKeeper(_$1);
    }

    private static final void $anonfun$1() {
    }

    private final String inputStreamAsStream$$anonfun$1$$anonfun$1(StdoutOrStderr outErr$2, Resource.ExitCase exitCase$1) {
        return "### " + this.name + " " + outErr$2 + " " + exitCase$1 + "   \ud83d\udd25\ud83d\udd25\ud83d\udd25 IO.blocking(()) is blocking itself \ud83d\udd25\ud83d\udd25\ud83d\udd25";
    }

    private final void $anonfun$2(StdoutOrStderr outErr$4, Resource.ExitCase exitCase$3, InputStream in$3) {
        Logger LoggerImpl_this = StdObservers$.js7$launcher$StdObservers$$$logger;
        if (LoggerImpl_this.underlying().isTraceEnabled()) {
            LoggerImpl_this.underlying().trace("### {} {} {} in.close!", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.name, outErr$4, exitCase$3}), Object.class));
        }
        in$3.close();
    }

    private final String inputStreamAsStream$$anonfun$1$$anonfun$2$$anonfun$1(StdoutOrStderr outErr$5) {
        return this.name + " " + outErr$5 + ".close() after cancellation";
    }

    private final IO inputStreamAsStream$$anonfun$1$$anonfun$2(StdoutOrStderr outErr$3, Resource.ExitCase exitCase$2, InputStream in$2) {
        IO iO = IO$.MODULE$.blocking((Function0 & Serializable)() -> {
            this.$anonfun$2(outErr$3, exitCase$2, in$2);
            return BoxedUnit.UNIT;
        });
        return CatsUtils$syntax$.MODULE$.logWhenItTakesLonger(iO, (Function0<String>)((Function0 & Serializable)() -> this.inputStreamAsStream$$anonfun$1$$anonfun$2$$anonfun$1(outErr$3)), CatsUtils$syntax$.MODULE$.logWhenItTakesLonger$default$3(iO));
    }

    private static final void $anonfun$3(InputStream in$4) {
        in$4.close();
    }

    private static final String inputStreamAsStream$$anonfun$1$$anonfun$3(StdoutOrStderr outErr$6) {
        return outErr$6 + " close after cancellation";
    }

    private static final boolean pumpToSink$$anonfun$1(StdoutOrStderr outErr$7) {
        StdoutOrStderr stdoutOrStderr = outErr$7;
        Stderr$ stderr$ = Stderr$.MODULE$;
        return !(stdoutOrStderr != null ? !stdoutOrStderr.equals(stderr$) : stderr$ != null);
    }

    private static final Function1 pumpToSink$$anonfun$2$$anonfun$1() {
        return (Function1 & Serializable)x2 -> (Stream)Predef$.MODULE$.identity(x2);
    }
}

