/*
 * Decompiled with CFR 0.152.
 */
package js7.launcher.crashpidfile;

import cats.Functor;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Resource;
import cats.effect.package$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import js7.base.utils.AsyncLock;
import js7.base.utils.AsyncLock$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.launcher.crashpidfile.IndexedRecordSet;
import js7.launcher.crashpidfile.WriteBasedIndexedRecordSet$;
import js7.launcher.crashpidfile.WriteBasedIndexedRecordSet$Delete$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.BitSet;
import scala.collection.mutable.BitSet$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import sourcecode.Enclosing$;

public final class WriteBasedIndexedRecordSet<A>
implements IndexedRecordSet<A> {
    private final String label;
    private final Function2<Object, Object, IO<BoxedUnit>> writeAtIndex;
    private final AsyncLock lock;
    private final Map<A, Integer> aToIndex;
    private int size;
    private final BitSet freeIndices;
    private Option<Throwable> throwable;

    public static <A> Resource<IO, WriteBasedIndexedRecordSet<A>> file(Path path, int n, ByteOrder byteOrder, String string, Function2<ByteBuffer, Object, BoxedUnit> function2) {
        return WriteBasedIndexedRecordSet$.MODULE$.file(path, n, byteOrder, string, function2);
    }

    public static <A> Resource<IO, WriteBasedIndexedRecordSet<A>> textFile(Path path, int n, String string, Function2<ByteBuffer, A, BoxedUnit> function2) {
        return WriteBasedIndexedRecordSet$.MODULE$.textFile(path, n, string, function2);
    }

    public static <A> ByteOrder file$default$3() {
        return WriteBasedIndexedRecordSet$.MODULE$.file$default$3();
    }

    public static <A> String textFile$default$3() {
        return WriteBasedIndexedRecordSet$.MODULE$.textFile$default$3();
    }

    public static <A> String file$default$4() {
        return WriteBasedIndexedRecordSet$.MODULE$.file$default$4();
    }

    public WriteBasedIndexedRecordSet(String label, Function2<Object, Object, IO<BoxedUnit>> writeAtIndex) {
        this.label = label;
        this.writeAtIndex = writeAtIndex;
        this.lock = AsyncLock$.MODULE$.apply(Enclosing$.MODULE$.apply("js7.launcher.crashpidfile.WriteBasedIndexedRecordSet#lock"));
        this.aToIndex = (Map)Map$.MODULE$.empty();
        this.size = 0;
        this.freeIndices = (BitSet)BitSet$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[0]));
        this.throwable = package.option$.MODULE$.none();
    }

    @Override
    public Resource<IO, BoxedUnit> register(A a) {
        BoxedUnit boxedUnit = (BoxedUnit)Predef$.MODULE$.ArrowAssoc((Object)BoxedUnit.UNIT);
        return package$.MODULE$.Resource().apply((Object)this.add(a).as((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)boxedUnit, this.remove(a))), (Functor)IO$.MODULE$.asyncForIO());
    }

    private IO<BoxedUnit> add(A a) {
        return this.manipulate(a, "add", (Function0<IO<BoxedUnit>>)((Function0 & Serializable)() -> this.add$$anonfun$1(a)));
    }

    @Override
    public IO<BoxedUnit> remove(A a) {
        return this.manipulate(a, "remove", (Function0<IO<BoxedUnit>>)((Function0 & Serializable)() -> this.remove$$anonfun$1(a)));
    }

    private IO<BoxedUnit> manipulate(A a, String name, Function0<IO<BoxedUnit>> body) {
        return this.lock.lock(IO$.MODULE$.defer(() -> this.manipulate$$anonfun$1(name, a, body)), Enclosing$.MODULE$.apply("js7.launcher.crashpidfile.WriteBasedIndexedRecordSet#manipulate"));
    }

    public String toString() {
        return "WriteBasedIndexedRecordSet" + ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.label))), (Function0<String>)((Function0 & Serializable)this::toString$$anonfun$1));
    }

    private final int $anonfun$1() {
        ++this.size;
        return this.size - 1;
    }

    private final IO add$$anonfun$1(Object a$1) {
        int index = BoxesRunTime.unboxToInt((Object)this.freeIndices.headOption().getOrElse(this::$anonfun$1));
        this.freeIndices.$minus$eq((Object)BoxesRunTime.boxToInteger((int)index));
        this.aToIndex.update(a$1, (Object)Predef$.MODULE$.int2Integer(index));
        return (IO)this.writeAtIndex.apply((Object)BoxesRunTime.boxToInteger((int)index), a$1);
    }

    private static final IO remove$$anonfun$1$$anonfun$1() {
        return IO$.MODULE$.unit();
    }

    private static final int a$proxy1$1(IntRef newSize$1) {
        return newSize$1.elem;
    }

    private static final int $anonfun$2(IntRef newSize$2) {
        return WriteBasedIndexedRecordSet.a$proxy1$1(newSize$2);
    }

    private final IO remove$$anonfun$1(Object a$2) {
        return (IO)this.aToIndex.remove(a$2).fold(WriteBasedIndexedRecordSet::remove$$anonfun$1$$anonfun$1, (Function1 & Serializable)index_ -> {
            int index = index_;
            this.freeIndices.$plus$eq((Object)BoxesRunTime.boxToInteger((int)index));
            IntRef newSize = IntRef.create((int)this.size);
            while (newSize.elem > 0 && this.freeIndices.apply$mcZI$sp(newSize.elem - 1)) {
                --newSize.elem;
                this.freeIndices.$minus$eq((Object)BoxesRunTime.boxToInteger((int)newSize.elem));
            }
            boolean RichBoolean_this = ScalaUtils$syntax$.MODULE$.RichBoolean(newSize.elem < this.size);
            Option truncate = ScalaUtils$syntax$RichBoolean$.MODULE$.thenSome$extension(RichBoolean_this, () -> WriteBasedIndexedRecordSet.$anonfun$2(newSize));
            this.size = newSize.elem;
            return (IO)this.writeAtIndex.apply((Object)BoxesRunTime.boxToInteger((int)index), (Object)WriteBasedIndexedRecordSet$Delete$.MODULE$.apply(truncate));
        });
    }

    private final void manipulate$$anonfun$1$$anonfun$1(String name$2, Object a$4, Throwable t$1) {
        Logger LoggerImpl_this = WriteBasedIndexedRecordSet$.js7$launcher$crashpidfile$WriteBasedIndexedRecordSet$$$logger;
        if (LoggerImpl_this.underlying().isWarnEnabled()) {
            LoggerImpl_this.underlying().warn("{} {}({}) ignored due to previous error {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.toString(), name$2, a$4, t$1}), Object.class));
            return;
        }
    }

    private final void manipulate$$anonfun$1$$anonfun$2$$anonfun$1(Throwable t$2) {
        Throwable throwable = (Throwable)package.option$.MODULE$.catsSyntaxOptionId((Object)t$2);
        this.throwable = OptionIdOps$.MODULE$.some$extension((Object)throwable);
    }

    private final IO manipulate$$anonfun$1(String name$1, Object a$3, Function0 body$1) {
        Option<Throwable> option = this.throwable;
        if (option instanceof Some) {
            Throwable t2 = (Throwable)((Some)option).value();
            return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                this.manipulate$$anonfun$1$$anonfun$1(name$1, a$3, t2);
                return BoxedUnit.UNIT;
            });
        }
        if (None$.MODULE$.equals(option)) {
            return IO$.MODULE$.defer(body$1).onError((Function1 & Serializable)t -> IO$.MODULE$.apply((Function0 & Serializable)() -> {
                this.manipulate$$anonfun$1$$anonfun$2$$anonfun$1((Throwable)t);
                return BoxedUnit.UNIT;
            }));
        }
        throw new MatchError(option);
    }

    private final String toString$$anonfun$1() {
        return ":" + this.label;
    }

    public static final class Delete
    implements Product,
    Serializable {
        private final Option<Object> truncate;

        public static Delete apply(Option<Object> option) {
            return WriteBasedIndexedRecordSet$Delete$.MODULE$.apply(option);
        }

        public static Delete fromProduct(Product product) {
            return WriteBasedIndexedRecordSet$Delete$.MODULE$.fromProduct(product);
        }

        public static Delete unapply(Delete delete) {
            return WriteBasedIndexedRecordSet$Delete$.MODULE$.unapply(delete);
        }

        public Delete(Option<Object> truncate) {
            this.truncate = truncate;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Delete)) return false;
            Delete delete = (Delete)object;
            Option<Object> option = this.truncate();
            Option<Object> option2 = delete.truncate();
            if (option != null) {
                if (!option.equals(option2)) return false;
                return true;
            }
            if (option2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Delete;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Delete";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "truncate";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Option<Object> truncate() {
            return this.truncate;
        }

        public Delete copy(Option<Object> truncate) {
            return new Delete(truncate);
        }

        public Option<Object> copy$default$1() {
            return this.truncate();
        }

        public Option<Object> _1() {
            return this.truncate();
        }
    }
}

