/*
 * Decompiled with CFR 0.152.
 */
package js7.provider.scheduledorder;

import cats.effect.IO;
import cats.effect.unsafe.IORuntime;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import js7.base.generic.Completed$package$Completed$;
import js7.base.monixlike.MonixLikeExtensions$;
import js7.base.monixlike.SerialFutureCancelable;
import js7.base.monixlike.SerialFutureCancelable$;
import js7.base.monixlike.SyncCancelable;
import js7.base.monixlike.SyncCancelable$;
import js7.base.time.JavaTimeConverters$;
import js7.base.time.JavaTimeConverters$AsJavaFiniteDuration$;
import js7.base.time.JavaTimeConverters$AsScalaDuration$;
import js7.base.time.JavaTimestamp$specific$;
import js7.base.time.JavaTimestamp$specific$RichJavaTimestamp$;
import js7.base.time.Timestamp;
import js7.base.time.Timestamp$;
import js7.base.utils.CancelableFuture;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import js7.data.order.FreshOrder;
import js7.provider.scheduledorder.OrderScheduleGenerator$;
import js7.provider.scheduledorder.ScheduledOrderGenerator;
import js7.provider.scheduledorder.ScheduledOrderGeneratorKeeper;
import js7.provider.scheduledorder.oldruntime.InstantInterval;
import js7.provider.scheduledorder.oldruntime.InstantInterval$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyRef;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import sourcecode.Enclosing$;
import sourcecode.FileName$;
import sourcecode.FullName$;
import sourcecode.Line$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class OrderScheduleGenerator {
    private final Function1<Seq<FreshOrder>, IO<Completed$package$Completed$>> addOrders;
    private final FiniteDuration addEvery;
    private final FiniteDuration addEarlier;
    private volatile ScheduledOrderGeneratorKeeper scheduledOrderGeneratorKeeper;
    private volatile Timestamp generatedUntil;
    private volatile SyncCancelable timer;
    private final AtomicBoolean started;
    private volatile boolean closed;
    private final SerialFutureCancelable addOrdersCancelable;

    public OrderScheduleGenerator(Function1<Seq<FreshOrder>, IO<Completed$package$Completed$>> addOrders, Config config) {
        this.addOrders = addOrders;
        this.addEvery = JavaTimeConverters$AsScalaDuration$.MODULE$.toFiniteDuration$extension(JavaTimeConverters$.MODULE$.AsScalaDuration(config.getDuration("js7.provider.add-orders-every")));
        this.addEarlier = JavaTimeConverters$AsScalaDuration$.MODULE$.toFiniteDuration$extension(JavaTimeConverters$.MODULE$.AsScalaDuration(config.getDuration("js7.provider.add-orders-earlier")));
        this.scheduledOrderGeneratorKeeper = new ScheduledOrderGeneratorKeeper((Iterable<ScheduledOrderGenerator>)package$.MODULE$.Nil());
        this.generatedUntil = Timestamp$.MODULE$.now().roundToNextSecond();
        this.timer = SyncCancelable$.MODULE$.empty();
        this.started = new AtomicBoolean(false);
        this.closed = false;
        this.addOrdersCancelable = new SerialFutureCancelable(SerialFutureCancelable$.MODULE$.$lessinit$greater$default$1());
    }

    public void close() {
        this.closed = true;
        this.timer.cancel();
        this.addOrdersCancelable.cancelAndForget();
    }

    public void replaceGenerators(Seq<ScheduledOrderGenerator> generators) {
        this.scheduledOrderGeneratorKeeper = new ScheduledOrderGeneratorKeeper((Iterable<ScheduledOrderGenerator>)generators);
    }

    public void start(IORuntime x$1) {
        if (this.started.getAndSet(true)) {
            throw new IllegalStateException("OrderScheduleGenerator has already been started");
        }
        this.generate(x$1);
    }

    private void generate(IORuntime ioRuntime) {
        LazyRef lazyRef = new LazyRef();
        InstantInterval interval = InstantInterval$.MODULE$.apply(JavaTimestamp$specific$RichJavaTimestamp$.MODULE$.toInstant$extension(JavaTimestamp$specific$.MODULE$.RichJavaTimestamp(this.generatedUntil)), JavaTimeConverters$AsJavaFiniteDuration$.MODULE$.asJava$extension(JavaTimeConverters$.MODULE$.AsJavaFiniteDuration(this.addEvery)));
        Logger LoggerImpl_this = OrderScheduleGenerator$.js7$provider$scheduledorder$OrderScheduleGenerator$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("Generating orders for time interval {}", (Object)interval);
        }
        Seq<FreshOrder> orders = this.scheduledOrderGeneratorKeeper.generateOrders(interval);
        if (!this.closed) {
            Logger LoggerImpl_this2;
            if (orders.isEmpty() && (LoggerImpl_this2 = OrderScheduleGenerator$.js7$provider$scheduledorder$OrderScheduleGenerator$$$logger).underlying().isDebugEnabled()) {
                LoggerImpl_this2.underlying().debug("No orders generated in this time interval");
            }
            CancelableFuture future = MonixLikeExtensions$.MODULE$.unsafeToCancelableFuture(((IO)this.addOrders.apply(orders)).void(), ioRuntime);
            this.addOrdersCancelable.set(future, Enclosing$.MODULE$.apply("js7.provider.scheduledorder.OrderScheduleGenerator#generate"), FileName$.MODULE$.apply("OrderScheduleGenerator.scala"), Line$.MODULE$.apply(57));
            future.onComplete((JProcedure1 & Serializable)x$1 -> {
                Try try_ = x$1;
                if (try_ instanceof Success) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    Object object = ((Success)try_).value();
                    if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                        this.continue(ioRuntime);
                        return;
                    }
                }
                if (try_ instanceof Failure) {
                    Logger LoggerImpl_this;
                    Throwable t = ((Failure)try_).exception();
                    Logger LoggerImpl_this2 = OrderScheduleGenerator$.js7$provider$scheduledorder$OrderScheduleGenerator$$$logger;
                    if (LoggerImpl_this2.underlying().isErrorEnabled()) {
                        Throwable throwable = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                        LoggerImpl_this2.underlying().error(ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable));
                    }
                    if ((LoggerImpl_this = OrderScheduleGenerator$.js7$provider$scheduledorder$OrderScheduleGenerator$$$logger).underlying().isDebugEnabled()) {
                        LoggerImpl_this.underlying().debug(t.toString(), t);
                    }
                    this.continue(ioRuntime);
                    return;
                }
                throw new MatchError((Object)try_);
            }, OrderScheduleGenerator.given_ExecutionContext$1(lazyRef, ioRuntime));
            return;
        }
    }

    private void continue(IORuntime ioRuntime) {
        this.generatedUntil = this.generatedUntil.$plus(this.addEvery);
        this.timer.cancel();
        this.timer = MonixLikeExtensions$.MODULE$.scheduleOnce(ioRuntime.scheduler(), this.generatedUntil.$minus(this.addEarlier).$minus(Timestamp$.MODULE$.now()), (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.continue$$anonfun$1(ioRuntime);
            return BoxedUnit.UNIT;
        }, FullName$.MODULE$.apply("js7.provider.scheduledorder.OrderScheduleGenerator.continue"));
    }

    public String toString() {
        return "OrderScheduleGenerator";
    }

    private static final ExecutionContext given_ExecutionContext$lzyINIT1$1(LazyRef given_ExecutionContext$lzy1$1, IORuntime ioRuntime$1) {
        ExecutionContext executionContext;
        LazyRef lazyRef = given_ExecutionContext$lzy1$1;
        synchronized (lazyRef) {
            executionContext = (ExecutionContext)(given_ExecutionContext$lzy1$1.initialized() ? given_ExecutionContext$lzy1$1.value() : given_ExecutionContext$lzy1$1.initialize((Object)ioRuntime$1.compute()));
        }
        return executionContext;
    }

    private static final ExecutionContext given_ExecutionContext$1(LazyRef given_ExecutionContext$lzy1$2, IORuntime ioRuntime$2) {
        return (ExecutionContext)(given_ExecutionContext$lzy1$2.initialized() ? given_ExecutionContext$lzy1$2.value() : OrderScheduleGenerator.given_ExecutionContext$lzyINIT1$1(given_ExecutionContext$lzy1$2, ioRuntime$2));
    }

    private final void continue$$anonfun$1(IORuntime ioRuntime$4) {
        this.generate(ioRuntime$4);
    }
}

