/*
 * Decompiled with CFR 0.152.
 */
package js7.service.pgp;

import cats.syntax.package;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import js7.base.Problems$MessageSignedByUnknownProblem$;
import js7.base.Problems$TamperedWithSignedMessageProblem$;
import js7.base.crypt.GenericSignature;
import js7.base.crypt.SignatureVerifier;
import js7.base.crypt.SignerId;
import js7.base.crypt.SignerId$;
import js7.base.crypt.pgp.PgpSignature;
import js7.base.data.ByteArray;
import js7.base.problem.Problem;
import js7.base.utils.Labeled;
import js7.service.pgp.PgpCommons$;
import js7.service.pgp.PgpCommons$RichPGPPublicKeyRingCollection$;
import js7.service.pgp.PgpSignatureVerifier$;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import scala.Function1;
import scala.collection.IterableOnce;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class PgpSignatureVerifier
implements SignatureVerifier {
    private final PGPPublicKeyRingCollection publicKeyRingCollection;
    private final String publicKeyOrigin;
    private final JcaPGPContentVerifierBuilderProvider contentVerifierBuilderProvider;

    public static Either<Problem, PgpSignatureVerifier> checked(Seq<Labeled<ByteArray>> seq, String string) {
        return PgpSignatureVerifier$.MODULE$.checked(seq, string);
    }

    public static String filenameExtension() {
        return PgpSignatureVerifier$.MODULE$.filenameExtension();
    }

    public static Either<Problem, PgpSignature> genericSignatureToSignature(GenericSignature genericSignature) {
        return PgpSignatureVerifier$.MODULE$.genericSignatureToSignature(genericSignature);
    }

    public static PgpSignatureVerifier ignoreInvalid(Seq<Labeled<ByteArray>> seq, String string) {
        return PgpSignatureVerifier$.MODULE$.ignoreInvalid((Seq)seq, string);
    }

    public static String recommendedKeyDirectoryName() {
        return PgpSignatureVerifier$.MODULE$.recommendedKeyDirectoryName();
    }

    public static Either<Problem, PGPSignature> toMutablePGPSignature(PgpSignature pgpSignature) {
        return PgpSignatureVerifier$.MODULE$.toMutablePGPSignature(pgpSignature);
    }

    public static String typeName() {
        return PgpSignatureVerifier$.MODULE$.typeName();
    }

    public static String checked$default$2() {
        return PgpSignatureVerifier$.MODULE$.checked$default$2();
    }

    public PgpSignatureVerifier(PGPPublicKeyRingCollection publicKeyRingCollection, String publicKeyOrigin) {
        this.publicKeyRingCollection = publicKeyRingCollection;
        this.publicKeyOrigin = publicKeyOrigin;
        PgpCommons$.MODULE$.registerBouncyCastle();
        this.contentVerifierBuilderProvider = new JcaPGPContentVerifierBuilderProvider().setProvider("BC");
    }

    @Override
    public String publicKeyOrigin() {
        return this.publicKeyOrigin;
    }

    @Override
    public PgpSignatureVerifier$ companion() {
        return PgpSignatureVerifier$.MODULE$;
    }

    @Override
    public Seq<String> publicKeys() {
        String string = PgpCommons$RichPGPPublicKeyRingCollection$.MODULE$.toArmoredString$extension(PgpCommons$.MODULE$.RichPGPPublicKeyRingCollection(this.publicKeyRingCollection));
        return package$.MODULE$.Nil().$colon$colon((Object)string);
    }

    public Either<Problem, Seq<SignerId>> verify(ByteArray document, PgpSignature signature) {
        return PgpSignatureVerifier$.MODULE$.toMutablePGPSignature(signature).flatMap((Function1 & Serializable)pgpSignature -> this.findPublicKeyInKeyRing((PGPSignature)pgpSignature).flatMap((Function1 & Serializable)publicKey -> this.verifyWithPublicKey(document, (PGPSignature)pgpSignature, (PGPPublicKey)publicKey).map((Function1 & Serializable)signerIds -> signerIds)));
    }

    private Either<Problem, PGPPublicKey> findPublicKeyInKeyRing(PGPSignature signature) {
        PGPPublicKey pGPPublicKey = this.publicKeyRingCollection.getPublicKey(signature.getKeyID());
        if (pGPPublicKey == null) {
            Logger LoggerImpl_this = PgpSignatureVerifier$.js7$service$pgp$PgpSignatureVerifier$$$logger;
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("\u26d4 {}, no public key for {} publicKeyOrigin={}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{Problems$MessageSignedByUnknownProblem$.MODULE$, package.show$.MODULE$.toShow((Object)signature, PgpCommons$.MODULE$.PGPSignatureShow()).show(), this.publicKeyOrigin()}), Object.class));
            }
            return package$.MODULE$.Left().apply((Object)Problems$MessageSignedByUnknownProblem$.MODULE$);
        }
        PGPPublicKey publicKey = pGPPublicKey;
        return package$.MODULE$.Right().apply((Object)publicKey);
    }

    private Either<Problem, Seq<SignerId>> verifyWithPublicKey(ByteArray document, PGPSignature pgpSignature, PGPPublicKey publicKey) {
        Logger LoggerImpl_this = PgpSignatureVerifier$.js7$service$pgp$PgpSignatureVerifier$$$logger;
        if (LoggerImpl_this.underlying().isTraceEnabled()) {
            LoggerImpl_this.underlying().trace("Verifying document with " + package.show$.MODULE$.toShow((Object)pgpSignature, PgpCommons$.MODULE$.PGPSignatureShow()).show() + ", using " + PgpCommons$.MODULE$.pgpPublicKeyToShortString(publicKey));
        }
        pgpSignature.init((PGPContentVerifierBuilderProvider)this.contentVerifierBuilderProvider, publicKey);
        pgpSignature.update(document.unsafeArray());
        if (!pgpSignature.verify()) {
            return package$.MODULE$.Left().apply((Object)Problems$TamperedWithSignedMessageProblem$.MODULE$);
        }
        return package$.MODULE$.Right().apply((Object)CollectionConverters$.MODULE$.IteratorHasAsScala(publicKey.getUserIDs()).asScala().map((Function1 & Serializable)string -> (SignerId)SignerId$.MODULE$.apply((String)string)).toVector());
    }

    public String toString() {
        return "PgpSignatureVerifier(origin=" + this.publicKeyOrigin() + ", " + package.show$.MODULE$.toShow((Object)this.publicKeyRingCollection, PgpCommons$.MODULE$.PGPPublicKeyRingCollectionShow()).show() + ")";
    }

    @Override
    public Seq<String> publicKeysToStrings() {
        return (Seq)((SeqOps)new .colon.colon((Object)("PGP origin=" + this.publicKeyOrigin()), (List)Nil$.MODULE$)).$plus$plus((IterableOnce)CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)this.publicKeyRingCollection).asScala().flatMap((Function1 & Serializable)_$1 -> (IterableOnce)CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)_$1).asScala().map((Function1 & Serializable)k -> "  " + PgpCommons$.MODULE$.pgpPublicKeyToShortString((PGPPublicKey)k))));
    }
}

