/*
 * Decompiled with CFR 0.152.
 */
package com.sos.graphviz;

import com.sos.graphviz.Edge;
import com.sos.graphviz.Graph;
import com.sos.graphviz.GraphProperties;
import com.sos.graphviz.GraphvizObject;
import com.sos.graphviz.Node;
import com.sos.graphviz.SubgraphProperties;
import com.sos.graphviz.enums.RankType;

public class Subgraph
extends Graph {
    private final SubgraphProperties subgraphProperties;
    private final Graph parent;

    protected Subgraph(String subgraphId, RankType rankType, Graph parent) {
        super(subgraphId);
        this.subgraphProperties = new SubgraphProperties(rankType);
        this.parent = parent;
        this.setGlobalNodeProperties(parent.getGlobalNodeProperties());
    }

    @Override
    public String getContent() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.subgraphProperties.getContent());
        sb.append(this.getGlobalNodeProperties().getSource());
        sb.append(this.getMainContent());
        return sb.toString();
    }

    @Override
    public GraphvizObject getProperties() {
        return this.subgraphProperties;
    }

    @Override
    public GraphProperties getGraphProperties() {
        return null;
    }

    public SubgraphProperties getSubgraphProperties() {
        return this.subgraphProperties;
    }

    public Graph getParent() {
        return this.parent;
    }

    @Override
    public Edge newEdge(Node nodeFrom, Node nodeTo) {
        return this.getRootGraph().newEdge(nodeFrom, nodeTo);
    }

    private Graph getRootGraph() {
        Graph g = this.getParent();
        while (g instanceof Subgraph) {
            g = ((Subgraph)g).getParent();
        }
        return g;
    }
}

