/*
 * Decompiled with CFR 0.152.
 */
package com.sos.classes;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.sos.jobscheduler.model.event.CustomEvent;
import com.sos.jobscheduler.model.event.CustomEventVariables;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CustomEventsUtil {
    private ObjectMapper objectMapper;
    private List<CustomEvent> listOfCustomEvents;
    private String source;

    public CustomEventsUtil(String source) {
        this.source = source;
        this.objectMapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
        this.listOfCustomEvents = new ArrayList<CustomEvent>();
    }

    public String getEventCommandAsXml() throws JsonProcessingException {
        String xmlCommand = "";
        if (!this.listOfCustomEvents.isEmpty()) {
            if (this.listOfCustomEvents.size() > 1) {
                xmlCommand = xmlCommand + "<commands>";
            }
            for (CustomEvent event : this.listOfCustomEvents) {
                String command = this.getEventAsCommand(event);
                xmlCommand = xmlCommand + command;
            }
            if (this.listOfCustomEvents.size() > 1) {
                xmlCommand = xmlCommand + "</commands>";
            }
        }
        return xmlCommand;
    }

    public void addEvent(CustomEvent customEvent) {
        this.listOfCustomEvents.add(customEvent);
    }

    public CustomEvent createEvent(String key) {
        CustomEvent customEvent = new CustomEvent();
        customEvent.setKey(key);
        CustomEventVariables customEventVariables = new CustomEventVariables();
        customEventVariables.setAdditionalProperty("source", this.source);
        customEvent.setVariables(customEventVariables);
        return customEvent;
    }

    public void addEvent(String key, Map<String, String> parameters) throws JsonProcessingException {
        CustomEvent customEvent = new CustomEvent();
        customEvent.setKey(key);
        CustomEventVariables customEventVariables = new CustomEventVariables();
        customEventVariables.setAdditionalProperty("source", this.source);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            customEventVariables.setAdditionalProperty(entry.getKey(), entry.getValue());
        }
        customEvent.setVariables(customEventVariables);
        this.listOfCustomEvents.add(customEvent);
    }

    public void addEvent(String key) throws JsonProcessingException {
        CustomEvent customEvent = new CustomEvent();
        customEvent.setKey(key);
        CustomEventVariables customEventVariables = new CustomEventVariables();
        customEventVariables.setAdditionalProperty("source", this.source);
        customEvent.setVariables(customEventVariables);
        this.listOfCustomEvents.add(customEvent);
    }

    private String getEventAsCommand(CustomEvent customEvent) throws JsonProcessingException {
        String xmlCommand = this.objectMapper.writeValueAsString((Object)customEvent);
        return "<publish_event>" + xmlCommand + "</publish_event>";
    }
}

