/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.calendar;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum CalendarType {
    WORKING_DAYS("WORKING_DAYS"),
    NON_WORKING_DAYS("NON_WORKING_DAYS"),
    JOB("JOB"),
    ORDER("ORDER"),
    SCHEDULE("SCHEDULE");

    private final String value;
    private static final Map<String, CalendarType> CONSTANTS;

    private CalendarType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static CalendarType fromValue(String value) {
        CalendarType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, CalendarType>();
        for (CalendarType c : CalendarType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

