/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.configuration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ConfigurationType {
    CUSTOMIZATION("CUSTOMIZATION"),
    IGNORELIST("IGNORELIST"),
    PROFILE("PROFILE"),
    SETTING("SETTING");

    private final String value;
    private static final Map<String, ConfigurationType> CONSTANTS;

    private ConfigurationType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static ConfigurationType fromValue(String value) {
        ConfigurationType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ConfigurationType>();
        for (ConfigurationType c : ConfigurationType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

