/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.order;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.sos.classes.Latin1ToUtf8;
import com.sos.joc.model.calendar.Calendar;
import com.sos.joc.model.common.NameValuePair;
import com.sos.joc.model.joe.schedule.RunTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"orderId", "jobChain", "state", "endState", "at", "timeZone", "resume", "removeSetback", "title", "priority", "params", "runTime", "runTimeXml", "calendars"})
public class ModifyOrder {
    @JsonProperty(value="orderId")
    private String orderId;
    @JsonProperty(value="jobChain")
    @JsonPropertyDescription(value="absolute path based on live folder of a JobScheduler object.")
    private String jobChain;
    @JsonProperty(value="state")
    @JsonPropertyDescription(value="the name of the node")
    private String state;
    @JsonProperty(value="endState")
    @JsonPropertyDescription(value="the name of the end node")
    private String endState;
    @JsonProperty(value="at")
    @JsonPropertyDescription(value="ISO format yyyy-mm-dd HH:MM[:SS] or now or now + HH:MM[:SS] or now + SECONDS")
    private String at;
    @JsonProperty(value="timeZone")
    @JsonPropertyDescription(value="see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones")
    private String timeZone;
    @JsonProperty(value="resume")
    @JsonPropertyDescription(value="only useful when changing order state of suspended orders")
    private Boolean resume;
    @JsonProperty(value="removeSetback")
    @JsonPropertyDescription(value="only useful when order has a setback")
    private Boolean removeSetback;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="priority")
    private Integer priority;
    @JsonProperty(value="params")
    private List<NameValuePair> params = new ArrayList<NameValuePair>();
    @JsonProperty(value="runTime")
    private RunTime runTime;
    @JsonProperty(value="runTimeXml")
    @JsonPropertyDescription(value="A run_time xml is expected which is specified in the <xsd:complexType name='run_time'> element of  http://www.sos-berlin.com/schema/scheduler.xsd")
    private String runTimeXml;
    @JsonProperty(value="calendars")
    private List<Calendar> calendars = new ArrayList<Calendar>();

    @JsonProperty(value="orderId")
    public String getOrderId() {
        return this.orderId;
    }

    @JsonProperty(value="orderId")
    public void setOrderId(String orderId) {
        this.orderId = Latin1ToUtf8.convert(orderId);
    }

    @JsonProperty(value="jobChain")
    public String getJobChain() {
        return this.jobChain;
    }

    @JsonProperty(value="jobChain")
    public void setJobChain(String jobChain) {
        this.jobChain = Latin1ToUtf8.convert(jobChain);
    }

    @JsonProperty(value="state")
    public String getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    public void setState(String state) {
        this.state = state;
    }

    @JsonProperty(value="endState")
    public String getEndState() {
        return this.endState;
    }

    @JsonProperty(value="endState")
    public void setEndState(String endState) {
        this.endState = endState;
    }

    @JsonProperty(value="at")
    public String getAt() {
        return this.at;
    }

    @JsonProperty(value="at")
    public void setAt(String at) {
        this.at = at;
    }

    @JsonProperty(value="timeZone")
    public String getTimeZone() {
        return this.timeZone;
    }

    @JsonProperty(value="timeZone")
    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    @JsonProperty(value="resume")
    public Boolean getResume() {
        return this.resume;
    }

    @JsonProperty(value="resume")
    public void setResume(Boolean resume) {
        this.resume = resume;
    }

    @JsonProperty(value="removeSetback")
    public Boolean getRemoveSetback() {
        return this.removeSetback;
    }

    @JsonProperty(value="removeSetback")
    public void setRemoveSetback(Boolean removeSetback) {
        this.removeSetback = removeSetback;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty(value="priority")
    public Integer getPriority() {
        return this.priority;
    }

    @JsonProperty(value="priority")
    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    @JsonProperty(value="params")
    public List<NameValuePair> getParams() {
        return this.params;
    }

    @JsonProperty(value="params")
    public void setParams(List<NameValuePair> params) {
        this.params = params;
    }

    @JsonProperty(value="runTime")
    public RunTime getRunTime() {
        return this.runTime;
    }

    @JsonProperty(value="runTime")
    public void setRunTime(RunTime runTime) {
        this.runTime = runTime;
    }

    @JsonProperty(value="runTimeXml")
    public String getRunTimeXml() {
        return this.runTimeXml;
    }

    @JsonProperty(value="runTimeXml")
    public void setRunTimeXml(String runTimeXml) {
        this.runTimeXml = runTimeXml;
    }

    @JsonProperty(value="calendars")
    public List<Calendar> getCalendars() {
        return this.calendars;
    }

    @JsonProperty(value="calendars")
    public void setCalendars(List<Calendar> calendars) {
        this.calendars = calendars;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("orderId", (Object)this.orderId).append("jobChain", (Object)this.jobChain).append("state", (Object)this.state).append("endState", (Object)this.endState).append("at", (Object)this.at).append("timeZone", (Object)this.timeZone).append("resume", (Object)this.resume).append("removeSetback", (Object)this.removeSetback).append("title", (Object)this.title).append("priority", (Object)this.priority).append("params", this.params).append("runTime", (Object)this.runTime).append("runTimeXml", (Object)this.runTimeXml).append("calendars", this.calendars).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.resume).append((Object)this.orderId).append((Object)this.endState).append((Object)this.jobChain).append((Object)this.timeZone).append((Object)this.title).append((Object)this.priority).append(this.params).append((Object)this.at).append(this.calendars).append((Object)this.state).append((Object)this.runTime).append((Object)this.runTimeXml).append((Object)this.removeSetback).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ModifyOrder)) {
            return false;
        }
        ModifyOrder rhs = (ModifyOrder)other;
        return new EqualsBuilder().append((Object)this.resume, (Object)rhs.resume).append((Object)this.orderId, (Object)rhs.orderId).append((Object)this.endState, (Object)rhs.endState).append((Object)this.jobChain, (Object)rhs.jobChain).append((Object)this.timeZone, (Object)rhs.timeZone).append((Object)this.title, (Object)rhs.title).append((Object)this.priority, (Object)rhs.priority).append(this.params, rhs.params).append((Object)this.at, (Object)rhs.at).append(this.calendars, rhs.calendars).append((Object)this.state, (Object)rhs.state).append((Object)this.runTime, (Object)rhs.runTime).append((Object)this.runTimeXml, (Object)rhs.runTimeXml).append((Object)this.removeSetback, (Object)rhs.removeSetback).isEquals();
    }
}

