/*
 * Decompiled with CFR 0.152.
 */
package com.sos.DataExchange.helpers;

import com.sos.vfs.common.options.SOSBaseOptions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sos.xml.SOSXMLXPath;

public class UpdateXmlToOptionHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateXmlToOptionHelper.class);
    private SOSBaseOptions options;

    public UpdateXmlToOptionHelper(SOSBaseOptions jadeOptions) {
        this.options = jadeOptions;
    }

    public boolean checkBefore() {
        return this.options.updateConfiguration.value();
    }

    public void executeBefore() throws Exception {
        LOGGER.debug(this.options.xmlUpdate.getValue());
        this.extractOptionsFromXmlSnippet(this.options.xmlUpdate.getValue());
    }

    private Map<String, String> getCredentialsFromFragmentNode(Node node) {
        HashMap<String, String> credentials = new HashMap<String, String>();
        NodeList childNodes = node.getChildNodes();
        switch (node.getNodeName()) {
            case "FTPFragment": {
                credentials.put("protocol", "ftp");
            }
            case "FTPSFragment": {
                if (credentials.get("protocol") == null || ((String)credentials.get("protocol")).isEmpty()) {
                    credentials.put("protocol", "ftps");
                }
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node currentNode = childNodes.item(i);
                    if ("BasicConnection".equalsIgnoreCase(currentNode.getNodeName())) {
                        credentials.put("host", currentNode.getFirstChild().getFirstChild().getNodeValue());
                        continue;
                    }
                    if (!"BasicAuthentication".equalsIgnoreCase(currentNode.getNodeName())) continue;
                    credentials.put("user", currentNode.getFirstChild().getFirstChild().getNodeValue());
                    credentials.put("password", currentNode.getFirstChild().getNextSibling().getFirstChild().getNodeValue());
                }
                break;
            }
            case "HTTPFragment": {
                credentials.put("protocol", "http");
            }
            case "HTTPSFragment": {
                if (credentials.get("protocol") == null || ((String)credentials.get("protocol")).isEmpty()) {
                    credentials.put("protocol", "https");
                }
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node currentNode = childNodes.item(i);
                    if (!"URLConnection".equalsIgnoreCase(currentNode.getNodeName())) continue;
                    credentials.put("connectionUrl", currentNode.getFirstChild().getFirstChild().getNodeValue());
                }
                break;
            }
            case "JumpFragment": {
                credentials.put("protocol", "sftp");
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node currentNode = childNodes.item(i);
                    if ("BasicConnection".equalsIgnoreCase(currentNode.getNodeName())) {
                        credentials.put("host", currentNode.getFirstChild().getFirstChild().getNodeValue());
                        continue;
                    }
                    if ("SSHAuthentication".equalsIgnoreCase(currentNode.getNodeName())) {
                        credentials.put("user", currentNode.getFirstChild().getFirstChild().getNodeValue());
                        Node authMethod = currentNode.getFirstChild().getNextSibling();
                        if (authMethod.getNodeName().contains("Password")) {
                            credentials.put("authMethodName", "password");
                            credentials.put("password", authMethod.getFirstChild().getFirstChild().getNodeValue());
                            continue;
                        }
                        credentials.put("authMethodName", "publickey");
                        credentials.put("publickey", authMethod.getFirstChild().getFirstChild().getNodeValue());
                        continue;
                    }
                    if (!"JumpCommand".equalsIgnoreCase(currentNode.getNodeName())) continue;
                    credentials.put("JumpCommand", currentNode.getFirstChild().getNodeValue());
                }
                break;
            }
            case "SFTPFragment": {
                credentials.put("protocol", "sftp");
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node currentNode = childNodes.item(i);
                    if ("BasicConnection".equalsIgnoreCase(currentNode.getNodeName())) {
                        credentials.put("host", currentNode.getFirstChild().getFirstChild().getNodeValue());
                        continue;
                    }
                    if (!"SSHAuthentication".equalsIgnoreCase(currentNode.getNodeName())) continue;
                    credentials.put("user", currentNode.getFirstChild().getFirstChild().getNodeValue());
                    Node authMethod = currentNode.getFirstChild().getNextSibling();
                    if (authMethod.getNodeName().contains("Password")) {
                        credentials.put("authMethodName", "password");
                        credentials.put("password", authMethod.getFirstChild().getFirstChild().getNodeValue());
                        continue;
                    }
                    credentials.put("authMethodName", "publickey");
                    credentials.put("publickey", authMethod.getFirstChild().getFirstChild().getNodeValue());
                }
                break;
            }
            case "SMBFragment": {
                credentials.put("protocol", "smb");
                if ("Hostname".equalsIgnoreCase(node.getNodeName())) {
                    credentials.put("host", node.getFirstChild().getNodeValue());
                    break;
                }
                if (!"SMBAuthentication".equalsIgnoreCase(node.getNodeName())) break;
                credentials.put("user", node.getFirstChild().getFirstChild().getNodeValue());
                credentials.put("password", node.getFirstChild().getNextSibling().getFirstChild().getNodeValue());
                break;
            }
            case "WebDAVFragment": {
                credentials.put("protocol", "WebDAV");
                if ("URLConnection".equalsIgnoreCase(node.getNodeName())) {
                    credentials.put("connectionUrl", node.getFirstChild().getFirstChild().getNodeValue());
                    break;
                }
                if (!"BasicAuthentication".equalsIgnoreCase(node.getNodeName())) break;
                credentials.put("user", node.getFirstChild().getFirstChild().getNodeValue());
                credentials.put("password", node.getFirstChild().getNextSibling().getFirstChild().getNodeValue());
                break;
            }
        }
        return credentials;
    }

    private void extractOptionsFromXmlSnippet(String xml) throws Exception {
        String operation = null;
        String sourceFragmentInUse = null;
        String targetFragmentInUse = null;
        String filePath = null;
        String filePathDir = null;
        String fileSpec = null;
        String fileSpecDir = null;
        String fileList = null;
        String fileListDir = null;
        String targetDir = null;
        try {
            SOSXMLXPath xPath = new SOSXMLXPath(new StringBuffer(xml));
            if (xPath.selectSingleNode("//Operation") != null) {
                operation = xPath.selectSingleNode("//Operation").getFirstChild().getNodeName();
                LOGGER.debug("Operation Type update received from XML. New Operation: " + operation);
            } else {
                LOGGER.debug("*******No Operation Element specified in XML Snippet, falling back to configured operation from options*******");
                if ("send".equalsIgnoreCase(this.options.operation.getValue())) {
                    operation = "Copy";
                    LOGGER.debug("Operation Type set to COPY as default");
                } else {
                    operation = this.options.operation.getValue();
                    LOGGER.debug("Operation not changed! Operation Type already in use is: " + operation);
                }
            }
            if (operation != null && !operation.isEmpty()) {
                String key;
                Iterator<String> iterator;
                Node node;
                String nodeName;
                Boolean isJump = false;
                sourceFragmentInUse = xPath.selectDocumentText("//" + operation + "Source/" + operation + "SourceFragmentRef");
                if (sourceFragmentInUse != null && !sourceFragmentInUse.isEmpty() && !"LocalSource".equalsIgnoreCase(nodeName = xPath.selectSingleNode("//" + operation + "SourceFragmentRef").getFirstChild().getNodeName())) {
                    node = xPath.selectSingleNode("//" + nodeName.replaceAll("Ref", ""));
                    if (node.getFirstChild().getNextSibling().getNextSibling() != null) {
                        LOGGER.debug("Overwriting OPERATION <" + this.options.operation.getValue() + "> with: copytointernet");
                        this.options.operation.setValue("copytointernet");
                        isJump = true;
                    }
                    Map<String, String> sourceCredentials = this.getCredentialsFromFragmentNode(node);
                    iterator = sourceCredentials.keySet().iterator();
                    while (iterator.hasNext()) {
                        switch (key = iterator.next()) {
                            case "host": {
                                LOGGER.debug("Overwriting Source HOST <" + this.options.getSource().host.getValue() + "> with: " + sourceCredentials.get(key));
                                this.options.getSource().host.setValue(sourceCredentials.get(key));
                                break;
                            }
                            case "user": {
                                LOGGER.debug("Overwriting Source USER <" + this.options.getSource().userName.getValue() + "> with: " + sourceCredentials.get(key));
                                this.options.getSource().userName.setValue(sourceCredentials.get(key));
                                break;
                            }
                            case "password": {
                                LOGGER.debug("Overwriting Source PWD <*****> with: new PWD *****");
                                this.options.getSource().password.setValue(sourceCredentials.get(key));
                                break;
                            }
                            case "protocol": {
                                LOGGER.debug("Overwriting Source PROTOCOL <" + this.options.getSource().protocol.getValue() + "> with: " + sourceCredentials.get(key));
                                this.options.getSource().protocol.setValue(sourceCredentials.get(key));
                                break;
                            }
                            case "authMethodName": {
                                LOGGER.debug("Overwriting Source AUTH_METHOD <" + this.options.getSource().authMethod.getValue() + "> with: " + sourceCredentials.get(key));
                                this.options.getSource().authMethod.setValue(sourceCredentials.get(key));
                                break;
                            }
                            case "publickey": {
                                LOGGER.debug("Overwriting Source AUTH_FILE <" + this.options.getSource().authFile.getValue() + "> with: " + sourceCredentials.get(key));
                                this.options.getSource().authFile.setValue(sourceCredentials.get(key));
                                break;
                            }
                            case "connectionUrl": {
                                LOGGER.debug("Overwriting Source CONNECTION_URL <" + this.options.getSource().url.getValue() + "> with: " + sourceCredentials.get(key));
                                this.options.getSource().url.setValue(sourceCredentials.get(key));
                                break;
                            }
                        }
                    }
                }
                if ((targetFragmentInUse = xPath.selectDocumentText("//" + operation + "Target/" + operation + "TargetFragmentRef")) != null && !targetFragmentInUse.isEmpty() && !"LocalSource".equalsIgnoreCase(nodeName = xPath.selectSingleNode("//" + operation + "TargetFragmentRef").getFirstChild().getNodeName())) {
                    node = xPath.selectSingleNode("//" + nodeName.replaceAll("Ref", ""));
                    if (node.getFirstChild().getNextSibling().getNextSibling() != null) {
                        this.options.operation.setValue("copyfrominternet");
                        isJump = true;
                    }
                    Map<String, String> targetCredentials = this.getCredentialsFromFragmentNode(node);
                    iterator = targetCredentials.keySet().iterator();
                    while (iterator.hasNext()) {
                        switch (key = iterator.next()) {
                            case "host": {
                                LOGGER.debug("Overwriting Target HOST <" + this.options.getTarget().host.getValue() + "> with: " + targetCredentials.get(key));
                                this.options.getTarget().host.setValue(targetCredentials.get(key));
                                break;
                            }
                            case "user": {
                                LOGGER.debug("Overwriting Target USER <" + this.options.getTarget().userName.getValue() + "> with: " + targetCredentials.get(key));
                                this.options.getTarget().userName.setValue(targetCredentials.get(key));
                                break;
                            }
                            case "password": {
                                LOGGER.debug("Overwriting Target PWD <*****> with: new PWD *****");
                                this.options.getTarget().password.setValue(targetCredentials.get(key));
                                break;
                            }
                            case "protocol": {
                                LOGGER.debug("Overwriting Target PROTOCOL <" + this.options.getTarget().protocol.getValue() + "> with: " + targetCredentials.get(key));
                                this.options.getTarget().protocol.setValue(targetCredentials.get(key));
                                break;
                            }
                            case "authMethodName": {
                                LOGGER.debug("Overwriting Target AUTH_METHOD <" + this.options.getTarget().authMethod.getValue() + "> with: " + targetCredentials.get(key));
                                this.options.getTarget().authMethod.setValue(targetCredentials.get(key));
                                break;
                            }
                            case "publickey": {
                                LOGGER.debug("Overwriting Target AUTH_FILE <" + this.options.getTarget().authFile.getValue() + "> with: " + targetCredentials.get(key));
                                this.options.getTarget().authFile.setValue(targetCredentials.get(key));
                                break;
                            }
                            case "connectionUrl": {
                                LOGGER.debug("Overwriting Target CONNECTION_URL <" + this.options.getTarget().url.getValue() + "> with: " + targetCredentials.get(key));
                                this.options.getTarget().url.setValue(targetCredentials.get(key));
                                break;
                            }
                        }
                    }
                }
                if (isJump.booleanValue()) {
                    Node node2 = xPath.selectSingleNode("//JumpFragment");
                    Map<String, String> jumpCredentials = this.getCredentialsFromFragmentNode(node2);
                    Iterator<String> iterator2 = jumpCredentials.keySet().iterator();
                    while (iterator2.hasNext()) {
                        String key2;
                        switch (key2 = iterator2.next()) {
                            case "host": {
                                LOGGER.debug("Overwriting jump HOST <" + this.options.jumpHost.getValue() + "> with: " + jumpCredentials.get(key2));
                                this.options.jumpHost.setValue(jumpCredentials.get(key2));
                                break;
                            }
                            case "user": {
                                LOGGER.debug("Overwriting jump USER <" + this.options.jumpUser.getValue() + "> with: " + jumpCredentials.get(key2));
                                this.options.jumpUser.setValue(jumpCredentials.get(key2));
                                break;
                            }
                            case "password": {
                                LOGGER.debug("Overwriting jump PWD <*****> with: new PWD *****");
                                this.options.jumpPassword.setValue(jumpCredentials.get(key2));
                                break;
                            }
                            case "authMethodName": {
                                LOGGER.debug("Overwriting jump AUTH_METHOD <" + this.options.jumpSshAuthMethod.getValue() + "> with: " + jumpCredentials.get(key2));
                                this.options.jumpSshAuthMethod.setValue(jumpCredentials.get(key2));
                                break;
                            }
                            case "publickey": {
                                LOGGER.debug("Overwriting jump AUTH_FILE <" + this.options.jumpSshAuthFile.getValue() + "> with: " + jumpCredentials.get(key2));
                                this.options.jumpSshAuthFile.setValue(jumpCredentials.get(key2));
                                break;
                            }
                            case "JumpCommand": {
                                LOGGER.debug("Overwriting jump COMMAND <" + this.options.jumpCommand.getValue() + "> with: " + jumpCredentials.get(key2));
                                this.options.jumpCommand.setValue(jumpCredentials.get(key2));
                                break;
                            }
                        }
                    }
                }
            }
            filePath = xPath.selectSingleNodeValue("//Selection/FilePathSelection/FilePath");
            filePathDir = xPath.selectSingleNodeValue("//Selection/FilePathSelection/Directory");
            fileSpec = xPath.selectSingleNodeValue("//Selection/FileSpecSelection/FileSpec");
            fileSpecDir = xPath.selectSingleNodeValue("//Selection/FileSpecSelection/Directory");
            fileList = xPath.selectSingleNodeValue("//Selection/FileListSelection/FileList");
            fileListDir = xPath.selectSingleNodeValue("//Selection/FileListSelection/Directory");
            if ("copy".equalsIgnoreCase(operation)) {
                targetDir = xPath.selectSingleNodeValue("//CopyTarget/Directory");
            } else if ("move".equalsIgnoreCase(operation)) {
                targetDir = xPath.selectSingleNodeValue("//MoveTarget/Directory");
            }
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        if (filePath != null && !filePath.isEmpty()) {
            LOGGER.debug("Overwriting Source FILE_PATH <" + this.options.filePath.getValue() + "> with: " + filePath);
            this.options.filePath.setValue(filePath);
            LOGGER.debug("Overwriting Source DIRECTORY <" + this.options.getSource().directory.getValue() + "> with: " + filePathDir);
            this.options.getSource().directory.setValue(filePathDir);
        } else if (fileSpec != null && !fileSpec.isEmpty()) {
            LOGGER.debug("Overwriting Source FILE_SPEC <" + this.options.fileSpec.getValue() + "> with: " + fileSpec);
            this.options.fileSpec.setValue(fileSpec);
            LOGGER.debug("Overwriting Source DIRECTORY <" + this.options.getSource().directory.getValue() + "> with: " + fileSpecDir);
            this.options.getSource().directory.setValue(fileSpecDir);
        } else if (fileList != null && !fileList.isEmpty()) {
            LOGGER.debug("Overwriting Source FILE_LIST <" + this.options.fileListName.getValue() + "> with: " + fileList);
            this.options.fileListName.setValue(fileList);
            LOGGER.debug("Overwriting Source DIRECTORY <" + this.options.getSource().directory.getValue() + "> with: " + fileListDir);
            this.options.getSource().directory.setValue(fileListDir);
        }
        if (targetDir != null && !targetDir.isEmpty()) {
            LOGGER.debug("Overwriting Target DIRECTORY <" + this.options.getTarget().directory.getValue() + "> with: " + targetDir);
            this.options.getTarget().directory.setValue(targetDir);
        }
    }

    public SOSBaseOptions getOptions() {
        return this.options;
    }

    public void setOptions(SOSBaseOptions options) {
        this.options = options;
    }
}

