/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.job.impl;

import com.sos.JSHelper.Options.SOSOptionTransferType;
import com.sos.vfs.common.SOSCommandResult;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.net.ssh.SOSSSHJobOptions;
import sos.scheduler.job.impl.SOSSSHJob;

public class SOSSSHTerminateRemotePidJob
extends SOSSSHJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSSSHTerminateRemotePidJob.class);
    private static final String PARAM_PIDS_TO_KILL = "PIDS_TO_KILL";
    private static final String PID_PLACEHOLDER = "${pid}";
    private static final String USER_PLACEHOLDER = "${user}";
    private static final String COMMAND_PLACEHOLDER = "${command}";
    private static final String DEFAULT_LINUX_TERMINATE_PID_COMMAND = "kill -15 ${pid}";
    private static final String DEFAULT_WINDOWS_TERMINATE_PID_COMMAND = "taskkill /pid ${pid} /FI \"USERNAME eq ${user}\" /FI \"IMAGENAME eq ${command}\"";
    private List<Integer> allPids = new ArrayList<Integer>();
    private String terminatePidCommand = "kill -15 ${pid}";

    @Override
    public void execute() throws Exception {
        List<Integer> pidsToKillFromOrder = this.getPidsToKillFromOrder();
        try {
            this.connect(SOSOptionTransferType.TransferTypes.ssh);
            this.getTerminateCommandFromJobParameters();
            LOGGER.debug("try to kill remote PIDs");
            for (Integer pid : pidsToKillFromOrder) {
                this.allPids.add(pid);
                this.executeGetAllChildProcesses(pid);
            }
            for (Integer pid : this.allPids) {
                this.processTerminateCommand(pid);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.disconnect();
        }
    }

    private List<Integer> getPidsToKillFromOrder() {
        String[] pidsFromOrder = ((SOSSSHJobOptions)((Object)this.objOptions)).getItem(PARAM_PIDS_TO_KILL).split(",");
        ArrayList<Integer> pidsToKill = new ArrayList<Integer>();
        for (String pid : pidsFromOrder) {
            pidsToKill.add(Integer.parseInt(pid));
        }
        return pidsToKill;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTerminateCommand(Integer pid) {
        LOGGER.debug("Sending terminate command: " + this.terminatePidCommand + " with ${pid}=" + pid);
        String cmd = null;
        if (this.terminatePidCommand.contains(PID_PLACEHOLDER)) {
            cmd = this.terminatePidCommand.replace(PID_PLACEHOLDER, pid.toString());
        }
        if (this.terminatePidCommand.contains(USER_PLACEHOLDER)) {
            cmd = cmd.replace(USER_PLACEHOLDER, ((SOSSSHJobOptions)((Object)this.objOptions)).userName.getValue());
        }
        if (this.terminatePidCommand.contains(COMMAND_PLACEHOLDER)) {
            cmd = cmd.replace(COMMAND_PLACEHOLDER, ((SOSSSHJobOptions)((Object)this.objOptions)).command.getValue());
        }
        SOSCommandResult result = null;
        try {
            result = this.getHandler().executeResultCommand(cmd);
        }
        catch (Exception e) {
            LOGGER.error(e.toString(), (Throwable)e);
        }
        finally {
            if (result != null && result.getExitCode() != 0 && result.getStdErr().toString().contains("No such process")) {
                LOGGER.info("meanwhile the remote process is not available anymore!");
            }
        }
    }

    private void getTerminateCommandFromJobParameters() {
        if (((SOSSSHJobOptions)((Object)this.objOptions)).sshJobTerminatePidCommand.isDirty() && !((SOSSSHJobOptions)((Object)this.objOptions)).sshJobTerminatePidCommand.getValue().isEmpty()) {
            this.terminatePidCommand = ((SOSSSHJobOptions)((Object)this.objOptions)).sshJobTerminatePidCommand.getValue();
            LOGGER.debug("Commands to terminate from Job Parameter used!");
        } else if (this.isWindowsShell()) {
            this.terminatePidCommand = DEFAULT_WINDOWS_TERMINATE_PID_COMMAND;
            LOGGER.debug("Default Windows commands used to terminate PID!");
        } else {
            this.terminatePidCommand = DEFAULT_LINUX_TERMINATE_PID_COMMAND;
            LOGGER.debug("Default Linux commands used to terminate PID!");
        }
    }

    private boolean executeGetAllChildProcesses(Integer pPid) {
        try {
            String cmd = ((SOSSSHJobOptions)((Object)this.objOptions)).getSshJobGetChildProcessesCommand().getValue().contains(PID_PLACEHOLDER) ? ((SOSSSHJobOptions)((Object)this.objOptions)).getSshJobGetChildProcessesCommand().getValue().replace(PID_PLACEHOLDER, pPid.toString()) : ((SOSSSHJobOptions)((Object)this.objOptions)).getSshJobGetChildProcessesCommand().getValue();
            LOGGER.debug("***Execute read children of pid command!***");
            SOSCommandResult result = this.getHandler().executeResultCommand(cmd);
            BufferedReader reader = new BufferedReader(new StringReader(new String(result.getStdOut())));
            String line = null;
            while ((line = reader.readLine()) != null) {
                LOGGER.debug(line);
                Matcher regExMatcher = Pattern.compile("^([^\r\n]*)\r*\n*").matcher(line);
                if (!regExMatcher.find()) continue;
                String pid = regExMatcher.group(1).trim();
                try {
                    LOGGER.debug("PID: " + pid);
                    this.allPids.add(Integer.parseInt(pid));
                    this.executeGetAllChildProcesses(Integer.parseInt(pid));
                }
                catch (Exception e) {
                    LOGGER.debug("no parseable pid received in line: \"" + pid + "\"");
                }
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error(e.toString(), (Throwable)e);
            return false;
        }
    }
}

