/*
 * Decompiled with CFR 0.152.
 */
package com.sos.xml;

import com.sos.exception.SOSConnectionRefusedException;
import com.sos.exception.SOSNoResponseException;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sos.xml.SOSXMLXPath;

public class SOSXmlCommand {
    private static final String DEFAULT_PROTOCOL = "http";
    private String protocol;
    private String host;
    private Long port;
    private String url;
    protected Map<String, Map<String, String>> attributes;
    private SOSXMLXPath sosxml;
    private int connectTimeout = 0;
    private int readTimeout = 0;
    private boolean allowAllHostnameVerifier = true;
    private String basicAuthorization = null;

    public SOSXmlCommand(String protocol, String host, Long port) {
        if (protocol == null || "".equals(protocol)) {
            protocol = DEFAULT_PROTOCOL;
        }
        this.attributes = new HashMap<String, Map<String, String>>();
        this.protocol = protocol;
        this.host = host;
        this.port = port;
    }

    public SOSXmlCommand(String url) {
        this.attributes = new HashMap<String, Map<String, String>>();
        this.url = url;
    }

    public SOSXmlCommand(String host, int port) {
        this.attributes = new HashMap<String, Map<String, String>>();
        this.host = host;
        this.port = new Long(port);
        this.protocol = DEFAULT_PROTOCOL;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setAllowAllHostnameVerifier(boolean flag) {
        this.allowAllHostnameVerifier = flag;
    }

    public void setBasicAuthorization(String basicAuthorization) {
        this.basicAuthorization = basicAuthorization;
    }

    public String getBasicAuthorization() {
        return this.basicAuthorization;
    }

    protected void setUrl(String url) {
        this.url = url;
    }

    protected String getUrl() {
        return this.url;
    }

    public String getAttribute(String key, String attribute) {
        return this.attributes.get(key).get(attribute);
    }

    public String getAttribute(String attribute) {
        return this.getAttribute("", attribute);
    }

    public String getAttributeWithDefault(String attribute, String defaultValue) {
        return this.getAttributeWithDefault("", attribute, defaultValue);
    }

    public String getAttributeWithDefault(String key, String attribute, String defaultValue) {
        String val = this.attributes.get(key).get(attribute);
        if (val == null || "".equals(val)) {
            return defaultValue;
        }
        return this.attributes.get(key).get(attribute);
    }

    public Integer getAttributeAsIntegerOr0(String key, String attribute) {
        try {
            return Integer.parseInt(this.attributes.get(key).get(attribute));
        }
        catch (Exception e) {
            return 0;
        }
    }

    public Integer getAttributeAsInteger(String key, String attribute) {
        try {
            return Integer.parseInt(this.attributes.get(key).get(attribute));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Integer getAttributeAsIntegerOr0(String attribute) {
        return this.getAttributeAsIntegerOr0("", attribute);
    }

    public Integer getAttributeAsInteger(String attribute) {
        return this.getAttributeAsInteger("", attribute);
    }

    public Date getAttributeAsDate(String key, String dateAttribute) {
        Date date;
        try {
            String dateString = this.getAttribute(key, dateAttribute);
            if (dateString == null || dateString.isEmpty()) {
                return null;
            }
            dateString = dateString.trim().replaceFirst("^(\\d{4}-\\d{2}-\\d{2}) ", "$1T");
            date = Date.from(Instant.parse(dateString));
        }
        catch (Exception e) {
            return null;
        }
        return date;
    }

    public Date getAttributeAsDate(String dateAttribute) {
        return this.getAttributeAsDate("", dateAttribute);
    }

    public Element executeXPath(String key, String xPath) throws Exception {
        Element element = null;
        if (this.sosxml != null) {
            HashMap<String, String> attrs = new HashMap<String, String>();
            Node n = this.sosxml.selectSingleNode(xPath);
            if (n != null) {
                element = (Element)n;
                NamedNodeMap map = n.getAttributes();
                for (int j = 0; j < map.getLength(); ++j) {
                    attrs.put(map.item(j).getNodeName(), map.item(j).getNodeValue());
                }
                this.attributes.put(key, attrs);
            }
        } else {
            this.attributes.put(key, new HashMap());
        }
        return element;
    }

    public Element executeXPath(String xPath) throws Exception {
        return this.executeXPath("", xPath);
    }

    public NodeList selectNodelist(String xPath) throws Exception {
        if (this.sosxml != null) {
            return this.sosxml.selectNodeList(xPath);
        }
        return null;
    }

    public String executeXMLPost(String urlParameters) throws SOSConnectionRefusedException, SOSNoResponseException {
        return this.executeXMLPost(urlParameters, UUID.randomUUID().toString());
    }

    public String executeXMLPost(String urlParameters, String csrfToken) throws SOSConnectionRefusedException, SOSNoResponseException {
        return this.responseToString(this.requestXMLPost(urlParameters, csrfToken));
    }

    public String executeXMLPost(String urlParameters, ResponseStream responseStream) throws SOSConnectionRefusedException, SOSNoResponseException {
        return this.executeXMLPost(urlParameters, responseStream, UUID.randomUUID().toString());
    }

    public String executeXMLPost(String urlParameters, ResponseStream responseStream, String csrfToken) throws SOSConnectionRefusedException, SOSNoResponseException {
        return this.responseToString(this.requestXMLPost(urlParameters, csrfToken), responseStream);
    }

    public SOSXMLXPath getSosxml() {
        return this.sosxml;
    }

    private String getCsrfToken(String csrfToken) {
        if (csrfToken == null || csrfToken.isEmpty()) {
            return UUID.randomUUID().toString();
        }
        return csrfToken;
    }

    public HttpURLConnection requestXMLPost(String urlParameters, String csrfToken) throws SOSConnectionRefusedException {
        HttpURLConnection connection = null;
        String targetURL = this.url != null && !"".equals(this.url) ? this.url : String.format("%s://%s:%s", this.protocol, this.host, this.port);
        try {
            URL url = new URL(targetURL);
            if ("https".equals(url.getProtocol())) {
                if (this.allowAllHostnameVerifier) {
                    HttpsURLConnection.setDefaultHostnameVerifier((hostname, session) -> true);
                }
                connection = (HttpsURLConnection)url.openConnection();
            } else {
                connection = (HttpURLConnection)url.openConnection();
            }
            if (this.basicAuthorization != null && !this.basicAuthorization.isEmpty()) {
                connection.setRequestProperty("Authorization", "Basic " + this.basicAuthorization);
            }
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/xml");
            if (urlParameters.indexOf("<?xml") < 0) {
                urlParameters = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>" + urlParameters;
            }
            byte[] body = urlParameters.getBytes(StandardCharsets.ISO_8859_1);
            connection.setRequestProperty("Content-Length", Integer.toString(body.length));
            connection.setRequestProperty("X-CSRF-Token", this.getCsrfToken(csrfToken));
            connection.setUseCaches(false);
            connection.setDoOutput(true);
            connection.setConnectTimeout(this.connectTimeout);
            connection.setReadTimeout(this.readTimeout);
            DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
            wr.write(body);
            wr.close();
            return connection;
        }
        catch (Exception e) {
            if (connection != null) {
                connection.disconnect();
            }
            throw new SOSConnectionRefusedException((Throwable)e);
        }
    }

    private String responseToString(HttpURLConnection connection) throws SOSNoResponseException {
        return this.responseToString(connection, ResponseStream.TO_STRING_AND_SOSXML);
    }

    private String responseToString(HttpURLConnection connection, ResponseStream responseStream) throws SOSNoResponseException {
        if (connection != null) {
            InputStream is = null;
            StringBuffer response = new StringBuffer();
            Reader rd = null;
            try {
                int length;
                is = connection.getInputStream();
                if (responseStream == ResponseStream.TO_SOSXML) {
                    this.sosxml = new SOSXMLXPath(is);
                    String string = null;
                    return string;
                }
                rd = new InputStreamReader(is);
                char[] buffer = new char[4096];
                while ((length = rd.read(buffer)) != -1) {
                    response.append(buffer, 0, length);
                }
                if (responseStream == ResponseStream.TO_STRING_AND_SOSXML) {
                    this.sosxml = new SOSXMLXPath(response);
                }
                String string = response.toString();
                return string;
            }
            catch (Exception e) {
                throw new SOSNoResponseException((Throwable)e);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (rd != null) {
                        rd.close();
                    }
                }
                catch (Exception exception) {}
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        return "";
    }

    public static enum ResponseStream {
        TO_STRING,
        TO_SOSXML,
        TO_STRING_AND_SOSXML;

    }
}

