/*
 * Decompiled with CFR 0.152.
 */
package com.sos.controller.model.cluster;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ClusterType {
    EMPTY("Empty"),
    NODES_APPOINTED("NodesAppointed"),
    PREPARED_TO_BE_COUPLED("PreparedToBeCoupled"),
    COUPLED("Coupled"),
    PASSIVE_LOST("PassiveLost"),
    FAILED_OVER("FailedOver"),
    SWITCHED_OVER("SwitchedOver"),
    ACTIVE_NODE_IS_NOT_READY("ActiveNodeIsNotReady"),
    ACTIVE_SHUT_DOWN("ActiveShutDown"),
    NODE_LOSS_TO_BE_CONFIRMED("NodeLossToBeConfirmed");

    private final String value;
    private static final Map<String, ClusterType> CONSTANTS;

    private ClusterType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static ClusterType fromValue(String value) {
        ClusterType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ClusterType>();
        for (ClusterType c : ClusterType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

