/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.audit;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum CategoryType {
    CONTROLLER(2),
    INVENTORY(3),
    DEPLOYMENT(4),
    DAILYPLAN(5),
    DOCUMENTATIONS(9),
    CERTIFICATES(10),
    IDENTITY(11),
    SETTINGS(12),
    MONITORING(13);

    private final Integer intValue;
    private static final Map<String, CategoryType> CONSTANTS;
    private static final Map<Integer, CategoryType> INTCONSTANTS;

    private CategoryType(Integer intValue) {
        this.intValue = intValue;
    }

    public String toString() {
        return this.name();
    }

    @JsonValue
    public String value() {
        return this.name();
    }

    public Integer intValue() {
        return this.intValue;
    }

    @JsonCreator
    public static CategoryType fromValue(String value) {
        CategoryType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public static CategoryType fromValue(Integer intValue) {
        CategoryType constant = INTCONSTANTS.get(intValue);
        if (constant == null) {
            throw new IllegalArgumentException("" + intValue);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, CategoryType>();
        INTCONSTANTS = new HashMap<Integer, CategoryType>();
        for (CategoryType c : CategoryType.values()) {
            CONSTANTS.put(c.name(), c);
        }
        for (CategoryType c : CategoryType.values()) {
            INTCONSTANTS.put(c.intValue, c);
        }
    }
}

