/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.inventory.changes.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ChangeState {
    OPEN(0),
    CLOSED(1),
    PUBLISHED(2);

    private final Integer intValue;
    private static final Map<String, ChangeState> CONSTANTS;
    private static final Map<Integer, ChangeState> INTCONSTANTS;

    private ChangeState(Integer value) {
        this.intValue = value;
    }

    public String toString() {
        return this.name();
    }

    public Integer intValue() {
        return this.intValue;
    }

    @JsonValue
    public String value() {
        return this.name();
    }

    @JsonCreator
    public static ChangeState fromValue(String value) {
        ChangeState constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public static ChangeState fromValue(Integer intValue) {
        ChangeState constant = INTCONSTANTS.get(intValue);
        if (constant == null) {
            throw new IllegalArgumentException("" + intValue);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ChangeState>();
        INTCONSTANTS = new HashMap<Integer, ChangeState>();
        for (ChangeState c : ChangeState.values()) {
            CONSTANTS.put(c.name(), c);
        }
        for (ChangeState c : ChangeState.values()) {
            INTCONSTANTS.put(c.intValue, c);
        }
    }
}

