/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.inventory.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ReleaseType {
    WORKINGDAYSCALENDAR(60),
    NONWORKINGDAYSCALENDAR(61),
    SCHEDULE(7),
    INCLUDESCRIPT(12),
    JOBTEMPLATE(8),
    REPORT(15);

    private final Integer intValue;
    private static final Map<String, ReleaseType> CONSTANTS;
    private static final Map<Integer, ReleaseType> INTCONSTANTS;

    private ReleaseType(Integer intValue) {
        this.intValue = intValue;
    }

    public String toString() {
        return this.name();
    }

    @JsonValue
    public String value() {
        return this.name();
    }

    public Integer intValue() {
        return this.intValue;
    }

    @JsonCreator
    public static ReleaseType fromValue(String value) {
        ReleaseType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public static ReleaseType fromValue(Integer intValue) {
        ReleaseType constant = INTCONSTANTS.get(intValue);
        if (constant == null) {
            throw new IllegalArgumentException("" + intValue);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ReleaseType>();
        INTCONSTANTS = new HashMap<Integer, ReleaseType>();
        for (ReleaseType c : ReleaseType.values()) {
            CONSTANTS.put(c.name(), c);
        }
        for (ReleaseType c : ReleaseType.values()) {
            INTCONSTANTS.put(c.intValue, c);
        }
    }
}

