/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.order;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum OrderStateFilter {
    pending("pending"),
    scheduled("scheduled"),
    running("running"),
    suspended("suspended"),
    failed("failed"),
    blocked("blocked"),
    waiting("waiting"),
    prompting("prompting"),
    terminated("terminated");

    private final String value;
    private static final Map<String, OrderStateFilter> CONSTANTS;

    private OrderStateFilter(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static OrderStateFilter fromValue(String value) {
        OrderStateFilter constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, OrderStateFilter>();
        for (OrderStateFilter c : OrderStateFilter.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

