/*
 * Decompiled with CFR 0.152.
 */
package sos.marshalling;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.connection.SOSConnection;
import sos.connection.SOSMySQLConnection;
import sos.marshalling.SOSImExportTableFieldTypes;

public class SOSExport {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSExport.class);
    private static final char[] HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private SOSConnection connection = null;
    private String application = null;
    private String fileName = null;
    private String xmlTagname = "sos_export";
    private String xmlEncoding = "iso-8859-1";
    private String normalizeFieldName = "strtoupper";
    private String normalizeTagName = "strtolower";
    private String xmlIndentation = "  ";
    private int xmlIndent = 0;
    private Queries queries = new Queries();
    private int queryCnt = 0;
    private int rekursionCnt = 0;
    private int lineWrap = 254;

    public SOSExport(SOSConnection conn, String fileName, String application) {
        if (conn != null) {
            this.connection = conn;
        }
        if (fileName != null) {
            this.fileName = fileName;
        }
        if (application != null) {
            this.application = application;
        }
        System.setProperty("oracledatabasemetadata.get_lob_precision", "false");
    }

    public void setConnection(SOSConnection conn) {
        this.connection = conn;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setXMLTagname(String xmlTagname) {
        this.xmlTagname = xmlTagname;
    }

    public void setXMLEncoding(String xmlEncoding) {
        this.xmlEncoding = xmlEncoding;
    }

    public void setNormalizeFieldName(String normalizeFieldName) {
        if (!"strtolower".equalsIgnoreCase(normalizeFieldName) || !"strtoupper".equalsIgnoreCase(normalizeFieldName)) {
            throw new IllegalArgumentException("SOSExport.setNormalizeFieldName: normalizeFielName must be \"strtolower\" or \"strtoupper\"");
        }
        this.normalizeFieldName = normalizeFieldName;
    }

    public void setNormalizeTagName(String normalizeTagName) {
        if (!"strtolower".equalsIgnoreCase(normalizeTagName) || !"strtoupper".equalsIgnoreCase(normalizeTagName)) {
            throw new IllegalArgumentException("SOSExport.setNormalizeTagName: normalizeTagName must be \"strtolower\" or \"strtoupper\"");
        }
        this.normalizeTagName = normalizeTagName;
    }

    public void setXMLIndentation(String indentation) {
        if ((indentation.length() & 1) != 0) {
            throw new IllegalArgumentException("SOSExport.setXMLIndentation: the indentation string must have an even length");
        }
        this.xmlIndentation = indentation;
    }

    public void setLineWrap(int lineWrap) {
        if ((lineWrap & 1) != 0) {
            throw new IllegalArgumentException("SOSExport.setLineWrap: the line must wrap at an even length");
        }
        this.lineWrap = lineWrap;
    }

    public int query(String tag, String key, String query, String parameter, int queryId) throws Exception {
        try {
            if (query != null && !"".equals(query) && tag != null && !"".equals(tag)) {
                Query obj = new Query(tag, key, query, parameter);
                if (queryId > -1) {
                    obj.setDependent(true);
                }
                if (obj.getParameterCnt() < SOSExport.countStr(query, "?")) {
                    throw new IllegalArgumentException("SOSExport.query: too few fields in parameter for substitution in the query");
                }
                LOGGER.debug("query: tag=" + tag + " key=" + key + " query_id=" + queryId + " query_cnt=" + this.queryCnt);
                if (queryId >= 0 && queryId < this.queries.cnt()) {
                    this.queries.get(queryId).addDependRef(new Integer(this.queryCnt));
                } else if (this.queryCnt > 0 && this.queryCnt - 1 < this.queries.cnt()) {
                    this.queries.get(this.queryCnt - 1).addDependRef(new Integer(this.queryCnt));
                } else if (parameter != null) {
                    throw new IllegalArgumentException("SOSExport.query: query_id index out of range: " + queryId);
                }
                this.queries.add(obj);
                return this.queryCnt++;
            }
            throw new IllegalArgumentException("SOSExport.query: empty query statement!");
        }
        catch (Exception e) {
            throw new Exception("SOSExport.query: " + e.getMessage(), e);
        }
    }

    public int query(String tag, String key, String query, String parameter, String operation, Map<String, String> keys4Delete, int queryId) throws Exception {
        try {
            if (query != null && !"".equals(query) && tag != null && !"".equals(tag)) {
                Query obj = new Query(tag, key, query, parameter, operation, keys4Delete);
                if (queryId > -1) {
                    obj.setDependent(true);
                }
                if (obj.getParameterCnt() < SOSExport.countStr(query, "?")) {
                    throw new IllegalArgumentException("SOSExport.query: too few fields in parameter for substitution in the query");
                }
                LOGGER.debug("query: tag=" + tag + " key=" + key + " query_id=" + queryId + " query_cnt=" + this.queryCnt);
                if (queryId >= 0 && queryId < this.queries.cnt()) {
                    this.queries.get(queryId).addDependRef(new Integer(this.queryCnt));
                } else if (this.queryCnt > 0 && this.queryCnt - 1 < this.queries.cnt()) {
                    this.queries.get(this.queryCnt - 1).addDependRef(new Integer(this.queryCnt));
                } else if (parameter != null) {
                    throw new IllegalArgumentException("SOSExport.query: query_id index out of range: " + queryId);
                }
                this.queries.add(obj);
                return this.queryCnt++;
            }
            throw new IllegalArgumentException("SOSExport.query: empty query statement!");
        }
        catch (Exception e) {
            throw new Exception("SOSExport.query: " + e.getMessage(), e);
        }
    }

    public int query(String tag, String key, String query) throws Exception {
        return this.query(tag, key, query, null, -1);
    }

    public int add(String tag, String key, String query, String parameter, int queryId) throws Exception {
        try {
            if (query != null && !"".equals(query) && tag != null && !"".equals(tag)) {
                Query obj = new Query(tag, key, query, parameter);
                if (obj.getParameterCnt() < SOSExport.countStr(query, "?")) {
                    throw new IllegalArgumentException("SOSExport.query: too few fields in parameter for substitution in the query");
                }
                LOGGER.debug("add: tag=" + tag + " key=" + key + " query_id=" + queryId + "query_cnt=" + this.queryCnt);
                if (queryId >= 0 && queryId < this.queries.cnt()) {
                    this.queries.get(queryId).addIndepdRef(new Integer(this.queryCnt));
                } else if (parameter != null) {
                    throw new IllegalArgumentException("SOSExport.add: query_id index out of range: " + queryId);
                }
                this.queries.add(obj);
                return this.queryCnt++;
            }
            throw new IllegalArgumentException("SOSExport.query: tag and query must be defined!");
        }
        catch (Exception e) {
            throw new Exception("SOSExport.add: " + e.getMessage(), e);
        }
    }

    public int add(String tag, String key, String query, String parameter, String operation, Map<String, String> keys4Delete, int queryId) throws Exception {
        try {
            if (query != null && !"".equals(query) && tag != null && !"".equals(tag)) {
                Query obj = new Query(tag, key, query, parameter, operation, keys4Delete);
                if (obj.getParameterCnt() < SOSExport.countStr(query, "?")) {
                    throw new IllegalArgumentException("SOSExport.query: too few fields in parameter for substitution in the query");
                }
                LOGGER.debug("add: tag=" + tag + " key=" + key + " query_id=" + queryId + "query_cnt=" + this.queryCnt);
                if (queryId >= 0 && queryId < this.queries.cnt()) {
                    this.queries.get(queryId).addIndepdRef(new Integer(this.queryCnt));
                } else if (parameter != null) {
                    throw new IllegalArgumentException("SOSExport.add: query_id index out of range: " + queryId);
                }
                this.queries.add(obj);
                return this.queryCnt++;
            }
            throw new IllegalArgumentException("SOSExport.query: tag and query must be defined!");
        }
        catch (Exception e) {
            throw new Exception("SOSExport.add: " + e.getMessage(), e);
        }
    }

    public String doExport() throws Exception, FileNotFoundException {
        try {
            if ("strtoupper".equalsIgnoreCase(this.normalizeFieldName)) {
                this.connection.setKeysToUpperCase();
                this.connection.setFieldNameToUpperCase(true);
            } else {
                this.connection.setKeysToLowerCase();
                this.connection.setFieldNameToUpperCase(false);
            }
            if (this.fileName != null && !"".equals(this.fileName)) {
                File file = new File(this.fileName);
                file.createNewFile();
                if (!file.canWrite()) {
                    throw new FileNotFoundException("File not writeable: " + this.fileName);
                }
                LOGGER.debug("Starte Export in die Datei...");
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                FileOutputStream fos = new FileOutputStream(this.fileName);
                OutputStreamWriter fw = new OutputStreamWriter((OutputStream)fos, this.xmlEncoding);
                fw.write("<?xml version=\"1.0\" encoding=\"" + this.xmlEncoding + "\"?>\n");
                fw.write(this.indent(1) + "<" + this.normalizeTagName(this.xmlTagname) + " application=\"" + this.application + "\" created=\"" + dateFormat.format(new Date()) + "\">\n");
                dateFormat = null;
                for (int i = 0; i < this.queries.cnt(); ++i) {
                    if (this.queries.get(i).isDone() || this.queries.get(i).isDependent()) continue;
                    if (this.queries.get(i).getOperation() != null && "delete".equalsIgnoreCase(this.queries.get(i).getOperation())) {
                        this.exportQueriesForDelete(i, null, fw);
                        continue;
                    }
                    this.exportQueries(i, fw);
                }
                fw.write(this.indent(-1) + "</" + this.normalizeTagName(this.xmlTagname) + ">\n");
                fw.close();
                fos.close();
                LOGGER.debug("...Export in die Datei beendet");
                return "";
            }
            LOGGER.debug("Starte Export...");
            StringBuilder output = new StringBuilder();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            output.append("<?xml version=\"1.0\" encoding=\"" + this.xmlEncoding + "\"?>\n");
            output.append(this.indent(1) + "<" + this.normalizeTagName(this.xmlTagname) + " application=\"" + this.application + "\" created=\"" + dateFormat.format(new Date()) + "\">\n");
            dateFormat = null;
            for (int i = 0; i < this.queries.cnt(); ++i) {
                if (this.queries.get(i).isDone()) continue;
                output.append(this.exportQueries(i));
            }
            output.append(this.indent(-1) + "</" + this.normalizeTagName(this.xmlTagname) + ">\n");
            LOGGER.debug("...Export beendet");
            return output.toString();
        }
        catch (Exception e) {
            throw new Exception("SOSExport.export: " + e.getMessage(), e);
        }
    }

    public String doExport(SOSConnection conn, String fileName) throws Exception, FileNotFoundException {
        this.connection = conn;
        this.fileName = fileName;
        return this.doExport();
    }

    private String exportQueries(int queryId) throws Exception {
        return this.exportQueries(queryId, new ArrayList<String>());
    }

    private String exportQueries(int queryId, Writer fw) throws Exception {
        return this.exportQueries(queryId, new ArrayList<String>(), fw);
    }

    private String exportQueries(int queryId, List<String> parameterValues, Writer fw) throws Exception {
        try {
            LOGGER.debug("export_queries:  name=\"" + this.queries.get(queryId).getTag() + "\" query_id=\"" + queryId + "\" key=\"" + this.queries.get(queryId).keysToStr() + "\" dependend=\"" + this.queries.get(queryId).dependRefToStr() + "\" operation=\"" + this.queries.get(queryId).getOperation() + "\" independend=\"" + this.queries.get(queryId).indepdRefToStr() + "\"");
            ++this.rekursionCnt;
            String queryStm = this.substituteQuery(this.queries.get(queryId).getQuery(), parameterValues);
            Map<String, String> allFieldNames = this.prepareGetFieldName(queryStm);
            SOSImExportTableFieldTypes fieldTypes = this.getFieldTypes(queryStm.toString());
            List<Object> result = new ArrayList();
            result = this.getArray(queryStm.toString());
            fw.write(this.indent(1) + "<" + this.normalizeTagName(this.xmlTagname + "_package id=\"") + this.queries.get(queryId).getTag() + "\">\n");
            if (!result.isEmpty()) {
                int i;
                fw.write(this.indent(1) + "<" + this.normalizeTagName(this.xmlTagname + "_meta") + ">\n");
                fw.write(this.indent(0) + "<" + this.normalizeTagName("table name=\"") + this.queries.get(queryId).getTag() + "\" />\n");
                fw.write(this.indent(1) + "<" + this.normalizeTagName("key_fields") + ">\n");
                for (int i2 = 0; i2 < this.queries.get(queryId).getKeyCnt(); ++i2) {
                    LOGGER.debug("key_field[" + i2 + "]=\"" + this.queries.get(queryId).getKey(i2) + "\"");
                    fw.write(this.indent() + "<" + this.normalizeTagName("field name=\"") + this.normalizeFieldName(this.queries.get(queryId).getKey(i2)) + "\"");
                    fw.write(" type=\"" + fieldTypes.getTypeName(this.normalizeFieldName(this.queries.get(queryId).getKey(i2))) + "\"");
                    fw.write(" typeID=\"" + fieldTypes.getTypeId(this.normalizeFieldName(this.queries.get(queryId).getKey(i2))) + "\"");
                    fw.write(" len=\"" + fieldTypes.getLength(this.normalizeFieldName(this.queries.get(queryId).getKey(i2))) + "\"");
                    fw.write(" scale=\"" + fieldTypes.getScale(this.normalizeFieldName(this.queries.get(queryId).getKey(i2))) + "\"");
                    fw.write(" />\n");
                }
                fw.write(this.indent(-1) + this.normalizeTagName("</key_fields>") + "\n");
                fw.write(this.indent(1) + this.normalizeTagName("<fields>") + "\n");
                Object[] fields = ((Map)result.get(0)).keySet().toArray();
                for (i = 0; i < fields.length; ++i) {
                    fw.write(this.indent() + "<" + this.normalizeTagName("field name=\"") + this.normalizeFieldName((String)fields[i]) + "\"");
                    fw.write(" type=\"" + fieldTypes.getTypeName(this.normalizeFieldName((String)fields[i])) + "\"");
                    fw.write(" typeID=\"" + fieldTypes.getTypeId(this.normalizeFieldName((String)fields[i])) + "\"");
                    fw.write(" len=\"" + fieldTypes.getLength(this.normalizeFieldName((String)fields[i])) + "\"");
                    fw.write(" scale=\"" + fieldTypes.getScale(this.normalizeFieldName((String)fields[i])) + "\"");
                    fw.write(" />\n");
                }
                fields = null;
                fw.write(this.indent(-1) + this.normalizeTagName("</fields>") + "\n");
                fw.write(this.indent(-1) + "</" + this.normalizeTagName(this.xmlTagname + "_meta") + ">\n");
                fw.write(this.indent(1) + "<" + this.normalizeTagName(this.xmlTagname + "_data") + ">\n");
                for (i = 0; i < result.size(); ++i) {
                    Map record = (Map)result.get(i);
                    LOGGER.trace("get: " + this.queries.get(queryId).getTag() + " query_id=" + queryId);
                    fw.write(this.indent(1) + "<" + this.normalizeTagName(this.xmlTagname + "_record name=\"") + this.queries.get(queryId).getTag() + "\">\n");
                    fw.write(this.indent(1) + "<" + this.normalizeTagName(this.xmlTagname + "_fields") + (this.queries.get(queryId).getOperation() != null && !this.queries.get(queryId).getOperation().isEmpty() ? " operation=\"" + this.queries.get(queryId).getOperation() + "\" " : "") + ">\n");
                    for (String key : record.keySet()) {
                        String lobType = null;
                        switch (fieldTypes.getTypeId(this.normalizeFieldName(key))) {
                            case -1: 
                            case 2005: {
                                lobType = "clob";
                                break;
                            }
                            case -4: 
                            case -3: 
                            case -2: 
                            case 2004: {
                                lobType = "blob";
                                break;
                            }
                            default: {
                                if (record.get(key) != null) {
                                    switch (fieldTypes.getTypeId(this.normalizeFieldName(key))) {
                                        case 91: 
                                        case 93: {
                                            String val = ((String)record.get(key)).toString();
                                            if (!val.endsWith(".0")) break;
                                            record.put(key, val.substring(0, val.length() - 2));
                                        }
                                    }
                                }
                                fw.write(this.indent() + "<" + this.normalizeTagName(key) + " null=");
                                if (record.get(key) != null) {
                                    fw.write("\"false\"><![CDATA[" + SOSExport.asXml(((String)record.get(key)).toString()) + "]]>");
                                } else {
                                    fw.write("\"true\"><![CDATA[]]>");
                                }
                                fw.write("</" + this.normalizeTagName(key) + ">\n");
                            }
                        }
                        if (lobType == null) continue;
                        int posBegin = new String(queryStm).toLowerCase().indexOf("from");
                        int posEnd = new String(queryStm).toLowerCase().indexOf(" ", posBegin + 5);
                        StringBuilder queryBlobStm = new StringBuilder();
                        String blobFieldName = this.getBlobFieldName(allFieldNames, key.toString());
                        queryBlobStm.append("SELECT " + this.normalizeFieldName(blobFieldName) + " ");
                        if (posEnd < posBegin) {
                            posEnd = queryStm.length();
                        }
                        queryBlobStm.append(queryStm.substring(posBegin, posEnd));
                        String and = " WHERE ";
                        for (int j = 0; j < this.queries.get(queryId).getKeyCnt(); ++j) {
                            String keyFieldName = this.getKeyFieldName(allFieldNames, this.queries.get(queryId).getKey(j));
                            queryBlobStm.append(and + this.normalizeFieldName(keyFieldName) + " =");
                            queryBlobStm.append(this.quote(fieldTypes.getTypeId(this.normalizeFieldName(this.queries.get(queryId).getKey(j))), (String)record.get(this.normalizeFieldName(this.queries.get(queryId).getKey(j)))));
                            and = " AND ";
                        }
                        byte[] blob = null;
                        blob = "blob".equals(lobType) ? this.connection.getBlob(queryBlobStm.toString()) : SOSExport.str2bin(this.connection.getClob(queryBlobStm.toString()));
                        fw.write(this.indent() + "<" + this.normalizeTagName(key) + " null=");
                        if (blob != null && blob.length > 0) {
                            this.indent(1);
                            fw.write("\"false\">\n");
                            SOSExport.toHexString(blob, this.indent(), this.lineWrap, fw);
                            fw.write("\n" + this.indent(-1));
                        } else {
                            fw.write("\"true\">");
                        }
                        fw.write("</" + this.normalizeTagName(key) + ">\n");
                    }
                    fw.write(this.indent(-1) + "</" + this.normalizeTagName(this.xmlTagname + "_fields") + ">\n");
                    if (this.queries.get(queryId).getIndepdRefCnt() > 0) {
                        for (int j = 0; j < this.queries.get(queryId).getIndepdRefCnt(); ++j) {
                            int recQuery = this.queries.get(queryId).getIndepdRef(j);
                            LOGGER.debug("recursive independend query: " + this.queries.get(recQuery).getQuery());
                            this.exportQueries(recQuery, this.queryParams(recQuery, record), fw);
                        }
                    }
                    if (this.queries.get(queryId).getDependRefCnt() > 0) {
                        for (int j = 0; j < this.queries.get(queryId).getDependRefCnt(); ++j) {
                            int recQuery = this.queries.get(queryId).getDependRef(j);
                            LOGGER.debug("recursive dependend query: " + this.queries.get(recQuery).getQuery());
                            this.exportQueries(recQuery, this.queryParams(recQuery, record), fw);
                        }
                    }
                    fw.write(this.indent(-1) + "</" + this.normalizeTagName(this.xmlTagname + "_record") + ">\n");
                }
                fw.write(this.indent(-1) + "</" + this.normalizeTagName(this.xmlTagname + "_data") + ">\n");
            }
            fw.write(this.indent(-1) + "</" + this.normalizeTagName(this.xmlTagname + "_package") + ">\n");
            this.queries.get(queryId).setDone(true);
            return "";
        }
        catch (Exception e) {
            throw new Exception("SOSExport.exportQueries: " + e.getMessage(), e);
        }
    }

    public String exportQueriesForDelete(int queryId, List<String> parameterValues, Writer fw) throws Exception {
        try {
            LOGGER.debug("export_queries:  name=\"" + this.queries.get(queryId).getTag() + "\" query_id=\"" + queryId + "\" key=\"" + this.queries.get(queryId).keysToStr() + "\" dependend=\"" + this.queries.get(queryId).dependRefToStr() + "\" operation=\"" + this.queries.get(queryId).getOperation() + "\" field_keys=\"" + this.queries.get(queryId).getFieldsKeys() + "\" independend=\"" + this.queries.get(queryId).indepdRefToStr() + "\"");
            ++this.rekursionCnt;
            String queryStm = this.substituteQuery(this.queries.get(queryId).getQuery(), parameterValues);
            Map<String, String> allFieldNames = this.prepareGetFieldName(queryStm);
            SOSImExportTableFieldTypes fieldTypes = this.getFieldTypes(queryStm.toString());
            fw.write(this.indent(1) + "<" + this.normalizeTagName(this.xmlTagname + "_package id=\"") + this.queries.get(queryId).getTag() + "\">\n");
            fw.write(this.indent(1) + "<" + this.normalizeTagName(this.xmlTagname + "_meta") + ">\n");
            fw.write(this.indent(0) + "<" + this.normalizeTagName("table name=\"") + this.queries.get(queryId).getTag() + "\" />\n");
            fw.write(this.indent(1) + "<" + this.normalizeTagName("key_fields") + ">\n");
            for (int i = 0; i < this.queries.get(queryId).getKeyCnt(); ++i) {
                LOGGER.debug("key_field[" + i + "]=\"" + this.queries.get(queryId).getKey(i) + "\"");
                fw.write(this.indent() + "<" + this.normalizeTagName("field name=\"") + this.normalizeFieldName(this.queries.get(queryId).getKey(i)) + "\"");
                fw.write(" type=\"" + fieldTypes.getTypeName(this.normalizeFieldName(this.queries.get(queryId).getKey(i))) + "\"");
                fw.write(" typeID=\"" + fieldTypes.getTypeId(this.normalizeFieldName(this.queries.get(queryId).getKey(i))) + "\"");
                fw.write(" len=\"" + fieldTypes.getLength(this.normalizeFieldName(this.queries.get(queryId).getKey(i))) + "\"");
                fw.write(" scale=\"" + fieldTypes.getScale(this.normalizeFieldName(this.queries.get(queryId).getKey(i))) + "\"");
                fw.write(" />\n");
            }
            fw.write(this.indent(-1) + this.normalizeTagName("</key_fields>") + "\n");
            fw.write(this.indent(1) + this.normalizeTagName("<fields>") + "\n");
            Object[] fields = this.queries.get(queryId).getFieldsKeys().keySet().toArray();
            for (int i = 0; i < fields.length; ++i) {
                fw.write(this.indent() + "<" + this.normalizeTagName("field name=\"") + this.normalizeFieldName((String)fields[i]) + "\"");
                fw.write(" type=\"" + fieldTypes.getTypeName(this.normalizeFieldName((String)fields[i])) + "\"");
                fw.write(" typeID=\"" + fieldTypes.getTypeId(this.normalizeFieldName((String)fields[i])) + "\"");
                fw.write(" len=\"" + fieldTypes.getLength(this.normalizeFieldName((String)fields[i])) + "\"");
                fw.write(" scale=\"" + fieldTypes.getScale(this.normalizeFieldName((String)fields[i])) + "\"");
                fw.write(" />\n");
            }
            fields = null;
            fw.write(this.indent(-1) + this.normalizeTagName("</fields>") + "\n");
            fw.write(this.indent(-1) + "</" + this.normalizeTagName(this.xmlTagname + "_meta") + ">\n");
            fw.write(this.indent(1) + "<" + this.normalizeTagName(this.xmlTagname + "_data") + ">\n");
            Map<String, String> record = this.queries.get(queryId).getFieldsKeys();
            LOGGER.trace("get: " + this.queries.get(queryId).getTag() + " query_id=" + queryId);
            fw.write(this.indent(1) + "<" + this.normalizeTagName(this.xmlTagname + "_record name=\"") + this.queries.get(queryId).getTag() + "\">\n");
            fw.write(this.indent(1) + "<" + this.normalizeTagName(this.xmlTagname + "_fields") + (this.queries.get(queryId).getOperation() != null && this.queries.get(queryId).getOperation().length() > 0 ? " operation=\"" + this.queries.get(queryId).getOperation() + "\" " : "") + ">\n");
            for (String key : record.keySet()) {
                if (record.get(key) != null) {
                    switch (fieldTypes.getTypeId(this.normalizeFieldName(key))) {
                        case 91: 
                        case 93: {
                            String val = record.get(key).toString();
                            if (!val.endsWith(".0")) break;
                            record.put(key, val.substring(0, val.length() - 2));
                        }
                    }
                }
                if (record.get(key) == null || record.get(key).toString().isEmpty()) continue;
                fw.write(this.indent() + "<" + this.normalizeTagName(key) + " null=");
                if (record.get(key) != null) {
                    fw.write("\"false\"><![CDATA[" + SOSExport.asXml(record.get(key).toString()) + "]]>");
                } else {
                    fw.write("\"true\"><![CDATA[]]>");
                }
                fw.write("</" + this.normalizeTagName(key) + ">\n");
            }
            fw.write(this.indent(-1) + "</" + this.normalizeTagName(this.xmlTagname + "_fields") + ">\n");
            if (this.queries.get(queryId).getIndepdRefCnt() > 0) {
                for (int j = 0; j < this.queries.get(queryId).getIndepdRefCnt(); ++j) {
                    int recQuery = this.queries.get(queryId).getIndepdRef(j);
                    LOGGER.debug("recursive independend query: " + this.queries.get(recQuery).getQuery());
                    this.exportQueries(recQuery, this.queryParams(recQuery, record), fw);
                }
            }
            if (this.queries.get(queryId).getDependRefCnt() > 0) {
                for (int j = 0; j < this.queries.get(queryId).getDependRefCnt(); ++j) {
                    int recQuery = this.queries.get(queryId).getDependRef(j);
                    LOGGER.debug("recursive dependend query: " + this.queries.get(recQuery).getQuery());
                    this.exportQueriesForDelete(recQuery, this.queryParams(recQuery, record), fw);
                }
            }
            fw.write(this.indent(-1) + "</" + this.normalizeTagName(this.xmlTagname + "_record") + ">\n");
            fw.write(this.indent(-1) + "</" + this.normalizeTagName(this.xmlTagname + "_data") + ">\n");
            fw.write(this.indent(-1) + "</" + this.normalizeTagName(this.xmlTagname + "_package") + ">\n");
            this.queries.get(queryId).setDone(true);
            return "";
        }
        catch (Exception e) {
            throw new Exception("SOSExport.exportQueries: " + e.getMessage(), e);
        }
    }

    private String exportQueries(int queryId, List<String> parameterValues) throws Exception {
        StringBuilder output = new StringBuilder();
        try {
            LOGGER.debug("export_queries: name=\"" + this.queries.get(queryId).getTag() + "\" query_id=\"" + queryId + "\" key=\"" + this.queries.get(queryId).keysToStr() + "\" dependend=\"" + this.queries.get(queryId).dependRefToStr() + "\" independend=\"" + this.queries.get(queryId).indepdRefToStr() + "\"");
            ++this.rekursionCnt;
            String queryStm = this.substituteQuery(this.queries.get(queryId).getQuery(), parameterValues);
            Map<String, String> allFieldNames = this.prepareGetFieldName(queryStm);
            SOSImExportTableFieldTypes fieldTypes = this.getFieldTypes(queryStm.toString());
            List<Map<String, String>> result = this.getArray(queryStm.toString());
            output.append(this.indent(1) + "<" + this.normalizeTagName(this.xmlTagname + "_package id=\"") + this.queries.get(queryId).getTag() + "\">\n");
            if (!result.isEmpty()) {
                int i;
                output.append(this.indent(1)).append("<").append(this.normalizeTagName(this.xmlTagname + "_meta")).append(">\n");
                output.append(this.indent(0)).append("<").append(this.normalizeTagName("table name=\"")).append(this.queries.get(queryId).getTag()).append("\" />\n");
                output.append(this.indent(1)).append("<").append(this.normalizeTagName("key_fields")).append(">\n");
                for (int i2 = 0; i2 < this.queries.get(queryId).getKeyCnt(); ++i2) {
                    LOGGER.debug("key_field[" + i2 + "]=\"" + this.queries.get(queryId).getKey(i2) + "\"");
                    output.append(this.indent()).append("<").append(this.normalizeTagName("field name=\"")).append(this.normalizeFieldName(this.queries.get(queryId).getKey(i2))).append("\"");
                    output.append(" type=\"").append(fieldTypes.getTypeName(this.normalizeFieldName(this.queries.get(queryId).getKey(i2)))).append("\"");
                    output.append(" typeID=\"").append(fieldTypes.getTypeId(this.normalizeFieldName(this.queries.get(queryId).getKey(i2)))).append("\"");
                    output.append(" len=\"").append(fieldTypes.getLength(this.normalizeFieldName(this.queries.get(queryId).getKey(i2)))).append("\"");
                    output.append(" scale=\"").append(fieldTypes.getScale(this.normalizeFieldName(this.queries.get(queryId).getKey(i2)))).append("\"");
                    output.append(" />\n");
                }
                output.append(this.indent(-1)).append(this.normalizeTagName("</key_fields>")).append("\n");
                output.append(this.indent(1)).append(this.normalizeTagName("<fields>")).append("\n");
                Object[] fields = result.get(0).keySet().toArray();
                for (i = 0; i < fields.length; ++i) {
                    output.append(this.indent()).append("<").append(this.normalizeTagName("field name=\"")).append(this.normalizeFieldName((String)fields[i])).append("\"");
                    output.append(" type=\"").append(fieldTypes.getTypeName(this.normalizeFieldName((String)fields[i]))).append("\"");
                    output.append(" typeID=\"").append(fieldTypes.getTypeId(this.normalizeFieldName((String)fields[i]))).append("\"");
                    output.append(" len=\"").append(fieldTypes.getLength(this.normalizeFieldName((String)fields[i]))).append("\"");
                    output.append(" scale=\"").append(fieldTypes.getScale(this.normalizeFieldName((String)fields[i]))).append("\"");
                    output.append(" />\n");
                }
                fields = null;
                output.append(this.indent(-1)).append(this.normalizeTagName("</fields>")).append("\n");
                output.append(this.indent(-1)).append("</").append(this.normalizeTagName(this.xmlTagname + "_meta")).append(">\n");
                output.append(this.indent(1)).append("<").append(this.normalizeTagName(this.xmlTagname + "_data")).append(">\n");
                for (i = 0; i < result.size(); ++i) {
                    Map<String, String> record = result.get(i);
                    LOGGER.trace("get: " + this.queries.get(queryId).getTag() + " query_id=" + queryId);
                    output.append(this.indent(1)).append("<").append(this.normalizeTagName(this.xmlTagname + "_record name=\"")).append(this.queries.get(queryId).getTag()).append("\">\n").append(this.indent(1)).append("<").append(this.normalizeTagName(this.xmlTagname + "_fields")).append(">\n");
                    for (String key : record.keySet()) {
                        String lobType = null;
                        switch (fieldTypes.getTypeId(this.normalizeFieldName(key))) {
                            case -1: 
                            case 2005: {
                                lobType = "clob";
                                break;
                            }
                            case -4: 
                            case -3: 
                            case -2: 
                            case 2004: {
                                lobType = "blob";
                                break;
                            }
                            default: {
                                if (record.get(key) != null) {
                                    switch (fieldTypes.getTypeId(this.normalizeFieldName(key))) {
                                        case 91: 
                                        case 93: {
                                            String val = record.get(key).toString();
                                            if (!val.endsWith(".0")) break;
                                            record.put(key, val.substring(0, val.length() - 2));
                                        }
                                    }
                                }
                                output.append(this.indent()).append("<").append(this.normalizeTagName(key)).append(" null=");
                                if (record.get(key) != null) {
                                    output.append("\"false\"><![CDATA[").append(SOSExport.asXml(record.get(key).toString())).append("]]>");
                                } else {
                                    output.append("\"true\"><![CDATA[]]>");
                                }
                                output.append("</").append(this.normalizeTagName(key)).append(">\n");
                            }
                        }
                        if (lobType == null) continue;
                        int posBegin = new String(queryStm).toLowerCase().indexOf("from");
                        int posEnd = new String(queryStm).toLowerCase().indexOf(" ", posBegin + 5);
                        StringBuilder queryBlobStm = new StringBuilder();
                        String blobFieldName = this.getBlobFieldName(allFieldNames, key.toString());
                        queryBlobStm.append("SELECT ").append(this.normalizeFieldName(blobFieldName)).append(" ");
                        if (posEnd < posBegin) {
                            posEnd = queryStm.length();
                        }
                        queryBlobStm.append(queryStm.substring(posBegin, posEnd));
                        String and = " WHERE ";
                        for (int j = 0; j < this.queries.get(queryId).getKeyCnt(); ++j) {
                            String keyFieldName = this.getKeyFieldName(allFieldNames, this.queries.get(queryId).getKey(j));
                            queryBlobStm.append(and).append(this.normalizeFieldName(keyFieldName)).append(" =");
                            queryBlobStm.append(this.quote(fieldTypes.getTypeId(this.normalizeFieldName(this.queries.get(queryId).getKey(j))), record.get(this.normalizeFieldName(this.queries.get(queryId).getKey(j)))));
                            and = " AND ";
                        }
                        byte[] blob = null;
                        blob = "blob".equals(lobType) ? this.connection.getBlob(queryBlobStm.toString()) : SOSExport.str2bin(this.connection.getClob(queryBlobStm.toString()));
                        output.append(this.indent()).append("<").append(this.normalizeTagName(key)).append(" null=");
                        if (blob != null && blob.length > 0) {
                            this.indent(1);
                            output.append("\"false\">\n").append(SOSExport.toHexString(blob, this.indent(), this.lineWrap)).append("\n").append(this.indent(-1));
                        } else {
                            output.append("\"true\">");
                        }
                        output.append("</").append(this.normalizeTagName(key)).append(">\n");
                    }
                    output.append(this.indent(-1)).append("</").append(this.normalizeTagName(this.xmlTagname + "_fields")).append(">\n");
                    if (this.queries.get(queryId).getIndepdRefCnt() > 0) {
                        for (int j = 0; j < this.queries.get(queryId).getIndepdRefCnt(); ++j) {
                            int recQuery = this.queries.get(queryId).getIndepdRef(j);
                            LOGGER.debug("recursive independend query: " + this.queries.get(recQuery).getQuery());
                            output.append(this.exportQueries(recQuery, this.queryParams(recQuery, record)));
                        }
                    }
                    if (this.queries.get(queryId).getDependRefCnt() > 0) {
                        for (int j = 0; j < this.queries.get(queryId).getDependRefCnt(); ++j) {
                            int recQuery = this.queries.get(queryId).getDependRef(j);
                            LOGGER.debug("recursive dependend query: " + this.queries.get(recQuery).getQuery());
                            output.append(this.exportQueries(recQuery, this.queryParams(recQuery, record)));
                        }
                    }
                    output.append(this.indent(-1)).append("</").append(this.normalizeTagName(this.xmlTagname + "_record")).append(">\n");
                }
                output.append(this.indent(-1)).append("</").append(this.normalizeTagName(this.xmlTagname + "_data")).append(">\n");
            }
            output.append(this.indent(-1)).append("</").append(this.normalizeTagName(this.xmlTagname + "_package")).append(">\n");
            this.queries.get(queryId).setDone(true);
            return output.toString();
        }
        catch (Exception e) {
            throw new Exception("SOSExport.exportQueries: " + e.getMessage(), e);
        }
    }

    private Map<String, String> prepareGetFieldName(String stmt) throws Exception {
        int posBegin = new String(stmt).toUpperCase().indexOf("SELECT");
        int posEnd = new String(stmt).toUpperCase().indexOf("FROM");
        if (posBegin == -1 || posEnd == -1) {
            throw new Exception("sql statement is not valid : " + stmt);
        }
        String selectFields = stmt.substring(posBegin + 6, posEnd).trim().toUpperCase();
        HashMap<String, String> hm = new HashMap<String, String>();
        if (!"*".equals(selectFields)) {
            String[] splitFields = selectFields.split(",");
            for (int i = 0; i < splitFields.length; ++i) {
                String field = splitFields[i].trim();
                String[] split = field.split(" ");
                int len = split.length;
                if (len > 1) {
                    String lastName = split[len - 1].replace('\"', ' ').trim();
                    if (field.indexOf(" AS ") == -1) continue;
                    String firstName = split[0].replace('\"', ' ').trim();
                    hm.put(lastName, firstName);
                    continue;
                }
                String firstName = field.replace('\"', ' ').trim();
                hm.put(firstName, firstName);
            }
        }
        return hm;
    }

    private String getBlobFieldName(Map<String, String> hm, String sampleFieldName) throws Exception {
        String sample = sampleFieldName.toUpperCase();
        if (hm != null && !hm.isEmpty() && hm.containsKey(sample)) {
            return "\"" + hm.get(sample) + "\" as \"" + sample + "\"";
        }
        return "\"" + sample + "\"";
    }

    private String getKeyFieldName(Map<String, String> hm, String sampleFieldName) throws Exception {
        String sample = sampleFieldName.toUpperCase();
        if (hm != null && !hm.isEmpty() && hm.containsKey(sample)) {
            return "\"" + hm.get(sample) + "\"";
        }
        return "\"" + sample + "\"";
    }

    public List<String> queryParams(int queryId, Map<String, String> record) throws Exception {
        ArrayList<String> values = new ArrayList<String>();
        try {
            LOGGER.debug("query_params: query_id=" + queryId);
            for (int i = 0; i < this.queries.get(queryId).getParameterCnt(); ++i) {
                LOGGER.debug("param_value[" + i + "] = " + this.queries.get(queryId).getParameter(i));
                if (!record.containsKey(this.normalizeFieldName(this.queries.get(queryId).getParameter(i)))) continue;
                values.add(record.get(this.normalizeFieldName(this.queries.get(queryId).getParameter(i))));
            }
            return values;
        }
        catch (Exception e) {
            throw new Exception("SOSExport.queryParams: " + e.getMessage(), e);
        }
    }

    private String substituteQuery(String query, List<String> values) {
        int matches = SOSExport.countStr(query, "?");
        String[] queryParts = query.split("\\?");
        if (matches == 0) {
            return query;
        }
        if (matches > values.size()) {
            throw new IllegalArgumentException("SOSExport.substituteQuery: too few values for substitution");
        }
        StringBuilder queryStm = new StringBuilder();
        for (int i = 0; i < queryParts.length; ++i) {
            queryStm.append(queryParts[i]);
            if (i >= values.size()) continue;
            if (values.get(i) == null || "".equals(values.get(i))) {
                queryStm.append("NULL");
                continue;
            }
            queryStm.append(values.get(i));
        }
        return queryStm.toString();
    }

    private static int countStr(String string, String part) {
        int index = 0;
        int matches = 0;
        index = string.indexOf(part, index);
        while (index >= 0) {
            ++matches;
            ++index;
            index = string.indexOf(part, index);
        }
        return matches;
    }

    private List<Map<String, String>> getArray(String query) throws Exception {
        try {
            this.connection.executeQuery(query);
            ResultSet rs = this.connection.getResultSet();
            ResultSetMetaData rsmd = rs.getMetaData();
            int n = rsmd.getColumnCount();
            ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
            while (rs.next()) {
                HashMap<String, String> row = new HashMap<String, String>(n);
                block7: for (int i = 1; i <= n; ++i) {
                    switch (rsmd.getColumnType(i)) {
                        case -6: 
                        case -5: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 91: 
                        case 93: {
                            row.put(rsmd.getColumnName(i), rs.getString(i));
                            continue block7;
                        }
                        case -4: 
                        case -3: 
                        case -2: 
                        case -1: 
                        case 2004: 
                        case 2005: {
                            row.put(rsmd.getColumnName(i), null);
                            continue block7;
                        }
                        default: {
                            row.put(rsmd.getColumnName(i), rs.getString(i));
                        }
                    }
                }
                result.add(row);
            }
            rs.close();
            return result;
        }
        catch (Exception e) {
            throw new Exception("SOSExport.getArray: " + e.getMessage());
        }
    }

    private SOSImExportTableFieldTypes getFieldTypes(String query) throws Exception {
        try {
            StringBuilder stm = new StringBuilder();
            int index = query.toLowerCase().indexOf("order by");
            if (index >= 0) {
                stm.append(query.substring(0, index - 1));
            } else {
                stm.append(query);
            }
            if (query.toLowerCase().indexOf("where") >= 0) {
                stm.append(" AND 1=0");
            } else {
                stm.append(" WHERE 1=0");
            }
            if (index >= 0) {
                stm.append(query.substring(index - 1));
            }
            this.connection.executeQuery(stm.toString());
            ResultSet resultSet = this.connection.getResultSet();
            SOSImExportTableFieldTypes fieldTypes = new SOSImExportTableFieldTypes();
            Map fieldDesc = new HashMap();
            for (int i = 1; i <= resultSet.getMetaData().getColumnCount(); ++i) {
                fieldDesc = this.connection.fieldDesc(i);
                Integer type = new Integer((String)fieldDesc.get("columnType"));
                BigInteger size = new BigInteger((String)fieldDesc.get("columnDisplaySize"));
                Integer scale = new Integer((String)fieldDesc.get("scale"));
                LOGGER.trace("field_type: name=" + (String)fieldDesc.get("columnName") + " type=" + (String)fieldDesc.get("columnTypeName") + " type_id=" + type + " size=" + size + " scale=" + scale);
                fieldTypes.addField(this.normalizeFieldName(this.normalizeFieldName((String)fieldDesc.get("columnName"))), (String)fieldDesc.get("columnTypeName"), type, size, scale);
            }
            resultSet.close();
            return fieldTypes;
        }
        catch (Exception e) {
            throw new Exception("SOSExport.getFieldTypes: " + e.getMessage(), e);
        }
    }

    private String quote(int type, String val) {
        if (val == null) {
            return "NULL";
        }
        if ("".equals(val)) {
            return "NULL";
        }
        switch (type) {
            case 8: {
                if ("null".equalsIgnoreCase(val)) {
                    val = "NULL";
                }
                return val;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                if ("null".equalsIgnoreCase(val)) {
                    val = "NULL";
                }
                return val;
            }
            case 91: 
            case 93: {
                return "%timestamp_iso('" + val + "')";
            }
        }
        val = val.replaceAll("'", "''");
        if (this.connection instanceof SOSMySQLConnection) {
            val = val.replaceAll("\\\\", "\\\\\\\\");
        }
        return "'" + val + "'";
    }

    private String indent(int indent) {
        int curIndent = this.xmlIndent;
        this.xmlIndent += indent;
        StringBuilder output = new StringBuilder(curIndent);
        if (indent > 0) {
            for (int i = 0; i < curIndent; ++i) {
                output.append(this.xmlIndentation);
            }
        } else {
            for (int i = 0; i < this.xmlIndent; ++i) {
                output.append(this.xmlIndentation);
            }
        }
        return output.toString();
    }

    private String indent() {
        return this.indent(0);
    }

    private String normalizeTagName(String tag) {
        if ("strtoupper".equalsIgnoreCase(this.normalizeTagName)) {
            return tag.toUpperCase();
        }
        return tag.toLowerCase();
    }

    private String normalizeFieldName(String field) {
        if ("strtoupper".equalsIgnoreCase(this.normalizeFieldName)) {
            return field.toUpperCase();
        }
        return field.toLowerCase();
    }

    private static String asXml(String str) {
        return str;
    }

    private static byte[] str2bin(String str) {
        return str.getBytes();
    }

    private static String toHexString(byte[] b, String indent, int wrap, Writer fw) throws Exception {
        int length = b.length * 2;
        int indentLength = indent.length();
        if (wrap > 0) {
            int indents = length / (wrap - indentLength);
            length += indents * (indentLength + "\n".length());
            length += indentLength;
        }
        int line = indentLength;
        if (wrap > 0) {
            fw.write(indent);
        }
        for (int i = 0; i < b.length; ++i) {
            fw.write(HEX_CHAR[(b[i] & 0xF0) >>> 4]);
            fw.write(HEX_CHAR[b[i] & 0xF]);
            if (wrap <= 0 || (line += 2) < wrap || i >= b.length - 1) continue;
            fw.write("\n" + indent);
            line = indentLength;
        }
        return "";
    }

    private static String toHexString(byte[] b, String indent, int wrap) {
        int length = b.length * 2;
        int indentLength = indent.length();
        if (wrap > 0) {
            int indents = length / (wrap - indentLength);
            length += indents * (indentLength + "\n".length());
            length += indentLength;
        }
        int line = indentLength;
        StringBuilder sb = new StringBuilder(length);
        if (wrap > 0) {
            sb.append(indent);
        }
        for (int i = 0; i < b.length; ++i) {
            sb.append(HEX_CHAR[(b[i] & 0xF0) >>> 4]);
            sb.append(HEX_CHAR[b[i] & 0xF]);
            if (wrap <= 0 || (line += 2) < wrap || i >= b.length - 1) continue;
            sb.append("\n" + indent);
            line = indentLength;
        }
        return sb.toString();
    }

    private class Queries {
        private List<Query> list = new ArrayList<Query>();

        private Queries() {
        }

        public void add(Query query) throws Exception {
            this.list.add(query);
        }

        public Query get(int index) throws IndexOutOfBoundsException {
            return this.list.get(index);
        }

        public void clear() throws UnsupportedOperationException {
            this.list.clear();
        }

        public int cnt() {
            return this.list.size();
        }
    }

    private class Query {
        private String tag = null;
        private List<String> key = new ArrayList<String>();
        private String query = null;
        private List<String> parameters = new ArrayList<String>();
        private List<Integer> dependRefs = new ArrayList<Integer>();
        private List<Integer> indepdRefs = new ArrayList<Integer>();
        private boolean done = false;
        private boolean dependent = false;
        private String operation = null;
        private Map<String, String> fieldsKeys = null;

        public Query(String tag, String key, String query, String parameters, int dependRef) {
            this.tag = tag;
            this.key.addAll(Arrays.asList(key.split(",")));
            this.query = query;
            this.parameters.addAll(Arrays.asList(parameters.split(",")));
            this.dependRefs.add(new Integer(dependRef));
        }

        public Query(String tag, String key, String query, String parameters) throws Exception {
            this.tag = tag;
            if (key != null && !"".equals(key)) {
                this.key.addAll(Arrays.asList(key.split(",")));
            }
            this.query = query;
            if (parameters != null) {
                this.parameters.addAll(Arrays.asList(parameters.split(",")));
            }
        }

        public Query(String tag, String key, String query, String parameters, String operation, Map<String, String> keys4Delete) throws Exception {
            this.tag = tag;
            if (key != null && !"".equals(key)) {
                this.key.addAll(Arrays.asList(key.split(",")));
            }
            this.query = query;
            this.fieldsKeys = keys4Delete;
            this.operation = operation;
            if (parameters != null) {
                this.parameters.addAll(Arrays.asList(parameters.split(",")));
            }
        }

        public Integer getDependRef(int index) {
            return this.dependRefs.get(index);
        }

        public int getDependRefCnt() {
            return this.dependRefs.size();
        }

        public void addDependRef(Integer dependRef) {
            this.dependRefs.add(dependRef);
        }

        public String dependRefToStr() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.dependRefs.size(); ++i) {
                sb.append(this.dependRefs.get(i).toString());
                if (i >= this.dependRefs.size() - 1) continue;
                sb.append(", ");
            }
            return sb.toString();
        }

        public boolean isDone() {
            return this.done;
        }

        public void setDone(boolean done) {
            this.done = done;
        }

        public Integer getIndepdRef(int index) {
            return this.indepdRefs.get(index);
        }

        public int getIndepdRefCnt() {
            return this.indepdRefs.size();
        }

        public void addIndepdRef(Integer indepdRef) {
            this.indepdRefs.add(indepdRef);
        }

        public String indepdRefToStr() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.indepdRefs.size(); ++i) {
                sb.append(this.indepdRefs.get(i).toString());
                if (i >= this.indepdRefs.size() - 1) continue;
                sb.append(", ");
            }
            return sb.toString();
        }

        public String getKey(int index) {
            return this.key.get(index);
        }

        public int getKeyCnt() {
            return this.key.size();
        }

        public void addKey(String key) {
            this.key.add(key);
        }

        public String keysToStr() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.key.size(); ++i) {
                sb.append(this.key.get(i));
                if (i >= this.key.size() - 1) continue;
                sb.append(", ");
            }
            return sb.toString();
        }

        public String getParameter(int index) {
            return this.parameters.get(index);
        }

        public int getParameterCnt() {
            return this.parameters.size();
        }

        public void addParameter(String parameter) {
            this.parameters.add(parameter);
        }

        public String parametersToStr() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.parameters.size(); ++i) {
                sb.append(this.parameters.get(i));
                if (i >= this.parameters.size() - 1) continue;
                sb.append(", ");
            }
            return sb.toString();
        }

        public String getQuery() {
            return this.query;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public String getTag() {
            return this.tag;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public boolean isDependent() {
            return this.dependent;
        }

        public void setDependent(boolean dependent) {
            this.dependent = dependent;
        }

        public String getOperation() {
            return this.operation;
        }

        public void setOperation(String operation) {
            this.operation = operation;
        }

        public Map<String, String> getFieldsKeys() {
            return this.fieldsKeys;
        }

        public void setFieldsKeys(Map<String, String> fieldsKeys) {
            this.fieldsKeys = fieldsKeys;
        }
    }
}

