/*
 * Decompiled with CFR 0.152.
 */
package sos.marshalling;

import java.io.File;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.connection.SOSConnection;
import sos.marshalling.SOSExport;
import sos.util.SOSArguments;

public class SOSExportProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSExportProcessor.class);
    private SOSConnection sosConnection = null;
    private File configFile = null;
    private File outputFile = null;
    private String tableNames = null;
    private String executeQuery = null;
    private String keys = null;
    private boolean enableTableParametr = true;
    private boolean enableExecuteParametr = true;

    public SOSExportProcessor(File configFile, File logFile, int logLevel, File outputFile, String tableNames, String executeQuery, String keys) throws Exception {
        if (configFile == null) {
            throw new NullPointerException("Export: Parameter config == null!");
        }
        if (outputFile == null) {
            throw new NullPointerException("Export: Parameter output == null!");
        }
        try {
            this.configFile = configFile;
            this.outputFile = outputFile;
            this.tableNames = tableNames;
            this.executeQuery = executeQuery;
            this.keys = keys;
            if (configFile != null && !configFile.getName().isEmpty() && !configFile.exists()) {
                throw new Exception("configuration file not found: " + configFile);
            }
            if (tableNames != null && !"".equals(tableNames) && executeQuery != null && !"".equals(executeQuery)) {
                throw new Exception("-tables and -execute may not be indicated together");
            }
            if (logLevel != 0 && "".equals(logFile.toString())) {
                throw new Exception("log file is not defined");
            }
        }
        catch (Exception e) {
            throw new Exception("error in SOSExportProcessor: " + e.getMessage());
        }
    }

    public SOSExportProcessor() {
        System.out.println("Syntax");
        System.out.println("Optionen :");
        System.out.println("        -config     Namen der Konfigurationsdatei f\u00fcr die DB Verbindung angeben.");
        System.out.println("                    Default : hibernate.cfg.xml");
        System.out.println("        -output     Namen der Export XML-Datei angeben.");
        System.out.println("                    Default : sos_export.xml ");
        System.out.println("        -tables     Tabellennamen f\u00fcr den Export.");
        System.out.println("                    Es werden alle Daten der jeweiligen Tabelle exportiert.");
        System.out.println("                    Mehrere Tabellen durch + Zeichen getrennt");
        System.out.println("        -keys    \tSchl\u00fcsselfelder f\u00fcr eine bzw mehreren Tabellen angeben.");
        System.out.println("           \t\t\tWird im Zusammenhang mit der Option -tables ber\u00fccksichtigt.");
        System.out.println("                    Schl\u00fcsselfelder sind wichtig, wenn eine Tabelle CLOB bzw BLOB enth\u00e4lt.");
        System.out.println("                    mehrere Schl\u00fcssel f\u00fcr eine Tabelle - durch Komma getrennt.");
        System.out.println("                    f\u00fcr mehreren Tabellen durch + Zeichen getrennt.");
        System.out.println("                    f\u00fcr mehreren Tabellen : die Reihenfolge wie bei -tables.");
        System.out.println("        -execute    eigene SQL-Statement f\u00fcr eine Tabelle angeben.");
        System.out.println("                    SQL-Statement in doppelten Hochkommas.");
        System.out.println("");
        System.out.println("");
        System.out.println("Notiz : -execute und -tables d\u00fcrfen nicht zusammen angegeben werden.");
        System.out.println("        eine von beiden Optionen muss angegeben sein");
        System.out.println("");
        System.out.println("");
        System.out.println("Beispiel 1 : alle Daten der Tabelle t1 exportieren und in die default Log-Datei loggen");
        System.out.println("         -config=config/hibernate.cfg.xml -tables=t1 -log-level=9");
        System.out.println("");
        System.out.println("Beispiel 2 : wie Beispiel 1 + Schl\u00fcsselfeld ID f\u00fcr die Tabelle t1 definieren");
        System.out.println("         -config=config/hibernate.cfg.xml -tables=t1 -keys=ID -log-level=9");
        System.out.println("");
        System.out.println("Beispiel 3 : alle Daten der Tabellen t1 und t2 ohne zu loggen exportieren");
        System.out.println("         -config=config/hibernate.cfg.xml -tables=t1+t2");
        System.out.println("");
        System.out.println("Beispiel 4 : wie Beispiel 3 + Schl\u00fcsselfelder T1_ID und T1_NAME f\u00fcr die Tabelle t1 und Schl\u00fcsselfeld T2_ID f\u00fcr die Tabelle t2 definieren");
        System.out.println("         -config=config/hibernate.cfg.xml -tables=t1+t2 -keys=T1_ID,T1_NAME+T2_ID");
        System.out.println("");
        System.out.println("Beispiel 5 : eigene SQL-Statement f\u00fcr die Tabelle t1 definieren");
        System.out.println("         -config=config/hibernate.cfg.xml -execute=\"select * from t1 where ID=1\"");
    }

    public void doExport() throws Exception {
        try {
            if (this.isEnableTableParametr() && this.isEnableExecuteParametr() && (this.tableNames == null || "".equals(this.tableNames)) && (this.executeQuery == null || "".equals(this.executeQuery))) {
                throw new Exception("undefined operation for export. Check please input for your -tables or -execute arguments");
            }
            this.sosConnection = SOSConnection.createInstance((String)this.configFile.toString());
            this.sosConnection.connect();
            SOSExport export = new SOSExport(this.sosConnection, this.outputFile.toString(), "EXPORT");
            this.prepareExport(export);
            export.doExport();
            System.out.println("");
            System.out.println("Export erfolgreich beendet.");
        }
        catch (Exception e) {
            throw new Exception("error in SOSExportProcessor: " + e.getMessage());
        }
        finally {
            try {
                if (this.sosConnection != null) {
                    this.sosConnection.disconnect();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void prepareExport(SOSExport export) throws Exception {
        String keys = "";
        String[] tablesKeys = new String[]{};
        if (keys != null && !"".equals(keys.trim())) {
            keys = keys.toUpperCase();
            tablesKeys = keys.split("\\+");
        }
        if (!"".equals(this.tableNames)) {
            StringTokenizer tables = new StringTokenizer(this.tableNames, "+");
            int i = 0;
            while (tables.hasMoreTokens()) {
                String table = tables.nextToken().toUpperCase();
                String key = "";
                if ("".equals(table)) continue;
                if (tablesKeys != null && tablesKeys.length != 0) {
                    try {
                        key = tablesKeys[i];
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                export.add(table, key, "select * from " + table, null, i);
                ++i;
            }
        } else if (!"".equals(this.executeQuery)) {
            StringTokenizer st = new StringTokenizer(this.executeQuery, " ");
            String table = "";
            while (st.hasMoreTokens()) {
                String token = st.nextToken().toUpperCase();
                if (!"FROM".equals(token)) continue;
                table = st.nextToken().toUpperCase();
                break;
            }
            export.add(table, keys, this.executeQuery, null, 0);
        }
    }

    public static void main(String[] args) throws Exception {
        String argument;
        boolean isExport = true;
        if (args.length == 1 && ("?".equals(argument = args[0].toLowerCase().trim()) || "help".equals(argument))) {
            isExport = false;
        }
        if (isExport) {
            SOSArguments arguments = new SOSArguments(args);
            SOSExportProcessor processor = new SOSExportProcessor(new File(arguments.asString("-config=", "hibernate.cfg.xml")), new File(arguments.asString("-log=", "sos_export.log")), arguments.asInt("-log-level=", 0), new File(arguments.asString("-output=", "sos_export.xml")), new String(arguments.asString("-tables=", "")), new String(arguments.asString("-execute=", "")), new String(arguments.asString("-keys=", "")));
            arguments.checkAllUsed();
            processor.doExport();
        }
    }

    public boolean isEnableExecuteParametr() {
        return this.enableExecuteParametr;
    }

    public void setEnableExecuteParametr(boolean enableExecuteParametr) {
        this.enableExecuteParametr = enableExecuteParametr;
    }

    public boolean isEnableTableParametr() {
        return this.enableTableParametr;
    }

    public void setEnableTableParametr(boolean enableTableParametr) {
        this.enableTableParametr = enableTableParametr;
    }
}

