/*
 * Decompiled with CFR 0.152.
 */
package sos.marshalling;

import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.connection.SOSConnection;
import sos.marshalling.SOSImport;
import sos.util.SOSFile;

public class SOSImportProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSImportProcessor.class);
    private SOSConnection sosConnection = null;
    private boolean update = false;
    private String fileSpec = "^(.*)";
    private File configFile = null;
    private File inputFile = null;

    public SOSImportProcessor(String settingsFilename) throws Exception {
        this.configFile = new File(settingsFilename);
    }

    public SOSImportProcessor(File configFile, File inputFile) throws Exception {
        if (configFile == null) {
            throw new NullPointerException("Import: Parameter config == null!");
        }
        if (inputFile == null) {
            throw new NullPointerException("Import: Parameter input == null!");
        }
        try {
            this.configFile = configFile;
            this.inputFile = inputFile;
            if (configFile != null && !configFile.getName().isEmpty() && !configFile.exists()) {
                throw new Exception("configuration file not found: " + configFile);
            }
            if (inputFile != null && !inputFile.getName().isEmpty() && !inputFile.exists()) {
                throw new Exception("input file not found: " + inputFile);
            }
        }
        catch (Exception e) {
            throw new Exception("error in SOSImportProcessor: " + e.getMessage(), e);
        }
    }

    public SOSImportProcessor() {
        System.out.println("Syntax");
        System.out.println("Optionen :");
        System.out.println("        -config     Namen der Konfigurationsdatei f\u00fcr die DB Verbindung angeben.");
        System.out.println("                    Default : hibernate.cfg.xml");
        System.out.println("        -input      Namen der Import XML-Datei angeben.");
        System.out.println("                    Default : sos_export.xml ");
        System.out.println("");
        System.out.println("");
        System.out.println("Beispiel 1 : Datei sos_import.xml in die Tabelle t1 importieren");
        System.out.println("         -config=config/hibernate.cfg.xml -input=sos_import.xml -table=t1");
    }

    public void doImport() throws Exception {
        try {
            this.sosConnection = SOSConnection.createInstance((String)this.configFile.toString());
            this.sosConnection.connect();
            SOSImport imp = new SOSImport(this.sosConnection, this.inputFile.toString(), null, null, null);
            imp.doImport();
            this.sosConnection.commit();
            System.out.println("");
            System.out.println("Import erfolgreich beendet.");
        }
        catch (Exception e) {
            this.sosConnection.rollback();
            throw new Exception("error in SOSImportProcessor.doImport: " + e.getMessage());
        }
        finally {
            try {
                if (this.sosConnection != null) {
                    this.sosConnection.disconnect();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(File inputFile) throws Exception {
        try {
            this.sosConnection = SOSConnection.createInstance((String)this.configFile.toString());
            this.sosConnection.connect();
            if (inputFile.isDirectory()) {
                boolean counter = false;
                Vector filelist = SOSFile.getFilelist((String)inputFile.getAbsolutePath(), (String)this.getFileSpec(), (int)0);
                Iterator iterator = filelist.iterator();
                while (iterator.hasNext()) {
                    this.process((File)iterator.next());
                }
            } else {
                SOSImport imp = new SOSImport(this.sosConnection, inputFile.toString(), null, null, null);
                imp.setUpdate(this.getUpdate());
                imp.doImport();
                this.sosConnection.commit();
            }
        }
        catch (Exception e) {
            LOGGER.warn("an error occurred processing file [" + inputFile.getAbsolutePath() + "]: " + e, (Throwable)e);
        }
        finally {
            try {
                if (this.sosConnection != null) {
                    this.sosConnection.rollback();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Usage: SOSImportProcessor configuration-file  path  [file-specification] [update]");
        }
        SOSImportProcessor processor = new SOSImportProcessor(args[0]);
        File inputFile = new File(args[1]);
        if (args.length > 2) {
            processor.setFileSpec(args[2]);
        }
        if (args.length > 3) {
            processor.setUpdate("1".equals(args[3]));
        }
        processor.process(inputFile);
    }

    public void setUpdate(boolean ovr) {
        this.update = ovr;
    }

    public boolean getUpdate() {
        return this.update;
    }

    public void setFileSpec(String fileSpec) {
        this.fileSpec = fileSpec;
    }

    public String getFileSpec() {
        return this.fileSpec;
    }
}

