/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.cmd;

import com.sos.scheduler.cmd.JSCommand;
import com.sos.scheduler.model.SchedulerObjectFactory;
import com.sos.scheduler.model.commands.JSCmdAddOrder;
import com.sos.scheduler.model.objects.JSObjParams;
import com.sos.scheduler.model.objects.Param;
import com.sos.scheduler.model.objects.Params;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSAddOrder
extends JSCommand {
    private final Logger logger = LoggerFactory.getLogger(JSAddOrder.class);
    private final JSCmdAddOrder cmdAddOrder;

    public JSAddOrder(String host, Integer port, String orderId, String jobChain) {
        super(host, port);
        this.cmdAddOrder = this.setCommand(orderId, jobChain);
    }

    public JSAddOrder(SchedulerObjectFactory factory, String orderId, String jobChain) {
        super(factory);
        this.cmdAddOrder = this.setCommand(orderId, jobChain);
    }

    private JSCmdAddOrder setCommand(String orderId, String jobChain) {
        JSCmdAddOrder cmd = this.getFactory().createAddOrder();
        cmd.setJobChain(jobChain);
        cmd.setId(orderId);
        this.setCommand(cmd);
        this.logger.info("Starting order for jobchain " + jobChain + " with orderID " + orderId);
        return cmd;
    }

    public void addParam(String name, String value) {
        this.initializeParams();
        Param p = this.getFactory().createParam(name, value);
        this.getParams().getParamOrCopyParamsOrInclude().add(p);
    }

    private void initializeParams() {
        if (this.cmdAddOrder.getParams() == null) {
            JSObjParams params = this.getFactory().createParams();
            this.setParams(params);
        }
    }

    public void mergeParams(Params paramsToMerge) {
        if (paramsToMerge != null) {
            this.initializeParams();
            JSObjParams orderParams = new JSObjParams(this.getFactory());
            orderParams.setParamsFromString(this.getParams().toXMLString());
            orderParams.merge(paramsToMerge);
            this.cmdAddOrder.setParams(orderParams);
        }
    }

    public void setParams(Params params) {
        if (params != null) {
            this.cmdAddOrder.setParams(params);
            this.cmdAddOrder.getParams().setParent(this.getFactory());
        }
    }

    public Params getParams() {
        return this.cmdAddOrder.getParams();
    }

    public void setState(String state) {
        this.cmdAddOrder.setState(state);
    }

    public void setTitle(String title) {
        this.cmdAddOrder.setTitle(title);
    }

    public void setReplace(boolean replace) {
        this.cmdAddOrder.setReplace(this.cmdAddOrder.setYesOrNo(replace));
    }

    public void setAt(String at) {
        this.cmdAddOrder.setAt(at);
    }
}

