/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.cmd;

import com.sos.scheduler.cmd.JSCommand;
import com.sos.scheduler.model.SchedulerObjectFactory;
import com.sos.scheduler.model.commands.JSCmdKillTask;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSKillTask
extends JSCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSKillTask.class);
    private final JSCmdKillTask cmdKillTask;

    public JSKillTask(String host, Integer port, Integer taskId, String jobName, Boolean immediately) {
        super(host, port);
        this.cmdKillTask = this.setCommand(taskId, jobName, immediately);
    }

    public JSKillTask(SchedulerObjectFactory factory, Integer taskId, String jobName, Boolean immediately) {
        super(factory);
        this.cmdKillTask = this.setCommand(taskId, jobName, immediately);
    }

    private JSCmdKillTask setCommand(Integer taskId, String jobName, Boolean immediately) {
        JSCmdKillTask cmd = this.getFactory().createKillTask();
        cmd.setId(BigInteger.valueOf(taskId.intValue()));
        cmd.setJob(jobName);
        cmd.setImmediately(immediately != false ? "yes" : "no");
        this.setCommand(cmd);
        LOGGER.info("Try to kill task " + jobName + " with taskID " + taskId + (immediately != false ? " immediately" : ""));
        return cmd;
    }
}

