/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.cmd;

import com.sos.scheduler.cmd.JSCommand;
import com.sos.scheduler.model.SchedulerObjectFactory;
import com.sos.scheduler.model.commands.JSCmdRemoveOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSRemoveOrder
extends JSCommand {
    private final Logger logger = LoggerFactory.getLogger(JSRemoveOrder.class);
    private final JSCmdRemoveOrder cmdRemoveOrder;

    public JSRemoveOrder(String host, Integer port, String orderId, String jobChain) {
        super(host, port);
        this.cmdRemoveOrder = this.setCommand(orderId, jobChain);
    }

    public JSRemoveOrder(SchedulerObjectFactory factory, String orderId, String jobChain) {
        super(factory);
        this.cmdRemoveOrder = this.setCommand(orderId, jobChain);
    }

    private JSCmdRemoveOrder setCommand(String orderId, String jobChain) {
        JSCmdRemoveOrder cmd = this.getFactory().createRemoveOrder();
        cmd.setJobChain(jobChain);
        cmd.setOrder(orderId);
        this.setCommand(cmd);
        this.logger.info("Remove order for jobchain " + jobChain + " with orderId " + orderId);
        return cmd;
    }
}

