/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.model;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.scheduler.model.SchedulerHotFolderFileList;
import com.sos.scheduler.model.SchedulerObjectFactory;
import com.sos.scheduler.model.objects.JSObjBase;
import com.sos.scheduler.model.objects.JSObjJob;
import com.sos.vfs.common.SOSFileEntry;
import com.sos.vfs.common.interfaces.ISOSProvider;
import com.sos.vfs.common.interfaces.ISOSProviderFile;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerHotFolder
extends JSObjBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulerHotFolder.class);
    private boolean isLoaded = false;
    private SchedulerHotFolderFileList hotFolderFileList = new SchedulerHotFolderFileList();

    public SchedulerHotFolder(SchedulerObjectFactory schedulerObjectFactory, ISOSProviderFile providerFile) {
        this.objFactory = schedulerObjectFactory;
        this.setHotFolderSrc(providerFile);
    }

    public SchedulerHotFolderFileList load() throws Exception {
        if (this.isLoaded) {
            return this.getHotFolderFileList();
        }
        this.hotFolderFileList = this.load(this.getHotFolderSrc());
        return this.hotFolderFileList;
    }

    public SchedulerHotFolderFileList loadOrderObjects() throws Exception {
        if (this.isLoaded) {
            return this.getHotFolderFileList();
        }
        this.hotFolderFileList = this.load(this.getHotFolderSrc(), ".*(.order.xml)");
        return this.hotFolderFileList;
    }

    public SchedulerHotFolderFileList loadRecursive() throws Exception {
        if (this.isLoaded) {
            return this.getHotFolderFileList();
        }
        this.hotFolderFileList = this.loadRecursive(this.getHotFolderSrc());
        return this.hotFolderFileList;
    }

    public SchedulerHotFolderFileList refresh() throws Exception {
        this.hotFolderFileList = this.load(this.getHotFolderSrc());
        return this.hotFolderFileList;
    }

    private SchedulerHotFolderFileList loadRecursive(ISOSProviderFile providerFile) throws Exception {
        SchedulerHotFolderFileList result = this.load(providerFile);
        List<SchedulerHotFolder> folders = result.getFolderList();
        for (SchedulerHotFolder folder : folders) {
            LOGGER.debug("reading content of " + folder.getHotFolderSrc().getName());
            SchedulerHotFolderFileList fileList = this.loadRecursive(folder.getHotFolderSrc());
            result.addAll(fileList);
        }
        return result;
    }

    public JSObjJob getJobByName(String jobName) {
        JSObjJob result = null;
        for (JSObjJob job : this.getHotFolderFileList().getJobList()) {
            if (!job.getJobName().equalsIgnoreCase(jobName)) continue;
            result = job;
            break;
        }
        return result;
    }

    private SchedulerHotFolderFileList load(ISOSProviderFile providerFile) throws Exception {
        return this.load(providerFile, ".*");
    }

    private SchedulerHotFolderFileList load(ISOSProviderFile providerFile, String regex) throws Exception {
        ISOSProviderFile pf2;
        String conMethodName = "SchedulerHotFolder::load";
        SchedulerHotFolderFileList result = new SchedulerHotFolderFileList();
        try {
            if (!providerFile.isDirectory()) {
                throw new JobSchedulerException(String.format("%1$s isn't a directory", providerFile.getName()));
            }
        }
        catch (Exception e) {
            JobSchedulerException exception = new JobSchedulerException("SchedulerHotFolder::load", (Throwable)e);
            LOGGER.error(exception.getMessage(), (Throwable)exception);
            throw exception;
        }
        ISOSProvider provider = providerFile.getProvider();
        List entries = provider.getSubFolders(providerFile.getName(), -1, false, Pattern.compile(".*", 0), 0);
        result.setHotFolderSrc(providerFile);
        for (SOSFileEntry entry : entries) {
            if (entry.getFilename().contains(".svn")) continue;
            try {
                if (!entry.isDirectory()) continue;
                pf2 = provider.getFile(entry.getFullPath());
                LOGGER.debug("load SchedulerHotFolder = " + pf2.getName());
                result.add(this.objFactory.createSchedulerHotFolder(pf2));
            }
            catch (Exception pf2) {}
        }
        LOGGER.debug("getFilelist from: " + providerFile.getName());
        entries = provider.getFileList(providerFile.getName(), -1, false, Pattern.compile(regex, 0), null, true, null, 0);
        for (SOSFileEntry entry : entries) {
            pf2 = provider.getFile(entry.getFullPath());
            String lowerFilename = entry.getFilename().toLowerCase();
            try {
                if (entry.isDirectory()) {
                    LOGGER.debug("load SchedulerHotFolder = " + pf2.getName());
                    result.add(this.objFactory.createSchedulerHotFolder(pf2));
                    continue;
                }
                if (lowerFilename.endsWith(".job.xml")) {
                    LOGGER.debug("load JSObjJob = " + pf2.getName());
                    result.add(this.objFactory.createJob(pf2));
                    continue;
                }
                if (lowerFilename.endsWith(".job_chain.xml")) {
                    LOGGER.debug("load JSObjJobChain = " + pf2.getName());
                    result.add(this.objFactory.createJobChain(pf2));
                    continue;
                }
                if (lowerFilename.endsWith(".order.xml")) {
                    LOGGER.debug("load JSObjOrder = " + pf2.getName());
                    result.add(this.objFactory.createOrder(pf2));
                    continue;
                }
                if (lowerFilename.endsWith(".lock.xml")) {
                    LOGGER.debug("load JSObjLock = " + pf2.getName());
                    result.add(this.objFactory.createLock(pf2));
                    continue;
                }
                if (lowerFilename.endsWith(".process_class.xml")) {
                    LOGGER.debug("load JSObjProcessClass = " + pf2.getName());
                    result.add(this.objFactory.createProcessClass(pf2));
                    continue;
                }
                if (lowerFilename.endsWith(".schedule.xml")) {
                    LOGGER.debug("load JSObjSchedule = " + pf2.getName());
                    result.add(this.objFactory.createSchedule(pf2));
                    continue;
                }
                if (!lowerFilename.endsWith(".params.xml")) continue;
                LOGGER.debug("load JSObjParams = " + pf2.getName());
                result.add(this.objFactory.createParams(pf2));
            }
            catch (Exception e) {
                JobSchedulerException ex = new JobSchedulerException("SchedulerHotFolder::load", (Throwable)e);
                LOGGER.error(ex.getMessage(), (Throwable)ex);
                throw new JobSchedulerException("SchedulerHotFolder::load", (Throwable)e);
            }
        }
        this.isLoaded = true;
        LOGGER.debug(String.format("%1$s objects found in %2$s", result.getFileList().size(), providerFile.getName()));
        return result;
    }

    public SchedulerHotFolderFileList getHotFolderFileList() {
        return this.hotFolderFileList;
    }
}

