/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.model;

import com.sos.JSHelper.Basics.JSJobUtilities;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.scheduler.model.JSConfiguration;
import com.sos.scheduler.model.LiveConnector;
import com.sos.scheduler.model.SchedulerHotFolder;
import com.sos.scheduler.model.SchedulerObjectFactoryOptions;
import com.sos.scheduler.model.SchedulerSocket;
import com.sos.scheduler.model.answers.Answer;
import com.sos.scheduler.model.answers.ERROR;
import com.sos.scheduler.model.answers.HistoryEntry;
import com.sos.scheduler.model.answers.JSCmdBase;
import com.sos.scheduler.model.answers.Job;
import com.sos.scheduler.model.answers.Task;
import com.sos.scheduler.model.commands.JSCmdAddJobs;
import com.sos.scheduler.model.commands.JSCmdAddOrder;
import com.sos.scheduler.model.commands.JSCmdCheckFolders;
import com.sos.scheduler.model.commands.JSCmdClusterMemberCommand;
import com.sos.scheduler.model.commands.JSCmdCommands;
import com.sos.scheduler.model.commands.JSCmdEventsGet;
import com.sos.scheduler.model.commands.JSCmdJobChainModify;
import com.sos.scheduler.model.commands.JSCmdJobChainNodeModify;
import com.sos.scheduler.model.commands.JSCmdKillTask;
import com.sos.scheduler.model.commands.JSCmdLicenceUse;
import com.sos.scheduler.model.commands.JSCmdLockRemove;
import com.sos.scheduler.model.commands.JSCmdModifyHotFolder;
import com.sos.scheduler.model.commands.JSCmdModifyJob;
import com.sos.scheduler.model.commands.JSCmdModifyOrder;
import com.sos.scheduler.model.commands.JSCmdModifySpooler;
import com.sos.scheduler.model.commands.JSCmdParamGet;
import com.sos.scheduler.model.commands.JSCmdProcessClassRemove;
import com.sos.scheduler.model.commands.JSCmdRemoteSchedulerRemoteTaskClose;
import com.sos.scheduler.model.commands.JSCmdRemoteSchedulerStartRemoteTask;
import com.sos.scheduler.model.commands.JSCmdRemoveJobChain;
import com.sos.scheduler.model.commands.JSCmdRemoveOrder;
import com.sos.scheduler.model.commands.JSCmdScheduleRemove;
import com.sos.scheduler.model.commands.JSCmdSchedulerLogLogCategoriesReset;
import com.sos.scheduler.model.commands.JSCmdSchedulerLogLogCategoriesSet;
import com.sos.scheduler.model.commands.JSCmdShowCalendar;
import com.sos.scheduler.model.commands.JSCmdShowHistory;
import com.sos.scheduler.model.commands.JSCmdShowJob;
import com.sos.scheduler.model.commands.JSCmdShowJobChain;
import com.sos.scheduler.model.commands.JSCmdShowJobChains;
import com.sos.scheduler.model.commands.JSCmdShowJobs;
import com.sos.scheduler.model.commands.JSCmdShowOrder;
import com.sos.scheduler.model.commands.JSCmdShowState;
import com.sos.scheduler.model.commands.JSCmdShowTask;
import com.sos.scheduler.model.commands.JSCmdStartJob;
import com.sos.scheduler.model.commands.JSCmdSubsystemShow;
import com.sos.scheduler.model.commands.JSCmdSupervisorRemoteSchedulerConfigurationFetchUpdatedFiles;
import com.sos.scheduler.model.commands.JSCmdTerminate;
import com.sos.scheduler.model.exceptions.JSCommandErrorException;
import com.sos.scheduler.model.messages.JSMessages;
import com.sos.scheduler.model.objects.JSObjCluster;
import com.sos.scheduler.model.objects.JSObjCommands;
import com.sos.scheduler.model.objects.JSObjConfigurationDirectory;
import com.sos.scheduler.model.objects.JSObjConfigurationFile;
import com.sos.scheduler.model.objects.JSObjEnvironment;
import com.sos.scheduler.model.objects.JSObjHoliday;
import com.sos.scheduler.model.objects.JSObjHolidays;
import com.sos.scheduler.model.objects.JSObjInclude;
import com.sos.scheduler.model.objects.JSObjJob;
import com.sos.scheduler.model.objects.JSObjJobChain;
import com.sos.scheduler.model.objects.JSObjJobChainNodeEnd;
import com.sos.scheduler.model.objects.JSObjJobChainNodeJobChain;
import com.sos.scheduler.model.objects.JSObjJobChains;
import com.sos.scheduler.model.objects.JSObjJobSettings;
import com.sos.scheduler.model.objects.JSObjJobs;
import com.sos.scheduler.model.objects.JSObjLock;
import com.sos.scheduler.model.objects.JSObjMonthdays;
import com.sos.scheduler.model.objects.JSObjOrder;
import com.sos.scheduler.model.objects.JSObjParam;
import com.sos.scheduler.model.objects.JSObjParams;
import com.sos.scheduler.model.objects.JSObjProcessClass;
import com.sos.scheduler.model.objects.JSObjProcessClasses;
import com.sos.scheduler.model.objects.JSObjSchedule;
import com.sos.scheduler.model.objects.JSObjScript;
import com.sos.scheduler.model.objects.JSObjSecurity;
import com.sos.scheduler.model.objects.JSObjSpooler;
import com.sos.scheduler.model.objects.ObjectFactory;
import com.sos.scheduler.model.objects.Param;
import com.sos.scheduler.model.objects.Params;
import com.sos.scheduler.model.objects.Spooler;
import com.sos.vfs.common.interfaces.ISOSProviderFile;
import com.sos.xml.SOSXmlCommand;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.spooler.Variable_set;

public class SchedulerObjectFactory
extends ObjectFactory
implements Runnable {
    private static final int READ_TIME_OUT = 60;
    private static final int WRITE_TIME_OUT = 60;
    private static final Class<Spooler> DEFAULT_MARSHALLER = Spooler.class;
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulerObjectFactory.class);
    private SchedulerObjectFactoryOptions objOptions = new SchedulerObjectFactoryOptions();
    private static JAXBContext jc;
    private static JAXBContext jc4Answers;
    private final JSJobUtilities objJSJobUtilities = null;
    private LiveConnector liveConnector = null;
    private SchedulerHotFolder liveFolder;
    private Unmarshaller u;
    private Marshaller objM;
    private SchedulerSocket objSchedulerSocket = null;
    private Unmarshaller u4Answers = null;
    private Marshaller objM4Answers = null;
    private String strLastAnswer = null;
    private boolean useDefaultPeriod;
    private boolean ommitXmlDeclaration = false;
    private sos.spooler.Spooler spooler;

    public void setOmmitXmlDeclaration(boolean ommitXmlDeclaration) {
        this.ommitXmlDeclaration = ommitXmlDeclaration;
    }

    public SchedulerObjectFactory(sos.spooler.Spooler spooler) {
        super("com_sos_scheduler_model");
        this.getOptions().setTransferMethod("api");
        this.initMarshaller(DEFAULT_MARSHALLER);
        this.spooler = spooler;
        this.useDefaultPeriod = false;
    }

    public SchedulerObjectFactory() {
        super("com_sos_scheduler_model");
        this.initMarshaller(DEFAULT_MARSHALLER);
        this.useDefaultPeriod = false;
    }

    public SchedulerObjectFactory(LiveConnector liveConnector) {
        this();
        this.liveConnector = liveConnector;
        this.liveFolder = this.createSchedulerHotFolder(liveConnector.getHotFolderHandle());
    }

    public SchedulerObjectFactory(String pstrServerName, int pintPort) {
        this();
        this.getOptions().setTransferMethod("tcp");
        this.getOptions().ServerName.setValue(pstrServerName);
        this.getOptions().PortNumber.value(pintPort);
        this.initMarshaller(DEFAULT_MARSHALLER);
    }

    public SchedulerObjectFactory(String commandUrl) {
        this();
        this.getOptions().setTransferMethod("http");
        this.getOptions().commandUrl.setValue(commandUrl);
        this.initMarshaller(DEFAULT_MARSHALLER);
    }

    public SchedulerObjectFactory(String commandUrl, String basicAuthorization) {
        this();
        this.getOptions().setTransferMethod("https");
        this.getOptions().commandUrl.setValue(commandUrl);
        this.getOptions().basicAuthorization.setValue(basicAuthorization);
        this.initMarshaller(DEFAULT_MARSHALLER);
    }

    public SchedulerObjectFactory(String pstrServerName, int pintPort, LiveConnector liveConnector) {
        this(pstrServerName, pintPort);
        this.liveConnector = liveConnector;
        this.liveFolder = this.createSchedulerHotFolder(liveConnector.getHotFolderHandle());
    }

    public String getLastAnswer() {
        return this.strLastAnswer;
    }

    @Override
    public void run() {
    }

    private boolean isJSJobUtilitiesChanged() {
        boolean flgRet = false;
        if (this.objJSJobUtilities != null && !this.objJSJobUtilities.equals(this)) {
            flgRet = true;
        }
        return flgRet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Answer run(JSCmdBase pobjJSCmd) {
        String xmlCommand;
        Answer objAnswer;
        block14: {
            String conMethodName = "SchedulerObjectFactory::run";
            objAnswer = null;
            xmlCommand = pobjJSCmd.toXMLString();
            try {
                LOGGER.trace(JSMessages.JOM_D_0010.get(new Object[]{"SchedulerObjectFactory::run", xmlCommand}));
                if (this.isJSJobUtilitiesChanged()) break block14;
                if (this.objOptions.TransferMethod.isApi()) {
                    objAnswer = this.getAnswerFromSpooler(pobjJSCmd);
                    break block14;
                }
                if (this.objOptions.TransferMethod.isHttp()) {
                    SOSXmlCommand sosXmlCommand = new SOSXmlCommand(this.objOptions.getCommandUrl().getValue());
                    LOGGER.trace("Request sended to JobScheduler:\n" + xmlCommand);
                    String answer = sosXmlCommand.executeXMLPost(xmlCommand);
                    LOGGER.trace("Answer from JobScheduler:\n" + answer);
                    objAnswer = this.getAnswer(answer);
                    break block14;
                }
                if (this.objOptions.TransferMethod.isHttps()) {
                    SOSXmlCommand sosXmlCommand = new SOSXmlCommand(this.objOptions.getCommandUrl().getValue());
                    LOGGER.trace("Request sended to JobScheduler:\n" + xmlCommand);
                    sosXmlCommand.setBasicAuthorization(this.objOptions.basicAuthorization.getValue());
                    sosXmlCommand.setConnectTimeout(60);
                    sosXmlCommand.setReadTimeout(60);
                    String answer = sosXmlCommand.executeXMLPost(xmlCommand);
                    LOGGER.trace("Answer from JobScheduler:\n" + answer);
                    objAnswer = this.getAnswer(answer);
                    break block14;
                }
                if (this.objOptions.TransferMethod.isTcp()) {
                    this.getSocket().setSoTimeout(30000);
                    this.getSocket().sendRequest(xmlCommand);
                    LOGGER.trace("Request sended to JobScheduler:\n" + xmlCommand);
                    String answer = this.getSocket().getResponse();
                    LOGGER.trace("Answer from JobScheduler:\n" + answer);
                    objAnswer = this.getAnswer(answer);
                    break block14;
                }
                if (!this.objOptions.TransferMethod.isUdp()) {
                    throw new JobSchedulerException(String.format("TransferMethod '%1$s' not supported (yet)", this.objOptions.TransferMethod.getValue()));
                }
                DatagramSocket udpSocket = null;
                int intPortNumber = 0;
                try {
                    udpSocket = new DatagramSocket();
                    intPortNumber = this.objOptions.PortNumber.value();
                    InetAddress objInetAddress = this.objOptions.ServerName.getInetAddress();
                    udpSocket.connect(objInetAddress, intPortNumber);
                    if (xmlCommand.indexOf("<?xml") == -1) {
                        xmlCommand = "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>" + xmlCommand;
                    }
                    byte[] btyBuffer = xmlCommand.getBytes();
                    udpSocket.send(new DatagramPacket(btyBuffer, btyBuffer.length, objInetAddress, intPortNumber));
                    if (udpSocket == null) break block14;
                }
                catch (Exception e) {
                    try {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (udpSocket != null) {
                            LOGGER.trace(JSMessages.JOM_D_0020.get(new Object[]{this.objOptions.ServerName.toString(), intPortNumber}));
                            udpSocket.disconnect();
                            udpSocket = null;
                        }
                        throw throwable;
                    }
                }
                LOGGER.trace(JSMessages.JOM_D_0020.get(new Object[]{this.objOptions.ServerName.toString(), intPortNumber}));
                udpSocket.disconnect();
                udpSocket = null;
            }
            catch (Exception e) {
                throw new JobSchedulerException(String.format("%1$s: %2$s", "SchedulerObjectFactory::run", e.getMessage()), (Throwable)e);
            }
        }
        if (objAnswer != null && objAnswer.getERROR() != null) {
            throw new JobSchedulerException(this.Messages.getMsg("JOM_E_0010") + "\ncommand:\n" + xmlCommand + "\nanswer:\n" + this.strLastAnswer);
        }
        return objAnswer;
    }

    public Answer getAnswerFromSpooler(JSCmdBase pobjJSCmd) {
        String command = pobjJSCmd.toXMLString();
        this.strLastAnswer = this.spooler.execute_xml(command);
        LOGGER.trace("Answer from JobScheduler:\n" + this.strLastAnswer);
        Answer objAnswer = this.getAnswer(this.strLastAnswer);
        return objAnswer;
    }

    public Answer getAnswer(String pXMLStr) {
        String conMethodName = "SchedulerObjectFactory::getAnswer";
        if (JSCmdBase.flgLogXML) {
            LOGGER.trace(String.format("%1$s: Response: %n%2$s", "SchedulerObjectFactory::getAnswer", pXMLStr));
        }
        Answer objAnswer = null;
        com.sos.scheduler.model.answers.Spooler objSpooler = null;
        try {
            if (jc4Answers == null) {
                jc4Answers = JAXBContext.newInstance((Class[])new Class[]{com.sos.scheduler.model.answers.Spooler.class});
            }
            if (this.u4Answers == null) {
                this.u4Answers = jc4Answers.createUnmarshaller();
            }
            objSpooler = (com.sos.scheduler.model.answers.Spooler)this.u4Answers.unmarshal((Reader)new StringReader(pXMLStr));
            if (this.objM4Answers == null) {
                this.objM4Answers = jc4Answers.createMarshaller();
            }
        }
        catch (Exception e) {
            throw new JobSchedulerException(String.format("can't get answer object from %n%1$s", pXMLStr), (Throwable)e);
        }
        if (objSpooler != null) {
            objAnswer = objSpooler.getAnswer();
        }
        return objAnswer;
    }

    public void initMarshaller(Class<?> objC) {
        try {
            if (jc == null) {
                jc = JAXBContext.newInstance((Class[])new Class[]{objC});
            }
            this.u = jc.createUnmarshaller();
            this.objM = jc.createMarshaller();
        }
        catch (JAXBException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void initMarshaller(String context) {
        try {
            if (jc == null) {
                jc = JAXBContext.newInstance((String)context);
            }
            this.u = jc.createUnmarshaller();
            this.objM = jc.createMarshaller();
        }
        catch (JAXBException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void initAnswerMarshaller() {
        try {
            if (jc4Answers == null) {
                jc4Answers = JAXBContext.newInstance((Class[])new Class[]{com.sos.scheduler.model.answers.Spooler.class});
            }
            if (this.u4Answers == null) {
                this.u4Answers = jc4Answers.createUnmarshaller();
            }
            if (this.objM4Answers == null) {
                this.objM4Answers = jc4Answers.createMarshaller();
            }
        }
        catch (JAXBException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public Object unMarshall(File pobjFile) {
        Object objC = null;
        try {
            try {
                objC = this.u.unmarshal((InputStream)new FileInputStream(pobjFile));
            }
            catch (FileNotFoundException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        catch (JAXBException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return objC;
    }

    public Object unMarshall(ISOSProviderFile pobjVirtualFile) {
        Object objC = null;
        if (pobjVirtualFile != null) {
            InputStream objInputStream = pobjVirtualFile.getFileInputStream();
            try {
                if (objInputStream == null) {
                    LOGGER.error(String.format("can't get inputstream for file '%1$s'.", pobjVirtualFile.getName()));
                    throw new JobSchedulerException(String.format("can't get inputstream for file '%1$s'.", pobjVirtualFile.getName()));
                }
                objC = this.u.unmarshal(objInputStream);
            }
            catch (JAXBException e) {
                throw new JobSchedulerException(e.getMessage(), (Throwable)e);
            }
            finally {
                pobjVirtualFile.closeInput();
            }
        } else {
            LOGGER.error("pobjVirtualFile is null");
            throw new JobSchedulerException("pobjVirtualFile is null");
        }
        return objC;
    }

    public Object unMarshall(InputStream pobjInputStream) {
        Object objC = null;
        try {
            objC = this.u.unmarshal(pobjInputStream);
        }
        catch (JAXBException e) {
            throw new JobSchedulerException(e.getMessage(), (Throwable)e);
        }
        return objC;
    }

    public Object unMarshall(String pstrXMLContent) {
        Object objC = null;
        try {
            objC = this.u.unmarshal((Reader)new StringReader(pstrXMLContent));
        }
        catch (JAXBException e) {
            throw new JobSchedulerException(e.getMessage(), (Throwable)e);
        }
        return objC;
    }

    public Object marshal(Object objO, File objF) {
        try {
            XMLSerializer serializer = this.getXMLSerializer();
            FileOutputStream objFOS = new FileOutputStream(objF);
            serializer.setOutputByteStream((OutputStream)objFOS);
            this.objM.marshal(objO, serializer.asContentHandler());
        }
        catch (JAXBException e) {
            throw new JobSchedulerException(e.getMessage(), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new JobSchedulerException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new JobSchedulerException(e.getMessage(), (Throwable)e);
        }
        return objO;
    }

    public String marshal(Object objO) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        try {
            XMLSerializer serializer = this.getXMLSerializer();
            serializer.setOutputByteStream((OutputStream)out);
            this.objM.marshal(objO, serializer.asContentHandler());
        }
        catch (JAXBException e) {
            throw new JobSchedulerException(e.getMessage(), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new JobSchedulerException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new JobSchedulerException(e.getMessage(), (Throwable)e);
        }
        return baos.toString();
    }

    public Object toXMLFile(Object objO, ISOSProviderFile pobjVirtualFile) {
        if (pobjVirtualFile != null) {
            OutputStream objOutputStream = pobjVirtualFile.getProvider().getOutputStream(pobjVirtualFile.getName(), false, false);
            try {
                if (objOutputStream == null) {
                    LOGGER.error(String.format("can't get outputstream for file '%1$s'.", pobjVirtualFile.getName()));
                    throw new JobSchedulerException(String.format("can't get outputstream for file '%1$s'.", pobjVirtualFile.getName()));
                }
                XMLSerializer serializer = this.getXMLSerializer();
                serializer.setOutputByteStream(objOutputStream);
                this.objM.marshal(objO, serializer.asContentHandler());
            }
            catch (JAXBException e) {
                throw new JobSchedulerException(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                throw new JobSchedulerException(e.getMessage(), (Throwable)e);
            }
            finally {
                pobjVirtualFile.closeOutput();
            }
        } else {
            LOGGER.error("pobjVirtualFile is null");
            throw new JobSchedulerException("pobjVirtualFile is null");
        }
        return objO;
    }

    private String toXMLString(Object objO, Marshaller objMarshaller) {
        String strT = "";
        try {
            XMLSerializer serializer = this.getXMLSerializer();
            OutputFormat objOutputFormat = new OutputFormat();
            objOutputFormat.setEncoding("utf-8");
            objOutputFormat.setIndenting(true);
            objOutputFormat.setIndent(4);
            objOutputFormat.setOmitXMLDeclaration(this.ommitXmlDeclaration);
            objOutputFormat.setLineWidth(80);
            serializer.setOutputFormat(objOutputFormat);
            StringWriter objSW = new StringWriter();
            serializer.setOutputCharStream((Writer)objSW);
            objMarshaller.marshal(objO, serializer.asContentHandler());
            strT = objSW.getBuffer().toString();
        }
        catch (JAXBException e) {
            throw new JobSchedulerException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new JobSchedulerException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new JobSchedulerException(e.getMessage(), (Throwable)e);
        }
        return strT;
    }

    public String toXMLString(Object objO) {
        if (objO.getClass().getName().startsWith("com.sos.scheduler.model.answers.")) {
            return this.answerToXMLString(objO);
        }
        if (objO.getClass().getName().startsWith("com.sos.scheduler.model.commands.")) {
            return this.cmdToXMLString(objO);
        }
        return this.toXMLString(objO, this.objM);
    }

    public String answerToXMLString(Object objO) {
        this.initAnswerMarshaller();
        return this.toXMLString(objO, this.objM4Answers);
    }

    private String cmdToXMLString(Object objO) {
        StringWriter s = new StringWriter();
        try {
            this.objM.setProperty("jaxb.formatted.output", (Object)true);
            this.objM.setProperty("jaxb.encoding", (Object)"UTF-8");
            this.objM.setProperty("jaxb.fragment", (Object)this.ommitXmlDeclaration);
            this.objM.marshal(objO, (Writer)s);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        return s.toString();
    }

    private XMLSerializer getXMLSerializer() {
        OutputFormat of = new OutputFormat();
        of.setCDataElements(new String[]{"^description", "^script", "^scheduler_script", "^log_mail_to", "^log_mail_cc", "^log_mail_bcc"});
        of.setIndenting(true);
        XMLSerializer serializer = new XMLSerializer(of);
        return serializer;
    }

    public SchedulerObjectFactoryOptions getOptions() {
        if (this.objOptions == null) {
            this.objOptions = new SchedulerObjectFactoryOptions();
        }
        return this.objOptions;
    }

    public SchedulerSocket getSocket() {
        if (this.objSchedulerSocket == null) {
            try {
                this.objSchedulerSocket = new SchedulerSocket(this.objOptions);
            }
            catch (Exception e) {
                throw new JobSchedulerException(e.getMessage(), (Throwable)e);
            }
        }
        return this.objSchedulerSocket;
    }

    public void closeSocket() {
        if (this.objSchedulerSocket != null) {
            try {
                this.objSchedulerSocket.close();
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            this.objSchedulerSocket = null;
        }
    }

    public Params setParams(Variable_set pobjProperties) {
        String strParamValue = "";
        Params objParams = super.createParams();
        for (String strKey : pobjProperties.names().split(";")) {
            strParamValue = pobjProperties.value(strKey);
            Param objP = this.createParam(strKey, strParamValue);
            objParams.getParamOrCopyParamsOrInclude().add(objP);
        }
        return objParams;
    }

    public Params setParams(Properties pobjProperties) {
        Params objParams = super.createParams();
        for (Map.Entry<Object, Object> element : pobjProperties.entrySet()) {
            Param objP = this.createParam(element.getKey().toString(), element.getValue().toString());
            objParams.getParamOrCopyParamsOrInclude().add(objP);
        }
        return objParams;
    }

    public Params setParams(Map<String, String> params) {
        Params objParams = super.createParams();
        for (Map.Entry<String, String> element : params.entrySet()) {
            Param param = this.createParam(element.getKey(), element.getValue());
            objParams.getParamOrCopyParamsOrInclude().add(param);
        }
        return objParams;
    }

    public Params setParams(String[] pstrParamArray) {
        String strParamValue = "";
        Params objParams = super.createParams();
        for (int i = 0; i < pstrParamArray.length; i += 2) {
            String strParamName = pstrParamArray[i];
            strParamValue = i + 1 >= pstrParamArray.length ? "" : pstrParamArray[i + 1];
            Param objP = this.createParam(strParamName, strParamValue);
            objParams.getParamOrCopyParamsOrInclude().add(objP);
        }
        return objParams;
    }

    @Override
    public JSObjParam createParam() {
        JSObjParam objParam = new JSObjParam(this);
        return objParam;
    }

    public JSObjParam createParam(Param param) {
        JSObjParam objParam = new JSObjParam(this, param);
        return objParam;
    }

    public Param createParam(String pstrParamName, String pstrParamValue) {
        Param objP = super.createParam();
        objP.setName(pstrParamName);
        objP.setValue(pstrParamValue);
        return objP;
    }

    public JSConfiguration createJSConfiguration() {
        JSConfiguration objJSC = new JSConfiguration(this);
        return objJSC;
    }

    public JSConfiguration createJSConfiguration(ISOSProviderFile pobjVirtualFile) {
        JSConfiguration objJSC = new JSConfiguration(this, pobjVirtualFile);
        return objJSC;
    }

    public SchedulerHotFolder createSchedulerHotFolder(ISOSProviderFile objDir) {
        SchedulerHotFolder objSchedulerHotFolder = new SchedulerHotFolder(this, objDir);
        return objSchedulerHotFolder;
    }

    @Override
    public JSObjJob createJob() {
        JSObjJob objJob = new JSObjJob(this);
        return objJob;
    }

    public JSObjJob createJob(String pstrJobName) {
        JSObjJob objJob = new JSObjJob(this);
        objJob.setName(pstrJobName);
        return objJob;
    }

    public JSObjJob createStandAloneJob(String pstrJobName) {
        JSObjJob objJob = new JSObjJob(this);
        objJob.setName(pstrJobName);
        objJob.setOrder(false);
        return objJob;
    }

    public JSObjJob createJob(ISOSProviderFile pobjVirtualFile) {
        JSObjJob objJob = new JSObjJob(this, pobjVirtualFile);
        return objJob;
    }

    public JSObjParams createParams(ISOSProviderFile pobjVirtualFile) {
        JSObjParams objParams = new JSObjParams(this, pobjVirtualFile);
        return objParams;
    }

    @Override
    public JSObjParams createParams() {
        JSObjParams objParams = new JSObjParams(this);
        return objParams;
    }

    public JSObjParams createParams(Params params) {
        JSObjParams objParams = new JSObjParams(this, params);
        return objParams;
    }

    @Override
    public JSObjJobChain createJobChain() {
        JSObjJobChain objJobChain = new JSObjJobChain(this);
        return objJobChain;
    }

    public JSObjJobChain createJobChain(ISOSProviderFile pobjVirtualFile) {
        JSObjJobChain objJobChain = new JSObjJobChain(this, pobjVirtualFile);
        return objJobChain;
    }

    @Override
    public JSObjJobChains createJobChains() {
        JSObjJobChains objJobChains = new JSObjJobChains(this);
        return objJobChains;
    }

    @Override
    public JSObjJobChainNodeEnd createJobChainNodeEnd() {
        JSObjJobChainNodeEnd objJobChainNodeEnd = new JSObjJobChainNodeEnd(this);
        return objJobChainNodeEnd;
    }

    @Override
    public JSObjJobChainNodeJobChain createJobChainNodeJobChain() {
        JSObjJobChainNodeJobChain objJobChainNodeJobChain = new JSObjJobChainNodeJobChain(this);
        return objJobChainNodeJobChain;
    }

    @Override
    public JSObjJobs createJobs() {
        JSObjJobs objJobs = new JSObjJobs(this);
        return objJobs;
    }

    @Override
    public JSObjJobSettings createJobSettings() {
        JSObjJobSettings objJobSettings = new JSObjJobSettings(this);
        return objJobSettings;
    }

    @Override
    public JSObjHolidays createHolidays() {
        JSObjHolidays objHolidays = new JSObjHolidays(this);
        return objHolidays;
    }

    @Override
    public JSObjHoliday createHoliday() {
        JSObjHoliday objHoliday = new JSObjHoliday(this);
        return objHoliday;
    }

    @Override
    public JSObjMonthdays createMonthdays() {
        JSObjMonthdays objMonthdays = new JSObjMonthdays(this);
        return objMonthdays;
    }

    @Override
    public JSObjLock createLock() {
        JSObjLock objLock = new JSObjLock(this);
        return objLock;
    }

    public JSObjLock createLock(ISOSProviderFile pobjVirtualFile) {
        JSObjLock objLock = new JSObjLock(this, pobjVirtualFile);
        return objLock;
    }

    @Override
    public JSObjCluster createCluster() {
        JSObjCluster objCluster = new JSObjCluster(this);
        return objCluster;
    }

    @Override
    public JSCmdClusterMemberCommand createClusterMemberCommand() {
        JSCmdClusterMemberCommand objCMC = new JSCmdClusterMemberCommand(this);
        return objCMC;
    }

    @Override
    public JSObjSecurity createSecurity() {
        JSObjSecurity objSecurity = new JSObjSecurity(this);
        return objSecurity;
    }

    @Override
    public JSObjSpooler createSpooler() {
        JSObjSpooler objSpooler = new JSObjSpooler(this);
        return objSpooler;
    }

    public JSObjSpooler createSpooler(ISOSProviderFile pobjVirtualFile) {
        JSObjSpooler objSpooler = new JSObjSpooler(this, pobjVirtualFile);
        return objSpooler;
    }

    @Override
    public JSObjOrder createOrder() {
        JSObjOrder objOrder = new JSObjOrder(this);
        return objOrder;
    }

    public JSObjOrder createOrder(ISOSProviderFile pobjVirtualFile) {
        JSObjOrder objOrder = new JSObjOrder(this, pobjVirtualFile);
        try {
            String s = pobjVirtualFile.getName();
            s = new File(s).getName();
            s = s.replaceFirst(".*,(.*)\\.order\\.xml", "$1");
            objOrder.setId(s);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return objOrder;
    }

    public JSObjHolidays createHolidays(ISOSProviderFile pobjVirtualFile) {
        JSObjHolidays objHolidays = new JSObjHolidays(this, pobjVirtualFile);
        return objHolidays;
    }

    public JSObjSchedule createSchedule() {
        JSObjSchedule objSchedule = new JSObjSchedule(this);
        return objSchedule;
    }

    public JSObjSchedule createSchedule(ISOSProviderFile pobjVirtualFile) {
        JSObjSchedule objSchedule = new JSObjSchedule(this, pobjVirtualFile);
        return objSchedule;
    }

    @Override
    public JSObjProcessClass createProcessClass() {
        JSObjProcessClass objProcessClass = new JSObjProcessClass(this);
        return objProcessClass;
    }

    public JSObjProcessClass createProcessClass(ISOSProviderFile pobjVirtualFile) {
        JSObjProcessClass objProcessClass = new JSObjProcessClass(this, pobjVirtualFile);
        return objProcessClass;
    }

    @Override
    public JSObjProcessClasses createProcessClasses() {
        JSObjProcessClasses objProcessClasses = new JSObjProcessClasses(this);
        return objProcessClasses;
    }

    @Override
    public JSObjEnvironment createEnvironment() {
        JSObjEnvironment objEnvironment = new JSObjEnvironment(this);
        return objEnvironment;
    }

    @Override
    public JSCmdScheduleRemove createScheduleRemove() {
        JSCmdScheduleRemove objScheduleRemove = new JSCmdScheduleRemove(this);
        return objScheduleRemove;
    }

    @Override
    public JSCmdRemoteSchedulerStartRemoteTask createRemoteSchedulerStartRemoteTask() {
        JSCmdRemoteSchedulerStartRemoteTask objRemoteSchedulerStartRemoteTask = new JSCmdRemoteSchedulerStartRemoteTask(this);
        return objRemoteSchedulerStartRemoteTask;
    }

    @Override
    public JSCmdKillTask createKillTask() {
        JSCmdKillTask objKillTask = new JSCmdKillTask(this);
        return objKillTask;
    }

    @Override
    public JSObjScript createScript() {
        JSObjScript objScript = new JSObjScript(this);
        return objScript;
    }

    @Override
    public JSObjInclude createInclude() {
        JSObjInclude objInclude = new JSObjInclude(this);
        return objInclude;
    }

    @Override
    public JSObjCommands createCommands() {
        JSObjCommands objCommands = new JSObjCommands(this);
        return objCommands;
    }

    @Override
    public JSObjConfigurationDirectory createConfigurationDirectory() {
        JSObjConfigurationDirectory objConfigurationDirectory = new JSObjConfigurationDirectory(this);
        return objConfigurationDirectory;
    }

    @Override
    public JSObjConfigurationFile createConfigurationFile() {
        JSObjConfigurationFile objConfigurationFile = new JSObjConfigurationFile(this);
        return objConfigurationFile;
    }

    @Override
    public JSCmdSubsystemShow createSubsystemShow() {
        JSCmdSubsystemShow objSubsystemShow = new JSCmdSubsystemShow(this);
        return objSubsystemShow;
    }

    @Override
    public JSCmdStartJob createStartJob() {
        JSCmdStartJob objStartJobCmd = new JSCmdStartJob(this);
        return objStartJobCmd;
    }

    public JSCmdStartJob createStartJob(String pstrJobName) {
        JSCmdStartJob objStartJobCmd = new JSCmdStartJob(this);
        objStartJobCmd.setJob(pstrJobName);
        return objStartJobCmd;
    }

    public JSCmdStartJob startJob(String pstrJobName) {
        JSCmdStartJob objStartJobCmd = new JSCmdStartJob(this);
        objStartJobCmd.setJob(pstrJobName);
        objStartJobCmd.setForce(true);
        objStartJobCmd.run();
        objStartJobCmd.getAnswerWithException();
        return objStartJobCmd;
    }

    public JSCmdStartJob startJob(String pstrJobName, boolean raiseOk) {
        JSCmdStartJob objStartJobCmd = new JSCmdStartJob(this);
        objStartJobCmd.setJob(pstrJobName);
        objStartJobCmd.setForce(true);
        objStartJobCmd.run();
        JSCmdStartJob.flgRaiseOKException = raiseOk;
        objStartJobCmd.getAnswerWithException();
        return objStartJobCmd;
    }

    @Override
    public JSCmdShowCalendar createShowCalendar() {
        JSCmdShowCalendar objShowCalendarCmd = new JSCmdShowCalendar(this);
        return objShowCalendarCmd;
    }

    @Override
    public JSCmdShowState createShowState() {
        JSCmdShowState objShowStateCmd = new JSCmdShowState(this);
        return objShowStateCmd;
    }

    public JSCmdShowState createShowState(enu4What enuWhat) {
        JSCmdShowState objShowStateCmd = new JSCmdShowState(this);
        objShowStateCmd.setWhat(enuWhat);
        return objShowStateCmd;
    }

    public JSCmdShowState createShowState(enu4What[] enuWhat) {
        JSCmdShowState objShowStateCmd = new JSCmdShowState(this);
        objShowStateCmd.setWhat(enuWhat);
        return objShowStateCmd;
    }

    @Override
    public JSCmdShowJob createShowJob() {
        JSCmdShowJob objShowJobCmd = new JSCmdShowJob(this);
        return objShowJobCmd;
    }

    public JSCmdShowJob createShowJob(String pstrJobName) {
        JSCmdShowJob objShowJobCmd = this.createShowJob();
        objShowJobCmd.setJob(pstrJobName);
        objShowJobCmd.setWhat(new JSCmdShowJob.enu4What[]{JSCmdShowJob.enu4What.log, JSCmdShowJob.enu4What.task_queue});
        objShowJobCmd.maxTaskHistory(1);
        objShowJobCmd.maxOrders(1);
        return objShowJobCmd;
    }

    public JSCmdShowJob createShowJob(String pstrJobName, JSCmdShowJob.enu4What[] penuWhat) {
        JSCmdShowJob objShowJobCmd = new JSCmdShowJob(this);
        objShowJobCmd.setJob(pstrJobName);
        objShowJobCmd.setWhat(penuWhat);
        objShowJobCmd.maxTaskHistory(1);
        objShowJobCmd.maxOrders(1);
        return objShowJobCmd;
    }

    public JSCmdShowJob getTaskQueue(String pstrJobName) {
        JSCmdShowJob objShowJobCmd = this.createShowJob(pstrJobName, new JSCmdShowJob.enu4What[]{JSCmdShowJob.enu4What.task_queue});
        objShowJobCmd = this.executeShowJob(objShowJobCmd);
        return objShowJobCmd;
    }

    public JSCmdShowJob isJobRunning(String pstrJobName) {
        JSCmdShowJob objShowJob = this.createShowJob(pstrJobName);
        return this.executeShowJob(objShowJob);
    }

    public String getTaskLogFromShowHistory(String pstrJobName, int pintTaskId) {
        HistoryEntry objEntry;
        String log = null;
        JSCmdShowHistory objHist = this.createShowHistory();
        objHist.setJob(pstrJobName);
        objHist.setId(BigInteger.valueOf(pintTaskId));
        objHist.setWhat("log");
        objHist.run();
        Answer objAnswer = objHist.getAnswer();
        List<HistoryEntry> objEntries = objAnswer.getHistory().getHistoryEntry();
        if (objEntries != null && !objEntries.isEmpty() && (objEntry = objEntries.get(0)) != null) {
            log = objEntry.getLog().getContent();
        }
        return log;
    }

    public String getTaskLogFromShowJob(String pstrJobName, int pintTaskId) {
        String log = null;
        JSCmdShowJob objShowJob = this.createShowJob();
        objShowJob.setJob(pstrJobName);
        objShowJob.setWhat(JSCmdShowJob.enu4What.log);
        objShowJob.run();
        Answer objAnswer = objShowJob.getAnswer();
        Job objJobAnswer = objAnswer.getJob();
        List<Task> tasks = objJobAnswer.getTasks().getTask();
        for (Task task : tasks) {
            if (task.getId().compareTo(BigInteger.valueOf(pintTaskId)) != 0) continue;
            log = task.getLog().getContent();
            break;
        }
        return log;
    }

    public String getTaskLog(String pstrJobName, int pintTaskId, boolean pbUseCurrentTaskLog) {
        String log = null;
        if (pbUseCurrentTaskLog) {
            log = this.getTaskLogFromShowJob(pstrJobName, pintTaskId);
            if (log == null) {
                log = this.getTaskLogFromShowHistory(pstrJobName, pintTaskId);
            }
        } else {
            log = this.getTaskLogFromShowHistory(pstrJobName, pintTaskId);
            if (log == null) {
                log = this.getTaskLogFromShowJob(pstrJobName, pintTaskId);
            }
        }
        return log;
    }

    public JSCmdShowJob executeShowJob(JSCmdShowJob pobjShowJob) {
        boolean flgJobIsRunning = false;
        pobjShowJob.run();
        Answer objAnswer = pobjShowJob.getAnswer();
        if (objAnswer != null) {
            ERROR objError = objAnswer.getERROR();
            if (objError != null) {
                throw new JSCommandErrorException(objError.getText());
            }
            Job objJobAnswer = objAnswer.getJob();
            String strJobState = objJobAnswer.getState();
            String pstrJobName = pobjShowJob.getJobName();
            if (!"running".equalsIgnoreCase(strJobState)) {
                LOGGER.debug(JSMessages.JOM_D_0030.get(new Object[]{pstrJobName, strJobState}));
                flgJobIsRunning = false;
            } else {
                LOGGER.debug(JSMessages.JOM_D_0040.get(new Object[]{pstrJobName}));
                int intNoOfTasks = objJobAnswer.getTasks().getCount().intValue();
                if (intNoOfTasks > 0) {
                    flgJobIsRunning = true;
                }
            }
        }
        if (!flgJobIsRunning) {
            return null;
        }
        return pobjShowJob;
    }

    @Override
    public JSCmdShowJobs createShowJobs() {
        JSCmdShowJobs objShowJobsCmd = new JSCmdShowJobs(this);
        return objShowJobsCmd;
    }

    public JSCmdShowJobs createShowJobs(enu4What ... enuWhat) {
        JSCmdShowJobs objShowJobsCmd = new JSCmdShowJobs(this);
        objShowJobsCmd.setWhat(enuWhat);
        return objShowJobsCmd;
    }

    @Override
    public JSCmdShowTask createShowTask() {
        JSCmdShowTask objShowTaskCmd = new JSCmdShowTask(this);
        return objShowTaskCmd;
    }

    public JSCmdShowTask createShowTask(enu4What enuWhat) {
        JSCmdShowTask objShowTaskCmd = new JSCmdShowTask(this);
        objShowTaskCmd.setWhat(enuWhat);
        return objShowTaskCmd;
    }

    public JSCmdShowTask createShowTask(enu4What[] enuWhat) {
        JSCmdShowTask objShowTaskCmd = new JSCmdShowTask(this);
        objShowTaskCmd.setWhat(enuWhat);
        return objShowTaskCmd;
    }

    @Override
    public JSCmdShowOrder createShowOrder() {
        JSCmdShowOrder objShowOrderCmd = new JSCmdShowOrder(this);
        return objShowOrderCmd;
    }

    @Override
    public JSCmdShowJobChain createShowJobChain() {
        JSCmdShowJobChain objShowJobChainCmd = new JSCmdShowJobChain(this);
        return objShowJobChainCmd;
    }

    @Override
    public JSCmdShowJobChains createShowJobChains() {
        JSCmdShowJobChains objShowJobChainsCmd = new JSCmdShowJobChains(this);
        return objShowJobChainsCmd;
    }

    @Override
    public JSCmdShowHistory createShowHistory() {
        JSCmdShowHistory objShowHistoryCmd = new JSCmdShowHistory(this);
        return objShowHistoryCmd;
    }

    @Override
    public JSCmdModifyJob createModifyJob() {
        JSCmdModifyJob objModifyJob = new JSCmdModifyJob(this);
        return objModifyJob;
    }

    @Override
    public JSCmdJobChainModify createJobChainModify() {
        JSCmdJobChainModify objJobChainModify = new JSCmdJobChainModify(this);
        return objJobChainModify;
    }

    @Override
    public JSCmdRemoveJobChain createRemoveJobChain() {
        JSCmdRemoveJobChain objRemoveJobChain = new JSCmdRemoveJobChain(this);
        return objRemoveJobChain;
    }

    @Override
    public JSCmdProcessClassRemove createProcessClassRemove() {
        JSCmdProcessClassRemove objProcessClassRemove = new JSCmdProcessClassRemove(this);
        return objProcessClassRemove;
    }

    @Override
    public JSCmdCheckFolders createCheckFolders() {
        JSCmdCheckFolders objCheckFolders = new JSCmdCheckFolders(this);
        return objCheckFolders;
    }

    @Override
    public JSCmdModifySpooler createModifySpooler() {
        JSCmdModifySpooler objModifySpooler = new JSCmdModifySpooler(this);
        return objModifySpooler;
    }

    @Override
    public JSCmdEventsGet createEventsGet() {
        JSCmdEventsGet objEventsGet = new JSCmdEventsGet(this);
        return objEventsGet;
    }

    @Override
    public JSCmdRemoveOrder createRemoveOrder() {
        JSCmdRemoveOrder objRemoveOrder = new JSCmdRemoveOrder(this);
        return objRemoveOrder;
    }

    @Override
    public JSCmdSchedulerLogLogCategoriesReset createSchedulerLogLogCategoriesReset() {
        JSCmdSchedulerLogLogCategoriesReset objSchedulerLogLogCategoriesReset = new JSCmdSchedulerLogLogCategoriesReset(this);
        return objSchedulerLogLogCategoriesReset;
    }

    @Override
    public JSCmdTerminate createTerminate() {
        JSCmdTerminate objTerminate = new JSCmdTerminate(this);
        return objTerminate;
    }

    @Override
    public JSCmdRemoteSchedulerRemoteTaskClose createRemoteSchedulerRemoteTaskClose() {
        JSCmdRemoteSchedulerRemoteTaskClose objRemoteSchedulerRemoteTaskClose = new JSCmdRemoteSchedulerRemoteTaskClose(this);
        return objRemoteSchedulerRemoteTaskClose;
    }

    @Override
    public JSCmdLockRemove createLockRemove() {
        JSCmdLockRemove objLockRemove = new JSCmdLockRemove(this);
        return objLockRemove;
    }

    @Override
    public JSCmdSupervisorRemoteSchedulerConfigurationFetchUpdatedFiles createSupervisorRemoteSchedulerConfigurationFetchUpdatedFiles() {
        JSCmdSupervisorRemoteSchedulerConfigurationFetchUpdatedFiles objSupervisorRemoteSchedulerConfigurationFetchUpdatedFiles = new JSCmdSupervisorRemoteSchedulerConfigurationFetchUpdatedFiles(this);
        return objSupervisorRemoteSchedulerConfigurationFetchUpdatedFiles;
    }

    @Override
    public JSCmdJobChainNodeModify createJobChainNodeModify() {
        JSCmdJobChainNodeModify objJobChainNodeModify = new JSCmdJobChainNodeModify(this);
        return objJobChainNodeModify;
    }

    @Override
    public JSCmdModifyOrder createModifyOrder() {
        JSCmdModifyOrder objModifyOrder = new JSCmdModifyOrder(this);
        return objModifyOrder;
    }

    public JSCmdModifyOrder startOrder(String pstrJobChainName, String pstrOrderName) {
        JSCmdModifyOrder objModifyOrder = new JSCmdModifyOrder(this);
        objModifyOrder.setJobChain(pstrJobChainName);
        objModifyOrder.setOrder(pstrOrderName);
        objModifyOrder.setAt("now");
        objModifyOrder.run();
        objModifyOrder.getAnswerWithException();
        return objModifyOrder;
    }

    public JSCmdModifyOrder startOrder(String pstrJobChainName, String pstrOrderName, boolean raiseOk) {
        JSCmdModifyOrder objModifyOrder = new JSCmdModifyOrder(this);
        objModifyOrder.setJobChain(pstrJobChainName);
        objModifyOrder.setOrder(pstrOrderName);
        objModifyOrder.setAt("now");
        objModifyOrder.run();
        JSCmdModifyOrder.flgRaiseOKException = raiseOk;
        objModifyOrder.getAnswerWithException();
        return objModifyOrder;
    }

    @Override
    public JSCmdParamGet createParamGet() {
        JSCmdParamGet objParamGet = new JSCmdParamGet(this);
        return objParamGet;
    }

    @Override
    public JSCmdModifyHotFolder createModifyHotFolder() {
        JSCmdModifyHotFolder objModifyHotFolder = new JSCmdModifyHotFolder(this);
        return objModifyHotFolder;
    }

    @Override
    public JSCmdAddJobs createAddJobs() {
        JSCmdAddJobs objAddJobs = new JSCmdAddJobs(this);
        return objAddJobs;
    }

    public JSCmdAddOrder createAddOrder() {
        JSCmdAddOrder objAddOrder = new JSCmdAddOrder(this);
        return objAddOrder;
    }

    public JSCmdCommands createCmdCommands() {
        JSCmdCommands objCommands = new JSCmdCommands(this);
        return objCommands;
    }

    @Override
    public JSCmdSchedulerLogLogCategoriesSet createSchedulerLogLogCategoriesSet() {
        JSCmdSchedulerLogLogCategoriesSet objSchedulerLogLogCategoriesSet = new JSCmdSchedulerLogLogCategoriesSet(this);
        return objSchedulerLogLogCategoriesSet;
    }

    @Override
    public Spooler.Answer createSpoolerAnswer() {
        return new Spooler.Answer();
    }

    @Override
    public JSCmdLicenceUse createLicenceUse() {
        JSCmdLicenceUse objLicenceUse = new JSCmdLicenceUse(this);
        return objLicenceUse;
    }

    public boolean useDefaultPeriod() {
        return this.useDefaultPeriod;
    }

    public void setUseDefaultPeriod(boolean useDefaultPeriod) {
        this.useDefaultPeriod = useDefaultPeriod;
    }

    public SchedulerHotFolder getLiveFolderOrNull() {
        return this.liveFolder;
    }

    public ISOSProviderFile getFileHandleOrNull(String pstrFilename) {
        return this.liveConnector != null ? this.liveConnector.getFileSystemHandler().getFile(pstrFilename) : null;
    }

    public void setSpooler(sos.spooler.Spooler spooler) {
        this.spooler = spooler;
    }

    static {
        jc4Answers = null;
    }

    public static enum enu4What {
        remote_schedulers,
        all,
        folders,
        job_chains,
        job_chain_jobs,
        running,
        no_subfolders,
        log,
        task_queue;


        public String getText() {
            String strT = this.name();
            return strT;
        }
    }
}

