/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.model.objects;

import com.google.common.base.Strings;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.scheduler.model.SchedulerObjectFactory;
import com.sos.scheduler.model.objects.JSObjParam;
import com.sos.scheduler.model.objects.Param;
import com.sos.scheduler.model.objects.Params;
import com.sos.vfs.common.interfaces.ISOSProviderFile;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSObjParams
extends Params {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSObjParams.class);
    public static final String fileNameExtension = ".params.xml";

    public JSObjParams(SchedulerObjectFactory schedulerObjectFactory) {
        this.objFactory = schedulerObjectFactory;
    }

    public JSObjParams(SchedulerObjectFactory schedulerObjectFactory, Params params) {
        this.objFactory = schedulerObjectFactory;
        this.setObjectFieldsFrom(params);
    }

    public JSObjParams(SchedulerObjectFactory schedulerObjectFactory, ISOSProviderFile pobjVirtualFile) {
        this.objFactory = schedulerObjectFactory;
        Params objParams = (Params)this.unMarshal(pobjVirtualFile);
        this.setObjectFieldsFrom(objParams);
        this.setHotFolderSrc(pobjVirtualFile);
    }

    public HashMap<String, String> getParamList() {
        return this.values();
    }

    public HashMap<String, String> values() {
        HashMap<String, String> values = new HashMap<String, String>();
        for (Object o : this.getParamOrCopyParamsOrInclude()) {
            if (!(o instanceof Param)) continue;
            Param p = (Param)o;
            values.put(p.getName(), p.getValue());
        }
        return values;
    }

    public boolean hasParameterValue(String parameterName) {
        String pValue;
        boolean result = false;
        HashMap<String, String> values = this.values();
        if (values.containsKey(parameterName) && !"".equals(pValue = values.get(parameterName))) {
            result = true;
        }
        return result;
    }

    public String getParameterValue(String parameterName) {
        String result = null;
        HashMap<String, String> values = this.values();
        if (values.containsKey(parameterName)) {
            result = values.get(parameterName);
        }
        return result;
    }

    public void setParamsFromString(String paramString) {
        try {
            if (!Strings.isNullOrEmpty((String)paramString)) {
                Params params = (Params)this.objFactory.unMarshall(paramString);
                this.setObjectFieldsFrom(params);
            }
        }
        catch (Exception e) {
            String msg = "Error while parsing parameter string " + paramString;
            LOGGER.error(msg);
            throw new JobSchedulerException((Throwable)e);
        }
    }

    public void merge(Params paramsToMerge) {
        for (Object o : paramsToMerge.getParamOrCopyParamsOrInclude()) {
            Param p;
            if (!(o instanceof Param) || this.hasParameterValue((p = (Param)o).getName())) continue;
            this.add(p);
            LOGGER.debug("Parameter " + p.getName() + "=" + p.getValue() + " merged.");
        }
    }

    public void add(Param newParam) {
        this.getParamOrCopyParamsOrInclude().add(newParam);
    }

    public void add(String name, String value) {
        JSObjParam p = this.objFactory.createParam();
        p.setName(name);
        p.setValue(value);
        this.add(p);
    }

    public int size() {
        return this.getParamList().size();
    }
}

