/*
 * Decompiled with CFR 0.152.
 */
package com.sos.scheduler.model.objects;

import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class JodaTools {
    public static DateTime getNextWeekday(DateTime date, int weekday) {
        if (date.getDayOfWeek() > weekday) {
            date = date.plusWeeks(1);
        }
        return date.withDayOfWeek(weekday);
    }

    public static DateTime getPreviousWeekday(DateTime date, int weekday) {
        if (date.getDayOfWeek() < weekday) {
            date = date.minusWeeks(1);
        }
        return date.withDayOfWeek(weekday);
    }

    public static DateTime getWeekdayInMonth(DateTime date, int weekday, int which) {
        if (which < 0) {
            DateTime baseDate = JodaTools.getEndOfMonth(date);
            DateTime d = JodaTools.getPreviousWeekday(baseDate, weekday);
            int weeks = which * -1 - 1;
            return d.minusWeeks(weeks);
        }
        DateTime baseDate = JodaTools.getStartOfMonth(date);
        DateTime d = JodaTools.getNextWeekday(baseDate, weekday);
        return d.plusWeeks(which - 1);
    }

    public static DateTime getWeekdayInIntervalOrNull(Interval interval, int weekday, int which) {
        DateTime currentDate = JodaTools.getStartOfMonth(interval.getStart());
        DateTime result = JodaTools.getWeekdayInMonth(currentDate, weekday, which);
        while (!interval.contains((ReadableInstant)result)) {
            result = JodaTools.getWeekdayInMonth(currentDate = currentDate.plusMonths(1), weekday, which);
            if (result.isBefore((ReadableInstant)interval.getEnd())) continue;
            return null;
        }
        return result;
    }

    public static DateTime getDayInMonth(DateTime date, int day) {
        DateTime baseDate = day > 1 ? date.minusMonths(1) : date;
        DateTime result = JodaTools.getEndOfMonth(baseDate).plusDays(day);
        return result.minusMillis(result.getMillisOfDay());
    }

    public static DateTime getDayInIntervalOrNull(Interval interval, int day) {
        DateTime currentDate = JodaTools.getStartOfMonth(interval.getStart());
        DateTime result = JodaTools.getDayInMonth(currentDate, day);
        while (!interval.contains((ReadableInstant)result)) {
            result = JodaTools.getDayInMonth(currentDate = currentDate.plusMonths(1), day);
            if (result.isBefore((ReadableInstant)interval.getEnd())) continue;
            return null;
        }
        return result;
    }

    public static List<Integer> getJodaWeekdays(String jsDay) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        String[] arr = jsDay.split(" ");
        for (int i = 0; i < arr.length; ++i) {
            result.add(JodaTools.getJodaWeekday(arr[i]));
        }
        return result;
    }

    public static int getJodaWeekday(String jsWeekday) {
        String d = jsWeekday.toLowerCase();
        if (d.length() > 2) {
            d = d.substring(0, 2);
        }
        if ("1".equals(d) || "mo".equals(d)) {
            return 1;
        }
        if ("2".equals(d) || "tu".equals(d) || "di".equals(d)) {
            return 2;
        }
        if ("3".equals(d) || "we".equals(d) || "mi".equals(d)) {
            return 3;
        }
        if ("4".equals(d) || "th".equals(d) || "do".equals(d)) {
            return 4;
        }
        if ("5".equals(d) || "fr".equals(d)) {
            return 5;
        }
        if ("6".equals(d) || "sa".equals(d)) {
            return 6;
        }
        return 7;
    }

    public static DateTime getStartOfMonth(DateTime base) {
        return base.minusMillis(base.getMillisOfDay()).minusDays(base.getDayOfMonth() - 1);
    }

    public static DateTime getEndOfMonth(DateTime base) {
        return JodaTools.getStartOfMonth(base.plusMonths(1)).minusMillis(1);
    }

    public static DateTime getStartOfDay(DateTime base) {
        return base.minusMillis(base.getMillisOfDay());
    }
}

