/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util;

import com.sos.commons.exception.SOSMissingDataException;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOSPrivateConf {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSPrivateConf.class);
    private String filename = "./config/private/private.conf";
    private Config config = null;

    public SOSPrivateConf(String filename) {
        this.filename = filename;
    }

    private void init() throws SOSMissingDataException {
        if (this.config == null) {
            Path path = Paths.get(this.filename, new String[0]);
            if (Files.exists(path, new LinkOption[0])) {
                this.config = ConfigFactory.parseFile((File)path.toFile());
            } else {
                String s = String.format("File %s not found", path);
                LOGGER.warn(s);
                throw new SOSMissingDataException(s);
            }
        }
    }

    public String getValue(String key) throws SOSMissingDataException {
        LOGGER.debug("reading key: " + key);
        String value = "";
        try {
            this.init();
        }
        catch (SOSMissingDataException e) {
            return "";
        }
        value = this.config.getString(key);
        return value;
    }

    public String getValueDefaultEmpty(String key) {
        LOGGER.debug("reading key: " + key);
        try {
            this.init();
            String value = null;
            value = this.config.getString(key);
            return value;
        }
        catch (SOSMissingDataException | ConfigException e) {
            return "";
        }
    }

    public String getValue(String objectId, String key) {
        LOGGER.debug("reading key: " + key);
        Config configClass = null;
        String value = "";
        try {
            this.init();
            configClass = this.config.getConfig(objectId);
        }
        catch (ConfigException.Missing e) {
            LOGGER.warn("The configuration item " + objectId + " is missing in private.conf!");
            LOGGER.warn("see https://kb.sos-berlin.com/x/NwgCAQ for further details on how to setup a secure connection");
        }
        catch (SOSMissingDataException sOSMissingDataException) {
            // empty catch block
        }
        if (configClass != null) {
            value = configClass.getString(key);
        }
        return value;
    }

    public String getValueDefaultEmpty(String objectId, String key) {
        LOGGER.debug("reading key: " + key);
        Config configClass = null;
        String value = "";
        try {
            this.init();
            configClass = this.config.getConfig(objectId);
        }
        catch (ConfigException.Missing e) {
            LOGGER.warn("The configuration item " + objectId + " is missing in private.conf!");
            LOGGER.warn("see https://kb.sos-berlin.com/x/NwgCAQ for further details on how to setup a secure connection");
        }
        catch (SOSMissingDataException e) {
            // empty catch block
        }
        if (configClass != null) {
            try {
                value = configClass.getString(key);
            }
            catch (ConfigException.Missing e) {
                value = "";
            }
        }
        return value;
    }

    public String getDecodedValue(String objectId, String key) throws UnsupportedEncodingException {
        String s = this.getValueDefaultEmpty(objectId, key);
        if (!s.isEmpty()) {
            return new String(Base64.getDecoder().decode(s.getBytes("UTF-8")), "UTF-8");
        }
        return null;
    }

    public String getDecodedValue(String key) throws UnsupportedEncodingException {
        String s = this.getValueDefaultEmpty(key);
        if (!s.isEmpty()) {
            return new String(Base64.getDecoder().decode(s.getBytes("UTF-8")), "UTF-8");
        }
        return null;
    }
}

