/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util.common;

import com.sos.commons.util.common.SOSArgumentHelper;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;

public class SOSArgument<T> {
    private final String name;
    private boolean required;
    private T defaultValue;
    private SOSArgumentHelper.DisplayMode displayMode;
    private Boolean dirty;
    private T value;
    private Object payload;

    public SOSArgument(String name, boolean required) {
        this(name, required, null, SOSArgumentHelper.DisplayMode.UNMASKED);
    }

    public SOSArgument(String name, boolean required, T defaultValue) {
        this(name, required, defaultValue, SOSArgumentHelper.DisplayMode.UNMASKED);
    }

    public SOSArgument(String name, boolean required, SOSArgumentHelper.DisplayMode displayMode) {
        this(name, required, null, displayMode);
    }

    public SOSArgument(SOSArgument<T> arg) {
        this(arg.getName(), arg.isRequired(), arg.getDefaultValue(), arg.getDisplayMode());
    }

    public SOSArgument(String name, boolean required, T defaultValue, SOSArgumentHelper.DisplayMode displayMode) {
        this.name = name;
        this.required = required;
        this.defaultValue = defaultValue;
        this.displayMode = displayMode;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean val) {
        this.required = val;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(T val) {
        this.defaultValue = val;
    }

    public T getValue() {
        if (this.value == null) {
            return this.defaultValue;
        }
        return this.value;
    }

    public void setValue(T val) {
        this.value = val;
        this.setIsDirty();
    }

    public SOSArgumentHelper.DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(SOSArgumentHelper.DisplayMode val) {
        this.displayMode = val;
    }

    public String getDisplayValue() {
        return SOSArgumentHelper.getDisplayValue(this.value, this.displayMode);
    }

    public boolean isDirty() {
        if (this.dirty == null) {
            this.setIsDirty();
        }
        return this.dirty;
    }

    public void setIsDirty(boolean val) {
        this.dirty = val;
    }

    public Object getPayload() {
        return this.payload;
    }

    public void setPayload(String val) {
        this.payload = val;
    }

    public boolean isEmpty() {
        if (this.value == null) {
            return true;
        }
        if (this.value instanceof String) {
            return ((String)this.value).isEmpty();
        }
        if (this.value instanceof List) {
            return ((List)this.value).isEmpty();
        }
        if (this.value instanceof Map) {
            return ((Map)this.value).isEmpty();
        }
        if (this.value.getClass().isArray()) {
            return Array.getLength(this.value) == 0;
        }
        return false;
    }

    public boolean isTrue() {
        return this.value != null && this.value instanceof Boolean && (Boolean)this.value != false;
    }

    public void fromString(String val) {
        if (this.value == null) {
            return;
        }
        if (this.value instanceof String) {
            this.value = val;
        } else if (this.value instanceof Integer) {
            this.value = Integer.valueOf(val);
        } else if (this.value instanceof Long) {
            this.value = Long.valueOf(val);
        }
    }

    private void setIsDirty() {
        if (this.value == null) {
            this.dirty = this.defaultValue != null;
            return;
        }
        if (this.defaultValue == null) {
            this.dirty = true;
            return;
        }
        this.dirty = !this.value.equals(this.defaultValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append("[");
        sb.append("value=").append(this.getDisplayValue());
        sb.append(" modified=").append(this.isDirty());
        sb.append("]");
        return sb.toString();
    }
}

