/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util.common;

public class SOSArgumentHelper {
    public static final String LIST_VALUE_DELIMITER = ";";
    private static final String DISPLAY_VALUE_TRUNCATING_SUFFIX = "<truncated>";
    private static final int DISPLAY_VALUE_MAX_LENGTH = 255;
    private static final int DISPLAY_VALUE_USED_LENGTH = 255 - "<truncated>".length();

    public static String getDisplayValue(Object value, DisplayMode mode) {
        if (value == null) {
            return null;
        }
        switch (mode) {
            case NONE: {
                return DisplayMode.NONE.getValue();
            }
            case UNMASKED: {
                return SOSArgumentHelper.truncatingIfNeeded(value.toString());
            }
            case MASKED: {
                return DisplayMode.MASKED.getValue();
            }
        }
        return DisplayMode.UNKNOWN.getValue();
    }

    public static String getClassName(String fullyQualifiedName) {
        if (fullyQualifiedName == null) {
            return null;
        }
        int indx = fullyQualifiedName.lastIndexOf(46);
        return indx > -1 ? fullyQualifiedName.substring(indx + 1) : fullyQualifiedName;
    }

    private static String truncatingIfNeeded(String val) {
        if (val == null) {
            return val;
        }
        Object v = val;
        if (((String)v).length() > 255) {
            v = ((String)v).substring(0, DISPLAY_VALUE_USED_LENGTH) + DISPLAY_VALUE_TRUNCATING_SUFFIX;
        }
        return v;
    }

    public static enum DisplayMode {
        NONE("<...>"),
        MASKED("********"),
        UNMASKED,
        UNKNOWN("<hidden>");

        private final String value;

        private DisplayMode() {
            this(null);
        }

        private DisplayMode(String val) {
            this.value = val;
        }

        public String getValue() {
            return this.value;
        }
    }
}

